/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.ScrollingModelEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.jediterm.terminal.TextStyle;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.exp.BlockTerminalEventsHandler;
import org.jetbrains.plugins.terminal.exp.BlockTerminalSession;
import org.jetbrains.plugins.terminal.exp.CommandBlock;
import org.jetbrains.plugins.terminal.exp.ErrorBlockDecorationState;
import org.jetbrains.plugins.terminal.exp.HighlightingInfo;
import org.jetbrains.plugins.terminal.exp.PromptRenderingInfo;
import org.jetbrains.plugins.terminal.exp.ShellCommandListener;
import org.jetbrains.plugins.terminal.exp.ShellCommandOutputListener;
import org.jetbrains.plugins.terminal.exp.ShellCommandOutputScraper;
import org.jetbrains.plugins.terminal.exp.StyleRange;
import org.jetbrains.plugins.terminal.exp.StyledCommandOutput;
import org.jetbrains.plugins.terminal.exp.TerminalBlocksDecorator;
import org.jetbrains.plugins.terminal.exp.TerminalCaretModel;
import org.jetbrains.plugins.terminal.exp.TerminalCaretPainter;
import org.jetbrains.plugins.terminal.exp.TerminalDataContextUtils;
import org.jetbrains.plugins.terminal.exp.TerminalEventDispatcherKt;
import org.jetbrains.plugins.terminal.exp.TerminalModel;
import org.jetbrains.plugins.terminal.exp.TerminalOutputModel;
import org.jetbrains.plugins.terminal.exp.TerminalSelectionModel;
import org.jetbrains.plugins.terminal.exp.TerminalTextHighlighter;
import org.jetbrains.plugins.terminal.exp.TerminalUi;
import org.jetbrains.plugins.terminal.exp.TerminalUiUtils;
import org.jetbrains.plugins.terminal.exp.hyperlinks.TerminalHyperlinkHighlighter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 H2\u00020\u0001:\u0002GHB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001a\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\u0012J&\u0010%\u001a\u00020!2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+H\u0002J\u0010\u0010-\u001a\u00020,2\u0006\u0010&\u001a\u00020'H\u0002J\b\u0010.\u001a\u00020!H\u0002J\u000e\u0010/\u001a\u00020!2\u0006\u00100\u001a\u000201J\b\u00102\u001a\u00020!H\u0007J\b\u00103\u001a\u00020!H\u0002J\u0010\u00104\u001a\u00020!2\u0006\u00105\u001a\u000206H\u0016J\b\u00107\u001a\u00020!H\u0007J\u0010\u00108\u001a\u00020!2\u0006\u0010$\u001a\u00020\u0012H\u0002J\u001c\u00109\u001a\u00020!2\b\u0010:\u001a\u0004\u0018\u00010)2\b\u0010;\u001a\u0004\u0018\u00010<H\u0007J\u0018\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u000201H\u0002J\u0010\u0010B\u001a\u00020!2\u0006\u0010?\u001a\u00020>H\u0002J\u0010\u0010C\u001a\u00020!2\u0006\u0010?\u001a\u00020@H\u0002J\f\u0010D\u001a\u00020E*\u00020FH\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalOutputController;", "Lorg/jetbrains/plugins/terminal/exp/TerminalModel$TerminalListener;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "session", "Lorg/jetbrains/plugins/terminal/exp/BlockTerminalSession;", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/ex/EditorEx;Lorg/jetbrains/plugins/terminal/exp/BlockTerminalSession;Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;)V", "blocksDecorator", "Lorg/jetbrains/plugins/terminal/exp/TerminalBlocksDecorator;", "caretPainter", "Lorg/jetbrains/plugins/terminal/exp/TerminalCaretPainter;", "hyperlinkHighlighter", "Lorg/jetbrains/plugins/terminal/exp/hyperlinks/TerminalHyperlinkHighlighter;", "keyEventsListenerDisposable", "Lcom/intellij/openapi/Disposable;", "mouseAndContentListenersDisposable", "outputModel", "Lorg/jetbrains/plugins/terminal/exp/TerminalOutputModel;", "getOutputModel", "()Lorg/jetbrains/plugins/terminal/exp/TerminalOutputModel;", "scraper", "Lorg/jetbrains/plugins/terminal/exp/ShellCommandOutputScraper;", "selectionModel", "Lorg/jetbrains/plugins/terminal/exp/TerminalSelectionModel;", "getSelectionModel", "()Lorg/jetbrains/plugins/terminal/exp/TerminalSelectionModel;", "textHighlighter", "Lorg/jetbrains/plugins/terminal/exp/TerminalTextHighlighter;", "addDocumentListener", "", "listener", "Lcom/intellij/openapi/editor/event/DocumentListener;", "disposable", "appendLineToBlock", "block", "Lorg/jetbrains/plugins/terminal/exp/CommandBlock;", "text", "", "highlightings", "", "Lorg/jetbrains/plugins/terminal/exp/HighlightingInfo;", "createCommandHighlighting", "disposeRunningCommandListeners", "finishCommandBlock", "exitCode", "", "insertEmptyLine", "installRunningCommandListeners", "onAlternateBufferChanged", "enabled", "", "scrollToBottom", "setupContentListener", "startCommandBlock", "command", "prompt", "Lorg/jetbrains/plugins/terminal/exp/PromptRenderingInfo;", "toHighlightedCommandOutput", "Lorg/jetbrains/plugins/terminal/exp/TerminalOutputController$CommandOutput;", "output", "Lorg/jetbrains/plugins/terminal/exp/StyledCommandOutput;", "baseOffset", "updateEditor", "updateEditorContent", "toTextAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "Lcom/jediterm/terminal/TextStyle;", "CommandOutput", "Companion", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalOutputController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalOutputController.kt\norg/jetbrains/plugins/terminal/exp/TerminalOutputController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,264:1\n1#2:265\n1549#3:266\n1620#3,3:267\n*S KotlinDebug\n*F\n+ 1 TerminalOutputController.kt\norg/jetbrains/plugins/terminal/exp/TerminalOutputController\n*L\n193#1:266\n193#1:267,3\n*E\n"})
public final class TerminalOutputController
implements TerminalModel.TerminalListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final BlockTerminalSession session;
    @NotNull
    private final JBTerminalSystemSettingsProviderBase settings;
    @NotNull
    private final TerminalOutputModel outputModel;
    @NotNull
    private final TerminalSelectionModel selectionModel;
    @NotNull
    private final ShellCommandOutputScraper scraper;
    @NotNull
    private final TerminalBlocksDecorator blocksDecorator;
    @NotNull
    private final TerminalTextHighlighter textHighlighter;
    @Nullable
    private TerminalCaretPainter caretPainter;
    @Nullable
    private volatile Disposable keyEventsListenerDisposable;
    @Nullable
    private volatile Disposable mouseAndContentListenersDisposable;
    @NotNull
    private final TerminalHyperlinkHighlighter hyperlinkHighlighter;
    @NotNull
    private static final DataKey<TerminalOutputController> KEY;

    public TerminalOutputController(@NotNull Project project, @NotNull EditorEx editor, @NotNull BlockTerminalSession session2, @NotNull JBTerminalSystemSettingsProviderBase settings) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.editor = editor;
        this.session = session2;
        this.settings = settings;
        this.outputModel = new TerminalOutputModel(this.editor);
        this.selectionModel = new TerminalSelectionModel(this.outputModel);
        this.scraper = new ShellCommandOutputScraper(this.session);
        this.blocksDecorator = new TerminalBlocksDecorator(this.outputModel, this.editor);
        this.textHighlighter = new TerminalTextHighlighter(this.outputModel);
        this.hyperlinkHighlighter = new TerminalHyperlinkHighlighter(project, this.outputModel, this.session);
        this.editor.putUserData(TerminalDataContextUtils.INSTANCE.getIS_OUTPUT_EDITOR_KEY(), (Object)true);
        this.editor.setHighlighter((EditorHighlighter)this.textHighlighter);
        TerminalModel.addTerminalListener$default(this.session.getModel(), this, null, 2, null);
        BlockTerminalSession.addCommandListener$default(this.session, new ShellCommandListener(){

            @Override
            public void clearInvoked() {
                Disposable disposable = Disposer.newDisposable();
                Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
                Disposable disposable2 = disposable;
                session.addCommandListener(new ShellCommandListener(disposable2, this){
                    final /* synthetic */ Disposable $disposable;
                    final /* synthetic */ TerminalOutputController this$0;
                    {
                        this.$disposable = $disposable;
                        this.this$0 = $receiver;
                    }

                    public void commandFinished(@Nullable String command, int exitCode, @Nullable Long duration) {
                        ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>(this.this$0){
                            final /* synthetic */ TerminalOutputController this$0;
                            {
                                this.this$0 = $receiver;
                                super(0);
                            }

                            public final void invoke() {
                                this.this$0.getOutputModel().clearBlocks();
                            }
                        }), (int)1, null);
                        Disposer.dispose((Disposable)this.$disposable);
                    }
                }, disposable2);
            }
        }, null, 2, null);
    }

    @NotNull
    public final TerminalOutputModel getOutputModel() {
        return this.outputModel;
    }

    @NotNull
    public final TerminalSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    @RequiresEdt
    public final void startCommandBlock(@Nullable String command, @Nullable PromptRenderingInfo prompt) {
        CommandBlock block = this.outputModel.createBlock(command, prompt);
        if (block.getWithPrompt()) {
            PromptRenderingInfo promptRenderingInfo = block.getPrompt();
            Intrinsics.checkNotNull((Object)promptRenderingInfo);
            this.appendLineToBlock(block, promptRenderingInfo.getText(), block.getPrompt().getHighlightings());
        }
        if (block.getWithCommand()) {
            String string = command;
            Intrinsics.checkNotNull((Object)string);
            this.appendLineToBlock(block, string, CollectionsKt.listOf((Object)this.createCommandHighlighting(block)));
        }
        if (block.getWithPrompt() || block.getWithCommand()) {
            this.blocksDecorator.installDecoration(block, this.outputModel.getBlocksSize() == 1);
        }
        this.scrollToBottom();
        this.installRunningCommandListeners();
    }

    private final void installRunningCommandListeners() {
        Disposable keyEventsDisposable;
        Disposable mouseAndContentDisposable;
        Disposable disposable;
        Disposable it = disposable = Disposer.newDisposable();
        boolean bl = false;
        Disposer.register((Disposable)this.session, (Disposable)it);
        Disposable disposable2 = disposable;
        Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"also(...)");
        this.mouseAndContentListenersDisposable = mouseAndContentDisposable = disposable2;
        Disposable it2 = it = Disposer.newDisposable();
        boolean bl2 = false;
        Disposer.register((Disposable)this.session, (Disposable)it2);
        Disposable disposable3 = it;
        Intrinsics.checkNotNullExpressionValue((Object)disposable3, (String)"also(...)");
        this.keyEventsListenerDisposable = keyEventsDisposable = disposable3;
        BlockTerminalEventsHandler eventsHandler = new BlockTerminalEventsHandler(this.session, this.settings, this);
        TerminalEventDispatcherKt.setupKeyEventDispatcher(this.editor, this.settings, eventsHandler, this.outputModel, this.selectionModel, keyEventsDisposable);
        TerminalEventDispatcherKt.setupMouseListener(this.editor, this.settings, this.session.getModel(), eventsHandler, mouseAndContentDisposable);
        this.setupContentListener(mouseAndContentDisposable);
        TerminalCaretModel caretModel = new TerminalCaretModel(this.session, this.outputModel, this.editor, mouseAndContentDisposable);
        TerminalCaretPainter terminalCaretPainter = this.caretPainter = new TerminalCaretPainter(caretModel, this.outputModel, this.selectionModel, this.editor);
        Intrinsics.checkNotNull((Object)terminalCaretPainter);
        Disposer.register((Disposable)keyEventsDisposable, (Disposable)terminalCaretPainter);
    }

    private final void disposeRunningCommandListeners() {
        Disposable disposable = this.mouseAndContentListenersDisposable;
        if (disposable != null) {
            Disposable it = disposable;
            boolean bl = false;
            Disposer.dispose((Disposable)it);
        }
        this.mouseAndContentListenersDisposable = null;
        ActionsKt.runInEdt$default(null, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ TerminalOutputController this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                Disposable disposable = TerminalOutputController.access$getKeyEventsListenerDisposable$p(this.this$0);
                if (disposable != null) {
                    Disposable it = disposable;
                    boolean bl = false;
                    Disposer.dispose((Disposable)it);
                }
                TerminalOutputController.access$setKeyEventsListenerDisposable$p(this.this$0, null);
                TerminalOutputController.access$setCaretPainter$p(this.this$0, null);
            }
        }), (int)1, null);
    }

    public final void finishCommandBlock(int exitCode) {
        this.disposeRunningCommandListeners();
        this.updateEditorContent(this.scraper.scrapeOutput());
        ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>(this, exitCode){
            final /* synthetic */ TerminalOutputController this$0;
            final /* synthetic */ int $exitCode;
            {
                this.this$0 = $receiver;
                this.$exitCode = $exitCode;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                CommandBlock commandBlock = this.this$0.getOutputModel().getLastBlock();
                if (commandBlock == null) {
                    return;
                }
                CommandBlock block = commandBlock;
                DocumentEx documentEx = TerminalOutputController.access$getEditor$p(this.this$0).getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
                DocumentEx document = documentEx;
                int lastLineInd = document.getLineNumber(block.getEndOffset());
                int lastLineStart = document.getLineStartOffset(lastLineInd);
                String string = document.getText(new TextRange(lastLineStart, block.getEndOffset()));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                String lastLineText = string;
                if (StringsKt.isBlank((CharSequence)lastLineText)) {
                    int startRemoveOffset = Math.max(block.getOutputStartOffset(), lastLineStart - (lastLineStart > 0 ? 1 : 0));
                    document.deleteString(startRemoveOffset, block.getEndOffset());
                    List<HighlightingInfo> list = this.this$0.getOutputModel().getHighlightings(block);
                    if (list != null) {
                        void $this$filterTo$iv$iv;
                        List<HighlightingInfo> list2 = list;
                        TerminalOutputController terminalOutputController = this.this$0;
                        List<HighlightingInfo> current = list2;
                        boolean bl = false;
                        Iterable $this$filter$iv = current;
                        boolean $i$f$filter = false;
                        Iterable iterable = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            HighlightingInfo it = (HighlightingInfo)element$iv$iv;
                            boolean bl2 = false;
                            if (!(it.getEndOffset() <= block.getEndOffset())) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        List updated = (List)destination$iv$iv;
                        terminalOutputController.getOutputModel().putHighlightings(block, updated);
                    }
                }
                String string2 = document.getText(block.getTextRange());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                if (StringsKt.isBlank((CharSequence)string2)) {
                    this.this$0.getOutputModel().removeBlock(block);
                } else if (this.$exitCode != 0) {
                    this.this$0.getOutputModel().addBlockState(block, new ErrorBlockDecorationState());
                }
            }
        }), (int)1, null);
    }

    @RequiresEdt
    public final void insertEmptyLine() {
        this.outputModel.closeLastBlock();
        this.editor.getDocument().insertString(this.editor.getDocument().getTextLength(), (CharSequence)"\n");
        this.scrollToBottom();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    public final void scrollToBottom() {
        ScrollingModelEx scrollingModelEx = this.editor.getScrollingModel();
        Intrinsics.checkNotNullExpressionValue((Object)scrollingModelEx, (String)"getScrollingModel(...)");
        ScrollingModelEx scrollingModel = scrollingModelEx;
        scrollingModel.disableAnimation();
        try {
            Rectangle rectangle = this.editor.getScrollingModel().getVisibleArea();
            Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getVisibleArea(...)");
            Rectangle visibleArea = rectangle;
            scrollingModel.scrollVertically(this.editor.getContentComponent().getHeight() - visibleArea.height);
        }
        finally {
            scrollingModel.enableAnimation();
        }
    }

    @Override
    public void onAlternateBufferChanged(boolean enabled) {
        if (enabled) {
            this.disposeRunningCommandListeners();
        } else {
            this.installRunningCommandListeners();
        }
    }

    private final void setupContentListener(Disposable disposable) {
        this.scraper.addListener(new ShellCommandOutputListener(this){
            final /* synthetic */ TerminalOutputController this$0;
            {
                this.this$0 = $receiver;
            }

            public void commandOutputChanged(@NotNull StyledCommandOutput output) {
                Intrinsics.checkNotNullParameter((Object)output, (String)"output");
                TerminalOutputController.access$updateEditorContent(this.this$0, output);
            }
        }, disposable);
    }

    private final void updateEditorContent(StyledCommandOutput output) {
        ActionsKt.invokeLater((ModalityState)ModalityState.any(), (Function0)((Function0)new Function0<Unit>(this, output){
            final /* synthetic */ TerminalOutputController this$0;
            final /* synthetic */ StyledCommandOutput $output;
            {
                this.this$0 = $receiver;
                this.$output = $output;
                super(0);
            }

            public final void invoke() {
                if (!TerminalOutputController.access$getEditor$p(this.this$0).isDisposed()) {
                    CommandBlock commandBlock = this.this$0.getOutputModel().getLastBlock();
                    if (commandBlock == null) {
                        return;
                    }
                    int baseOffset = commandBlock.getOutputStartOffset();
                    TerminalOutputController.access$updateEditor(this.this$0, TerminalOutputController.access$toHighlightedCommandOutput(this.this$0, this.$output, baseOffset));
                }
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final CommandOutput toHighlightedCommandOutput(StyledCommandOutput output, int baseOffset) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = output.getStyleRanges();
        String string = output.getText();
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            StyleRange styleRange = (StyleRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new HighlightingInfo(baseOffset + it.getStartOffset(), baseOffset + it.getEndOffset(), this.toTextAttributes(it.getStyle())));
        }
        List list = (List)destination$iv$iv;
        String string2 = string;
        return new CommandOutput(string2, list);
    }

    private final void updateEditor(CommandOutput output) {
        block7: {
            List list;
            boolean wasAtBottom;
            CommandBlock commandBlock = this.outputModel.getLastBlock();
            if (commandBlock == null) {
                throw new IllegalStateException("No active block".toString());
            }
            CommandBlock block = commandBlock;
            Rectangle it = this.editor.getScrollingModel().getVisibleArea();
            boolean bl = false;
            boolean bl2 = wasAtBottom = it.y + it.height == this.editor.getContentComponent().getHeight();
            if (block.getWithPrompt() || block.getWithCommand()) {
                List list2;
                List highlightings = list2 = CollectionsKt.toMutableList((Collection)output.getHighlightings());
                boolean bl3 = false;
                if (block.getWithCommand()) {
                    highlightings.add(0, this.createCommandHighlighting(block));
                }
                if (block.getWithPrompt()) {
                    PromptRenderingInfo promptRenderingInfo = block.getPrompt();
                    Intrinsics.checkNotNull((Object)promptRenderingInfo);
                    highlightings.addAll(0, (Collection)promptRenderingInfo.getHighlightings());
                }
                list = list2;
            } else {
                list = output.getHighlightings();
            }
            List highlightings = list;
            this.outputModel.putHighlightings(block, highlightings);
            this.editor.getDocument().replaceString(block.getOutputStartOffset(), block.getEndOffset(), (CharSequence)output.getText());
            this.hyperlinkHighlighter.highlightHyperlinks(block);
            if (this.outputModel.getDecoration(block) == null && !StringsKt.isBlank((CharSequence)output.getText()) && !Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)output.getText())).toString(), (Object)"%")) {
                this.blocksDecorator.installDecoration(block, this.outputModel.getBlocksSize() == 1);
            }
            if (wasAtBottom) {
                this.scrollToBottom();
            }
            TerminalCaretPainter terminalCaretPainter = this.caretPainter;
            if (terminalCaretPainter == null) break block7;
            terminalCaretPainter.repaint();
        }
    }

    private final TextAttributes toTextAttributes(TextStyle $this$toTextAttributes) {
        return TerminalUiUtils.INSTANCE.toTextAttributes$intellij_terminal($this$toTextAttributes, this.session.getColorPalette());
    }

    private final void appendLineToBlock(CommandBlock block, String text, List<HighlightingInfo> highlightings) {
        List list = this.outputModel.getHighlightings(block);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List existingHighlightings = list;
        this.outputModel.putHighlightings(block, CollectionsKt.plus((Collection)existingHighlightings, (Iterable)highlightings));
        this.editor.getDocument().insertString(block.getEndOffset(), (CharSequence)(text + "\n"));
    }

    private final HighlightingInfo createCommandHighlighting(CommandBlock block) {
        TextAttributes attributes = new TextAttributes(TerminalUi.INSTANCE.getCommandForeground(), null, null, null, 1);
        int n = block.getCommandStartOffset();
        int n2 = block.getCommandStartOffset();
        String string = block.getCommand();
        Intrinsics.checkNotNull((Object)string);
        return new HighlightingInfo(n, n2 + string.length(), attributes);
    }

    public final void addDocumentListener(@NotNull DocumentListener listener, @Nullable Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        if (disposable != null) {
            this.editor.getDocument().addDocumentListener(listener, disposable);
        } else {
            this.editor.getDocument().addDocumentListener(listener);
        }
    }

    public static /* synthetic */ void addDocumentListener$default(TerminalOutputController terminalOutputController, DocumentListener documentListener, Disposable disposable, int n, Object object) {
        if ((n & 2) != 0) {
            disposable = null;
        }
        terminalOutputController.addDocumentListener(documentListener, disposable);
    }

    public static final /* synthetic */ Disposable access$getKeyEventsListenerDisposable$p(TerminalOutputController $this) {
        return $this.keyEventsListenerDisposable;
    }

    public static final /* synthetic */ void access$setKeyEventsListenerDisposable$p(TerminalOutputController $this, Disposable disposable) {
        $this.keyEventsListenerDisposable = disposable;
    }

    public static final /* synthetic */ void access$setCaretPainter$p(TerminalOutputController $this, TerminalCaretPainter terminalCaretPainter) {
        $this.caretPainter = terminalCaretPainter;
    }

    public static final /* synthetic */ EditorEx access$getEditor$p(TerminalOutputController $this) {
        return $this.editor;
    }

    public static final /* synthetic */ void access$updateEditorContent(TerminalOutputController $this, StyledCommandOutput output) {
        $this.updateEditorContent(output);
    }

    public static final /* synthetic */ void access$updateEditor(TerminalOutputController $this, CommandOutput output) {
        $this.updateEditor(output);
    }

    public static final /* synthetic */ CommandOutput access$toHighlightedCommandOutput(TerminalOutputController $this, StyledCommandOutput output, int baseOffset) {
        return $this.toHighlightedCommandOutput(output, baseOffset);
    }

    static {
        DataKey dataKey = DataKey.create((String)"TerminalOutputController");
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"create(...)");
        KEY = dataKey;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalOutputController$CommandOutput;", "", "text", "", "highlightings", "", "Lorg/jetbrains/plugins/terminal/exp/HighlightingInfo;", "(Ljava/lang/String;Ljava/util/List;)V", "getHighlightings", "()Ljava/util/List;", "getText", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.terminal"})
    private static final class CommandOutput {
        @NotNull
        private final String text;
        @NotNull
        private final List<HighlightingInfo> highlightings;

        public CommandOutput(@NotNull String text, @NotNull List<HighlightingInfo> highlightings) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter(highlightings, (String)"highlightings");
            this.text = text;
            this.highlightings = highlightings;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final List<HighlightingInfo> getHighlightings() {
            return this.highlightings;
        }

        @NotNull
        public final String component1() {
            return this.text;
        }

        @NotNull
        public final List<HighlightingInfo> component2() {
            return this.highlightings;
        }

        @NotNull
        public final CommandOutput copy(@NotNull String text, @NotNull List<HighlightingInfo> highlightings) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter(highlightings, (String)"highlightings");
            return new CommandOutput(text, highlightings);
        }

        public static /* synthetic */ CommandOutput copy$default(CommandOutput commandOutput, String string, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string = commandOutput.text;
            }
            if ((n & 2) != 0) {
                list = commandOutput.highlightings;
            }
            return commandOutput.copy(string, list);
        }

        @NotNull
        public String toString() {
            return "CommandOutput(text=" + this.text + ", highlightings=" + this.highlightings + ")";
        }

        public int hashCode() {
            int result2 = this.text.hashCode();
            result2 = result2 * 31 + ((Object)this.highlightings).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CommandOutput)) {
                return false;
            }
            CommandOutput commandOutput = (CommandOutput)other;
            if (!Intrinsics.areEqual((Object)this.text, (Object)commandOutput.text)) {
                return false;
            }
            return Intrinsics.areEqual(this.highlightings, commandOutput.highlightings);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalOutputController$Companion;", "", "()V", "KEY", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lorg/jetbrains/plugins/terminal/exp/TerminalOutputController;", "getKEY", "()Lcom/intellij/openapi/actionSystem/DataKey;", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataKey<TerminalOutputController> getKEY() {
            return KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

