/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.exp.AllHighlightingsSnapshot;
import org.jetbrains.plugins.terminal.exp.BlockDecoration;
import org.jetbrains.plugins.terminal.exp.BlockDecorationState;
import org.jetbrains.plugins.terminal.exp.CommandBlock;
import org.jetbrains.plugins.terminal.exp.HighlightingInfo;
import org.jetbrains.plugins.terminal.exp.PromptRenderingInfo;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0015\u0018\u00002\u00020\u0001:\u0001?B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u000bH\u0007J\u001a\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u00172\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\b\u0010 \u001a\u00020\u0019H\u0007J\b\u0010!\u001a\u00020\u0019H\u0007J\u001c\u0010\"\u001a\u00020\t2\b\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010&H\u0007J\u0010\u0010'\u001a\u00020(2\u0006\u0010\u001a\u001a\u00020\tH\u0007J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u001a\u001a\u00020\tH\u0007J\u0006\u0010*\u001a\u00020+J\u000e\u0010,\u001a\u00020\t2\u0006\u0010-\u001a\u00020+J\u0010\u0010.\u001a\u0004\u0018\u00010\t2\u0006\u0010/\u001a\u00020+J\u0012\u00100\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001a\u001a\u00020\tH\u0007J\u0018\u00101\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\n2\u0006\u0010\u001a\u001a\u00020\tH\u0007J\r\u00102\u001a\u00020\u0006H\u0001\u00a2\u0006\u0002\b3J\u000e\u00104\u001a\u00020+2\u0006\u0010\u001a\u001a\u00020\tJ\b\u00105\u001a\u0004\u0018\u00010\tJ\u0018\u00106\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\t2\u0006\u00107\u001a\u00020\u000fH\u0007J\u001e\u00108\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\t2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\nH\u0007J\u0010\u00109\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\tH\u0007J\u0018\u0010:\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010;\u001a\u00020$H\u0007J,\u0010<\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\t2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000f0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R \u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalOutputModel;", "", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "(Lcom/intellij/openapi/editor/ex/EditorEx;)V", "allHighlightingsSnapshot", "Lorg/jetbrains/plugins/terminal/exp/AllHighlightingsSnapshot;", "blockStates", "", "Lorg/jetbrains/plugins/terminal/exp/CommandBlock;", "", "Lorg/jetbrains/plugins/terminal/exp/BlockDecorationState;", "blocks", "", "decorations", "Lorg/jetbrains/plugins/terminal/exp/BlockDecoration;", "document", "Lcom/intellij/openapi/editor/Document;", "getEditor", "()Lcom/intellij/openapi/editor/ex/EditorEx;", "highlightings", "Lorg/jetbrains/plugins/terminal/exp/HighlightingInfo;", "listeners", "Lorg/jetbrains/plugins/terminal/exp/TerminalOutputModel$TerminalOutputListener;", "addBlockState", "", "block", "state", "addListener", "listener", "disposable", "Lcom/intellij/openapi/Disposable;", "clearBlocks", "closeLastBlock", "createBlock", "command", "", "prompt", "Lorg/jetbrains/plugins/terminal/exp/PromptRenderingInfo;", "getBlockBounds", "Ljava/awt/Rectangle;", "getBlockState", "getBlocksSize", "", "getByIndex", "index", "getByOffset", "offset", "getDecoration", "getHighlightings", "getHighlightingsSnapshot", "getHighlightingsSnapshot$intellij_terminal", "getIndexOfBlock", "getLastBlock", "putDecoration", "decoration", "putHighlightings", "removeBlock", "removeBlockState", "stateName", "updateBlockStates", "oldStates", "newStates", "TerminalOutputListener", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalOutputModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalOutputModel.kt\norg/jetbrains/plugins/terminal/exp/TerminalOutputModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,263:1\n1549#2:264\n1620#2,3:265\n766#2:275\n857#2,2:276\n1855#2,2:278\n1#3:268\n76#4:269\n96#4,5:270\n*S KotlinDebug\n*F\n+ 1 TerminalOutputModel.kt\norg/jetbrains/plugins/terminal/exp/TerminalOutputModel\n*L\n47#1:264\n47#1:265,3\n177#1:275\n177#1:276,2\n183#1:278,2\n143#1:269\n143#1:270,5\n*E\n"})
public final class TerminalOutputModel {
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final List<CommandBlock> blocks;
    @NotNull
    private final Map<CommandBlock, BlockDecoration> decorations;
    @NotNull
    private final Map<CommandBlock, List<HighlightingInfo>> highlightings;
    @NotNull
    private final Map<CommandBlock, List<BlockDecorationState>> blockStates;
    @Nullable
    private AllHighlightingsSnapshot allHighlightingsSnapshot;
    @NotNull
    private final Document document;
    @NotNull
    private final List<TerminalOutputListener> listeners;

    public TerminalOutputModel(@NotNull EditorEx editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editor = editor;
        List list = Collections.synchronizedList(new ArrayList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"synchronizedList(...)");
        this.blocks = list;
        this.decorations = new HashMap();
        this.highlightings = new LinkedHashMap();
        this.blockStates = new HashMap();
        DocumentEx documentEx = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        this.document = (Document)documentEx;
        this.listeners = new CopyOnWriteArrayList();
    }

    @NotNull
    public final EditorEx getEditor() {
        return this.editor;
    }

    public final void addListener(@NotNull TerminalOutputListener listener, @Nullable Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listeners.add(listener);
        if (disposable != null) {
            Disposer.register((Disposable)disposable, () -> TerminalOutputModel.addListener$lambda$0(this, listener));
        }
    }

    public static /* synthetic */ void addListener$default(TerminalOutputModel terminalOutputModel, TerminalOutputListener terminalOutputListener, Disposable disposable, int n, Object object) {
        if ((n & 2) != 0) {
            disposable = null;
        }
        terminalOutputModel.addListener(terminalOutputListener, disposable);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    @NotNull
    public final CommandBlock createBlock(@Nullable String command, @Nullable PromptRenderingInfo prompt) {
        PromptRenderingInfo promptRenderingInfo;
        this.closeLastBlock();
        if (this.document.getTextLength() > 0) {
            this.document.insertString(this.document.getTextLength(), (CharSequence)"\n");
        }
        int startOffset = this.document.getTextLength();
        RangeMarker rangeMarker = this.document.createRangeMarker(startOffset, startOffset);
        Intrinsics.checkNotNullExpressionValue((Object)rangeMarker, (String)"createRangeMarker(...)");
        RangeMarker marker = rangeMarker;
        marker.setGreedyToRight(true);
        PromptRenderingInfo promptRenderingInfo2 = prompt;
        if (promptRenderingInfo2 != null) {
            void $this$mapTo$iv$iv;
            PromptRenderingInfo p = promptRenderingInfo2;
            boolean bl = false;
            Iterable $this$map$iv = p.getHighlightings();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                HighlightingInfo highlightingInfo = (HighlightingInfo)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(new HighlightingInfo(startOffset + it.getStartOffset(), startOffset + it.getEndOffset(), it.getTextAttributes()));
            }
            List highlightings = (List)destination$iv$iv;
            promptRenderingInfo = new PromptRenderingInfo(p.getText(), highlightings);
        } else {
            promptRenderingInfo = null;
        }
        PromptRenderingInfo adjustedPrompt = promptRenderingInfo;
        CommandBlock block = new CommandBlock(command, adjustedPrompt, marker);
        this.blocks.add(block);
        return block;
    }

    @RequiresEdt
    public final void closeLastBlock() {
        block1: {
            CommandBlock lastBlock = this.getLastBlock();
            if (lastBlock == null) break block1;
            lastBlock.getRange().setGreedyToRight(false);
            BlockDecoration blockDecoration = this.decorations.get(lastBlock);
            if (blockDecoration != null) {
                BlockDecoration it = blockDecoration;
                boolean bl = false;
                it.getBackgroundHighlighter().setGreedyToRight(false);
                it.getCornersHighlighter().setGreedyToRight(false);
                Inlay<?> inlay = it.getBottomInlay();
                Intrinsics.checkNotNull(inlay, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.RangeMarkerImpl");
                ((RangeMarkerImpl)inlay).setStickingToRight(false);
            }
        }
    }

    @RequiresEdt
    public final void removeBlock(@NotNull CommandBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        BlockDecoration blockDecoration = this.decorations.get(block);
        if (blockDecoration != null) {
            BlockDecoration it = blockDecoration;
            boolean bl = false;
            Disposer.dispose((Disposable)((Disposable)it.getTopInlay()));
            Disposer.dispose((Disposable)((Disposable)it.getBottomInlay()));
            Inlay<?> inlay = it.getCommandToOutputInlay();
            if (inlay != null) {
                Inlay<?> inlay2 = inlay;
                boolean bl2 = false;
                Disposer.dispose((Disposable)((Disposable)inlay2));
            }
            this.editor.getMarkupModel().removeHighlighter(it.getBackgroundHighlighter());
            this.editor.getMarkupModel().removeHighlighter(it.getCornersHighlighter());
        }
        this.blocks.remove(block);
        this.decorations.remove(block);
        this.highlightings.remove(block);
        this.allHighlightingsSnapshot = null;
        this.blockStates.remove(block);
        this.document.deleteString(block.getStartOffset(), block.getEndOffset());
        block.getRange().dispose();
    }

    @RequiresEdt
    public final void clearBlocks() {
        List blocksCopy = CollectionsKt.reversed((Iterable)this.blocks);
        for (CommandBlock block : blocksCopy) {
            this.removeBlock(block);
        }
        this.editor.getDocument().setText((CharSequence)"");
    }

    @Nullable
    public final CommandBlock getLastBlock() {
        return (CommandBlock)CollectionsKt.lastOrNull(this.blocks);
    }

    @Nullable
    public final CommandBlock getByOffset(int offset) {
        Object v1;
        block1: {
            Iterable iterable = this.blocks;
            for (Object t : iterable) {
                CommandBlock it = (CommandBlock)t;
                boolean bl = false;
                int n = it.getStartOffset();
                boolean bl2 = offset <= it.getEndOffset() ? n <= offset : false;
                if (!bl2) continue;
                v1 = t;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    @NotNull
    public final CommandBlock getByIndex(int index) {
        return this.blocks.get(index);
    }

    public final int getIndexOfBlock(@NotNull CommandBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return this.blocks.indexOf(block);
    }

    @RequiresEdt
    @NotNull
    public final Rectangle getBlockBounds(@NotNull CommandBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        int topY = this.editor.offsetToXY((int)block.getStartOffset()).y - 8;
        int bottomY = this.editor.offsetToXY((int)block.getEndOffset()).y + this.editor.getLineHeight() + 12;
        int width = this.editor.getScrollingModel().getVisibleArea().width - 7;
        return new Rectangle(0, topY, width, bottomY - topY);
    }

    public final int getBlocksSize() {
        return this.blocks.size();
    }

    @RequiresEdt
    @Nullable
    public final BlockDecoration getDecoration(@NotNull CommandBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return this.decorations.get(block);
    }

    @RequiresEdt
    public final void putDecoration(@NotNull CommandBlock block, @NotNull BlockDecoration decoration) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)decoration, (String)"decoration");
        this.decorations.put(block, decoration);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    @NotNull
    public final AllHighlightingsSnapshot getHighlightingsSnapshot$intellij_terminal() {
        AllHighlightingsSnapshot snapshot = this.allHighlightingsSnapshot;
        if (snapshot == null) {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            DocumentEx documentEx = this.editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
            Map<CommandBlock, List<HighlightingInfo>> map2 = this.highlightings;
            Document document = (Document)documentEx;
            boolean $i$f$flatMap = false;
            void var4_5 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator.next();
                boolean bl = false;
                Iterable list$iv$iv = (List)it.getValue();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List list = (List)destination$iv$iv;
            Document document2 = document;
            this.allHighlightingsSnapshot = snapshot = new AllHighlightingsSnapshot(document2, list);
        }
        return snapshot;
    }

    @RequiresEdt
    @Nullable
    public final List<HighlightingInfo> getHighlightings(@NotNull CommandBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return this.highlightings.get(block);
    }

    @RequiresEdt
    public final void putHighlightings(@NotNull CommandBlock block, @NotNull List<HighlightingInfo> highlightings) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter(highlightings, (String)"highlightings");
        this.highlightings.put(block, highlightings);
        this.allHighlightingsSnapshot = null;
    }

    @RequiresEdt
    @NotNull
    public final List<BlockDecorationState> getBlockState(@NotNull CommandBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        List list = this.blockStates.get(block);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @RequiresEdt
    public final void addBlockState(@NotNull CommandBlock block, @NotNull BlockDecorationState state) {
        Object v1;
        List curStates;
        block3: {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            List list = this.blockStates.get(block);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            curStates = list;
            Iterable iterable = curStates;
            for (Object t : iterable) {
                BlockDecorationState it = (BlockDecorationState)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)state.getName())) continue;
                v1 = t;
                break block3;
            }
            v1 = null;
        }
        if (v1 == null) {
            this.updateBlockStates(block, curStates, CollectionsKt.plus((Collection)CollectionsKt.toMutableList((Collection)curStates), (Object)state));
        }
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public final void removeBlockState(@NotNull CommandBlock block, @NotNull String stateName) {
        BlockDecorationState blockDecorationState;
        List<BlockDecorationState> curStates;
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)stateName, (String)"stateName");
        List<BlockDecorationState> list = curStates = this.blockStates.get(block);
        if (list != null) {
            Object v1;
            block5: {
                Iterable iterable = list;
                for (Object t : iterable) {
                    BlockDecorationState it = (BlockDecorationState)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)stateName)) continue;
                    v1 = t;
                    break block5;
                }
                v1 = null;
            }
            blockDecorationState = v1;
        } else {
            blockDecorationState = null;
        }
        if (blockDecorationState != null) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Iterable iterable = curStates;
            List<BlockDecorationState> list2 = curStates;
            CommandBlock commandBlock = block;
            TerminalOutputModel terminalOutputModel = this;
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                BlockDecorationState it = (BlockDecorationState)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it.getName(), (Object)stateName))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list3 = (List)destination$iv$iv;
            terminalOutputModel.updateBlockStates(commandBlock, list2, list3);
        }
    }

    private final void updateBlockStates(CommandBlock block, List<? extends BlockDecorationState> oldStates, List<? extends BlockDecorationState> newStates) {
        this.blockStates.put(block, newStates);
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TerminalOutputListener it = (TerminalOutputListener)element$iv;
            boolean bl = false;
            it.blockDecorationStateChanged(block, oldStates, newStates);
        }
    }

    private static final void addListener$lambda$0(TerminalOutputModel this$0, TerminalOutputListener $listener) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        this$0.listeners.remove($listener);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J,\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000b\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalOutputModel$TerminalOutputListener;", "", "blockDecorationStateChanged", "", "block", "Lorg/jetbrains/plugins/terminal/exp/CommandBlock;", "oldStates", "", "Lorg/jetbrains/plugins/terminal/exp/BlockDecorationState;", "newStates", "blockRemoved", "intellij.terminal"})
    public static interface TerminalOutputListener {
        default public void blockRemoved(@NotNull CommandBlock block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        }

        default public void blockDecorationStateChanged(@NotNull CommandBlock block, @NotNull List<? extends BlockDecorationState> oldStates, @NotNull List<? extends BlockDecorationState> newStates) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            Intrinsics.checkNotNullParameter(oldStates, (String)"oldStates");
            Intrinsics.checkNotNullParameter(newStates, (String)"newStates");
        }
    }
}

