/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.plugins.terminal.exp.HighlightingInfo;
import org.jetbrains.plugins.terminal.exp.TerminalOutputModel;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a$\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0002\u00a8\u0006\u0006"}, d2={"buildAndSortHighlightings", "", "Lorg/jetbrains/plugins/terminal/exp/HighlightingInfo;", "document", "Lcom/intellij/openapi/editor/Document;", "highlightings", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalOutputModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalOutputModel.kt\norg/jetbrains/plugins/terminal/exp/TerminalOutputModelKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,263:1\n1045#2:264\n11#3:265\n11#3:266\n*S KotlinDebug\n*F\n+ 1 TerminalOutputModel.kt\norg/jetbrains/plugins/terminal/exp/TerminalOutputModelKt\n*L\n226#1:264\n232#1:265\n235#1:266\n*E\n"})
public final class TerminalOutputModelKt {
    private static final List<HighlightingInfo> buildAndSortHighlightings(Document document, List<HighlightingInfo> highlightings) {
        Iterable $this$sortedBy$iv = highlightings;
        boolean $i$f$sortedBy = false;
        List sortedHighlightings = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                HighlightingInfo it = (HighlightingInfo)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getStartOffset());
                it = (HighlightingInfo)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getStartOffset()));
            }
        });
        int documentLength = document.getTextLength();
        List result2 = new ArrayList(sortedHighlightings.size() * 2 + 1);
        int startOffset = 0;
        for (HighlightingInfo highlighting : sortedHighlightings) {
            boolean $i$f$logger;
            if (highlighting.getStartOffset() < 0 || highlighting.getEndOffset() > documentLength) {
                $i$f$logger = false;
                Logger logger = Logger.getInstance(TerminalOutputModel.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("Terminal highlightings range should be within document");
            }
            if (startOffset > highlighting.getStartOffset()) {
                $i$f$logger = false;
                Logger logger = Logger.getInstance(TerminalOutputModel.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("Terminal highlightings should not overlap");
            }
            if (startOffset < highlighting.getStartOffset()) {
                int n = highlighting.getStartOffset();
                TextAttributes textAttributes = TextAttributes.ERASE_MARKER;
                Intrinsics.checkNotNullExpressionValue((Object)textAttributes, (String)"ERASE_MARKER");
                result2.add(new HighlightingInfo(startOffset, n, textAttributes));
            }
            result2.add(highlighting);
            startOffset = highlighting.getEndOffset();
        }
        if (startOffset < documentLength) {
            TextAttributes textAttributes = TextAttributes.ERASE_MARKER;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributes, (String)"ERASE_MARKER");
            result2.add(new HighlightingInfo(startOffset, documentLength, textAttributes));
        }
        return result2;
    }

    public static final /* synthetic */ List access$buildAndSortHighlightings(Document document, List highlightings) {
        return TerminalOutputModelKt.buildAndSortHighlightings(document, highlightings);
    }
}

