/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.find.SearchReplaceComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.ui.util.UiSizeUtilKt;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JScrollBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.action.TerminalInterruptCommandAction;
import org.jetbrains.plugins.terminal.exp.BlockTerminalSession;
import org.jetbrains.plugins.terminal.exp.TerminalOutputController;
import org.jetbrains.plugins.terminal.exp.TerminalUiUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001'B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"H\u0007J\u0010\u0010#\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"H\u0007J\u0010\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020&H\u0002R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006("}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalOutputView;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "session", "Lorg/jetbrains/plugins/terminal/exp/BlockTerminalSession;", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/terminal/exp/BlockTerminalSession;Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;)V", "charSize", "Ljava/awt/Dimension;", "getCharSize", "()Ljava/awt/Dimension;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "controller", "Lorg/jetbrains/plugins/terminal/exp/TerminalOutputController;", "getController", "()Lorg/jetbrains/plugins/terminal/exp/TerminalOutputController;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "preferredFocusableComponent", "getPreferredFocusableComponent", "terminalWidth", "", "getTerminalWidth", "()I", "createEditor", "dispose", "", "installSearchComponent", "searchComponent", "Lcom/intellij/find/SearchReplaceComponent;", "removeSearchComponent", "stickScrollBarToBottom", "verticalScrollBar", "Ljavax/swing/JScrollBar;", "TerminalOutputPanel", "intellij.terminal"})
public final class TerminalOutputView
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final TerminalOutputController controller;
    @NotNull
    private final JComponent component;
    @NotNull
    private final EditorImpl editor;

    public TerminalOutputView(@NotNull Project project, @NotNull BlockTerminalSession session2, @NotNull JBTerminalSystemSettingsProviderBase settings) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.project = project;
        this.editor = this.createEditor(settings);
        this.controller = new TerminalOutputController(this.project, (EditorEx)this.editor, session2, settings);
        this.component = (JComponent)((Object)new TerminalOutputPanel());
        TerminalOutputController.addDocumentListener$default(this.controller, new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ TerminalOutputView this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        if (TerminalOutputView.access$getEditor$p(this.this$0).isDisposed()) {
                            return;
                        }
                        JComponent jComponent = TerminalOutputView.access$getEditor$p(this.this$0).getComponent();
                        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
                        JComponent editorComponent = jComponent;
                        if (editorComponent.getHeight() < ((TerminalOutputPanel)((Object)this.this$0.getComponent())).getHeight() && UiSizeUtilKt.getPreferredHeight((JComponent)editorComponent) > editorComponent.getHeight()) {
                            this.this$0.getComponent().revalidate();
                            this.this$0.getComponent().repaint();
                        }
                    }
                }), (int)1, null);
            }
        }, null, 2, null);
    }

    @NotNull
    public final TerminalOutputController getController() {
        return this.controller;
    }

    @NotNull
    public final JComponent getComponent() {
        return this.component;
    }

    @NotNull
    public final JComponent getPreferredFocusableComponent() {
        EditorComponentImpl editorComponentImpl = this.editor.getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)editorComponentImpl, (String)"getContentComponent(...)");
        return (JComponent)editorComponentImpl;
    }

    public final int getTerminalWidth() {
        Rectangle rectangle = this.editor.getScrollingModel().getVisibleArea();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getVisibleArea(...)");
        Rectangle visibleArea = rectangle;
        int scrollBarWidth = this.editor.getScrollPane().getVerticalScrollBar().getWidth();
        return visibleArea.width - scrollBarWidth;
    }

    @NotNull
    public final Dimension getCharSize() {
        return new Dimension(this.editor.getCharHeight(), this.editor.getLineHeight());
    }

    @RequiresEdt
    public final void installSearchComponent(@NotNull SearchReplaceComponent searchComponent) {
        Intrinsics.checkNotNullParameter((Object)searchComponent, (String)"searchComponent");
        Component component2 = (Component)searchComponent;
        Integer n = JLayeredPane.POPUP_LAYER;
        Intrinsics.checkNotNull((Object)n, (String)"null cannot be cast to non-null type kotlin.Any");
        this.component.add(component2, n);
        this.component.revalidate();
        this.component.repaint();
    }

    @RequiresEdt
    public final void removeSearchComponent(@NotNull SearchReplaceComponent searchComponent) {
        Intrinsics.checkNotNullParameter((Object)searchComponent, (String)"searchComponent");
        this.component.remove((Component)searchComponent);
        this.component.revalidate();
        this.component.repaint();
    }

    private final EditorImpl createEditor(JBTerminalSystemSettingsProviderBase settings) {
        DocumentImpl document = new DocumentImpl((CharSequence)"", true);
        EditorImpl editor = TerminalUiUtils.INSTANCE.createOutputEditor((Document)document, this.project, settings);
        editor.getSettings().setUseSoftWraps(true);
        JScrollBar jScrollBar = editor.getScrollPane().getVerticalScrollBar();
        Intrinsics.checkNotNullExpressionValue((Object)jScrollBar, (String)"getVerticalScrollBar(...)");
        this.stickScrollBarToBottom(jScrollBar);
        new TerminalInterruptCommandAction().registerCustomShortcutSet((JComponent)editor.getContentComponent(), null);
        return editor;
    }

    private final void stickScrollBarToBottom(JScrollBar verticalScrollBar) {
        verticalScrollBar.getModel().addChangeListener(new ChangeListener(verticalScrollBar){
            private boolean preventRecursion;
            private int prevValue;
            private int prevMaximum;
            private int prevExtent;
            final /* synthetic */ JScrollBar $verticalScrollBar;
            {
                this.$verticalScrollBar = $verticalScrollBar;
            }

            public final boolean getPreventRecursion() {
                return this.preventRecursion;
            }

            public final void setPreventRecursion(boolean bl) {
                this.preventRecursion = bl;
            }

            public final int getPrevValue() {
                return this.prevValue;
            }

            public final void setPrevValue(int n) {
                this.prevValue = n;
            }

            public final int getPrevMaximum() {
                return this.prevMaximum;
            }

            public final void setPrevMaximum(int n) {
                this.prevMaximum = n;
            }

            public final int getPrevExtent() {
                return this.prevExtent;
            }

            public final void setPrevExtent(int n) {
                this.prevExtent = n;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void stateChanged(@Nullable ChangeEvent e) {
                if (this.preventRecursion) {
                    return;
                }
                BoundedRangeModel model = this.$verticalScrollBar.getModel();
                int maximum = model.getMaximum();
                int extent = model.getExtent();
                if ((extent != this.prevExtent || maximum != this.prevMaximum) && this.prevValue == this.prevMaximum - this.prevExtent) {
                    this.preventRecursion = true;
                    try {
                        model.setValue(maximum - extent);
                    }
                    finally {
                        this.preventRecursion = false;
                    }
                }
                this.prevValue = model.getValue();
                this.prevMaximum = model.getMaximum();
                this.prevExtent = model.getExtent();
            }
        });
    }

    public void dispose() {
        EditorFactory.getInstance().releaseEditor((Editor)this.editor);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalOutputView$TerminalOutputPanel;", "Lcom/intellij/ui/components/JBLayeredPane;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "(Lorg/jetbrains/plugins/terminal/exp/TerminalOutputView;)V", "doLayout", "", "getData", "", "dataId", "", "layoutEditor", "component", "Ljava/awt/Component;", "layoutSearchComponent", "intellij.terminal"})
    private final class TerminalOutputPanel
    extends JBLayeredPane
    implements DataProvider {
        public TerminalOutputPanel() {
            this.setOpaque(false);
            Component component2 = TerminalOutputView.this.editor.getComponent();
            Integer n = JLayeredPane.DEFAULT_LAYER;
            Intrinsics.checkNotNull((Object)n, (String)"null cannot be cast to non-null type kotlin.Any");
            this.add(component2, n);
        }

        @Nullable
        public Object getData(@NotNull String dataId) {
            Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
            return CommonDataKeys.EDITOR.is(dataId) ? TerminalOutputView.this.editor : null;
        }

        public void doLayout() {
            Component[] componentArray = this.getComponents();
            Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
            for (Component component2 : componentArray) {
                Component component3 = component2;
                if (Intrinsics.areEqual((Object)component3, (Object)TerminalOutputView.this.editor.getComponent())) {
                    Intrinsics.checkNotNull((Object)component2);
                    this.layoutEditor(component2);
                    continue;
                }
                if (!(component3 instanceof SearchReplaceComponent)) continue;
                Intrinsics.checkNotNull((Object)component2);
                this.layoutSearchComponent(component2);
            }
        }

        private final void layoutEditor(Component component2) {
            int prefHeight = component2.getPreferredSize().height;
            int compHeight = Math.min(this.getHeight(), prefHeight);
            component2.setBounds(0, this.getHeight() - compHeight, this.getWidth(), compHeight);
        }

        private final void layoutSearchComponent(Component component2) {
            Dimension prefSize = component2.getPreferredSize();
            Dimension maxSize = component2.getMaximumSize();
            int compWidth = Math.min(this.getWidth(), Math.min(prefSize.width, maxSize.width));
            int compHeight = Math.min(prefSize.height, maxSize.height);
            component2.setBounds(this.getWidth() - compWidth, 0, compWidth, compHeight);
        }
    }
}

