/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.CaretVisualAttributes;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.ui.LanguageTextField;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.panels.ListLayout;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.exp.BlockTerminalSession;
import org.jetbrains.plugins.terminal.exp.HighlightingInfo;
import org.jetbrains.plugins.terminal.exp.PromptRenderingInfo;
import org.jetbrains.plugins.terminal.exp.TerminalCommandExecutor;
import org.jetbrains.plugins.terminal.exp.TerminalInlineCompletion;
import org.jetbrains.plugins.terminal.exp.TerminalPromptController;
import org.jetbrains.plugins.terminal.exp.TerminalUi;
import org.jetbrains.plugins.terminal.exp.completion.TerminalShellSupport;
import org.jetbrains.plugins.terminal.exp.history.CommandHistoryPresenter;
import org.jetbrains.plugins.terminal.exp.history.CommandSearchPresenter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u001fH\u0016J\b\u0010#\u001a\u00020\u001dH\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010&\u001a\u00020\u001fH\u0016J\u0010\u0010'\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020!H\u0016J\u0014\u0010,\u001a\u00020\u001f*\u00020\u001d2\u0006\u0010(\u001a\u00020)H\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalPromptView;", "Lorg/jetbrains/plugins/terminal/exp/TerminalPromptController$PromptStateListener;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "session", "Lorg/jetbrains/plugins/terminal/exp/BlockTerminalSession;", "commandExecutor", "Lorg/jetbrains/plugins/terminal/exp/TerminalCommandExecutor;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;Lorg/jetbrains/plugins/terminal/exp/BlockTerminalSession;Lorg/jetbrains/plugins/terminal/exp/TerminalCommandExecutor;)V", "commandHistoryPresenter", "Lorg/jetbrains/plugins/terminal/exp/history/CommandHistoryPresenter;", "commandSearchPresenter", "Lorg/jetbrains/plugins/terminal/exp/history/CommandSearchPresenter;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "controller", "Lorg/jetbrains/plugins/terminal/exp/TerminalPromptController;", "getController", "()Lorg/jetbrains/plugins/terminal/exp/TerminalPromptController;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "preferredFocusableComponent", "getPreferredFocusableComponent", "promptComponent", "Lcom/intellij/ui/SimpleColoredComponent;", "commandHistoryStateChanged", "", "showing", "", "commandSearchRequested", "createPromptComponent", "createPromptTextField", "Lcom/intellij/ui/LanguageTextField;", "dispose", "promptContentUpdated", "renderingInfo", "Lorg/jetbrains/plugins/terminal/exp/PromptRenderingInfo;", "promptVisibilityChanged", "visible", "setContent", "intellij.terminal"})
public final class TerminalPromptView
implements TerminalPromptController.PromptStateListener,
Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final JBTerminalSystemSettingsProviderBase settings;
    @NotNull
    private final TerminalPromptController controller;
    @NotNull
    private final JComponent component;
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final SimpleColoredComponent promptComponent;
    @NotNull
    private final CommandHistoryPresenter commandHistoryPresenter;
    @NotNull
    private final CommandSearchPresenter commandSearchPresenter;

    public TerminalPromptView(@NotNull Project project, @NotNull JBTerminalSystemSettingsProviderBase settings, @NotNull BlockTerminalSession session2, @NotNull TerminalCommandExecutor commandExecutor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)commandExecutor, (String)"commandExecutor");
        this.project = project;
        this.settings = settings;
        this.component = new JPanel();
        LanguageTextField editorTextField = this.createPromptTextField(session2);
        EditorEx editorEx = editorTextField.getEditor(true);
        Intrinsics.checkNotNull((Object)editorEx, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        this.editor = (EditorImpl)editorEx;
        this.controller = new TerminalPromptController((EditorEx)this.editor, session2, commandExecutor);
        this.controller.addListener(this);
        this.promptComponent = this.createPromptComponent();
        this.commandHistoryPresenter = new CommandHistoryPresenter(this.project, (Editor)this.editor, commandExecutor);
        this.commandSearchPresenter = new CommandSearchPresenter(this.project, (Editor)this.editor);
        JBEmptyBorder jBEmptyBorder = JBUI.Borders.empty((int)11, (int)19, (int)12, (int)19);
        Intrinsics.checkNotNullExpressionValue((Object)jBEmptyBorder, (String)"empty(...)");
        JBEmptyBorder innerBorder = jBEmptyBorder;
        Border border = JBUI.Borders.customLineTop((Color)JBUI.CurrentTheme.CustomFrameDecorations.separatorForeground());
        Intrinsics.checkNotNullExpressionValue((Object)border, (String)"customLineTop(...)");
        Border outerBorder = border;
        this.component.setBorder(JBUI.Borders.compound((Border)outerBorder, (Border)((Border)innerBorder)));
        this.component.setBackground(TerminalUi.INSTANCE.getTerminalBackground());
        this.component.setLayout((LayoutManager)ListLayout.Companion.vertical$default((ListLayout.Companion)ListLayout.Companion, (int)2, null, null, (int)6, null));
        this.component.add((Component)this.promptComponent);
        this.component.add((Component)editorTextField);
        this.component.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(@Nullable MouseEvent e) {
                IdeFocusManager.getInstance((Project)project).requestFocus((Component)editor.getContentComponent(), true);
            }
        });
    }

    @NotNull
    public final TerminalPromptController getController() {
        return this.controller;
    }

    @NotNull
    public final JComponent getComponent() {
        return this.component;
    }

    @NotNull
    public final JComponent getPreferredFocusableComponent() {
        EditorComponentImpl editorComponentImpl = this.editor.getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)editorComponentImpl, (String)"getContentComponent(...)");
        return (JComponent)editorComponentImpl;
    }

    @Override
    public void promptVisibilityChanged(boolean visible) {
        this.component.setVisible(visible);
    }

    @Override
    public void promptContentUpdated(@NotNull PromptRenderingInfo renderingInfo) {
        Intrinsics.checkNotNullParameter((Object)renderingInfo, (String)"renderingInfo");
        Function0 changePrompt2 = (Function0)new Function0<Unit>(this, renderingInfo){
            final /* synthetic */ TerminalPromptView this$0;
            final /* synthetic */ PromptRenderingInfo $renderingInfo;
            {
                this.this$0 = $receiver;
                this.$renderingInfo = $renderingInfo;
                super(0);
            }

            public final void invoke() {
                TerminalPromptView.access$getPromptComponent$p(this.this$0).clear();
                TerminalPromptView.access$setContent(this.this$0, TerminalPromptView.access$getPromptComponent$p(this.this$0), this.$renderingInfo);
                TerminalPromptView.access$getPromptComponent$p(this.this$0).revalidate();
                TerminalPromptView.access$getPromptComponent$p(this.this$0).repaint();
            }
        };
        this.promptComponent.change(() -> TerminalPromptView.promptContentUpdated$lambda$0(changePrompt2), false);
    }

    private final void setContent(SimpleColoredComponent $this$setContent, PromptRenderingInfo renderingInfo) {
        int curOffset = 0;
        for (HighlightingInfo highlighting : renderingInfo.getHighlightings()) {
            String textPart;
            if (curOffset < highlighting.getStartOffset()) {
                String string = renderingInfo.getText().substring(curOffset, highlighting.getStartOffset());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                textPart = string;
                $this$setContent.append(textPart);
            }
            Intrinsics.checkNotNullExpressionValue((Object)renderingInfo.getText().substring(highlighting.getStartOffset(), highlighting.getEndOffset()), (String)"substring(...)");
            SimpleTextAttributes attributes = new SimpleTextAttributes(0, highlighting.getTextAttributes().getForegroundColor());
            $this$setContent.append(textPart, attributes);
            curOffset = highlighting.getEndOffset();
        }
    }

    @Override
    public void commandHistoryStateChanged(boolean showing) {
        if (showing) {
            List<String> history = this.controller.getCommandHistory();
            if (!((Collection)history).isEmpty()) {
                this.commandHistoryPresenter.showCommandHistory(history);
            }
        } else {
            this.commandHistoryPresenter.onCommandHistoryClosed();
        }
    }

    @Override
    public void commandSearchRequested() {
        List<String> history = this.controller.getCommandHistory();
        if (!((Collection)history).isEmpty()) {
            this.commandSearchPresenter.showCommandSearch(history);
        }
    }

    private final LanguageTextField createPromptTextField(BlockTerminalSession session2) {
        EditorColorsScheme editorColorsScheme;
        TerminalShellSupport terminalShellSupport = TerminalShellSupport.Companion.findByShellType(session2.getShellIntegration().getShellType());
        if (terminalShellSupport == null || (terminalShellSupport = terminalShellSupport.getPromptLanguage()) == null) {
            terminalShellSupport = (Language)PlainTextLanguage.INSTANCE;
        }
        TerminalShellSupport language = terminalShellSupport;
        Project project = this.project;
        LanguageTextField textField2 = new LanguageTextField((Language)language, project){

            public void setBackground(@Nullable Color bg) {
            }

            public void updateUI() {
                super.updateUI();
                this.setFont(EditorUtil.getEditorFont());
            }
        };
        textField2.setDisposedWith((Disposable)this);
        textField2.setAlignmentX(0.0f);
        EditorEx editorEx = textField2.getEditor(true);
        Intrinsics.checkNotNull((Object)editorEx, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        EditorImpl editor = (EditorImpl)editorEx;
        editor.getScrollPane().setBorder((Border)JBUI.Borders.empty());
        editor.getGutterComponentEx().setPaintBackground(false);
        editor.setBackgroundColor(TerminalUi.INSTANCE.getTerminalBackground());
        EditorColorsScheme $this$createPromptTextField_u24lambda_u241 = editorColorsScheme = editor.getColorsScheme();
        boolean bl = false;
        $this$createPromptTextField_u24lambda_u241.setEditorFontName(this.settings.getTerminalFont().getFontName());
        $this$createPromptTextField_u24lambda_u241.setEditorFontSize(this.settings.getTerminalFont().getSize());
        $this$createPromptTextField_u24lambda_u241.setLineSpacing(1.0f);
        editor.getCaretModel().getPrimaryCaret().setVisualAttributes(new CaretVisualAttributes(null, CaretVisualAttributes.Weight.HEAVY));
        editor.putUserData(AutoPopupController.SHOW_BOTTOM_PANEL_IN_LOOKUP_UI, (Object)false);
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile((Document)editor.getDocument());
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl2 = false;
            editor.setFile(it);
        }
        TerminalInlineCompletion.Companion.getInstance(this.project).install((EditorEx)editor);
        editor.setContextMenuGroupId("Terminal.PromptContextMenu");
        return textField2;
    }

    private final SimpleColoredComponent createPromptComponent() {
        SimpleColoredComponent component2 = new SimpleColoredComponent(){

            public void updateUI() {
                super.updateUI();
                this.setFont(EditorUtil.getEditorFont());
            }
        };
        component2.setBackground(TerminalUi.INSTANCE.getTerminalBackground());
        return component2;
    }

    public void dispose() {
    }

    private static final void promptContentUpdated$lambda$0(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke();
    }

    public static final /* synthetic */ SimpleColoredComponent access$getPromptComponent$p(TerminalPromptView $this) {
        return $this.promptComponent;
    }

    public static final /* synthetic */ void access$setContent(TerminalPromptView $this, SimpleColoredComponent $receiver, PromptRenderingInfo renderingInfo) {
        $this.setContent($receiver, renderingInfo);
    }
}

