/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.Alarm;
import com.intellij.util.MathUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.exp.CommandBlock;
import org.jetbrains.plugins.terminal.exp.InactiveSelectedBlockDecorationState;
import org.jetbrains.plugins.terminal.exp.SelectedBlockDecorationState;
import org.jetbrains.plugins.terminal.exp.TerminalFocusModel;
import org.jetbrains.plugins.terminal.exp.TerminalOutputModel;
import org.jetbrains.plugins.terminal.exp.TerminalSelectionModel;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 /2\u00020\u00012\u00020\u0002:\u0001/B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ$\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00122\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012H\u0002J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u001aH\u0007J\u0012\u0010!\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u000bH\u0002J\u0010\u0010&\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010'\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010(\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020\u000bH\u0002J\b\u0010*\u001a\u00020\u001aH\u0007J\u0018\u0010+\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020\u001f2\u0006\u0010-\u001a\u00020\u001fH\u0007J$\u0010.\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00122\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u00060"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalSelectionController;", "Lcom/intellij/openapi/editor/event/EditorMouseListener;", "Lorg/jetbrains/plugins/terminal/exp/TerminalSelectionModel$TerminalSelectionListener;", "focusModel", "Lorg/jetbrains/plugins/terminal/exp/TerminalFocusModel;", "selectionModel", "Lorg/jetbrains/plugins/terminal/exp/TerminalSelectionModel;", "outputModel", "Lorg/jetbrains/plugins/terminal/exp/TerminalOutputModel;", "(Lorg/jetbrains/plugins/terminal/exp/TerminalFocusModel;Lorg/jetbrains/plugins/terminal/exp/TerminalSelectionModel;Lorg/jetbrains/plugins/terminal/exp/TerminalOutputModel;)V", "primarySelection", "Lorg/jetbrains/plugins/terminal/exp/CommandBlock;", "getPrimarySelection", "()Lorg/jetbrains/plugins/terminal/exp/CommandBlock;", "rangeSelectionInitialIndex", "", "Ljava/lang/Integer;", "selectedBlocks", "", "getSelectedBlocks", "()Ljava/util/List;", "textSelectionModel", "Lcom/intellij/openapi/editor/SelectionModel;", "getTextSelectionModel", "()Lcom/intellij/openapi/editor/SelectionModel;", "applyActiveSelectionDecoration", "", "oldSelection", "newSelection", "applyInactiveSelectionDecoration", "isActive", "", "clearSelection", "getBlockUnderMouse", "event", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "makeBlockVisible", "block", "mouseClicked", "mousePressed", "selectBlockRange", "targetBlock", "selectLastBlock", "selectRelativeBlock", "isBelow", "dropCurrentSelection", "selectionChanged", "Companion", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalSelectionController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalSelectionController.kt\norg/jetbrains/plugins/terminal/exp/TerminalSelectionController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,246:1\n1#2:247\n1549#3:248\n1620#3,3:249\n*S KotlinDebug\n*F\n+ 1 TerminalSelectionController.kt\norg/jetbrains/plugins/terminal/exp/TerminalSelectionController\n*L\n168#1:248\n168#1:249,3\n*E\n"})
public final class TerminalSelectionController
implements EditorMouseListener,
TerminalSelectionModel.TerminalSelectionListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TerminalFocusModel focusModel;
    @NotNull
    private final TerminalSelectionModel selectionModel;
    @NotNull
    private final TerminalOutputModel outputModel;
    @Nullable
    private Integer rangeSelectionInitialIndex;
    @NotNull
    private static final DataKey<TerminalSelectionController> KEY;

    public TerminalSelectionController(@NotNull TerminalFocusModel focusModel, @NotNull TerminalSelectionModel selectionModel, @NotNull TerminalOutputModel outputModel) {
        Intrinsics.checkNotNullParameter((Object)focusModel, (String)"focusModel");
        Intrinsics.checkNotNullParameter((Object)selectionModel, (String)"selectionModel");
        Intrinsics.checkNotNullParameter((Object)outputModel, (String)"outputModel");
        this.focusModel = focusModel;
        this.selectionModel = selectionModel;
        this.outputModel = outputModel;
        this.outputModel.getEditor().addEditorMouseListener((EditorMouseListener)this);
        TerminalSelectionModel.addListener$default(this.selectionModel, this, null, 2, null);
        TerminalFocusModel.addListener$default(this.focusModel, new TerminalFocusModel.TerminalFocusListener(){

            @Override
            public void promptFocused() {
                this.clearSelection();
            }

            @Override
            public void activeStateChanged(boolean isActive) {
                new Alarm().addRequest(() -> 1.activeStateChanged$lambda$0(this, isActive), 150);
            }

            private static final void activeStateChanged$lambda$0(TerminalSelectionController this$0, boolean $isActive) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                if (!this$0.outputModel.getEditor().isDisposed()) {
                    this$0.applyInactiveSelectionDecoration($isActive);
                }
            }
        }, null, 2, null);
        this.getTextSelectionModel().addSelectionListener(new SelectionListener(){

            public void selectionChanged(@NotNull SelectionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!e.getNewRange().isEmpty()) {
                    selectionModel.setSelectedBlocks(CollectionsKt.emptyList());
                }
            }
        });
    }

    @NotNull
    public final List<CommandBlock> getSelectedBlocks() {
        return this.selectionModel.getSelectedBlocks();
    }

    @Nullable
    public final CommandBlock getPrimarySelection() {
        return this.selectionModel.getPrimarySelection();
    }

    private final SelectionModel getTextSelectionModel() {
        SelectionModel selectionModel = this.outputModel.getEditor().getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"getSelectionModel(...)");
        return selectionModel;
    }

    @RequiresEdt
    public final void selectRelativeBlock(boolean isBelow, boolean dropCurrentSelection) {
        int newIndex;
        CommandBlock commandBlock = this.selectionModel.getPrimarySelection();
        if (commandBlock == null) {
            return;
        }
        CommandBlock primaryBlock = commandBlock;
        Integer n = this.outputModel.getIndexOfBlock(primaryBlock);
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = it >= 0 ? n : null;
        if (n2 == null) {
            return;
        }
        int curIndex = n2;
        int n3 = newIndex = isBelow ? curIndex + 1 : curIndex - 1;
        boolean bl2 = 0 <= newIndex ? newIndex < this.outputModel.getBlocksSize() : false;
        if (bl2) {
            CommandBlock newBlock = this.outputModel.getByIndex(newIndex);
            if (dropCurrentSelection) {
                this.selectionModel.setSelectedBlocks(CollectionsKt.listOf((Object)newBlock));
            } else {
                this.selectBlockRange(newBlock);
            }
            this.makeBlockVisible(newBlock);
        } else if (isBelow) {
            EditorEx editor = this.outputModel.getEditor();
            int visibleHeight = editor.getScrollingModel().getVisibleArea().height;
            editor.getScrollingModel().scrollVertically(editor.getContentComponent().getHeight() - visibleHeight);
        }
    }

    @RequiresEdt
    public final void selectLastBlock() {
        CommandBlock commandBlock = this.outputModel.getLastBlock();
        if (commandBlock == null) {
            return;
        }
        CommandBlock block = commandBlock;
        this.selectionModel.setSelectedBlocks(CollectionsKt.listOf((Object)block));
        this.makeBlockVisible(block);
    }

    @RequiresEdt
    public final void clearSelection() {
        this.selectionModel.setSelectedBlocks(CollectionsKt.emptyList());
        this.getTextSelectionModel().removeSelection();
        this.focusModel.focusPrompt();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void mouseClicked(@NotNull EditorMouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getMouseEvent().getClickCount() != 1) {
            return;
        }
        CommandBlock block = this.getBlockUnderMouse(event);
        if (block != null) {
            MouseEvent mouseEvent = event.getMouseEvent();
            Intrinsics.checkNotNullExpressionValue((Object)mouseEvent, (String)"getMouseEvent(...)");
            if (TerminalSelectionController.Companion.isSelectAdditionalBlock(mouseEvent)) {
                this.selectionModel.setSelectedBlocks(this.getSelectedBlocks().contains(block) ? CollectionsKt.minus((Iterable)this.getSelectedBlocks(), (Object)block) : CollectionsKt.plus((Collection)this.getSelectedBlocks(), (Object)block));
                return;
            }
        }
        if (block != null) {
            this.selectionModel.setSelectedBlocks(CollectionsKt.listOf((Object)block));
            return;
        }
        this.clearSelection();
    }

    public void mousePressed(@NotNull EditorMouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        MouseEvent mouseEvent = event.getMouseEvent();
        Intrinsics.checkNotNullExpressionValue((Object)mouseEvent, (String)"getMouseEvent(...)");
        if (TerminalSelectionController.Companion.isSelectBlockRange(mouseEvent)) {
            event.consume();
        }
        CommandBlock commandBlock = this.getBlockUnderMouse(event);
        if (commandBlock == null) {
            return;
        }
        CommandBlock block = commandBlock;
        if (SwingUtilities.isRightMouseButton(event.getMouseEvent())) {
            SelectionModel it = this.getTextSelectionModel();
            boolean bl = false;
            int n = it.getSelectionStart();
            int n2 = it.getSelectionEnd();
            int n3 = event.getOffset();
            boolean insideTextSelection = n <= n3 ? n3 <= n2 : false;
            if (!this.selectionModel.getSelectedBlocks().contains(block) && !insideTextSelection) {
                this.selectionModel.setSelectedBlocks(CollectionsKt.listOf((Object)block));
            }
        } else {
            MouseEvent mouseEvent2 = event.getMouseEvent();
            Intrinsics.checkNotNullExpressionValue((Object)mouseEvent2, (String)"getMouseEvent(...)");
            if (TerminalSelectionController.Companion.isSelectBlockRange(mouseEvent2)) {
                this.selectBlockRange(block);
            }
        }
    }

    @Override
    public void selectionChanged(@NotNull List<CommandBlock> oldSelection, @NotNull List<CommandBlock> newSelection) {
        Intrinsics.checkNotNullParameter(oldSelection, (String)"oldSelection");
        Intrinsics.checkNotNullParameter(newSelection, (String)"newSelection");
        this.applyActiveSelectionDecoration(oldSelection, newSelection);
        if (!((Collection)newSelection).isEmpty()) {
            this.getTextSelectionModel().removeSelection();
            this.focusModel.focusOutput();
        } else if (!this.getTextSelectionModel().hasSelection()) {
            this.focusModel.focusPrompt();
        }
        this.rangeSelectionInitialIndex = null;
    }

    /*
     * WARNING - void declaration
     */
    private final void selectBlockRange(CommandBlock targetBlock) {
        CommandBlock primaryBlock = this.getPrimarySelection();
        if (primaryBlock == null) {
            this.selectionModel.setSelectedBlocks(CollectionsKt.listOf((Object)targetBlock));
            return;
        }
        int curBlockIndex = this.outputModel.getIndexOfBlock(primaryBlock);
        Integer n = this.rangeSelectionInitialIndex;
        int initialBlockIndex = n != null ? n : curBlockIndex;
        int newBlockIndex = this.outputModel.getIndexOfBlock(targetBlock);
        if (curBlockIndex != -1 && newBlockIndex != -1) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            IntProgression indexRange = initialBlockIndex <= newBlockIndex ? (IntProgression)new IntRange(initialBlockIndex, newBlockIndex) : RangesKt.downTo((int)initialBlockIndex, (int)newBlockIndex);
            Iterable iterable = (Iterable)indexRange;
            TerminalSelectionModel terminalSelectionModel = this.selectionModel;
            boolean $i$f$map = false;
            void var9_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                int item$iv$iv;
                int n2 = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.outputModel.getByIndex((int)it));
            }
            terminalSelectionModel.setSelectedBlocks((List)destination$iv$iv);
            this.rangeSelectionInitialIndex = initialBlockIndex;
        } else {
            this.selectionModel.setSelectedBlocks(CollectionsKt.listOf((Object)targetBlock));
        }
    }

    private final CommandBlock getBlockUnderMouse(EditorMouseEvent event) {
        Rectangle bounds;
        CommandBlock block = this.outputModel.getByOffset(event.getOffset());
        if (block != null && (bounds = this.outputModel.getBlockBounds(block)).contains(event.getMouseEvent().getPoint())) {
            return block;
        }
        return null;
    }

    private final void makeBlockVisible(CommandBlock block) {
        EditorEx editor = this.outputModel.getEditor();
        Rectangle bounds = this.outputModel.getBlockBounds(block);
        Rectangle rectangle = editor.getScrollingModel().getVisibleArea();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getVisibleArea(...)");
        Rectangle visibleArea = rectangle;
        int n = visibleArea.y;
        int n2 = visibleArea.y + visibleArea.height;
        int n3 = bounds.y;
        if (!(n <= n3 ? n3 < n2 : false)) {
            int n4;
            if (bounds.y < visibleArea.y) {
                n4 = bounds.y - 6;
            } else {
                int blockMaxHeight = Math.min(bounds.height + 6, visibleArea.height);
                n4 = bounds.y + blockMaxHeight - visibleArea.height;
            }
            int scrollOffset = n4;
            int offset = MathUtil.clamp((int)scrollOffset, (int)0, (int)editor.getContentComponent().getHeight());
            editor.getScrollingModel().scrollVertically(offset);
        }
    }

    private final void applyActiveSelectionDecoration(List<CommandBlock> oldSelection, List<CommandBlock> newSelection) {
        for (CommandBlock block : oldSelection) {
            if (newSelection.contains(block)) continue;
            this.outputModel.removeBlockState(block, "SELECTED");
            this.outputModel.removeBlockState(block, "SELECTED_INACTIVE");
        }
        for (CommandBlock block : newSelection) {
            this.outputModel.addBlockState(block, new SelectedBlockDecorationState());
        }
    }

    private final void applyInactiveSelectionDecoration(boolean isActive) {
        for (CommandBlock block : this.getSelectedBlocks()) {
            if (isActive) {
                this.outputModel.removeBlockState(block, "SELECTED_INACTIVE");
                continue;
            }
            this.outputModel.addBlockState(block, new InactiveSelectedBlockDecorationState());
        }
    }

    static {
        DataKey dataKey = DataKey.create((String)"TerminalSelectionController");
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"create(...)");
        KEY = dataKey;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00020\t*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u000bR\u0018\u0010\f\u001a\u00020\t*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000bR\u0018\u0010\r\u001a\u00020\t*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0018\u0010\u000e\u001a\u00020\t*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalSelectionController$Companion;", "", "()V", "KEY", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lorg/jetbrains/plugins/terminal/exp/TerminalSelectionController;", "getKEY", "()Lcom/intellij/openapi/actionSystem/DataKey;", "isOnlyControlDown", "", "Ljava/awt/event/MouseEvent;", "(Ljava/awt/event/MouseEvent;)Z", "isOnlyMetaDown", "isSelectAdditionalBlock", "isSelectBlockRange", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataKey<TerminalSelectionController> getKEY() {
            return KEY;
        }

        private final boolean isSelectBlockRange(MouseEvent $this$isSelectBlockRange) {
            return $this$isSelectBlockRange.isShiftDown() && !$this$isSelectBlockRange.isControlDown() && !$this$isSelectBlockRange.isAltDown() && !$this$isSelectBlockRange.isMetaDown();
        }

        private final boolean isSelectAdditionalBlock(MouseEvent $this$isSelectAdditionalBlock) {
            return SystemInfo.isMac ? this.isOnlyMetaDown($this$isSelectAdditionalBlock) : this.isOnlyControlDown($this$isSelectAdditionalBlock);
        }

        private final boolean isOnlyMetaDown(MouseEvent $this$isOnlyMetaDown) {
            return $this$isOnlyMetaDown.isMetaDown() && !$this$isOnlyMetaDown.isControlDown() && !$this$isOnlyMetaDown.isAltDown() && !$this$isOnlyMetaDown.isShiftDown();
        }

        private final boolean isOnlyControlDown(MouseEvent $this$isOnlyControlDown) {
            return $this$isOnlyControlDown.isControlDown() && !$this$isOnlyControlDown.isAltDown() && !$this$isOnlyControlDown.isShiftDown() && !$this$isOnlyControlDown.isMetaDown();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

