/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.HyperlinkWithPopupMenuInfo;
import com.intellij.execution.impl.EditorHyperlinkSupport;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterFreePainterAreaState;
import com.intellij.openapi.editor.ex.EditorPopupHandler;
import com.intellij.openapi.editor.impl.ContextMenuPopupHandler;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.TerminalColorPalette;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Alarm;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jediterm.core.Color;
import com.jediterm.core.util.TermSize;
import com.jediterm.terminal.TerminalColor;
import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.ui.AwtTransformers;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013J%\u0010\u0015\u001a\u00020\u00162\u0016\u0010\u0017\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00160\u0018\"\u0004\u0018\u00010\u0016H\u0002\u00a2\u0006\u0002\u0010\u0019J\u001e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\u0010\u0010\"\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\u0011H\u0002J\u001a\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020)H\u0002J\u001a\u0010*\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020)H\u0002J\u0018\u0010+\u001a\u00020%2\u0006\u0010,\u001a\u00020-2\u0006\u0010(\u001a\u00020)H\u0002J\u0018\u0010.\u001a\u00020\u00162\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0002J\u0010\u00103\u001a\u00020\u000b2\u0006\u0010/\u001a\u000200H\u0002J\u000e\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\bJ\u0019\u00107\u001a\u000208*\u00020-2\u0006\u0010(\u001a\u00020)H\u0000\u00a2\u0006\u0002\b9R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalUiUtils;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "TERMINAL_OUTPUT_CONTEXT_MENU", "", "TIMEOUT", "", "awaitComponentLayout", "Ljava/util/concurrent/CompletableFuture;", "", "component", "Ljava/awt/Component;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "calculateTerminalSize", "Lcom/jediterm/core/util/TermSize;", "componentSize", "Ljava/awt/Dimension;", "charSize", "concatGroups", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "groups", "", "([Lcom/intellij/openapi/actionSystem/ActionGroup;)Lcom/intellij/openapi/actionSystem/ActionGroup;", "createOutputEditor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "document", "Lcom/intellij/openapi/editor/Document;", "project", "Lcom/intellij/openapi/project/Project;", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "ensureTermMinimumSize", "size", "getEffectiveBackgroundColor", "Ljava/awt/Color;", "color", "Lcom/jediterm/terminal/TerminalColor;", "palette", "Lcom/intellij/terminal/TerminalColorPalette;", "getEffectiveForegroundColor", "getForegroundColor", "style", "Lcom/jediterm/terminal/TextStyle;", "getPopupMenuGroup", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "event", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "installPopupMenu", "toFloatAndScale", "", "value", "toTextAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "toTextAttributes$intellij_terminal", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalUiUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalUiUtils.kt\norg/jetbrains/plugins/terminal/exp/TerminalUiUtils\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,208:1\n14#2:209\n11383#3,9:210\n13309#3:219\n13310#3:223\n11392#3:224\n18#4:220\n26#5:221\n1#6:222\n1#6:225\n11#7:226\n*S KotlinDebug\n*F\n+ 1 TerminalUiUtils.kt\norg/jetbrains/plugins/terminal/exp/TerminalUiUtils\n*L\n95#1:209\n101#1:210,9\n101#1:219\n101#1:223\n101#1:224\n102#1:220\n102#1:221\n101#1:222\n205#1:226\n*E\n"})
public final class TerminalUiUtils {
    @NotNull
    public static final TerminalUiUtils INSTANCE = new TerminalUiUtils();
    @NotNull
    private static final Logger LOG;
    private static final int TIMEOUT = 2000;
    @NotNull
    private static final String TERMINAL_OUTPUT_CONTEXT_MENU = "Terminal.OutputContextMenu";

    private TerminalUiUtils() {
    }

    @NotNull
    public final EditorImpl createOutputEditor(@NotNull Document document, @NotNull Project project, @NotNull JBTerminalSystemSettingsProviderBase settings) {
        EditorColorsScheme editorColorsScheme;
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Editor editor = EditorFactory.getInstance().createEditor(document, project, EditorKind.CONSOLE);
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        EditorImpl editor2 = (EditorImpl)editor;
        editor2.setScrollToCaret(false);
        editor2.setRendererMode(true);
        editor2.getScrollPane().setBorder((Border)JBUI.Borders.empty());
        editor2.getScrollPane().setHorizontalScrollBarPolicy(31);
        editor2.getGutterComponentEx().setPaintBackground(false);
        editor2.getGutterComponentEx().setRightFreePaintersAreaState(EditorGutterFreePainterAreaState.HIDE);
        EditorColorsScheme $this$createOutputEditor_u24lambda_u240 = editorColorsScheme = editor2.getColorsScheme();
        boolean bl = false;
        $this$createOutputEditor_u24lambda_u240.setEditorFontName(settings.getTerminalFont().getFontName());
        $this$createOutputEditor_u24lambda_u240.setEditorFontSize(settings.getTerminalFont().getSize());
        $this$createOutputEditor_u24lambda_u240.setLineSpacing(1.0f);
        EditorColorsScheme $this$createOutputEditor_u24lambda_u241 = editorColorsScheme = editor2.getSettings();
        boolean bl2 = false;
        $this$createOutputEditor_u24lambda_u241.setShowingSpecialChars(false);
        $this$createOutputEditor_u24lambda_u241.setLineNumbersShown(false);
        $this$createOutputEditor_u24lambda_u241.setGutterIconsShown(false);
        $this$createOutputEditor_u24lambda_u241.setRightMarginShown(false);
        $this$createOutputEditor_u24lambda_u241.setFoldingOutlineShown(false);
        $this$createOutputEditor_u24lambda_u241.setCaretRowShown(false);
        $this$createOutputEditor_u24lambda_u241.setAdditionalLinesCount(0);
        $this$createOutputEditor_u24lambda_u241.setAdditionalColumnsCount(0);
        $this$createOutputEditor_u24lambda_u241.setAdditionalPageAtBottom(false);
        $this$createOutputEditor_u24lambda_u241.setBlockCursor(true);
        $this$createOutputEditor_u24lambda_u241.setWhitespacesShown(false);
        this.installPopupMenu((EditorEx)editor2);
        return editor2;
    }

    private final void installPopupMenu(EditorEx editor) {
        editor.installPopupHandler((EditorPopupHandler)new ContextMenuPopupHandler(editor){
            final /* synthetic */ EditorEx $editor;
            {
                this.$editor = $editor;
            }

            @NotNull
            public ActionGroup getActionGroup(@NotNull EditorMouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                return TerminalUiUtils.access$getPopupMenuGroup(TerminalUiUtils.INSTANCE, this.$editor, event);
            }
        });
    }

    private final ActionGroup getPopupMenuGroup(EditorEx editor, EditorMouseEvent event) {
        HyperlinkInfo info;
        ThreadingAssertions.assertEventDispatchThread();
        HyperlinkInfo $this$asSafely$iv = info = EditorHyperlinkSupport.get((Editor)((Editor)editor)).getHyperlinkInfoByEvent(event);
        boolean $i$f$asSafely = false;
        HyperlinkInfo hyperlinkInfo = $this$asSafely$iv;
        if (!(hyperlinkInfo instanceof HyperlinkWithPopupMenuInfo)) {
            hyperlinkInfo = null;
        }
        HyperlinkWithPopupMenuInfo hyperlinkWithPopupMenuInfo = (HyperlinkWithPopupMenuInfo)hyperlinkInfo;
        ActionGroup customPopupMenuGroup = hyperlinkWithPopupMenuInfo != null ? hyperlinkWithPopupMenuInfo.getPopupMenuGroup(event.getMouseEvent()) : null;
        AnAction anAction = ActionManager.getInstance().getAction(TERMINAL_OUTPUT_CONTEXT_MENU);
        Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        ActionGroup defaultPopupMenuGroup = (ActionGroup)anAction;
        ActionGroup[] actionGroupArray = new ActionGroup[]{customPopupMenuGroup, defaultPopupMenuGroup};
        return this.concatGroups(actionGroupArray);
    }

    /*
     * WARNING - void declaration
     */
    private final ActionGroup concatGroups(ActionGroup ... groups) {
        void $this$mapNotNullTo$iv$iv;
        ActionGroup[] $this$mapNotNull$iv = groups;
        boolean $i$f$mapNotNull = false;
        Object object = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            List it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            void v0 = it;
            Object[] $this$orEmpty$iv = v0 != null ? v0.getChildren(null) : null;
            boolean $i$f$orEmpty = false;
            Object[] objectArray = $this$orEmpty$iv;
            if ($this$orEmpty$iv == null) {
                boolean $i$f$emptyArray = false;
                objectArray = new AnAction[]{};
            }
            if (UtilKt.nullize((List)ArraysKt.toList((Object[])objectArray)) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List actionsPerGroup = (List)destination$iv$iv;
        Iterable iterable = actionsPerGroup;
        object = new ArrayList();
        int n2 = 0;
        for (Object t : iterable) {
            void actions;
            int n3;
            if ((n3 = n2++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list = (List)t;
            int index = n3;
            boolean bl = false;
            CollectionsKt.addAll((Collection)object, (Iterable)((Iterable)(index > 0 ? CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)Separator.create()), (Iterable)((Iterable)actions)) : actions)));
        }
        List list = (List)object;
        return (ActionGroup)new DefaultActionGroup(list);
    }

    @NotNull
    public final TermSize calculateTerminalSize(@NotNull Dimension componentSize, @NotNull Dimension charSize) {
        Intrinsics.checkNotNullParameter((Object)componentSize, (String)"componentSize");
        Intrinsics.checkNotNullParameter((Object)charSize, (String)"charSize");
        int width = componentSize.width / charSize.width;
        int height = componentSize.height / charSize.height;
        return this.ensureTermMinimumSize(new TermSize(width, height));
    }

    private final TermSize ensureTermMinimumSize(TermSize size) {
        return new TermSize(Math.max(5, size.getColumns()), Math.max(2, size.getRows()));
    }

    @RequiresEdt(generateAssertion=false)
    @NotNull
    public final CompletableFuture<Unit> awaitComponentLayout(@NotNull Component component2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Dimension size = component2.getSize();
        if (size.width > 0 || size.height > 0) {
            CompletableFuture<Unit> completableFuture = CompletableFuture.completedFuture(Unit.INSTANCE);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        if (!UIUtil.isShowing((Component)component2, (boolean)false)) {
            CompletableFuture<Unit> completableFuture = CompletableFuture.failedFuture(new IllegalStateException("component should be showing"));
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"failedFuture(...)");
            return completableFuture;
        }
        CompletableFuture<Unit> result2 = new CompletableFuture<Unit>();
        long startNano = System.nanoTime();
        ComponentAdapter resizeListener2 = new ComponentAdapter(startNano, result2){
            final /* synthetic */ long $startNano;
            final /* synthetic */ CompletableFuture<Unit> $result;
            {
                this.$startNano = $startNano;
                this.$result = $result;
            }

            public void componentResized(@NotNull ComponentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (TerminalUiUtils.access$getLOG$p().isDebugEnabled()) {
                    TerminalUiUtils.access$getLOG$p().info("Terminal component layout took " + TimeoutUtil.getDurationMillis((long)this.$startNano) + "ms");
                }
                this.$result.complete(Unit.INSTANCE);
            }
        };
        component2.addComponentListener(resizeListener2);
        Alarm alarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, parentDisposable);
        alarm.addRequest(() -> TerminalUiUtils.awaitComponentLayout$lambda$4(result2), 2000, ModalityState.stateForComponent((Component)component2));
        Disposer.register((Disposable)((Disposable)alarm), () -> TerminalUiUtils.awaitComponentLayout$lambda$6(result2, component2));
        result2.whenComplete((arg_0, arg_1) -> TerminalUiUtils.awaitComponentLayout$lambda$7((Function2)new Function2<Unit, Throwable, Unit>(alarm, component2, resizeListener2){
            final /* synthetic */ Alarm $alarm;
            final /* synthetic */ Component $component;
            final /* synthetic */ ComponentAdapter $resizeListener;
            {
                this.$alarm = $alarm;
                this.$component = $component;
                this.$resizeListener = $resizeListener;
                super(2);
            }

            public final void invoke(Unit unit, Throwable throwable) {
                Disposer.dispose((Disposable)((Disposable)this.$alarm));
                this.$component.removeComponentListener(this.$resizeListener);
            }
        }, arg_0, arg_1));
        return result2;
    }

    public final float toFloatAndScale(int value) {
        return JBUIScale.scale((float)value);
    }

    @NotNull
    public final TextAttributes toTextAttributes$intellij_terminal(@NotNull TextStyle $this$toTextAttributes, @NotNull TerminalColorPalette palette) {
        TerminalColor terminalColor;
        TextAttributes textAttributes;
        Intrinsics.checkNotNullParameter((Object)$this$toTextAttributes, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)palette, (String)"palette");
        TextAttributes attr = textAttributes = new TextAttributes();
        boolean bl = false;
        TerminalColor terminalColor2 = terminalColor = $this$toTextAttributes.getBackgroundForRun();
        if (terminalColor2 != null) {
            Intrinsics.checkNotNull((Object)terminalColor2);
            TerminalColor it = terminalColor;
            boolean bl2 = false;
            attr.setBackgroundColor(AwtTransformers.toAwtColor((Color)palette.getBackground(it)));
        }
        attr.setForegroundColor(INSTANCE.getForegroundColor($this$toTextAttributes, palette));
        if ($this$toTextAttributes.hasOption(TextStyle.Option.BOLD)) {
            attr.setFontType(attr.getFontType() | 1);
        }
        if ($this$toTextAttributes.hasOption(TextStyle.Option.ITALIC)) {
            attr.setFontType(attr.getFontType() | 2);
        }
        if ($this$toTextAttributes.hasOption(TextStyle.Option.UNDERLINED)) {
            attr.withAdditionalEffect(EffectType.LINE_UNDERSCORE, attr.getForegroundColor());
        }
        return textAttributes;
    }

    private final java.awt.Color getForegroundColor(TextStyle style, TerminalColorPalette palette) {
        java.awt.Color color;
        java.awt.Color foreground = this.getEffectiveForegroundColor(style.getForegroundForRun(), palette);
        if (style.hasOption(TextStyle.Option.DIM)) {
            java.awt.Color background = this.getEffectiveBackgroundColor(style.getBackgroundForRun(), palette);
            color = new java.awt.Color((foreground.getRed() + background.getRed()) / 2, (foreground.getGreen() + background.getGreen()) / 2, (foreground.getBlue() + background.getBlue()) / 2, foreground.getAlpha());
        } else {
            color = foreground;
        }
        return color;
    }

    private final java.awt.Color getEffectiveForegroundColor(TerminalColor color, TerminalColorPalette palette) {
        TerminalColor terminalColor;
        block3: {
            block2: {
                terminalColor = color;
                if (terminalColor == null) break block2;
                TerminalColor it = terminalColor;
                boolean bl = false;
                Color color2 = palette.getForeground(it);
                terminalColor = color2;
                if (color2 != null) break block3;
            }
            terminalColor = palette.getDefaultForeground();
        }
        java.awt.Color color3 = AwtTransformers.toAwtColor((Color)terminalColor);
        Intrinsics.checkNotNull((Object)color3);
        return color3;
    }

    private final java.awt.Color getEffectiveBackgroundColor(TerminalColor color, TerminalColorPalette palette) {
        TerminalColor terminalColor;
        block3: {
            block2: {
                terminalColor = color;
                if (terminalColor == null) break block2;
                TerminalColor it = terminalColor;
                boolean bl = false;
                Color color2 = palette.getBackground(it);
                terminalColor = color2;
                if (color2 != null) break block3;
            }
            terminalColor = palette.getDefaultBackground();
        }
        java.awt.Color color3 = AwtTransformers.toAwtColor((Color)terminalColor);
        Intrinsics.checkNotNull((Object)color3);
        return color3;
    }

    private static final void awaitComponentLayout$lambda$4(CompletableFuture $result) {
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        $result.completeExceptionally(new IllegalStateException("Terminal component layout is timed out (>2000ms)"));
    }

    private static final void awaitComponentLayout$lambda$6$lambda$5(CompletableFuture $result) {
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        $result.completeExceptionally(new IllegalStateException("parent disposed"));
    }

    private static final void awaitComponentLayout$lambda$6(CompletableFuture $result, Component $component) {
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        Intrinsics.checkNotNullParameter((Object)$component, (String)"$component");
        if (!$result.isDone()) {
            ApplicationManager.getApplication().invokeLater(() -> TerminalUiUtils.awaitComponentLayout$lambda$6$lambda$5($result), ModalityState.stateForComponent((Component)$component));
        }
    }

    private static final void awaitComponentLayout$lambda$7(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ ActionGroup access$getPopupMenuGroup(TerminalUiUtils $this, EditorEx editor, EditorMouseEvent event) {
        return $this.getPopupMenuGroup(editor, event);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TerminalUiUtils.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

