/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp.completion;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Scheduler;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.terminal.completion.CommandSpecManager;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.coroutines.Continuation;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MagicApiIntrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.exp.completion.CommandSpecsBean;
import org.jetbrains.plugins.terminal.exp.completion.IJCommandSpecManager;
import org.jetbrains.terminal.completion.ShellCommand;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0003\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001c\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\u0005H\u0096@\u00a2\u0006\u0002\u0010\rJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\u0005H\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\u0005H\u0016J(\u0010\u0010\u001a\u0004\u0018\u0001H\u0011\"\u0006\b\u0000\u0010\u0011\u0018\u00012\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0082\b\u00a2\u0006\u0002\u0010\u0015J$\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u001bH\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/plugins/terminal/exp/completion/IJCommandSpecManager;", "Lcom/intellij/terminal/completion/CommandSpecManager;", "()V", "commandSpecsCache", "Lcom/github/benmanes/caffeine/cache/Cache;", "", "Lorg/jetbrains/terminal/completion/ShellCommand;", "commandsInfoCache", "Lorg/jetbrains/plugins/terminal/exp/completion/IJCommandSpecManager$ShellCommandInfo;", "json", "Lkotlinx/serialization/json/Json;", "getCommandSpec", "commandName", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getShellCommandInfo", "getShortCommandSpec", "loadAndParseJson", "T", "path", "classLoader", "Ljava/lang/ClassLoader;", "(Ljava/lang/String;Ljava/lang/ClassLoader;)Ljava/lang/Object;", "loadCommandSpecs", "", "bean", "Lorg/jetbrains/plugins/terminal/exp/completion/CommandSpecsBean;", "destination", "", "Companion", "ShellCommandInfo", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nIJCommandSpecManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IJCommandSpecManager.kt\norg/jetbrains/plugins/terminal/exp/completion/IJCommandSpecManager\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,128:1\n101#1,8:129\n110#1,7:138\n101#1,8:146\n110#1,7:155\n96#2:137\n96#2:154\n96#2:162\n1#3:145\n11#4:163\n*S KotlinDebug\n*F\n+ 1 IJCommandSpecManager.kt\norg/jetbrains/plugins/terminal/exp/completion/IJCommandSpecManager\n*L\n62#1:129,8\n62#1:138,7\n95#1:146,8\n95#1:155,7\n62#1:137\n95#1:154\n108#1:162\n126#1:163\n*E\n"})
public final class IJCommandSpecManager
implements CommandSpecManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Cache<String, ShellCommandInfo> commandsInfoCache;
    @NotNull
    private final Cache<String, ShellCommand> commandSpecsCache;
    @NotNull
    private final Json json;
    @NotNull
    private static final Logger LOG;

    public IJCommandSpecManager() {
        Cache cache = Caffeine.newBuilder().expireAfterAccess(Duration.ofMinutes(5L)).scheduler(Scheduler.systemScheduler()).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        this.commandsInfoCache = cache;
        Cache cache2 = Caffeine.newBuilder().maximumSize(10L).expireAfterAccess(Duration.ofMinutes(5L)).scheduler(Scheduler.systemScheduler()).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache2, (String)"build(...)");
        this.commandSpecsCache = cache2;
        this.json = JsonKt.Json$default(null, (Function1)json.1.INSTANCE, (int)1, null);
        CommandSpecsBean.Companion.getEP_NAME().addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<CommandSpecsBean>(){

            public void extensionAdded(@NotNull CommandSpecsBean extension, @NotNull PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                commandsInfoCache.invalidateAll();
            }

            public void extensionRemoved(@NotNull CommandSpecsBean extension, @NotNull PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                commandsInfoCache.invalidateAll();
            }
        });
    }

    @Override
    @Nullable
    public ShellCommand getShortCommandSpec(@NotNull String commandName) {
        Intrinsics.checkNotNullParameter((Object)commandName, (String)"commandName");
        ShellCommandInfo shellCommandInfo = this.getShellCommandInfo(commandName);
        return shellCommandInfo != null ? shellCommandInfo.getCommand() : null;
    }

    private final ShellCommandInfo getShellCommandInfo(String commandName) {
        if (this.commandsInfoCache.estimatedSize() == 0L) {
            Map commandsInfoMap = new LinkedHashMap();
            for (CommandSpecsBean bean : CommandSpecsBean.Companion.getEP_NAME().getExtensionList()) {
                this.loadCommandSpecs(bean, commandsInfoMap);
            }
            this.commandsInfoCache.putAll(commandsInfoMap);
        }
        return (ShellCommandInfo)this.commandsInfoCache.getIfPresent((Object)commandName);
    }

    /*
     * WARNING - void declaration
     */
    private final void loadCommandSpecs(CommandSpecsBean bean, Map<String, ShellCommandInfo> destination) {
        Object object;
        void path$iv;
        IJCommandSpecManager iJCommandSpecManager = this;
        String string = bean.getPath();
        ClassLoader classLoader = bean.getPluginDesc().getClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getClassLoader(...)");
        ClassLoader classLoader$iv = classLoader;
        boolean $i$f$loadAndParseJson = false;
        URL url$iv = classLoader$iv.getResource((String)path$iv);
        if (url$iv == null) {
            LOG.warn("Failed to find resource for path: " + (String)path$iv + " with classLoader: " + classLoader$iv);
            object = null;
        } else {
            Object object2;
            try {
                void this_$iv;
                URL uRL = url$iv;
                Charset charset = Charsets.UTF_8;
                byte[] byArray = TextStreamsKt.readBytes((URL)uRL);
                String resultJson$iv = new String(byArray, charset);
                Json this_$iv$iv = this_$iv.json;
                boolean $i$f$decodeFromString = false;
                this_$iv$iv.getSerializersModule();
                object2 = this_$iv$iv.decodeFromString((DeserializationStrategy)BuiltinSerializersKt.getNullable((KSerializer)new ArrayListSerializer(ShellCommand.Companion.serializer())), resultJson$iv);
            }
            catch (IOException ex$iv) {
                LOG.warn("Failed to load resource by URL: " + url$iv, (Throwable)ex$iv);
                object2 = null;
            }
            catch (Throwable t$iv) {
                LOG.warn("Failed to parse resource loaded from URL: " + url$iv, t$iv);
                object2 = null;
            }
            object = object2;
        }
        List list = (List)object;
        if (list == null) {
            return;
        }
        List commands2 = list;
        for (ShellCommand command : commands2) {
            for (String name : command.getNames()) {
                destination.put(name, new ShellCommandInfo(command, bean));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object getCommandSpec(@NotNull String commandName, @NotNull Continuation<? super ShellCommand> $completion) {
        Object object;
        ShellCommandInfo commandInfo;
        Pair pair;
        ShellCommand shellCommand2 = (ShellCommand)this.commandSpecsCache.getIfPresent((Object)commandName);
        if (shellCommand2 != null) {
            ShellCommand it = shellCommand2;
            boolean bl = false;
            return it;
        }
        if (StringsKt.contains$default((CharSequence)commandName, (char)'/', (boolean)false, (int)2, null)) {
            String mainCommand = StringsKt.substringBefore$default((String)commandName, (char)'/', null, (int)2, null);
            ShellCommandInfo shellCommandInfo = this.getShellCommandInfo(mainCommand);
            if (shellCommandInfo == null) {
                return null;
            }
            ShellCommandInfo mainCommandInfo = shellCommandInfo;
            String path = mainCommandInfo.getBean().getBasePath() + commandName + ".json";
            pair = TuplesKt.to((Object)mainCommandInfo, (Object)path);
        } else {
            ShellCommandInfo shellCommandInfo = this.getShellCommandInfo(commandName);
            if (shellCommandInfo == null) {
                return null;
            }
            commandInfo = shellCommandInfo;
            pair = TuplesKt.to((Object)commandInfo, (Object)(commandInfo.getBean().getBasePath() + commandInfo.getCommand().getLoadSpec() + ".json"));
        }
        Pair pair2 = pair;
        commandInfo = (ShellCommandInfo)pair2.component1();
        String path = (String)pair2.component2();
        IJCommandSpecManager iJCommandSpecManager = this;
        ClassLoader classLoader = commandInfo.getBean().getPluginDesc().getClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getClassLoader(...)");
        ClassLoader classLoader$iv = classLoader;
        boolean $i$f$loadAndParseJson = false;
        URL url$iv = classLoader$iv.getResource(path);
        if (url$iv == null) {
            LOG.warn("Failed to find resource for path: " + path + " with classLoader: " + classLoader$iv);
            object = null;
        } else {
            Object object2;
            try {
                void this_$iv;
                URL uRL = url$iv;
                Charset charset = Charsets.UTF_8;
                byte[] byArray = TextStreamsKt.readBytes((URL)uRL);
                String resultJson$iv = new String(byArray, charset);
                Json this_$iv$iv = this_$iv.json;
                boolean $i$f$decodeFromString = false;
                this_$iv$iv.getSerializersModule();
                object2 = this_$iv$iv.decodeFromString((DeserializationStrategy)BuiltinSerializersKt.getNullable(ShellCommand.Companion.serializer()), resultJson$iv);
            }
            catch (IOException ex$iv) {
                LOG.warn("Failed to load resource by URL: " + url$iv, (Throwable)ex$iv);
                object2 = null;
            }
            catch (Throwable t$iv) {
                LOG.warn("Failed to parse resource loaded from URL: " + url$iv, t$iv);
                object2 = null;
            }
            object = object2;
        }
        ShellCommand shellCommand3 = (ShellCommand)object;
        if (shellCommand3 == null) {
            return null;
        }
        ShellCommand command = shellCommand3;
        this.commandSpecsCache.put((Object)commandName, (Object)command);
        return command;
    }

    private final /* synthetic */ <T> T loadAndParseJson(String path, ClassLoader classLoader) {
        Object object;
        boolean $i$f$loadAndParseJson = false;
        URL url = classLoader.getResource(path);
        if (url == null) {
            LOG.warn("Failed to find resource for path: " + path + " with classLoader: " + classLoader);
            return null;
        }
        try {
            URL uRL = url;
            Charset charset = Charsets.UTF_8;
            Object object2 = TextStreamsKt.readBytes((URL)uRL);
            String resultJson = new String((byte[])object2, charset);
            Json this_$iv = this.json;
            boolean $i$f$decodeFromString = false;
            object2 = this_$iv.getSerializersModule();
            Intrinsics.reifiedOperationMarker((int)6, (String)"T");
            MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
            object = this_$iv.decodeFromString((DeserializationStrategy)SerializersKt.serializer((SerializersModule)object2, null), resultJson);
        }
        catch (IOException ex) {
            LOG.warn("Failed to load resource by URL: " + url, (Throwable)ex);
            object = null;
        }
        catch (Throwable t) {
            LOG.warn("Failed to parse resource loaded from URL: " + url, t);
            object = null;
        }
        return (T)object;
    }

    @JvmStatic
    @NotNull
    public static final CommandSpecManager getInstance() {
        return Companion.getInstance();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(IJCommandSpecManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/terminal/exp/completion/IJCommandSpecManager$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/intellij/terminal/completion/CommandSpecManager;", "intellij.terminal"})
    @SourceDebugExtension(value={"SMAP\nIJCommandSpecManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IJCommandSpecManager.kt\norg/jetbrains/plugins/terminal/exp/completion/IJCommandSpecManager$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,128:1\n43#2,3:129\n*S KotlinDebug\n*F\n+ 1 IJCommandSpecManager.kt\norg/jetbrains/plugins/terminal/exp/completion/IJCommandSpecManager$Companion\n*L\n124#1:129,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final CommandSpecManager getInstance() {
            boolean $i$f$service = false;
            Class<CommandSpecManager> serviceClass$iv = CommandSpecManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            return (CommandSpecManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/terminal/exp/completion/IJCommandSpecManager$ShellCommandInfo;", "", "command", "Lorg/jetbrains/terminal/completion/ShellCommand;", "bean", "Lorg/jetbrains/plugins/terminal/exp/completion/CommandSpecsBean;", "(Lorg/jetbrains/terminal/completion/ShellCommand;Lorg/jetbrains/plugins/terminal/exp/completion/CommandSpecsBean;)V", "getBean", "()Lorg/jetbrains/plugins/terminal/exp/completion/CommandSpecsBean;", "getCommand", "()Lorg/jetbrains/terminal/completion/ShellCommand;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.terminal"})
    private static final class ShellCommandInfo {
        @NotNull
        private final ShellCommand command;
        @NotNull
        private final CommandSpecsBean bean;

        public ShellCommandInfo(@NotNull ShellCommand command, @NotNull CommandSpecsBean bean) {
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
            this.command = command;
            this.bean = bean;
        }

        @NotNull
        public final ShellCommand getCommand() {
            return this.command;
        }

        @NotNull
        public final CommandSpecsBean getBean() {
            return this.bean;
        }

        @NotNull
        public final ShellCommand component1() {
            return this.command;
        }

        @NotNull
        public final CommandSpecsBean component2() {
            return this.bean;
        }

        @NotNull
        public final ShellCommandInfo copy(@NotNull ShellCommand command, @NotNull CommandSpecsBean bean) {
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
            return new ShellCommandInfo(command, bean);
        }

        public static /* synthetic */ ShellCommandInfo copy$default(ShellCommandInfo shellCommandInfo, ShellCommand shellCommand2, CommandSpecsBean commandSpecsBean, int n, Object object) {
            if ((n & 1) != 0) {
                shellCommand2 = shellCommandInfo.command;
            }
            if ((n & 2) != 0) {
                commandSpecsBean = shellCommandInfo.bean;
            }
            return shellCommandInfo.copy(shellCommand2, commandSpecsBean);
        }

        @NotNull
        public String toString() {
            return "ShellCommandInfo(command=" + this.command + ", bean=" + this.bean + ")";
        }

        public int hashCode() {
            int result2 = this.command.hashCode();
            result2 = result2 * 31 + this.bean.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ShellCommandInfo)) {
                return false;
            }
            ShellCommandInfo shellCommandInfo = (ShellCommandInfo)other;
            if (!Intrinsics.areEqual((Object)this.command, (Object)shellCommandInfo.command)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.bean, (Object)shellCommandInfo.bean);
        }
    }
}

