/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp.ui;

import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.terminal.BlockTerminalColors;
import com.intellij.terminal.TerminalColorPalette;
import com.jediterm.terminal.ui.AwtTransformers;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0011H\u0014R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/terminal/exp/ui/BlockTerminalColorPalette;", "Lcom/intellij/terminal/TerminalColorPalette;", "colorsScheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "(Lcom/intellij/openapi/editor/colors/EditorColorsScheme;)V", "colorKeys", "", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "[Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "defaultBackground", "Lcom/jediterm/core/Color;", "getDefaultBackground", "()Lcom/jediterm/core/Color;", "defaultForeground", "getDefaultForeground", "getAnsiColorKey", "value", "", "getAttributesByColorIndex", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "index", "intellij.terminal"})
public final class BlockTerminalColorPalette
extends TerminalColorPalette {
    @NotNull
    private final EditorColorsScheme colorsScheme;
    @NotNull
    private final TextAttributesKey[] colorKeys;

    public BlockTerminalColorPalette(@NotNull EditorColorsScheme colorsScheme) {
        Intrinsics.checkNotNullParameter((Object)colorsScheme, (String)"colorsScheme");
        this.colorsScheme = colorsScheme;
        this.colorKeys = BlockTerminalColors.INSTANCE.getKEYS();
    }

    @NotNull
    public com.jediterm.core.Color getDefaultForeground() {
        Color foregroundColor = this.colorsScheme.getColor(BlockTerminalColors.getDEFAULT_FOREGROUND());
        Color color = foregroundColor;
        if (color == null) {
            Color color2 = this.colorsScheme.getDefaultForeground();
            color = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getDefaultForeground(...)");
        }
        com.jediterm.core.Color color3 = AwtTransformers.fromAwtColor((Color)color);
        Intrinsics.checkNotNull((Object)color3);
        return color3;
    }

    @NotNull
    public com.jediterm.core.Color getDefaultBackground() {
        Color backgroundColor = this.colorsScheme.getColor(BlockTerminalColors.getDEFAULT_BACKGROUND());
        Color color = backgroundColor;
        if (color == null) {
            Color color2 = this.colorsScheme.getDefaultBackground();
            color = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getDefaultBackground(...)");
        }
        com.jediterm.core.Color color3 = AwtTransformers.fromAwtColor((Color)color);
        Intrinsics.checkNotNull((Object)color3);
        return color3;
    }

    @Nullable
    protected TextAttributes getAttributesByColorIndex(int index) {
        TextAttributesKey textAttributesKey = this.getAnsiColorKey(index);
        if (textAttributesKey == null) {
            return null;
        }
        TextAttributesKey key = textAttributesKey;
        return this.colorsScheme.getAttributes(key);
    }

    private final TextAttributesKey getAnsiColorKey(int value) {
        return (0 <= value ? value < this.colorKeys.length : false) ? this.colorKeys[value] : null;
    }
}

