/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp.ui;

import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0007R\u0014\u0010\u000b\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/plugins/terminal/exp/ui/GradientTextureCache;", "Lcom/intellij/openapi/Disposable;", "scheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "colorStartKey", "Lcom/intellij/openapi/editor/colors/ColorKey;", "colorEndKey", "defaultColorStart", "Ljava/awt/Color;", "defaultColorEnd", "(Lcom/intellij/openapi/editor/colors/EditorColorsScheme;Lcom/intellij/openapi/editor/colors/ColorKey;Lcom/intellij/openapi/editor/colors/ColorKey;Ljava/awt/Color;Ljava/awt/Color;)V", "colorEnd", "getColorEnd", "()Ljava/awt/Color;", "colorStart", "getColorStart", "texture", "Ljava/awt/TexturePaint;", "dispose", "", "getTexture", "graphics", "Ljava/awt/Graphics2D;", "width", "", "intellij.terminal"})
public final class GradientTextureCache
implements Disposable {
    @NotNull
    private final EditorColorsScheme scheme;
    @NotNull
    private final ColorKey colorStartKey;
    @NotNull
    private final ColorKey colorEndKey;
    @NotNull
    private final Color defaultColorStart;
    @NotNull
    private final Color defaultColorEnd;
    @Nullable
    private TexturePaint texture;

    public GradientTextureCache(@NotNull EditorColorsScheme scheme, @NotNull ColorKey colorStartKey, @NotNull ColorKey colorEndKey, @NotNull Color defaultColorStart, @NotNull Color defaultColorEnd) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        Intrinsics.checkNotNullParameter((Object)colorStartKey, (String)"colorStartKey");
        Intrinsics.checkNotNullParameter((Object)colorEndKey, (String)"colorEndKey");
        Intrinsics.checkNotNullParameter((Object)defaultColorStart, (String)"defaultColorStart");
        Intrinsics.checkNotNullParameter((Object)defaultColorEnd, (String)"defaultColorEnd");
        this.scheme = scheme;
        this.colorStartKey = colorStartKey;
        this.colorEndKey = colorEndKey;
        this.defaultColorStart = defaultColorStart;
        this.defaultColorEnd = defaultColorEnd;
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        Topic topic = LafManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection.subscribe(topic, arg_0 -> GradientTextureCache._init_$lambda$0(this, arg_0));
    }

    @NotNull
    public final Color getColorStart() {
        Color color = this.scheme.getColor(this.colorStartKey);
        if (color == null) {
            color = this.defaultColorStart;
        }
        return color;
    }

    private final Color getColorEnd() {
        Color color = this.scheme.getColor(this.colorEndKey);
        if (color == null) {
            color = this.defaultColorEnd;
        }
        return color;
    }

    @RequiresEdt
    @NotNull
    public final TexturePaint getTexture(@NotNull Graphics2D graphics, int width) {
        TexturePaint texturePaint;
        BufferedImage bufferedImage;
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
        int realWidth = (int)Math.floor(JBUIScale.sysScale((Graphics2D)graphics) * (float)width);
        TexturePaint texturePaint2 = this.texture;
        if (!(texturePaint2 != null && (bufferedImage = texturePaint2.getImage()) != null ? realWidth == bufferedImage.getWidth() : false)) {
            TexturePaint it = texturePaint2 = AppUIUtil.createHorizontalGradientTexture$default((AppUIUtil)AppUIUtil.INSTANCE, (Graphics)graphics, (Color)this.getColorStart(), (Color)this.getColorEnd(), (int)width, (int)0, (int)0, (int)48, null);
            boolean bl = false;
            this.texture = it;
            texturePaint = texturePaint2;
        } else {
            TexturePaint texturePaint3 = this.texture;
            texturePaint = texturePaint3;
            Intrinsics.checkNotNull((Object)texturePaint3);
        }
        return texturePaint;
    }

    public void dispose() {
        this.texture = null;
    }

    private static final void _init_$lambda$0(GradientTextureCache this$0, LafManager it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.texture = null;
    }
}

