/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp.ui;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.CustomHighlighterOrder;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.exp.ui.GradientTextureCache;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u001b\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/terminal/exp/ui/TerminalBlockBackgroundRenderer;", "Lcom/intellij/openapi/editor/markup/CustomHighlighterRenderer;", "background", "Ljava/awt/Color;", "(Ljava/awt/Color;)V", "gradientCache", "Lorg/jetbrains/plugins/terminal/exp/ui/GradientTextureCache;", "(Lorg/jetbrains/plugins/terminal/exp/ui/GradientTextureCache;)V", "(Ljava/awt/Color;Lorg/jetbrains/plugins/terminal/exp/ui/GradientTextureCache;)V", "getOrder", "Lcom/intellij/openapi/editor/markup/CustomHighlighterOrder;", "paint", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "g", "Ljava/awt/Graphics;", "intellij.terminal"})
public final class TerminalBlockBackgroundRenderer
implements CustomHighlighterRenderer {
    @Nullable
    private final Color background;
    @Nullable
    private final GradientTextureCache gradientCache;

    private TerminalBlockBackgroundRenderer(Color background, GradientTextureCache gradientCache) {
        this.background = background;
        this.gradientCache = gradientCache;
    }

    public TerminalBlockBackgroundRenderer(@NotNull Color background) {
        Intrinsics.checkNotNullParameter((Object)background, (String)"background");
        this(background, null);
    }

    public TerminalBlockBackgroundRenderer(@NotNull GradientTextureCache gradientCache) {
        Intrinsics.checkNotNullParameter((Object)gradientCache, (String)"gradientCache");
        this(null, gradientCache);
    }

    @NotNull
    public CustomHighlighterOrder getOrder() {
        return CustomHighlighterOrder.BEFORE_BACKGROUND;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(@NotNull Editor editor, @NotNull RangeHighlighter highlighter, @NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Rectangle rectangle = editor.getScrollingModel().getVisibleArea();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getVisibleArea(...)");
        Rectangle visibleArea = rectangle;
        int width = visibleArea.width - JBUI.scale((int)7);
        float topY = editor.offsetToXY((int)highlighter.getStartOffset()).y;
        float bottomY = (float)editor.offsetToXY((int)highlighter.getEndOffset()).y + (float)editor.getLineHeight();
        Rectangle2D.Float rect = new Rectangle2D.Float(0.0f, topY, width, bottomY - topY);
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2d = (Graphics2D)graphics;
        try {
            Object object = this.gradientCache;
            Paint paint = object != null && (object = ((GradientTextureCache)object).getTexture(g2d, width)) != null ? (Paint)object : (Paint)this.background;
            g2d.setPaint(paint);
            g2d.fill(rect);
        }
        finally {
            g2d.dispose();
        }
    }
}

