/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp.ui;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.exp.TerminalUi;
import org.jetbrains.plugins.terminal.exp.TerminalUiUtils;
import org.jetbrains.plugins.terminal.exp.ui.GradientTextureCache;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB1\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000bJ \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/terminal/exp/ui/TerminalBlockCornersRenderer;", "Lcom/intellij/openapi/editor/markup/CustomHighlighterRenderer;", "background", "Ljava/awt/Color;", "strokeBackground", "strokeWidth", "", "(Ljava/awt/Color;Ljava/awt/Color;I)V", "gradientCache", "Lorg/jetbrains/plugins/terminal/exp/ui/GradientTextureCache;", "(Lorg/jetbrains/plugins/terminal/exp/ui/GradientTextureCache;)V", "(Ljava/awt/Color;Lorg/jetbrains/plugins/terminal/exp/ui/GradientTextureCache;Ljava/awt/Color;I)V", "paint", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "g", "Ljava/awt/Graphics;", "intellij.terminal"})
public final class TerminalBlockCornersRenderer
implements CustomHighlighterRenderer {
    @Nullable
    private final Color background;
    @Nullable
    private final GradientTextureCache gradientCache;
    @Nullable
    private final Color strokeBackground;
    private final int strokeWidth;

    private TerminalBlockCornersRenderer(Color background, GradientTextureCache gradientCache, Color strokeBackground, int strokeWidth) {
        this.background = background;
        this.gradientCache = gradientCache;
        this.strokeBackground = strokeBackground;
        this.strokeWidth = strokeWidth;
    }

    /* synthetic */ TerminalBlockCornersRenderer(Color color, GradientTextureCache gradientTextureCache, Color color2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            color2 = null;
        }
        if ((n2 & 8) != 0) {
            n = 0;
        }
        this(color, gradientTextureCache, color2, n);
    }

    public TerminalBlockCornersRenderer(@NotNull Color background, @Nullable Color strokeBackground, int strokeWidth) {
        Intrinsics.checkNotNullParameter((Object)background, (String)"background");
        this(background, null, strokeBackground, strokeWidth);
    }

    public /* synthetic */ TerminalBlockCornersRenderer(Color color, Color color2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            color2 = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(color, color2, n);
    }

    public TerminalBlockCornersRenderer(@NotNull GradientTextureCache gradientCache) {
        Intrinsics.checkNotNullParameter((Object)gradientCache, (String)"gradientCache");
        this(null, gradientCache, null, 0, 12, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(@NotNull Editor editor, @NotNull RangeHighlighter highlighter, @NotNull Graphics g) {
        Path2D.Float float_;
        Path2D.Float float_2;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        float topIns = TerminalUiUtils.INSTANCE.toFloatAndScale(8);
        float bottomIns = TerminalUiUtils.INSTANCE.toFloatAndScale(12);
        float cornerToBlock = JBUI.scale((int)7);
        float gap = TerminalUiUtils.INSTANCE.toFloatAndScale(6);
        float arc = TerminalUiUtils.INSTANCE.toFloatAndScale(8);
        Rectangle rectangle = editor.getScrollingModel().getVisibleArea();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getVisibleArea(...)");
        Rectangle visibleArea = rectangle;
        float width = (float)visibleArea.width - cornerToBlock;
        float topY = (float)editor.offsetToXY((int)highlighter.getStartOffset()).y - topIns;
        float bottomY = (float)(editor.offsetToXY((int)highlighter.getEndOffset()).y + editor.getLineHeight()) + bottomIns;
        Rectangle2D.Float topRect = new Rectangle2D.Float(0.0f, topY, width, topIns);
        Rectangle2D.Float bottomRect = new Rectangle2D.Float(0.0f, bottomY - bottomIns, width, bottomIns + gap);
        Path2D.Float $this$paint_u24lambda_u240 = float_2 = new Path2D.Float(0);
        boolean bl = false;
        $this$paint_u24lambda_u240.moveTo(0.0f, topY);
        $this$paint_u24lambda_u240.lineTo(width - arc, topY);
        $this$paint_u24lambda_u240.quadTo(width, topY, width, topY + arc);
        $this$paint_u24lambda_u240.lineTo(width, topY + topIns);
        $this$paint_u24lambda_u240.lineTo(0.0f, topY + topIns);
        $this$paint_u24lambda_u240.lineTo(0.0f, topY);
        $this$paint_u24lambda_u240.closePath();
        Path2D.Float topCornerPath = float_2;
        Path2D.Float $this$paint_u24lambda_u241 = $this$paint_u24lambda_u240 = new Path2D.Float(0);
        boolean bl2 = false;
        $this$paint_u24lambda_u241.moveTo(0.0f, bottomY - bottomIns);
        $this$paint_u24lambda_u241.lineTo(width, bottomY - bottomIns);
        $this$paint_u24lambda_u241.lineTo(width, bottomY - arc);
        $this$paint_u24lambda_u241.quadTo(width, bottomY, width - arc, bottomY);
        $this$paint_u24lambda_u241.lineTo(0.0f, bottomY);
        $this$paint_u24lambda_u241.lineTo(0.0f, bottomY - bottomIns);
        $this$paint_u24lambda_u241.closePath();
        Path2D.Float bottomCornerPath = $this$paint_u24lambda_u240;
        if (this.strokeWidth > 0 && this.strokeBackground != null) {
            Path2D.Float float_3;
            Path2D.Float float_4;
            float stroke = TerminalUiUtils.INSTANCE.toFloatAndScale(this.strokeWidth);
            Path2D.Float $this$paint_u24lambda_u242 = float_4 = new Path2D.Float(0);
            boolean bl3 = false;
            $this$paint_u24lambda_u242.moveTo(0.0f, topY);
            $this$paint_u24lambda_u242.lineTo(width - arc, topY);
            $this$paint_u24lambda_u242.quadTo(width, topY, width, topY + arc);
            $this$paint_u24lambda_u242.lineTo(width, bottomY - arc);
            $this$paint_u24lambda_u242.quadTo(width, bottomY, width - arc, bottomY);
            $this$paint_u24lambda_u242.lineTo(0.0f, bottomY);
            Path2D.Float outerPath = float_4;
            Path2D.Float $this$paint_u24lambda_u243 = float_3 = new Path2D.Float(0);
            boolean bl4 = false;
            $this$paint_u24lambda_u243.moveTo(0.0f, topY + stroke);
            $this$paint_u24lambda_u243.lineTo(width - arc, topY + stroke);
            $this$paint_u24lambda_u243.quadTo(width - stroke, topY + stroke, width - stroke, topY + arc);
            $this$paint_u24lambda_u243.lineTo(width - stroke, bottomY - arc);
            $this$paint_u24lambda_u243.quadTo(width - stroke, bottomY - stroke, width - arc, bottomY - stroke);
            $this$paint_u24lambda_u243.lineTo(0.0f, bottomY - stroke);
            Path2D.Float innerPath = float_3;
            Path2D.Float $this$paint_u24lambda_u244 = float_3 = new Path2D.Float(0);
            boolean bl5 = false;
            $this$paint_u24lambda_u244.append(outerPath, false);
            $this$paint_u24lambda_u244.append(innerPath, false);
            $this$paint_u24lambda_u244.moveTo(0.0f, topY);
            $this$paint_u24lambda_u244.lineTo(0.0f, topY + stroke);
            $this$paint_u24lambda_u244.moveTo(0.0f, bottomY - stroke);
            $this$paint_u24lambda_u244.lineTo(0.0f, bottomY);
            $this$paint_u24lambda_u244.closePath();
            float_ = float_3;
        } else {
            float_ = null;
        }
        Path2D.Float strokePath = float_;
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2d = (Graphics2D)graphics;
        try {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setColor(TerminalUi.INSTANCE.getTerminalBackground());
            g2d.fill(topRect);
            g2d.fill(bottomRect);
            Object object = this.gradientCache;
            g2d.setPaint(object != null && (object = ((GradientTextureCache)object).getTexture(g2d, (int)width)) != null ? (Paint)object : (Paint)this.background);
            g2d.fill(topCornerPath);
            g2d.fill(bottomCornerPath);
            if (strokePath != null) {
                g2d.setPaint(this.strokeBackground);
                g2d.fill(strokePath);
            }
        }
        finally {
            g2d.dispose();
        }
    }
}

