/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.fus;

import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.AllowedItemsResourceWeakRefStorage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.fus.TerminalCommandUsageStatistics;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001!B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\r0\u000bH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\fH\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0017\u001a\u00020\fH\u0002J\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u00042\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u001aH\u0002J.\u0010\u001b\u001a\u00020\u001c2\u0016\u0010\u001d\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0006\u0012\u0004\u0018\u00010\f0\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\bR\u000e\u0010\u0011\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/plugins/terminal/fus/TerminalCommandUsageStatistics;", "", "()V", "absolutePathCommand", "Lorg/jetbrains/plugins/terminal/fus/TerminalCommandUsageStatistics$TerminalCommandEventData;", "commandExecutableField", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "getCommandExecutableField$intellij_terminal", "()Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "emptyCommand", "knownCommandToSubCommandsMap", "", "", "", "relativePathCommand", "subCommandField", "getSubCommandField$intellij_terminal", "whitespacesCommand", "buildKnownCommandToSubCommandMap", "isRelativePath", "", "executable", "toEventData", "userCommandLine", "toKnownCommand", "userCommand", "", "triggerCommandExecuted", "", "commandExecutedEvent", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "project", "Lcom/intellij/openapi/project/Project;", "TerminalCommandEventData", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalCommandUsageStatistics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalCommandUsageStatistics.kt\norg/jetbrains/plugins/terminal/fus/TerminalCommandUsageStatistics\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n1003#2:81\n1037#2,3:82\n1040#2,3:92\n372#3,7:85\n125#4:95\n152#4,3:96\n1253#5,4:99\n*S KotlinDebug\n*F\n+ 1 TerminalCommandUsageStatistics.kt\norg/jetbrains/plugins/terminal/fus/TerminalCommandUsageStatistics\n*L\n74#1:81\n74#1:82,3\n74#1:92,3\n74#1:85,7\n75#1:95\n75#1:96,3\n75#1:99,4\n*E\n"})
public final class TerminalCommandUsageStatistics {
    @NotNull
    public static final TerminalCommandUsageStatistics INSTANCE = new TerminalCommandUsageStatistics();
    @NotNull
    private static final TerminalCommandEventData emptyCommand = new TerminalCommandEventData("<empty>", null);
    @NotNull
    private static final TerminalCommandEventData whitespacesCommand = new TerminalCommandEventData("<whitespaces>", null);
    @NotNull
    private static final TerminalCommandEventData relativePathCommand = new TerminalCommandEventData("<relative path>", null);
    @NotNull
    private static final TerminalCommandEventData absolutePathCommand = new TerminalCommandEventData("<absolute path>", null);
    @NotNull
    private static final Map<String, Set<String>> knownCommandToSubCommandsMap = INSTANCE.buildKnownCommandToSubCommandMap();
    @NotNull
    private static final StringEventField commandExecutableField;
    @NotNull
    private static final StringEventField subCommandField;

    private TerminalCommandUsageStatistics() {
    }

    @NotNull
    public final StringEventField getCommandExecutableField$intellij_terminal() {
        return commandExecutableField;
    }

    @NotNull
    public final StringEventField getSubCommandField$intellij_terminal() {
        return subCommandField;
    }

    public final void triggerCommandExecuted(@NotNull EventId2<? super String, ? super String> commandExecutedEvent, @NotNull Project project, @NotNull String userCommandLine) {
        TerminalCommandEventData eventData;
        Intrinsics.checkNotNullParameter(commandExecutedEvent, (String)"commandExecutedEvent");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)userCommandLine, (String)"userCommandLine");
        TerminalCommandEventData terminalCommandEventData = eventData = this.toEventData(userCommandLine);
        TerminalCommandEventData terminalCommandEventData2 = eventData;
        commandExecutedEvent.log(project, (Object)(terminalCommandEventData != null ? terminalCommandEventData.getCommand() : null), (Object)(terminalCommandEventData2 != null ? terminalCommandEventData2.getSubCommand() : null));
    }

    private final TerminalCommandEventData toEventData(String userCommandLine) {
        if (((CharSequence)userCommandLine).length() == 0) {
            return emptyCommand;
        }
        if (StringsKt.isBlank((CharSequence)userCommandLine)) {
            return whitespacesCommand;
        }
        List list = ParametersListUtil.parse((String)userCommandLine);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"parse(...)");
        List userCommand = list;
        TerminalCommandEventData terminalCommandEventData = this.toKnownCommand(userCommand);
        if (terminalCommandEventData != null) {
            TerminalCommandEventData it = terminalCommandEventData;
            boolean bl = false;
            return it;
        }
        String string = (String)CollectionsKt.getOrNull((List)userCommand, (int)0);
        if (string == null) {
            return null;
        }
        String executable = string;
        if (this.isRelativePath(executable) && executable.length() > 2) {
            String string2 = PathUtil.toSystemIndependentName((String)executable);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemIndependentName(...)");
            if (StringsKt.startsWith$default((String)string2, (String)"./gradlew", (boolean)false, (int)2, null)) {
                return this.toKnownCommand(CollectionsKt.listOf((Object)"gradle"));
            }
            return relativePathCommand;
        }
        return OSAgnosticPathUtil.isAbsolute((String)executable) && executable.length() > 3 ? absolutePathCommand : null;
    }

    private final boolean isRelativePath(String executable) {
        return StringsKt.startsWith$default((String)executable, (String)"./", (boolean)false, (int)2, null) || SystemInfo.isWindows && StringsKt.startsWith$default((String)executable, (String)".\\", (boolean)false, (int)2, null);
    }

    private final TerminalCommandEventData toKnownCommand(List<String> userCommand) {
        String string;
        String string2 = (String)CollectionsKt.getOrNull(userCommand, (int)0);
        if (string2 == null) {
            return null;
        }
        String it = string2;
        boolean bl = false;
        String executable = SystemInfo.isWindows ? StringsKt.removeSuffix((String)it, (CharSequence)".exe") : it;
        Set<String> set = knownCommandToSubCommandsMap.get(executable);
        if (set == null) {
            return null;
        }
        Set<String> knownSubCommands = set;
        String string3 = (String)CollectionsKt.getOrNull(userCommand, (int)1);
        if (string3 != null) {
            String it2 = string3;
            boolean bl2 = false;
            string = knownSubCommands.contains(it2) ? it2 : null;
        } else {
            string = null;
        }
        String subCommand = string;
        return new TerminalCommandEventData(executable, subCommand);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Set<String>> buildKnownCommandToSubCommandMap() {
        void $this$associateTo$iv;
        void $this$mapTo$iv$iv;
        Object object;
        Object list$iv$iv;
        Pair it;
        Map $this$groupByTo$iv$iv;
        Set set = new AllowedItemsResourceWeakRefStorage(INSTANCE.getClass(), "known-commands.txt").getItems();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getItems(...)");
        Set commandLines = set;
        Sequence $this$groupBy$iv = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)commandLines), (Function1)buildKnownCommandToSubCommandMap.result.1.INSTANCE);
        boolean $i$f$groupBy = false;
        Sequence sequence = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Object object2 = $this$groupByTo$iv$iv.iterator();
        while (object2.hasNext()) {
            void it2;
            Object object3;
            Object element$iv$iv = object2.next();
            it = (Pair)element$iv$iv;
            boolean $i$a$-groupBy-TerminalCommandUsageStatistics$buildKnownCommandToSubCommandMap$result$42 = false;
            String key$iv$iv = (String)it.getFirst();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object3 = answer$iv$iv$iv;
            } else {
                object3 = value$iv$iv$iv;
            }
            list$iv$iv = (List)object3;
            Pair $i$a$-groupBy-TerminalCommandUsageStatistics$buildKnownCommandToSubCommandMap$result$42 = (Pair)element$iv$iv;
            object = list$iv$iv;
            boolean bl = false;
            object.add((String)it2.getSecond());
        }
        Map result2 = destination$iv$iv;
        Object $this$map$iv = result2;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            list$iv$iv = item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(TuplesKt.to(it.getKey(), Set.copyOf(CollectionsKt.filterNotNull((Iterable)((Iterable)it.getValue())))));
        }
        $this$map$iv = (List)destination$iv$iv;
        Map destination$iv = new HashMap(result2.size());
        boolean $i$f$associateTo = false;
        for (Object element$iv : $this$associateTo$iv) {
            object2 = destination$iv;
            Pair it3 = (Pair)element$iv;
            boolean bl = false;
            Pair pair = it3;
            object2.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv;
    }

    static {
        Object[] objectArray = new String[]{relativePathCommand.getCommand(), absolutePathCommand.getCommand(), emptyCommand.getCommand(), whitespacesCommand.getCommand()};
        commandExecutableField = EventFields.String$default((String)"command", (List)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)knownCommandToSubCommandsMap.keySet()), null, (int)4, null);
        subCommandField = EventFields.String$default((String)"subCommand", (List)CollectionsKt.flatten((Iterable)knownCommandToSubCommandsMap.values()), null, (int)4, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/terminal/fus/TerminalCommandUsageStatistics$TerminalCommandEventData;", "", "command", "", "subCommand", "(Ljava/lang/String;Ljava/lang/String;)V", "getCommand", "()Ljava/lang/String;", "getSubCommand", "intellij.terminal"})
    private static final class TerminalCommandEventData {
        @NotNull
        private final String command;
        @Nullable
        private final String subCommand;

        public TerminalCommandEventData(@NotNull String command, @Nullable String subCommand) {
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            this.command = command;
            this.subCommand = subCommand;
        }

        @NotNull
        public final String getCommand() {
            return this.command;
        }

        @Nullable
        public final String getSubCommand() {
            return this.subCommand;
        }
    }
}

