/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.fus;

import com.intellij.internal.statistic.collectors.fus.TerminalFusAwareHandler;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.ClassEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Version;
import com.intellij.terminal.TerminalShellCommandHandler;
import com.intellij.util.PathUtil;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.fus.TerminalCommandUsageStatistics;
import org.jetbrains.plugins.terminal.fus.TerminalUsageCollectorKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\u0004H\u0016J\u0012\u0010\u0012\u001a\u00020\n2\b\u0010\u0013\u001a\u0004\u0018\u00010\nH\u0003J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\nH\u0007J#\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\u001bH\u0007\u00a2\u0006\u0002\u0010\u001cJ:\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u001e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020 H\u0007J\u0010\u0010%\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0010\u0010&\u001a\u00020\n2\u0006\u0010'\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/plugins/terminal/fus/TerminalUsageTriggerCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "RUN_ANYTHING_PROVIDER_FIELD", "Lcom/intellij/internal/statistic/eventLog/events/ClassEventField;", "TERMINAL_COMMAND_HANDLER_FIELD", "commandExecutedEvent", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "", "localExecEvent", "sshExecEvent", "Lcom/intellij/internal/statistic/eventLog/events/EventId;", "terminalSmartCommandExecutedEvent", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "terminalSmartCommandNotExecutedEvent", "getGroup", "getShellNameForStat", "shellName", "triggerCommandExecuted", "", "project", "Lcom/intellij/openapi/project/Project;", "userCommandLine", "triggerLocalShellStarted", "shellCommand", "", "(Lcom/intellij/openapi/project/Project;[Ljava/lang/String;)V", "triggerSmartCommand", "workingDirectory", "localSession", "", "command", "handler", "Lcom/intellij/terminal/TerminalShellCommandHandler;", "executed", "triggerSshShellStarted", "trimKnownExt", "name", "intellij.terminal"})
public final class TerminalUsageTriggerCollector
extends CounterUsagesCollector {
    @NotNull
    public static final TerminalUsageTriggerCollector INSTANCE = new TerminalUsageTriggerCollector();
    @NotNull
    private static final EventLogGroup GROUP = new EventLogGroup("terminalShell", 16, null, null, 12, null);
    @NotNull
    private static final ClassEventField TERMINAL_COMMAND_HANDLER_FIELD = EventFields.Class$default((String)"terminalCommandHandler", null, (int)2, null);
    @NotNull
    private static final ClassEventField RUN_ANYTHING_PROVIDER_FIELD = EventFields.Class$default((String)"runAnythingProvider", null, (int)2, null);
    @NotNull
    private static final EventId sshExecEvent = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"ssh.exec", null, (int)2, null);
    @NotNull
    private static final VarargEventId terminalSmartCommandExecutedEvent;
    @NotNull
    private static final VarargEventId terminalSmartCommandNotExecutedEvent;
    @NotNull
    private static final EventId2<String, String> localExecEvent;
    @NotNull
    private static final EventId2<String, String> commandExecutedEvent;

    private TerminalUsageTriggerCollector() {
    }

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    @JvmStatic
    public static final void triggerSshShellStarted(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        sshExecEvent.log(project);
    }

    @JvmStatic
    public static final void triggerCommandExecuted(@NotNull Project project, @NotNull String userCommandLine) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)userCommandLine, (String)"userCommandLine");
        TerminalCommandUsageStatistics.INSTANCE.triggerCommandExecuted(commandExecutedEvent, project, userCommandLine);
    }

    @JvmStatic
    public static final void triggerSmartCommand(@NotNull Project project, @Nullable String workingDirectory, boolean localSession, @NotNull String command, @NotNull TerminalShellCommandHandler handler, boolean executed) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Object[] objectArray = new EventPair[]{TERMINAL_COMMAND_HANDLER_FIELD.with(handler.getClass())};
        List data = CollectionsKt.mutableListOf((Object[])objectArray);
        if (handler instanceof TerminalFusAwareHandler) {
            ((TerminalFusAwareHandler)handler).fillData(project, workingDirectory, localSession, command, data);
        }
        if (executed) {
            terminalSmartCommandExecutedEvent.log(project, data);
        } else {
            terminalSmartCommandNotExecutedEvent.log(project, data);
        }
    }

    @JvmStatic
    public static final void triggerLocalShellStarted(@NotNull Project project, @NotNull String[] shellCommand2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)shellCommand2, (String)"shellCommand");
        Version version = Version.parseVersion((String)SystemInfo.OS_VERSION);
        String string = version != null ? version.toCompactString() : null;
        if (string == null) {
            string = "unknown";
        }
        localExecEvent.log(project, (Object)string, (Object)TerminalUsageTriggerCollector.getShellNameForStat((String)ArraysKt.firstOrNull((Object[])shellCommand2)));
    }

    @JvmStatic
    private static final String getShellNameForStat(String shellName) {
        String string;
        if (shellName == null) {
            return "unspecified";
        }
        String name = ((Object)StringsKt.trimStart((CharSequence)shellName)).toString();
        int ind = StringsKt.indexOf$default((CharSequence)name, (String)" ", (int)0, (boolean)false, (int)6, null);
        if (ind < 0) {
            string = name;
        } else {
            String string2 = name.substring(0, ind);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        }
        name = string;
        if (SystemInfo.isFileSystemCaseSensitive) {
            String string3 = name;
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
            String string4 = string3.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
            name = string4;
        }
        String string5 = PathUtil.getFileName((String)name);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getFileName(...)");
        name = string5;
        name = INSTANCE.trimKnownExt(name);
        return TerminalUsageCollectorKt.access$getKNOWN_SHELLS$p().contains(name) ? name : "other";
    }

    private final String trimKnownExt(String name) {
        String string;
        String ext = PathUtil.getFileExtension((String)name);
        if (ext != null && TerminalUsageCollectorKt.access$getKNOWN_EXTENSIONS$p().contains(ext)) {
            String string2 = name.substring(0, name.length() - ext.length() - 1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = name;
        }
        return string;
    }

    static {
        EventField[] eventFieldArray = new EventField[]{TERMINAL_COMMAND_HANDLER_FIELD, RUN_ANYTHING_PROVIDER_FIELD};
        terminalSmartCommandExecutedEvent = GROUP.registerVarargEvent("terminal.smart.command.executed", eventFieldArray);
        eventFieldArray = new EventField[]{TERMINAL_COMMAND_HANDLER_FIELD, RUN_ANYTHING_PROVIDER_FIELD};
        terminalSmartCommandNotExecutedEvent = GROUP.registerVarargEvent("terminal.smart.command.not.executed", eventFieldArray);
        localExecEvent = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"local.exec", (EventField)((EventField)EventFields.StringValidatedByRegexpReference$default((String)"os-version", (String)"version", null, (int)4, null)), (EventField)((EventField)EventFields.String$default((String)"shell", (List)CollectionsKt.toList((Iterable)TerminalUsageCollectorKt.access$getKNOWN_SHELLS$p()), null, (int)4, null)), null, (int)8, null);
        commandExecutedEvent = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"terminal.command.executed", (EventField)((EventField)TerminalCommandUsageStatistics.INSTANCE.getCommandExecutableField$intellij_terminal()), (EventField)((EventField)TerminalCommandUsageStatistics.INSTANCE.getSubCommandField$intellij_terminal()), null, (int)8, null);
    }
}

