/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ide.editor;

import com.intellij.codeWithMe.ClientId;
import com.intellij.codeWithMe.ClientIdKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientSessionsManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretActionListener;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.DisposableEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.rd.ide.editor.EditorSynchronizer;
import com.jetbrains.rd.ide.editor.EditorSynchronizerBase;
import com.jetbrains.rd.ide.editor.UtilKt;
import com.jetbrains.rd.ide.model.RdOpenFileDescriptor;
import com.jetbrains.rd.ide.model.ScrollingInfo;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.model.TextControlModel;
import com.jetbrains.rd.ide.model.VisibleRange;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.Signal;
import com.jetbrains.rd.util.reactive.SourceExKt;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 [2\u00020\u0001:\u0002[\\B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u00109\u001a\u00020:H\u0002J\u0010\u0010;\u001a\u00020:2\u0006\u0010<\u001a\u00020=H\u0016J\u0010\u0010>\u001a\u00020:2\u0006\u0010<\u001a\u00020=H\u0016J\u0010\u0010?\u001a\u00020:2\u0006\u0010<\u001a\u00020=H\u0016J\b\u0010@\u001a\u00020:H\u0007J\u0010\u0010A\u001a\u00020:2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010B\u001a\u00020:2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010C\u001a\u00020:H\u0014J\u0018\u0010D\u001a\u00020:2\u0006\u0010E\u001a\u00020\u00172\u0006\u0010F\u001a\u00020GH\u0016J\u0018\u0010H\u001a\u00020:2\u0006\u0010E\u001a\u00020\u00172\u0006\u0010F\u001a\u00020GH\u0002J\u0010\u0010I\u001a\u00020:2\u0006\u0010J\u001a\u00020\u0013H\u0004J\u0010\u0010K\u001a\u00020:2\u0006\u0010F\u001a\u00020GH\u0014J\u0010\u0010L\u001a\u00020:2\u0006\u0010J\u001a\u00020\u0013H\u0016J\b\u0010M\u001a\u00020:H\u0014J\b\u0010N\u001a\u00020:H\u0002J\u0010\u0010O\u001a\u00020:2\u0006\u0010<\u001a\u00020PH\u0016J\u0010\u0010Q\u001a\u00020:2\u0006\u0010R\u001a\u00020SH$J\u0018\u0010T\u001a\u00020:2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010U\u001a\u00020\u0017H\u0002J\u0010\u0010V\u001a\u00020:2\u0006\u0010W\u001a\u00020\u0017H\u0016J\u0010\u0010X\u001a\u00020:2\u0006\u0010W\u001a\u00020\u0017H\u0016J\u0010\u0010Y\u001a\u00020:2\u0006\u0010<\u001a\u00020ZH\u0016R\u0014\u0010\r\u001a\u00020\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\u0017X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0018\u0010 \u001a\f\u0012\u0004\u0012\u00020\u00170!R\u00020\u0000X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0019R\u0014\u0010#\u001a\u00020$X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0013\u0010'\u001a\u0004\u0018\u00010(8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u000e\u0010+\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00130-\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u000e\u00106\u001a\u000207X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u00108\u001a\f\u0012\u0004\u0012\u00020\u00170!R\u00020\u0000X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006]"}, d2={"Lcom/jetbrains/rd/ide/editor/EditorSynchronizerBase;", "Lcom/jetbrains/rd/ide/editor/EditorSynchronizer;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "textControlLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "textControlId", "Lcom/jetbrains/rd/ide/model/TextControlId;", "editorModel", "Lcom/jetbrains/rd/ide/model/TextControlModel;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/client/ClientAppSession;Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rd/ide/model/TextControlId;Lcom/jetbrains/rd/ide/model/TextControlModel;Lcom/intellij/openapi/editor/Editor;)V", "clientId", "Lcom/intellij/codeWithMe/ClientId;", "getClientId", "()Lcom/intellij/codeWithMe/ClientId;", "deferredScrollingRequests", "", "Lcom/jetbrains/rd/ide/model/ScrollingInfo;", "disposable", "Lcom/intellij/openapi/Disposable;", "dontSendChange", "", "getDontSendChange", "()Z", "setDontSendChange", "(Z)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getEditorModel", "()Lcom/jetbrains/rd/ide/model/TextControlModel;", "focusChangedSignalBucket", "Lcom/jetbrains/rd/ide/editor/EditorSynchronizerBase$EventSignalBucket;", "isReceivingChange", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "scheduledScrollingRequests", "scrollingReceived", "Lcom/jetbrains/rd/util/reactive/Signal;", "getScrollingReceived", "()Lcom/jetbrains/rd/util/reactive/Signal;", "getSession", "()Lcom/intellij/openapi/client/ClientAppSession;", "getTextControlId", "()Lcom/jetbrains/rd/ide/model/TextControlId;", "getTextControlLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "visibleAreaChangesQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "visibleSignalBucket", "applySettingsFromModel", "", "caretAdded", "e", "Lcom/intellij/openapi/editor/event/CaretEvent;", "caretPositionChanged", "caretRemoved", "flushVisibleAreaChangesQueue", "focusGained", "focusLost", "init", "openEditor", "focus", "descriptor", "Lcom/jetbrains/rd/ide/model/RdOpenFileDescriptor;", "openEditorDontSendChange", "performScrollingRequest", "request", "receiveFocusRequestFromModel", "receiveScrollingRequest", "receiveVisibleRequestFromModel", "scheduleScrollingRequests", "selectionChanged", "Lcom/intellij/openapi/editor/event/SelectionEvent;", "sendCaretStateChange", "reason", "", "sendFocusToModel", "isFocused", "setFocused", "value", "setVisible", "visibleAreaChanged", "Lcom/intellij/openapi/editor/event/VisibleAreaEvent;", "Companion", "EventSignalBucket", "intellij.rd.platform"})
@SourceDebugExtension(value={"SMAP\nEditorSynchronizerBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorSynchronizerBase.kt\ncom/jetbrains/rd/ide/editor/EditorSynchronizerBase\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 ReflectionUtil.kt\ncom/jetbrains/rd/util/reflection/ReflectionUtilKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,298:1\n53#2,4:299\n53#2,4:303\n53#2,4:319\n53#2,4:326\n11#3,12:307\n11#3,3:323\n16#3,7:330\n1855#4,2:337\n*S KotlinDebug\n*F\n+ 1 EditorSynchronizerBase.kt\ncom/jetbrains/rd/ide/editor/EditorSynchronizerBase\n*L\n107#1:299,4\n116#1:303,4\n138#1:319,4\n246#1:326,4\n131#1:307,12\n245#1:323,3\n245#1:330,7\n209#1:337,2\n*E\n"})
public abstract class EditorSynchronizerBase
implements EditorSynchronizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClientAppSession session;
    @NotNull
    private final Lifetime textControlLifetime;
    @NotNull
    private final TextControlId textControlId;
    @NotNull
    private final TextControlModel editorModel;
    @NotNull
    private final Editor editor;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Disposable disposable;
    @NotNull
    private final MergingUpdateQueue visibleAreaChangesQueue;
    @NotNull
    private final List<ScrollingInfo> deferredScrollingRequests;
    private boolean scheduledScrollingRequests;
    private boolean dontSendChange;
    @NotNull
    private final ClientId clientId;
    @NotNull
    private final Signal<ScrollingInfo> scrollingReceived;
    private EventSignalBucket<Boolean> visibleSignalBucket;
    private EventSignalBucket<Boolean> focusChangedSignalBucket;
    private static int debugId;

    public EditorSynchronizerBase(@NotNull ClientAppSession session, @NotNull Lifetime textControlLifetime, @NotNull TextControlId textControlId, @NotNull TextControlModel editorModel, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)textControlLifetime, (String)"textControlLifetime");
        Intrinsics.checkNotNullParameter((Object)textControlId, (String)"textControlId");
        Intrinsics.checkNotNullParameter((Object)((Object)editorModel), (String)"editorModel");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.session = session;
        this.textControlLifetime = textControlLifetime;
        this.textControlId = textControlId;
        this.editorModel = editorModel;
        this.editor = editor;
        int n = debugId;
        debugId = n + 1;
        Logger logger = Logger.getInstance((String)("#" + this.getClass().getCanonicalName() + "#" + n + "(" + UtilKt.createLogCategory(this.textControlId) + ")"));
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.disposable = DisposableEx.createNestedDisposable(this.textControlLifetime, "textControlLifetime");
        this.visibleAreaChangesQueue = new MergingUpdateQueue("updateViewportQueue", 100, true, MergingUpdateQueue.ANY_COMPONENT, this.disposable, this.editor.getComponent(), true);
        this.deferredScrollingRequests = new ArrayList();
        this.clientId = new ClientId(this.textControlId.getClientId());
        this.scrollingReceived = new Signal();
    }

    @NotNull
    public final ClientAppSession getSession() {
        return this.session;
    }

    @Override
    @NotNull
    public final Lifetime getTextControlLifetime() {
        return this.textControlLifetime;
    }

    @Override
    @NotNull
    public final TextControlId getTextControlId() {
        return this.textControlId;
    }

    @Override
    @NotNull
    public TextControlModel getEditorModel() {
        return this.editorModel;
    }

    @Override
    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    @Nullable
    public final Project getProject() {
        return this.editor.getProject();
    }

    @NotNull
    protected final Logger getLogger() {
        return this.logger;
    }

    protected final boolean getDontSendChange() {
        return this.dontSendChange;
    }

    protected final void setDontSendChange(boolean bl) {
        this.dontSendChange = bl;
    }

    @NotNull
    protected final ClientId getClientId() {
        return this.clientId;
    }

    @NotNull
    public final Signal<ScrollingInfo> getScrollingReceived() {
        return this.scrollingReceived;
    }

    @Override
    public boolean isReceivingChange() {
        ThreadingAssertions.assertEventDispatchThread();
        return this.dontSendChange;
    }

    protected void init() {
        this.visibleSignalBucket = new EventSignalBucket<Boolean>(this, this.textControlLifetime, this.getEditorModel().getVisibleChangedFromFrontend(), "visibleChangedFromFrontend");
        this.focusChangedSignalBucket = new EventSignalBucket<Boolean>(this, this.textControlLifetime, this.getEditorModel().getFocusChangedFromFrontend(), "focusChangedFromFrontend");
        this.visibleAreaChangesQueue.setRestartTimerOnAdd(true);
        Editor editor = this.editor;
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        ((EditorImpl)editor).addFocusListener((FocusChangeListener)this, this.disposable);
        ((EditorImpl)this.editor).getDocument().addDocumentListener((DocumentListener)this, this.disposable);
        ((EditorImpl)this.editor).getSelectionModel().addSelectionListener((SelectionListener)this, this.disposable);
        ((EditorImpl)this.editor).getCaretModel().addCaretActionListener((CaretActionListener)this, this.disposable);
        ((EditorImpl)this.editor).getCaretModel().addCaretListener((CaretListener)this, this.disposable);
        ((EditorImpl)this.editor).getScrollingModel().addVisibleAreaListener((VisibleAreaListener)this, this.disposable);
        this.getEditorModel().getTabSize().advise(this.textControlLifetime, (Function1)new Function1<Integer, Unit>(this){
            final /* synthetic */ EditorSynchronizerBase this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(int it) {
                EditorSynchronizerBase.access$applySettingsFromModel(this.this$0);
            }
        });
        this.getEditorModel().getIndentSize().advise(this.textControlLifetime, (Function1)new Function1<Integer, Unit>(this){
            final /* synthetic */ EditorSynchronizerBase this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(int it) {
                EditorSynchronizerBase.access$applySettingsFromModel(this.this$0);
            }
        });
        this.getEditorModel().getUseTab().advise(this.textControlLifetime, (Function1)new Function1<Boolean, Unit>(this){
            final /* synthetic */ EditorSynchronizerBase this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(boolean it) {
                EditorSynchronizerBase.access$applySettingsFromModel(this.this$0);
            }
        });
        this.getEditorModel().getRightMargin().advise(this.textControlLifetime, (Function1)new Function1<Integer, Unit>(this){
            final /* synthetic */ EditorSynchronizerBase this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(int rightMargin) {
                if (rightMargin != 0) {
                    ((EditorImpl)this.this$0.getEditor()).getSettings().setRightMargin(rightMargin);
                }
            }
        });
        this.getEditorModel().getRequestFocusFromBackend().advise(this.textControlLifetime, (Function1)new Function1<RdOpenFileDescriptor, Unit>(this){
            final /* synthetic */ EditorSynchronizerBase this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull RdOpenFileDescriptor it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.this$0.receiveFocusRequestFromModel(it);
            }
        });
        this.getEditorModel().getRequestVisibleFromBackend().advise(this.textControlLifetime, (Function1)new Function1<Unit, Unit>(this){
            final /* synthetic */ EditorSynchronizerBase this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Unit it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.this$0.receiveVisibleRequestFromModel();
            }
        });
    }

    private final void applySettingsFromModel() {
        CodeStyleSettingsManager.getInstance((Project)this.getProject()).notifyCodeStyleSettingsChanged();
        Editor editor = this.editor;
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        ((EditorEx)editor).reinitSettings();
    }

    protected void receiveVisibleRequestFromModel() {
        Logger $this$trace$iv = this.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Got visible request from model. Marking editor as not focused");
        }
        UIUtil.markAsFocused((JComponent)this.editor.getContentComponent(), (boolean)false);
        this.openEditorDontSendChange(false, new RdOpenFileDescriptor(null));
    }

    protected void receiveFocusRequestFromModel(@NotNull RdOpenFileDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Logger $this$trace$iv = this.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Got focus request from model. Marking editor as 'hasFocus'");
        }
        UIUtil.markAsFocused((JComponent)this.editor.getContentComponent(), (boolean)true);
        this.openEditorDontSendChange(true, descriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void openEditorDontSendChange(boolean focus, RdOpenFileDescriptor descriptor) {
        void $this$usingTrueFlag_u24default$iv;
        EditorSynchronizerBase editorSynchronizerBase = this;
        KMutableProperty1 flag$iv = (KMutableProperty1)openEditorDontSendChange.1.INSTANCE;
        boolean set$iv = true;
        boolean $i$f$usingTrueFlag = false;
        if (!((Boolean)flag$iv.get((Object)$this$usingTrueFlag_u24default$iv) == false)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        try {
            flag$iv.set((Object)$this$usingTrueFlag_u24default$iv, (Object)true);
            boolean bl = false;
            this.openEditor(focus, descriptor);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            flag$iv.set((Object)$this$usingTrueFlag_u24default$iv, (Object)false);
        }
    }

    @Override
    public void openEditor(boolean focus, @NotNull RdOpenFileDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Editor editor = this.editor;
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        VirtualFile virtualFile = ((EditorImpl)editor).getVirtualFile();
        Logger $this$trace$iv = this.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Opening text editor for file " + virtualFile + " and 'focusEditor=false'");
        }
        if (virtualFile == null) {
            return;
        }
        Project project = this.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        Integer n = descriptor.getDocOffset();
        FileEditorManager.getInstance((Project)project2).openTextEditor(new OpenFileDescriptor(project2, virtualFile, n != null ? n : -1), focus);
        if (focus) {
            IdeFocusManager.getInstance((Project)project2).requestFocusInProject((Component)((EditorImpl)this.editor).getContentComponent(), project2);
        }
    }

    public void focusGained(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.sendFocusToModel(editor, true);
    }

    public void focusLost(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.sendFocusToModel(editor, false);
    }

    private final void sendFocusToModel(Editor editor, boolean isFocused) {
        if (!Intrinsics.areEqual((Object)editor, (Object)this.editor)) {
            return;
        }
        this.setFocused(isFocused);
    }

    public void caretAdded(@NotNull CaretEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.sendCaretStateChange("Caret was added");
    }

    public void caretRemoved(@NotNull CaretEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.sendCaretStateChange("Caret was removed");
    }

    public void caretPositionChanged(@NotNull CaretEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.sendCaretStateChange("Caret was changed");
    }

    public void selectionChanged(@NotNull SelectionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.sendCaretStateChange("Selection was changed");
    }

    protected abstract void sendCaretStateChange(@NotNull String var1);

    public void visibleAreaChanged(@NotNull VisibleAreaEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.dontSendChange) {
            return;
        }
        if (!this.deferredScrollingRequests.isEmpty() && !e.getNewRectangle().isEmpty()) {
            this.scheduleScrollingRequests();
        }
        this.visibleAreaChangesQueue.queue(new Update(this){
            final /* synthetic */ EditorSynchronizerBase this$0;
            {
                this.this$0 = $receiver;
                super((Object)"SendViewport");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void run() {
                void this_$iv;
                ClientId.Companion companion = ClientId.Companion;
                ClientId clientId = this.this$0.getClientId();
                EditorSynchronizerBase editorSynchronizerBase = this.this$0;
                boolean $i$f$withClientId = false;
                ClientSessionsManager clientSessionsManager = this_$iv.getCachedService();
                if (clientSessionsManager == null) {
                    boolean bl = false;
                    VisibleRange value2 = UtilKt.calculateVisibleRange(editorSynchronizerBase.getEditor());
                    Logger $this$trace$iv = editorSynchronizerBase.getLogger();
                    boolean $i$f$trace = false;
                    if ($this$trace$iv.isTraceEnabled()) {
                        Logger logger = $this$trace$iv;
                        boolean bl2 = false;
                        logger.trace("Sending viewport (" + value2.getStartOffset() + ", " + value2.getEndOffset() + ").");
                    }
                    editorSynchronizerBase.getEditorModel().getVisibleRange().set((Object)((Object)value2));
                } else {
                    String string;
                    void clientId$iv;
                    ClientSessionsManager service$iv = clientSessionsManager;
                    if (clientId$iv == null || service$iv.isValid((ClientId)clientId$iv)) {
                        if (clientId$iv != null && this_$iv.isFakeLocalId((ClientId)clientId$iv)) {
                            string = this_$iv.getLocalId().getValue();
                        } else {
                            void v2 = clientId$iv;
                            string = v2 != null ? v2.getValue() : null;
                        }
                    } else {
                        Logger $this$trace$iv$iv = this_$iv.getClientIdLogger();
                        boolean $i$f$trace = false;
                        if ($this$trace$iv$iv.isTraceEnabled()) {
                            Logger logger = $this$trace$iv$iv;
                            boolean bl = false;
                            logger.trace("Invalid ClientId " + clientId$iv + " replaced with null at " + new Throwable().fillInStackTrace());
                        }
                        string = null;
                    }
                    String newClientIdValue$iv = string;
                    String oldClientIdValue$iv = ClientIdKt.getCurrentClientIdString();
                    try {
                        ClientIdKt.setCurrentClientIdString((String)newClientIdValue$iv);
                        boolean bl = false;
                        VisibleRange value3 = UtilKt.calculateVisibleRange(editorSynchronizerBase.getEditor());
                        Logger $this$trace$iv = editorSynchronizerBase.getLogger();
                        boolean $i$f$trace = false;
                        if ($this$trace$iv.isTraceEnabled()) {
                            Logger logger = $this$trace$iv;
                            boolean bl3 = false;
                            logger.trace("Sending viewport (" + value3.getStartOffset() + ", " + value3.getEndOffset() + ").");
                        }
                        editorSynchronizerBase.getEditorModel().getVisibleRange().set((Object)((Object)value3));
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        ClientIdKt.setCurrentClientIdString((String)oldClientIdValue$iv);
                    }
                }
            }

            public boolean isDisposed() {
                return this.this$0.getEditor().isDisposed();
            }
        });
    }

    private final void scheduleScrollingRequests() {
        if (!this.scheduledScrollingRequests) {
            this.scheduledScrollingRequests = true;
            SwingUtilities.invokeLater(() -> EditorSynchronizerBase.scheduleScrollingRequests$lambda$4(this));
        }
    }

    @Override
    public void setVisible(boolean value2) {
        EventSignalBucket<Boolean> eventSignalBucket = this.visibleSignalBucket;
        if (eventSignalBucket == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"visibleSignalBucket");
            eventSignalBucket = null;
        }
        eventSignalBucket.fire(value2);
    }

    @Override
    public void setFocused(boolean value2) {
        EventSignalBucket<Boolean> eventSignalBucket = this.focusChangedSignalBucket;
        if (eventSignalBucket == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"focusChangedSignalBucket");
            eventSignalBucket = null;
        }
        eventSignalBucket.fire(value2);
    }

    @Override
    public void receiveScrollingRequest(@NotNull ScrollingInfo request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.scrollingReceived.fire((Object)request);
        if (this.editor.getScrollingModel().getVisibleArea().isEmpty() || !this.deferredScrollingRequests.isEmpty()) {
            this.deferredScrollingRequests.add(request);
        } else {
            this.performScrollingRequest(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected final void performScrollingRequest(@NotNull ScrollingInfo request) {
        void $this$usingTrueFlag_u24default$iv;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        EditorSynchronizerBase editorSynchronizerBase = this;
        KMutableProperty1 flag$iv = (KMutableProperty1)performScrollingRequest.1.INSTANCE;
        boolean set$iv = true;
        boolean $i$f$usingTrueFlag = false;
        if (!((Boolean)flag$iv.get((Object)$this$usingTrueFlag_u24default$iv) == false)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        try {
            flag$iv.set((Object)$this$usingTrueFlag_u24default$iv, (Object)true);
            boolean bl = false;
            Logger $this$trace$iv = this.logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl2 = false;
                logger.trace("Applying backend scrolling to (" + request + ")");
            }
            Integer offset = request.getDocOffset();
            ScrollType scrollType = UtilKt.toScrollType(request.getKind());
            if (offset != null) {
                LogicalPosition logicalPosition = this.editor.offsetToLogicalPosition(offset.intValue());
                Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"offsetToLogicalPosition(...)");
                LogicalPosition pos = logicalPosition;
                this.editor.getScrollingModel().scrollTo(pos, scrollType);
            } else {
                this.editor.getScrollingModel().scrollToCaret(scrollType);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            flag$iv.set((Object)$this$usingTrueFlag_u24default$iv, (Object)false);
        }
    }

    @TestOnly
    public final void flushVisibleAreaChangesQueue() {
        this.visibleAreaChangesQueue.flush();
    }

    private static final void scheduleScrollingRequests$lambda$4(EditorSynchronizerBase this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.scheduledScrollingRequests = false;
        if (!this$0.editor.isDisposed() && !this$0.editor.getScrollingModel().getVisibleArea().isEmpty()) {
            Iterable $this$forEach$iv = this$0.deferredScrollingRequests;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ScrollingInfo p0 = (ScrollingInfo)element$iv;
                boolean bl = false;
                this$0.performScrollingRequest(p0);
            }
            this$0.deferredScrollingRequests.clear();
        }
    }

    public static final /* synthetic */ void access$applySettingsFromModel(EditorSynchronizerBase $this) {
        $this.applySettingsFromModel();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rd/ide/editor/EditorSynchronizerBase$Companion;", "", "()V", "debugId", "", "intellij.rd.platform"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0015\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u0000H\u0007\u00a2\u0006\u0002\u0010\u000fR\u0012\u0010\n\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rd/ide/editor/EditorSynchronizerBase$EventSignalBucket;", "T", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "signal", "Lcom/jetbrains/rd/util/reactive/ISignal;", "name", "", "(Lcom/jetbrains/rd/ide/editor/EditorSynchronizerBase;Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rd/util/reactive/ISignal;Ljava/lang/String;)V", "beforeReadyState", "Ljava/lang/Object;", "fire", "", "state", "(Ljava/lang/Object;)V", "intellij.rd.platform"})
    @SourceDebugExtension(value={"SMAP\nEditorSynchronizerBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorSynchronizerBase.kt\ncom/jetbrains/rd/ide/editor/EditorSynchronizerBase$EventSignalBucket\n+ 2 ClientId.kt\ncom/intellij/codeWithMe/ClientId$Companion\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,298:1\n230#2:299\n232#2,8:304\n240#2,10:316\n53#3,4:300\n53#3,4:312\n53#3,4:326\n*S KotlinDebug\n*F\n+ 1 EditorSynchronizerBase.kt\ncom/jetbrains/rd/ide/editor/EditorSynchronizerBase$EventSignalBucket\n*L\n287#1:299\n287#1:304,8\n287#1:316,10\n288#1:300,4\n287#1:312,4\n293#1:326,4\n*E\n"})
    private final class EventSignalBucket<T> {
        @NotNull
        private final ISignal<T> signal;
        @NotNull
        private final String name;
        @Nullable
        private T beforeReadyState;
        final /* synthetic */ EditorSynchronizerBase this$0;

        public EventSignalBucket(@NotNull EditorSynchronizerBase this$0, @NotNull Lifetime lifetime, @NotNull ISignal<T> signal, String name) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter(signal, (String)"signal");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.this$0 = this$0;
            this.signal = signal;
            this.name = name;
            if (!Intrinsics.areEqual((Object)this.this$0.getEditorModel().getBackendReadyForEvents().getValueOrNull(), (Object)true)) {
                SourceExKt.adviseUntil((ISource)((ISource)this.this$0.getEditorModel().getBackendReadyForEvents()), (Lifetime)lifetime, (Function1)((Function1)new Function1<Boolean, Boolean>(){

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final Boolean invoke(boolean isReady) {
                        void $this$trace$iv;
                        ThreadingAssertions.assertEventDispatchThread();
                        if (!isReady) {
                            return false;
                        }
                        Object object = beforeReadyState;
                        if (object == null) {
                            return true;
                        }
                        Object stateToSend = object;
                        Logger logger = this$0.getLogger();
                        EventSignalBucket eventSignalBucket = this;
                        boolean $i$f$trace = false;
                        if ($this$trace$iv.isTraceEnabled()) {
                            void var7_6 = $this$trace$iv;
                            boolean bl = false;
                            var7_6.trace("backendReadyForEvents setted to true, sending " + eventSignalBucket.name + " = " + eventSignalBucket.beforeReadyState);
                        }
                        this.fire(stateToSend);
                        return true;
                    }
                }));
            }
        }

        public /* synthetic */ EventSignalBucket(EditorSynchronizerBase editorSynchronizerBase, Lifetime lifetime, ISignal iSignal, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string = "EventSignalBucket";
            }
            this(editorSynchronizerBase, lifetime, iSignal, string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @RequiresEdt
        public final void fire(T state) {
            if (Intrinsics.areEqual((Object)this.this$0.getEditorModel().getBackendReadyForEvents().getValueOrNull(), (Object)true)) {
                void this_$iv;
                ClientId.Companion companion = ClientId.Companion;
                ClientId clientId = this.this$0.getClientId();
                EditorSynchronizerBase editorSynchronizerBase = this.this$0;
                boolean $i$f$withClientId = false;
                ClientSessionsManager clientSessionsManager = this_$iv.getCachedService();
                if (clientSessionsManager == null) {
                    boolean bl = false;
                    Logger $this$trace$iv = editorSynchronizerBase.getLogger();
                    boolean $i$f$trace = false;
                    if ($this$trace$iv.isTraceEnabled()) {
                        Logger logger = $this$trace$iv;
                        boolean bl2 = false;
                        logger.trace("Sending " + this.name + "=" + state);
                    }
                    this.signal.fire(state);
                } else {
                    String string;
                    void clientId$iv;
                    ClientSessionsManager service$iv = clientSessionsManager;
                    if (clientId$iv == null || service$iv.isValid((ClientId)clientId$iv)) {
                        if (clientId$iv != null && this_$iv.isFakeLocalId((ClientId)clientId$iv)) {
                            string = this_$iv.getLocalId().getValue();
                        } else {
                            void v2 = clientId$iv;
                            string = v2 != null ? v2.getValue() : null;
                        }
                    } else {
                        Logger $this$trace$iv$iv = this_$iv.getClientIdLogger();
                        boolean $i$f$trace = false;
                        if ($this$trace$iv$iv.isTraceEnabled()) {
                            Logger logger = $this$trace$iv$iv;
                            boolean bl = false;
                            logger.trace("Invalid ClientId " + clientId$iv + " replaced with null at " + new Throwable().fillInStackTrace());
                        }
                        string = null;
                    }
                    String newClientIdValue$iv = string;
                    String oldClientIdValue$iv = ClientIdKt.getCurrentClientIdString();
                    try {
                        ClientIdKt.setCurrentClientIdString((String)newClientIdValue$iv);
                        boolean bl = false;
                        Logger $this$trace$iv = editorSynchronizerBase.getLogger();
                        boolean $i$f$trace = false;
                        if ($this$trace$iv.isTraceEnabled()) {
                            Logger logger = $this$trace$iv;
                            boolean bl3 = false;
                            logger.trace("Sending " + this.name + "=" + state);
                        }
                        this.signal.fire(state);
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        ClientIdKt.setCurrentClientIdString((String)oldClientIdValue$iv);
                    }
                }
            } else {
                Logger $this$trace$iv = this.this$0.getLogger();
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("Backend is not ready to events, saving value for " + this.name + " = " + state);
                }
                this.beforeReadyState = state;
            }
        }
    }
}

