/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.indexer;

import com.intellij.openapi.util.text.StringUtilRt;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.events.TransferListener;
import org.jetbrains.idea.maven.server.MavenProcessCanceledRuntimeException;
import org.jetbrains.idea.maven.server.MavenServerGlobals;
import org.jetbrains.idea.maven.server.MavenServerProgressIndicator;
import org.jetbrains.idea.maven.server.RuntimeRemoteException;

public class WagonTransferListenerAdapter
implements TransferListener {
    protected final MavenServerProgressIndicator myIndicator;
    private final Map<String, DownloadData> myDownloads = new ConcurrentHashMap<String, DownloadData>();

    public WagonTransferListenerAdapter(MavenServerProgressIndicator indicator) {
        this.myIndicator = indicator;
    }

    public void transferInitiated(TransferEvent event) {
        this.checkCanceled();
    }

    private void checkCanceled() {
        try {
            if (this.myIndicator.isCanceled()) {
                throw new MavenProcessCanceledRuntimeException();
            }
        }
        catch (RemoteException e) {
            throw new RuntimeRemoteException(e);
        }
    }

    public void transferStarted(TransferEvent event) {
        this.checkCanceled();
        String resourceName = event.getResource().getName();
        DownloadData data = new DownloadData(event.getWagon().getRepository().getName(), event.getResource().getContentLength());
        this.myDownloads.put(resourceName, data);
        this.updateProgress(resourceName, data);
    }

    public void transferProgress(TransferEvent event, byte[] bytes, int i) {
        this.checkCanceled();
        String resourceName = event.getResource().getName();
        DownloadData data = this.myDownloads.get(resourceName);
        data.downloaded += (long)i;
        this.updateProgress(resourceName, data);
    }

    public void transferCompleted(TransferEvent event) {
        MavenServerGlobals.getDownloadListener().artifactDownloaded(event.getLocalFile(), event.getResource().getName());
        this.checkCanceled();
        String resourceName = event.getResource().getName();
        DownloadData data = this.myDownloads.remove(resourceName);
        data.finished = true;
        this.updateProgress(resourceName, data);
    }

    public void transferError(TransferEvent event) {
        this.checkCanceled();
        String resourceName = event.getResource().getName();
        DownloadData data = this.myDownloads.remove(resourceName);
        if (data != null) {
            data.failed = true;
            this.updateProgress(resourceName, data);
        }
    }

    public void debug(String s) {
        this.checkCanceled();
    }

    private void updateProgress(String resourceName, DownloadData data) {
        String prefix = "";
        if (data.finished) {
            prefix = "Finished ";
        }
        if (data.failed) {
            prefix = "Failed ";
        }
        String sizeInfo = data.finished || data.failed || data.total <= 0L ? StringUtilRt.formatFileSize((long)data.downloaded) : 100L * data.downloaded / data.total + "% of " + StringUtilRt.formatFileSize((long)data.total);
        try {
            this.myIndicator.setText2(MessageFormat.format(prefix + sizeInfo + " [{0}] {1}", data.repository, resourceName));
        }
        catch (RemoteException e) {
            throw new RuntimeRemoteException(e);
        }
        this.downloadProgress(data.downloaded, data.total);
    }

    private void downloadProgress(long downloaded, long total) {
        try {
            this.myIndicator.setFraction((double)downloaded / (double)total);
        }
        catch (RemoteException e) {
            throw new RuntimeRemoteException(e);
        }
    }

    private static final class DownloadData {
        public final String repository;
        public final long total;
        public long downloaded;
        public boolean finished;
        public boolean failed;

        private DownloadData(String repository, long total) {
            this.repository = repository;
            this.total = total;
        }
    }
}

