/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.changeToMethod;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.changeToMethod.transformations.Transformation;
import org.jetbrains.plugins.groovy.codeInspection.changeToMethod.transformations.Transformations;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSafeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;

public class ChangeToMethodInspection
extends BaseInspection {
    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        return new BaseInspectionVisitor(){

            @Override
            public void visitExpression(@NotNull GrExpression expression) {
                Transformation<? extends GrExpression> transformation;
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((transformation = ChangeToMethodInspection.this.getTransformation(expression)) == null) {
                    return;
                }
                PsiElement highlightingElement = ChangeToMethodInspection.this.getHighlightingElement(expression);
                if (highlightingElement == null) {
                    return;
                }
                if (transformation.couldApplyRow(expression)) {
                    this.registerError(highlightingElement, GroovyBundle.message("replace.with.method.message", transformation.getMethod()), new LocalQuickFix[]{new TransformationBasedFix(transformation)}, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/codeInspection/changeToMethod/ChangeToMethodInspection$1", "visitExpression"));
            }
        };
    }

    @Nullable
    public Transformation<? extends GrExpression> getTransformation(@NotNull GrExpression expression) {
        if (expression == null) {
            ChangeToMethodInspection.$$$reportNull$$$0(0);
        }
        if (expression instanceof GrUnaryExpression) {
            GrUnaryExpression unary = (GrUnaryExpression)expression;
            return Transformations.UNARY_TRANSFORMATIONS.get(unary.getOperationTokenType());
        }
        if (expression instanceof GrBinaryExpression) {
            GrBinaryExpression binary = (GrBinaryExpression)expression;
            return Transformations.BINARY_TRANSFORMATIONS.get(binary.getOperationTokenType());
        }
        if (expression instanceof GrSafeCastExpression) {
            return Transformations.AS_TYPE_TRANSFORMATION;
        }
        return null;
    }

    @Nullable
    public PsiElement getHighlightingElement(@NotNull GrExpression expression) {
        if (expression == null) {
            ChangeToMethodInspection.$$$reportNull$$$0(1);
        }
        if (expression instanceof GrUnaryExpression) {
            GrUnaryExpression unary = (GrUnaryExpression)expression;
            return unary.getOperationToken();
        }
        if (expression instanceof GrBinaryExpression) {
            GrBinaryExpression binary = (GrBinaryExpression)expression;
            return binary.getOperationToken();
        }
        if (expression instanceof GrSafeCastExpression) {
            GrSafeCastExpression safeCast = (GrSafeCastExpression)expression;
            return safeCast.getOperationToken();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "expression";
        objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/changeToMethod/ChangeToMethodInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getTransformation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getHighlightingElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class TransformationBasedFix
    extends PsiUpdateModCommandQuickFix {
        private final Transformation<?> myTransformation;

        private TransformationBasedFix(Transformation<?> transformation) {
            this.myTransformation = transformation;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = GroovyBundle.message("replace.with.method.fix", this.myTransformation.getMethod());
            if (string == null) {
                TransformationBasedFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiElement call;
            if (project == null) {
                TransformationBasedFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                TransformationBasedFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                TransformationBasedFix.$$$reportNull$$$0(3);
            }
            if (!((call = element.getParent()) instanceof GrExpression)) {
                return;
            }
            GrExpression expression = (GrExpression)call;
            if (!this.myTransformation.couldApplyRow(expression)) {
                return;
            }
            this.myTransformation.applyRow(expression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/changeToMethod/ChangeToMethodInspection$TransformationBasedFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/changeToMethod/ChangeToMethodInspection$TransformationBasedFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

