/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.GroovyControlFlow;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.VariableDescriptorFactory;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrUnusedIncDecInspection
extends BaseInspection {
    private static final Logger LOG = Logger.getInstance(GrUnusedIncDecInspection.class);

    @NotNull
    public String getShortName() {
        return "GroovyUnusedIncOrDec";
    }

    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        return new GrUnusedIncDecInspectionVisitor();
    }

    @Nullable
    private static GrUnaryExpression findUnaryExpression(@NotNull PsiElement element) {
        if (element == null) {
            GrUnusedIncDecInspection.$$$reportNull$$$0(0);
        }
        PsiElement parent2 = element.getParent();
        IElementType opType = element.getNode().getElementType();
        if (opType != GroovyTokenTypes.mINC && opType != GroovyTokenTypes.mDEC) {
            return null;
        }
        return (GrUnaryExpression)ObjectUtils.tryCast((Object)parent2, GrUnaryExpression.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/codeInspection/confusing/GrUnusedIncDecInspection", "findUnaryExpression"));
    }

    private static class GrUnusedIncDecInspectionVisitor
    extends BaseInspectionVisitor {
        private GrUnusedIncDecInspectionVisitor() {
        }

        @Override
        public void visitUnaryExpression(@NotNull GrUnaryExpression expression) {
            if (expression == null) {
                GrUnusedIncDecInspectionVisitor.$$$reportNull$$$0(0);
            }
            super.visitUnaryExpression(expression);
            IElementType opType = expression.getOperationTokenType();
            if (opType != GroovyTokenTypes.mINC && opType != GroovyTokenTypes.mDEC) {
                return;
            }
            GrExpression operand = expression.getOperand();
            if (!(operand instanceof GrReferenceExpression)) {
                return;
            }
            PsiElement resolved = ((GrReferenceExpression)operand).resolve();
            if (!(resolved instanceof GrVariable) || resolved instanceof GrField) {
                return;
            }
            GrControlFlowOwner owner = ControlFlowUtils.findControlFlowOwner(expression);
            assert (owner != null);
            GrControlFlowOwner ownerOfDeclaration = ControlFlowUtils.findControlFlowOwner(resolved);
            if (ownerOfDeclaration != owner) {
                return;
            }
            GroovyControlFlow groovyFlow = ControlFlowUtils.getGroovyControlFlow(owner);
            Instruction cur = ControlFlowUtils.findInstruction(operand, groovyFlow.getFlow());
            if (cur == null) {
                LOG.error("no instruction found in flow.operand: " + operand.getText(), new Attachment[]{new Attachment("", owner.getText())});
            }
            Iterable<Instruction> successors = cur.allSuccessors();
            Iterator<Instruction> iterator2 = successors.iterator();
            LOG.assertTrue(iterator2.hasNext());
            Instruction writeAccess = iterator2.next();
            LOG.assertTrue(!iterator2.hasNext());
            int variableIndex = groovyFlow.getIndex(VariableDescriptorFactory.createDescriptor((GrVariable)resolved));
            List<ReadWriteVariableInstruction> accesses = ControlFlowUtils.findAccess(variableIndex, true, false, writeAccess);
            boolean allAreWrite = true;
            for (ReadWriteVariableInstruction access : accesses) {
                if (access.isWrite()) continue;
                allAreWrite = false;
                break;
            }
            if (allAreWrite) {
                if (expression.isPostfix() && PsiUtil.isExpressionUsed(expression)) {
                    this.registerError(expression.getOperationToken(), GroovyBundle.message("unused.0", expression.getOperationToken().getText()), new LocalQuickFix[]{new ReplacePostfixIncWithPrefixFix(expression), new RemoveIncOrDecFix(expression)}, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                } else if (!PsiUtil.isExpressionUsed(expression)) {
                    this.registerError(expression.getOperationToken(), GroovyBundle.message("unused.0", expression.getOperationToken().getText()), LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/codeInspection/confusing/GrUnusedIncDecInspection$GrUnusedIncDecInspectionVisitor", "visitUnaryExpression"));
        }

        private static class ReplacePostfixIncWithPrefixFix
        extends PsiUpdateModCommandQuickFix {
            @IntentionFamilyName
            private final String myMessage;

            ReplacePostfixIncWithPrefixFix(GrUnaryExpression expression) {
                this.myMessage = GroovyBundle.message("replace.postfix.0.with.prefix.0", expression.getOperationToken().getText());
            }

            @NotNull
            public String getFamilyName() {
                String string = this.myMessage;
                if (string == null) {
                    ReplacePostfixIncWithPrefixFix.$$$reportNull$$$0(0);
                }
                return string;
            }

            protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
                GrUnaryExpression expr;
                if (project == null) {
                    ReplacePostfixIncWithPrefixFix.$$$reportNull$$$0(1);
                }
                if (element == null) {
                    ReplacePostfixIncWithPrefixFix.$$$reportNull$$$0(2);
                }
                if (updater == null) {
                    ReplacePostfixIncWithPrefixFix.$$$reportNull$$$0(3);
                }
                if ((expr = GrUnusedIncDecInspection.findUnaryExpression(element)) == null) {
                    return;
                }
                GrExpression prefix = GroovyPsiElementFactory.getInstance(project).createExpressionFromText(expr.getOperationToken().getText() + expr.getOperand().getText());
                expr.replaceWithExpression(prefix, true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2, 3 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/confusing/GrUnusedIncDecInspection$GrUnusedIncDecInspectionVisitor$ReplacePostfixIncWithPrefixFix";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "updater";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/confusing/GrUnusedIncDecInspection$GrUnusedIncDecInspectionVisitor$ReplacePostfixIncWithPrefixFix";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2, 3 -> new IllegalArgumentException(string);
                };
            }
        }

        private static class RemoveIncOrDecFix
        extends PsiUpdateModCommandQuickFix {
            @IntentionFamilyName
            private final String myMessage;

            RemoveIncOrDecFix(GrUnaryExpression expression) {
                this.myMessage = GroovyBundle.message("remove.0", expression.getOperationToken().getText());
            }

            @NotNull
            public String getFamilyName() {
                String string = this.myMessage;
                if (string == null) {
                    RemoveIncOrDecFix.$$$reportNull$$$0(0);
                }
                return string;
            }

            protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
                GrUnaryExpression expr;
                if (project == null) {
                    RemoveIncOrDecFix.$$$reportNull$$$0(1);
                }
                if (element == null) {
                    RemoveIncOrDecFix.$$$reportNull$$$0(2);
                }
                if (updater == null) {
                    RemoveIncOrDecFix.$$$reportNull$$$0(3);
                }
                if ((expr = GrUnusedIncDecInspection.findUnaryExpression(element)) == null) {
                    return;
                }
                expr.replaceWithExpression(expr.getOperand(), true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2, 3 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/confusing/GrUnusedIncDecInspection$GrUnusedIncDecInspectionVisitor$RemoveIncOrDecFix";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "updater";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/confusing/GrUnusedIncDecInspection$GrUnusedIncDecInspectionVisitor$RemoveIncOrDecFix";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2, 3 -> new IllegalArgumentException(string);
                };
            }
        }
    }
}

