/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrElvisExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;

public class GroovyConditionalCanBeElvisInspection
extends BaseInspection {
    @Override
    public String buildErrorString(Object ... args) {
        return GroovyBundle.message("inspection.message.conditional.expression.can.be.elvis", new Object[0]);
    }

    @Override
    public LocalQuickFix buildFix(@NotNull PsiElement location) {
        if (location == null) {
            GroovyConditionalCanBeElvisInspection.$$$reportNull$$$0(0);
        }
        return new PsiUpdateModCommandQuickFix(){

            @NotNull
            public String getFamilyName() {
                String string = GroovyBundle.message("intention.family.name.convert.conditional.expression.to.elvis", new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
                if (project == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (element == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (updater == null) {
                    1.$$$reportNull$$$0(3);
                }
                GrConditionalExpression expr = (GrConditionalExpression)element;
                GrExpression condition = expr.getCondition();
                GrExpression thenExpression = expr.getThenBranch();
                GrExpression elseExpression = expr.getElseBranch();
                assert (elseExpression != null);
                assert (thenExpression != null);
                String newExpression = GroovyConditionalCanBeElvisInspection.checkForStringIsEmpty(condition, elseExpression) || GroovyConditionalCanBeElvisInspection.checkForListIsEmpty(condition, elseExpression) || GroovyConditionalCanBeElvisInspection.checkForEqualsNotElse(condition, elseExpression) ? elseExpression.getText() + " ?: " + thenExpression.getText() : thenExpression.getText() + " ?: " + elseExpression.getText();
                PsiImplUtil.replaceExpression(newExpression, expr);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2, 3 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/control/GroovyConditionalCanBeElvisInspection$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "updater";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/control/GroovyConditionalCanBeElvisInspection$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2, 3 -> new IllegalArgumentException(string);
                };
            }
        };
    }

    private static boolean checkPsiElement(GrConditionalExpression expr) {
        if (expr instanceof GrElvisExpression) {
            return false;
        }
        GrExpression condition = expr.getCondition();
        GrExpression then = expr.getThenBranch();
        GrExpression elseBranch = expr.getElseBranch();
        if (then == null || elseBranch == null) {
            return false;
        }
        return GroovyConditionalCanBeElvisInspection.checkForEqualsThen(condition, then) || GroovyConditionalCanBeElvisInspection.checkForEqualsNotElse(condition, elseBranch) || GroovyConditionalCanBeElvisInspection.checkForNull(condition, then) || GroovyConditionalCanBeElvisInspection.checkForStringIsEmpty(condition, elseBranch) || GroovyConditionalCanBeElvisInspection.checkForStringIsNotEmpty(condition, then) || GroovyConditionalCanBeElvisInspection.checkForListIsEmpty(condition, elseBranch) || GroovyConditionalCanBeElvisInspection.checkForListIsNotEmpty(condition, then);
    }

    private static boolean checkForEqualsNotElse(GrExpression condition, GrExpression elseBranch) {
        if (!(condition instanceof GrUnaryExpression)) {
            return false;
        }
        if (((GrUnaryExpression)condition).getOperationTokenType() != GroovyTokenTypes.mLNOT) {
            return false;
        }
        GrExpression operand = ((GrUnaryExpression)condition).getOperand();
        return operand != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)operand, (PsiElement)elseBranch);
    }

    private static boolean checkForEqualsThen(GrExpression condition, GrExpression then) {
        return PsiEquivalenceUtil.areElementsEquivalent((PsiElement)condition, (PsiElement)then);
    }

    private static boolean checkForListIsNotEmpty(GrExpression condition, GrExpression then) {
        if (!(condition instanceof GrUnaryExpression)) {
            return false;
        }
        if (((GrUnaryExpression)condition).getOperationTokenType() != GroovyTokenTypes.mLNOT) {
            return false;
        }
        return GroovyConditionalCanBeElvisInspection.checkForListIsEmpty(((GrUnaryExpression)condition).getOperand(), then);
    }

    private static boolean checkForListIsEmpty(GrExpression condition, GrExpression elseBranch) {
        if (condition instanceof GrMethodCall) {
            condition = ((GrMethodCall)condition).getInvokedExpression();
        }
        if (!(condition instanceof GrReferenceExpression)) {
            return false;
        }
        GrExpression qualifier = (GrExpression)((GrReferenceExpression)condition).getQualifier();
        if (qualifier == null) {
            return false;
        }
        if (!PsiEquivalenceUtil.areElementsEquivalent((PsiElement)qualifier, (PsiElement)elseBranch)) {
            return false;
        }
        PsiType type2 = qualifier.getType();
        if (type2 == null) {
            return false;
        }
        if (!InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.List")) {
            return false;
        }
        PsiElement resolved = ((GrReferenceExpression)condition).resolve();
        return resolved instanceof PsiMethod && "isEmpty".equals(((PsiMethod)resolved).getName()) && ((PsiMethod)resolved).getParameterList().isEmpty();
    }

    private static boolean checkForStringIsNotEmpty(GrExpression condition, GrExpression then) {
        if (!(condition instanceof GrUnaryExpression)) {
            return false;
        }
        if (((GrUnaryExpression)condition).getOperationTokenType() != GroovyTokenTypes.mLNOT) {
            return false;
        }
        return GroovyConditionalCanBeElvisInspection.checkForStringIsEmpty(((GrUnaryExpression)condition).getOperand(), then);
    }

    private static boolean checkForStringIsEmpty(GrExpression condition, GrExpression elseBranch) {
        if (condition instanceof GrMethodCall) {
            condition = ((GrMethodCall)condition).getInvokedExpression();
        }
        if (!(condition instanceof GrReferenceExpression)) {
            return false;
        }
        GrExpression qualifier = (GrExpression)((GrReferenceExpression)condition).getQualifier();
        if (qualifier == null) {
            return false;
        }
        if (!PsiEquivalenceUtil.areElementsEquivalent((PsiElement)qualifier, (PsiElement)elseBranch)) {
            return false;
        }
        PsiType type2 = qualifier.getType();
        if (type2 == null) {
            return false;
        }
        if (!type2.equalsToText("java.lang.String")) {
            return false;
        }
        PsiElement resolved = ((GrReferenceExpression)condition).resolve();
        return resolved instanceof PsiMethod && "isEmpty".equals(((PsiMethod)resolved).getName()) && ((PsiMethod)resolved).getParameterList().isEmpty();
    }

    private static boolean checkForNull(GrExpression condition, GrExpression then) {
        if (!(condition instanceof GrBinaryExpression)) {
            return false;
        }
        GrBinaryExpression binaryExpression = (GrBinaryExpression)condition;
        if (GroovyTokenTypes.mNOT_EQUAL != binaryExpression.getOperationTokenType()) {
            return false;
        }
        GrExpression left = binaryExpression.getLeftOperand();
        GrExpression right = binaryExpression.getRightOperand();
        if (left instanceof GrLiteral && "null".equals(left.getText()) && right != null) {
            return PsiEquivalenceUtil.areElementsEquivalent((PsiElement)right, (PsiElement)then);
        }
        if (right instanceof GrLiteral && "null".equals(right.getText())) {
            return PsiEquivalenceUtil.areElementsEquivalent((PsiElement)left, (PsiElement)then);
        }
        return false;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyConditionalCanBeElvisInspection", "buildFix"));
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitConditionalExpression(@NotNull GrConditionalExpression expression) {
            if (expression == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitConditionalExpression(expression);
            if (GroovyConditionalCanBeElvisInspection.checkPsiElement(expression)) {
                this.registerError(expression);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyConditionalCanBeElvisInspection$Visitor", "visitConditionalExpression"));
        }
    }
}

