/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.threading;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSynchronizedStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;

public class GroovySynchronizationOnNonFinalFieldInspection
extends BaseInspection {
    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return GroovyBundle.message("inspection.message.synchronization.on.non.final.field.ref", new Object[0]);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitSynchronizedStatement(@NotNull GrSynchronizedStatement synchronizedStatement) {
            if (synchronizedStatement == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitSynchronizedStatement(synchronizedStatement);
            GrExpression lock = synchronizedStatement.getMonitor();
            if (!(lock instanceof GrReferenceExpression)) {
                return;
            }
            PsiElement referent = ((PsiReference)lock).resolve();
            if (!(referent instanceof PsiField)) {
                return;
            }
            PsiField field2 = (PsiField)referent;
            if (field2.hasModifierProperty("final")) {
                return;
            }
            this.registerError(lock);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "synchronizedStatement", "org/jetbrains/plugins/groovy/codeInspection/threading/GroovySynchronizationOnNonFinalFieldInspection$Visitor", "visitSynchronizedStatement"));
        }
    }
}

