/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions.strings;

import com.intellij.lang.ASTNode;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.GrPsiUpdateIntention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;

public class RemoveUnnecessaryEscapeCharactersIntention
extends GrPsiUpdateIntention {
    public static final String HINT = "Remove unnecessary escape characters";

    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull ActionContext context, @NotNull ModPsiUpdater updater) {
        if (element == null) {
            RemoveUnnecessaryEscapeCharactersIntention.$$$reportNull$$$0(0);
        }
        if (context == null) {
            RemoveUnnecessaryEscapeCharactersIntention.$$$reportNull$$$0(1);
        }
        if (updater == null) {
            RemoveUnnecessaryEscapeCharactersIntention.$$$reportNull$$$0(2);
        }
        Document document = element.getContainingFile().getViewProvider().getDocument();
        TextRange range = element.getTextRange();
        document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)RemoveUnnecessaryEscapeCharactersIntention.removeUnnecessaryEscapeSymbols((GrLiteral)element));
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        PsiElementPredicate psiElementPredicate = element -> {
            if (!(element instanceof GrLiteral)) {
                return false;
            }
            String text = element.getText();
            return GrStringUtil.getStartQuote(text) != null && !RemoveUnnecessaryEscapeCharactersIntention.removeUnnecessaryEscapeSymbols((GrLiteral)element).equals(text);
        };
        if (psiElementPredicate == null) {
            RemoveUnnecessaryEscapeCharactersIntention.$$$reportNull$$$0(3);
        }
        return psiElementPredicate;
    }

    private static String removeUnnecessaryEscapeSymbols(GrLiteral literal) {
        String text = literal.getText();
        String quote = GrStringUtil.getStartQuote(text);
        String value2 = GrStringUtil.removeQuotes(text);
        StringBuilder buffer = new StringBuilder();
        buffer.append(quote);
        switch (quote) {
            case "'": {
                GrStringUtil.escapeAndUnescapeSymbols(value2, "", "\"$", buffer);
                break;
            }
            case "'''": {
                int position = buffer.length();
                GrStringUtil.escapeAndUnescapeSymbols(value2, "", "\"'$n", buffer);
                GrStringUtil.fixAllTripleQuotes(buffer, position);
                break;
            }
            case "\"": {
                if (literal instanceof GrString) {
                    ASTNode node = literal.getNode();
                    for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
                        IElementType type2 = child.getElementType();
                        if (type2 == GroovyTokenTypes.mGSTRING_BEGIN || type2 == GroovyTokenTypes.mGSTRING_END) continue;
                        if (type2 == GroovyElementTypes.GSTRING_INJECTION) {
                            buffer.append(child.getText());
                            continue;
                        }
                        GrStringUtil.escapeAndUnescapeSymbols(child.getText(), "", "'", buffer);
                    }
                    break;
                }
                GrStringUtil.escapeAndUnescapeSymbols(value2, "", "'", buffer);
                break;
            }
            case "\"\"\"": {
                if (literal instanceof GrString) {
                    ASTNode node = literal.getNode();
                    for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
                        IElementType type3 = child.getElementType();
                        if (type3 == GroovyTokenTypes.mGSTRING_BEGIN || type3 == GroovyTokenTypes.mGSTRING_END) continue;
                        if (type3 == GroovyElementTypes.GSTRING_INJECTION) {
                            buffer.append(child.getText());
                            continue;
                        }
                        int position = buffer.length();
                        GrStringUtil.escapeAndUnescapeSymbols(child.getText(), "", "\"'n", buffer);
                        GrStringUtil.fixAllTripleDoubleQuotes(buffer, position);
                    }
                    break;
                }
                int position = buffer.length();
                GrStringUtil.escapeAndUnescapeSymbols(value2, "", "\"'n", buffer);
                GrStringUtil.fixAllTripleDoubleQuotes(buffer, position);
                break;
            }
            default: {
                return text;
            }
        }
        buffer.append(quote);
        return buffer.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/intentions/conversions/strings/RemoveUnnecessaryEscapeCharactersIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/intentions/conversions/strings/RemoveUnnecessaryEscapeCharactersIntention";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

