/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.JBColor;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.ModuleProvider;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.compiler.NestedFormLoader;
import com.intellij.uiDesigner.compiler.RecursiveFormNestingException;
import com.intellij.uiDesigner.compiler.Utils;
import com.intellij.uiDesigner.lw.LwAtomicComponent;
import com.intellij.uiDesigner.lw.LwComponent;
import com.intellij.uiDesigner.lw.LwContainer;
import com.intellij.uiDesigner.lw.LwHSpacer;
import com.intellij.uiDesigner.lw.LwIntrospectedProperty;
import com.intellij.uiDesigner.lw.LwNestedForm;
import com.intellij.uiDesigner.lw.LwRootContainer;
import com.intellij.uiDesigner.lw.LwScrollPane;
import com.intellij.uiDesigner.lw.LwSplitPane;
import com.intellij.uiDesigner.lw.LwTabbedPane;
import com.intellij.uiDesigner.lw.LwToolBar;
import com.intellij.uiDesigner.lw.LwVSpacer;
import com.intellij.uiDesigner.lw.StringDescriptor;
import com.intellij.uiDesigner.make.PsiNestedFormLoader;
import com.intellij.uiDesigner.palette.Palette;
import com.intellij.uiDesigner.propertyInspector.IntrospectedProperty;
import com.intellij.uiDesigner.radComponents.LayoutManagerRegistry;
import com.intellij.uiDesigner.radComponents.RadAtomicComponent;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.uiDesigner.radComponents.RadErrorComponent;
import com.intellij.uiDesigner.radComponents.RadHSpacer;
import com.intellij.uiDesigner.radComponents.RadLayoutManager;
import com.intellij.uiDesigner.radComponents.RadNestedForm;
import com.intellij.uiDesigner.radComponents.RadRootContainer;
import com.intellij.uiDesigner.radComponents.RadScrollPane;
import com.intellij.uiDesigner.radComponents.RadSplitPane;
import com.intellij.uiDesigner.radComponents.RadTabbedPane;
import com.intellij.uiDesigner.radComponents.RadTable;
import com.intellij.uiDesigner.radComponents.RadToolBar;
import com.intellij.uiDesigner.radComponents.RadVSpacer;
import com.intellij.uiDesigner.radComponents.XYLayoutManagerImpl;
import com.intellij.uiDesigner.shared.XYLayoutManager;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;

public final class XmlReader {
    private XmlReader() {
    }

    @NotNull
    public static RadRootContainer createRoot(ModuleProvider module, LwRootContainer lwRootContainer, ClassLoader loader, Locale stringDescriptorLocale) throws Exception {
        return (RadRootContainer)XmlReader.createComponent(module, (LwComponent)lwRootContainer, loader, stringDescriptorLocale);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static RadComponent createComponent(@NotNull ModuleProvider module, @NotNull LwComponent lwComponent, @NotNull ClassLoader loader, Locale stringDescriptorLocale) throws Exception {
        RadComponent component;
        if (module == null) {
            XmlReader.$$$reportNull$$$0(0);
        }
        if (lwComponent == null) {
            XmlReader.$$$reportNull$$$0(1);
        }
        if (loader == null) {
            XmlReader.$$$reportNull$$$0(2);
        }
        String id = lwComponent.getId();
        Class<?> componentClass = null;
        if (lwComponent instanceof LwNestedForm) {
            LwNestedForm nestedForm = (LwNestedForm)lwComponent;
            boolean recursiveNesting = false;
            try {
                Utils.validateNestedFormLoop((String)nestedForm.getFormFileName(), (NestedFormLoader)new PsiNestedFormLoader(module.getModule()));
            }
            catch (RecursiveFormNestingException ex) {
                recursiveNesting = true;
            }
            component = recursiveNesting ? RadErrorComponent.create(module, id, lwComponent.getComponentClassName(), lwComponent.getErrorComponentProperties(), UIDesignerBundle.message("error.recursive.form.nesting", new Object[0])) : new RadNestedForm(module, nestedForm.getFormFileName(), id);
        } else {
            if (lwComponent.getErrorComponentProperties() == null) {
                componentClass = Class.forName(lwComponent.getComponentClassName(), true, loader);
            }
            if (lwComponent instanceof LwHSpacer) {
                component = new RadHSpacer(module, id);
            } else if (lwComponent instanceof LwVSpacer) {
                component = new RadVSpacer(module, id);
            } else if (lwComponent instanceof LwAtomicComponent) {
                if (componentClass == null) {
                    component = XmlReader.createErrorComponent(module, id, lwComponent, loader);
                } else {
                    RadAtomicComponent component1;
                    try {
                        component1 = JTable.class.isAssignableFrom(componentClass) ? new RadTable(module, componentClass, id) : new RadAtomicComponent(module, componentClass, id);
                    }
                    catch (Exception exception) {
                        Object errorDescription = UIDesignerBundle.message("error.class.cannot.be.instantiated", lwComponent.getComponentClassName());
                        String message = FormEditingUtil.getExceptionMessage(exception);
                        if (message != null) {
                            errorDescription = (String)errorDescription + ": " + message;
                        }
                        component1 = RadErrorComponent.create(module, id, lwComponent.getComponentClassName(), lwComponent.getErrorComponentProperties(), (String)errorDescription);
                    }
                    component = component1;
                }
            } else if (lwComponent instanceof LwScrollPane) {
                component = new RadScrollPane(module, componentClass, id);
            } else if (lwComponent instanceof LwTabbedPane) {
                component = new RadTabbedPane(module, componentClass, id);
            } else if (lwComponent instanceof LwSplitPane) {
                component = new RadSplitPane(module, componentClass, id);
            } else if (lwComponent instanceof LwToolBar) {
                component = new RadToolBar(module, componentClass, id);
            } else if (lwComponent instanceof LwContainer) {
                LwContainer lwContainer = (LwContainer)lwComponent;
                Object layout = lwContainer.getLayout();
                if (layout instanceof XYLayoutManager) {
                    XYLayoutManagerImpl xYLayoutManagerImpl = new XYLayoutManagerImpl();
                    layout = xYLayoutManagerImpl;
                    xYLayoutManagerImpl.setPreferredSize(lwComponent.getBounds().getSize());
                }
                if (componentClass == null) {
                    component = XmlReader.createErrorComponent(module, id, lwComponent, loader);
                } else {
                    if (lwContainer instanceof LwRootContainer) {
                        component = new RadRootContainer(module, id);
                        if (stringDescriptorLocale != null) {
                            ((RadRootContainer)component).setStringDescriptorLocale(stringDescriptorLocale);
                        }
                    } else {
                        void var10_19;
                        component = new RadContainer(module, componentClass, id);
                        String string = lwContainer.getLayoutManager();
                        if (string == null || string.isEmpty()) {
                            if (layout instanceof XYLayoutManager) {
                                String string2 = "XYLayout";
                            } else {
                                String string3 = "GridLayoutManager";
                            }
                        }
                        RadLayoutManager layoutManager = LayoutManagerRegistry.createLayoutManager((String)var10_19);
                        RadContainer container = (RadContainer)component;
                        layoutManager.readLayout(lwContainer, container);
                        container.setLayoutManager(layoutManager);
                    }
                    ((RadContainer)component).setLayout((LayoutManager)layout);
                }
            } else {
                throw new IllegalArgumentException("unexpected component: " + lwComponent);
            }
        }
        component.setBinding(lwComponent.getBinding());
        component.setCustomCreate(lwComponent.isCustomCreate());
        component.setDefaultBinding(lwComponent.isDefaultBinding());
        component.setBounds(lwComponent.getBounds());
        if (stringDescriptorLocale != null) {
            component.putClientProperty("LoadTimeLocaleKey", stringDescriptorLocale);
        }
        LwIntrospectedProperty[] properties = lwComponent.getAssignedIntrospectedProperties();
        if (componentClass != null) {
            Palette palette = Palette.getInstance(module.getProject());
            for (LwIntrospectedProperty lwProperty : properties) {
                IntrospectedProperty<?> property = palette.getIntrospectedProperty(component, lwProperty.getName());
                if (property == null) continue;
                component.loadLwProperty(lwComponent, lwProperty, property);
            }
        }
        component.getConstraints().restore(lwComponent.getConstraints());
        component.setCustomLayoutConstraints(lwComponent.getCustomLayoutConstraints());
        HashMap clientProps = lwComponent.getDelegeeClientProperties();
        for (Object e : clientProps.entrySet()) {
            Map.Entry entry = (Map.Entry)e;
            Object value = entry.getValue();
            if (value instanceof StringDescriptor) {
                value = ((StringDescriptor)value).getValue();
            }
            component.getDelegee().putClientProperty(entry.getKey(), value);
        }
        if (component instanceof RadContainer) {
            RadContainer container = (RadContainer)component;
            LwContainer lwContainer = (LwContainer)lwComponent;
            XmlReader.copyBorder(container, lwContainer);
            for (int i = 0; i < lwContainer.getComponentCount(); ++i) {
                container.addComponent(XmlReader.createComponent(module, (LwComponent)lwContainer.getComponent(i), loader, stringDescriptorLocale));
            }
        }
        if (component instanceof RadRootContainer) {
            RadRootContainer radRootContainer = (RadRootContainer)component;
            LwRootContainer lwRootContainer = (LwRootContainer)lwComponent;
            radRootContainer.setClassToBind(lwRootContainer.getClassToBind());
            radRootContainer.setMainComponentBinding(lwRootContainer.getMainComponentBinding());
            radRootContainer.setButtonGroups(lwRootContainer.getButtonGroups());
            radRootContainer.setInspectionSuppressions(lwRootContainer.getInspectionSuppressions());
            radRootContainer.getDelegee().setBackground((Color)new JBColor(Color.WHITE, UIUtil.getListBackground()));
        }
        component.doneLoadingFromLw();
        component.putClientProperty("LoadTimeLocaleKey", null);
        RadComponent radComponent = component;
        if (radComponent == null) {
            XmlReader.$$$reportNull$$$0(3);
        }
        return radComponent;
    }

    private static void copyBorder(RadContainer container, LwContainer lwContainer) {
        container.setBorderType(lwContainer.getBorderType());
        container.setBorderTitle(lwContainer.getBorderTitle());
        container.setBorderTitleJustification(lwContainer.getBorderTitleJustification());
        container.setBorderTitlePosition(lwContainer.getBorderTitlePosition());
        container.setBorderTitleFont(lwContainer.getBorderTitleFont());
        container.setBorderTitleColor(lwContainer.getBorderTitleColor());
        container.setBorderSize(lwContainer.getBorderSize());
        container.setBorderColor(lwContainer.getBorderColor());
    }

    private static RadErrorComponent createErrorComponent(ModuleProvider module, String id, LwComponent lwComponent, ClassLoader loader) {
        String componentClassName = lwComponent.getComponentClassName();
        @NlsSafe String errorDescription = Utils.validateJComponentClass((ClassLoader)loader, (String)componentClassName, (boolean)true);
        return RadErrorComponent.create(module, id, lwComponent.getComponentClassName(), lwComponent.getErrorComponentProperties(), errorDescription != null ? errorDescription : UIDesignerBundle.message("error.cannot.load.class", componentClassName));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lwComponent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uiDesigner/XmlReader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uiDesigner/XmlReader";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createComponent";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

