/*
 * Decompiled with CFR 0.152.
 */
package com.michaelbaranov.microba.gradient.ui;

import com.michaelbaranov.microba.common.BoundedTableModel;
import com.michaelbaranov.microba.gradient.GradientBar;
import java.awt.Color;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.plaf.ComponentUI;

public class GradientUI
extends ComponentUI {
    protected static final int PREF_BAR_HEIGHT = 32;
    protected static Rectangle viewRect = new Rectangle();
    private PreparedColorPoint[] colorPoints = new PreparedColorPoint[0];
    private PreparedAlphaPoint[] alphaPoints = new PreparedAlphaPoint[0];

    protected void calculateViewRect(GradientBar gradient) {
        Insets insets = gradient.getInsets();
        GradientUI.viewRect.x = insets.left;
        GradientUI.viewRect.y = insets.top;
        GradientUI.viewRect.width = gradient.getWidth() - (insets.right + GradientUI.viewRect.x);
        GradientUI.viewRect.height = gradient.getHeight() - (insets.bottom + GradientUI.viewRect.y);
    }

    protected PreparedColorPoint[] prepareColorPoints(BoundedTableModel model2, int positionColumn, int colorColumn) {
        int i;
        int numPoints = model2.getRowCount();
        if (numPoints > this.colorPoints.length) {
            this.colorPoints = new PreparedColorPoint[numPoints * 2];
            for (i = 0; i < this.colorPoints.length; ++i) {
                this.colorPoints[i] = new PreparedColorPoint();
            }
        }
        for (i = 0; i < numPoints; ++i) {
            PreparedColorPoint p = this.colorPoints[i];
            Color c = (Color)model2.getValueAt(i, colorColumn);
            p.position = ((Number)model2.getValueAt(i, positionColumn)).intValue();
            p.r = c.getRed();
            p.g = c.getGreen();
            p.b = c.getBlue();
        }
        Arrays.sort(this.colorPoints, 0, numPoints, PreparedColorPoint.comparator);
        return this.colorPoints;
    }

    protected PreparedAlphaPoint[] prepareAlphaPoints(BoundedTableModel model2, int positionColumn, int alphaColumn) {
        int i;
        int numPoints = model2.getRowCount();
        if (numPoints > this.alphaPoints.length) {
            this.alphaPoints = new PreparedAlphaPoint[numPoints * 2];
            for (i = 0; i < this.alphaPoints.length; ++i) {
                this.alphaPoints[i] = new PreparedAlphaPoint();
            }
        }
        for (i = 0; i < numPoints; ++i) {
            PreparedAlphaPoint p = this.alphaPoints[i];
            float f = ((Number)model2.getValueAt(i, alphaColumn)).floatValue();
            p.position = ((Number)model2.getValueAt(i, positionColumn)).intValue();
            p.alpha = f;
        }
        Arrays.sort(this.alphaPoints, 0, numPoints, PreparedAlphaPoint.comparator);
        return this.alphaPoints;
    }

    protected static class PreparedAlphaPoint {
        public static final Comparator comparator = new PtComparator();
        public float alpha;
        public int position;

        private static class PtComparator
        implements Comparator {
            private PtComparator() {
            }

            public int compare(Object o1, Object o2) {
                PreparedColorPoint cp1 = (PreparedColorPoint)o1;
                PreparedColorPoint cp2 = (PreparedColorPoint)o2;
                if (cp1.position < cp2.position) {
                    return -1;
                }
                if (cp1.position > cp2.position) {
                    return 1;
                }
                return 0;
            }
        }
    }

    protected static class PreparedColorPoint {
        public static final Comparator comparator = new PtComparator();
        public int r;
        public int g;
        public int b;
        public int position;

        private static class PtComparator
        implements Comparator {
            private PtComparator() {
            }

            public int compare(Object o1, Object o2) {
                PreparedColorPoint cp1 = (PreparedColorPoint)o1;
                PreparedColorPoint cp2 = (PreparedColorPoint)o2;
                if (cp1.position < cp2.position) {
                    return -1;
                }
                if (cp1.position > cp2.position) {
                    return 1;
                }
                return 0;
            }
        }
    }
}

