/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.sequence;

import com.vladsch.flexmark.util.misc.CharPredicate;
import com.vladsch.flexmark.util.misc.Pair;
import com.vladsch.flexmark.util.misc.Utils;
import com.vladsch.flexmark.util.sequence.IRichSequence;
import com.vladsch.flexmark.util.sequence.Range;
import com.vladsch.flexmark.util.sequence.RepeatedSequence;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SequenceUtils {
    public static final String EOL = "\n";
    public static final String SPACE = " ";
    public static final String ANY_EOL = "\r\n";
    public static final char EOL_CHAR = "\r\n".charAt(1);
    public static final char EOL_CHAR1 = "\r\n".charAt(0);
    public static final char EOL_CHAR2 = "\r\n".charAt(1);
    public static final char SPC = ' ';
    public static final char NUL = '\u0000';
    public static final char ENC_NUL = '\ufffd';
    public static final char NBSP = '\u00a0';
    public static final char LS = '\u2028';
    public static final char US = '\u001f';
    public static final String LINE_SEP = Character.toString('\u2028');
    public static final String SPACE_TAB = " \t";
    public static final String SPACE_EOL = " \n";
    public static final String US_CHARS = Character.toString('\u001f');
    public static final String WHITESPACE = " \t\r\n";
    public static final String NBSP_CHARS = Character.toString('\u00a0');
    public static final String WHITESPACE_NBSP = " \t\r\n\u00a0";
    @Deprecated
    public static final CharPredicate SPACE_SET = CharPredicate.SPACE;
    @Deprecated
    public static final CharPredicate TAB_SET = CharPredicate.TAB;
    @Deprecated
    public static final CharPredicate EOL_SET = CharPredicate.EOL;
    @Deprecated
    public static final CharPredicate SPACE_TAB_SET = CharPredicate.SPACE_TAB;
    @Deprecated
    public static final CharPredicate SPACE_TAB_NBSP_SET = CharPredicate.SPACE_TAB_NBSP;
    @Deprecated
    public static final CharPredicate SPACE_TAB_EOL_SET = CharPredicate.SPACE_TAB_EOL;
    @Deprecated
    public static final CharPredicate SPACE_EOL_SET = CharPredicate.WHITESPACE;
    @Deprecated
    public static final CharPredicate ANY_EOL_SET = CharPredicate.ANY_EOL;
    @Deprecated
    public static final CharPredicate WHITESPACE_SET = CharPredicate.WHITESPACE;
    @Deprecated
    public static final CharPredicate WHITESPACE_NBSP_SET = CharPredicate.WHITESPACE_NBSP;
    @Deprecated
    public static final CharPredicate BACKSLASH_SET = CharPredicate.BACKSLASH;
    @Deprecated
    public static final CharPredicate US_SET = value -> value == 31;
    @Deprecated
    public static final CharPredicate HASH_SET = CharPredicate.HASH;
    @Deprecated
    public static final CharPredicate DECIMAL_DIGITS = CharPredicate.HASH;
    @Deprecated
    public static final CharPredicate HEXADECIMAL_DIGITS = CharPredicate.HASH;
    @Deprecated
    public static final CharPredicate OCTAL_DIGITS = CharPredicate.HASH;
    @Deprecated
    public static final char LSEP = '\u2028';
    @Deprecated
    public static final String EOL_CHARS = "\r\n";
    @Deprecated
    public static final String WHITESPACE_NO_EOL_CHARS = " \t";
    @Deprecated
    public static final String WHITESPACE_CHARS = " \t\r\n";
    @Deprecated
    public static final String WHITESPACE_NBSP_CHARS = " \t\r\n\u00a0";
    public static final int SPLIT_INCLUDE_DELIMS = 1;
    public static final int SPLIT_TRIM_PARTS = 2;
    public static final int SPLIT_SKIP_EMPTY = 4;
    public static final int SPLIT_INCLUDE_DELIM_PARTS = 8;
    public static final int SPLIT_TRIM_SKIP_EMPTY = 6;
    public static final Map<Character, String> visibleSpacesMap = SequenceUtils.getVisibleSpacesMap();
    public static final int[] EMPTY_INDICES = new int[0];

    public static Map<Character, String> getVisibleSpacesMap() {
        HashMap<Character, String> charMap = new HashMap<Character, String>();
        charMap.put(Character.valueOf('\n'), "\\n");
        charMap.put(Character.valueOf('\r'), "\\r");
        charMap.put(Character.valueOf('\f'), "\\f");
        charMap.put(Character.valueOf('\t'), "\\u2192");
        charMap.put(Character.valueOf('\u2028'), "\u27a5");
        return charMap;
    }

    @NotNull
    public static <T extends CharSequence> T subSequence(@NotNull T thizz, int startIndex) {
        return (T)thizz.subSequence(startIndex, thizz.length());
    }

    @NotNull
    public static <T extends CharSequence> T subSequence(@NotNull T thizz, @NotNull Range range) {
        return (T)(range.isNull() ? thizz : thizz.subSequence(range.getStart(), range.getEnd()));
    }

    @Nullable
    public static <T extends CharSequence> T subSequenceBefore(@NotNull T thizz, @NotNull Range range) {
        return (T)(range.isNull() ? null : thizz.subSequence(0, range.getStart()));
    }

    @Nullable
    public static <T extends CharSequence> T subSequenceAfter(@NotNull T thizz, @NotNull Range range) {
        return (T)(range.isNull() ? null : thizz.subSequence(range.getEnd(), thizz.length()));
    }

    @NotNull
    public static <T extends CharSequence> Pair<T, T> subSequenceBeforeAfter(@NotNull T thizz, Range range) {
        return Pair.of(SequenceUtils.subSequenceBefore(thizz, range), SequenceUtils.subSequenceAfter(thizz, range));
    }

    public static boolean containsAny(@NotNull CharSequence thizz, @NotNull CharPredicate s) {
        return SequenceUtils.indexOfAny(thizz, s, 0, Integer.MAX_VALUE) != -1;
    }

    public static boolean containsAny(@NotNull CharSequence thizz, @NotNull CharPredicate s, int index) {
        return SequenceUtils.indexOfAny(thizz, s, index, Integer.MAX_VALUE) != -1;
    }

    public static boolean containsAnyNot(@NotNull CharSequence thizz, @NotNull CharPredicate s) {
        return SequenceUtils.indexOfAny(thizz, s.negate(), 0, Integer.MAX_VALUE) != -1;
    }

    public static boolean containsAnyNot(@NotNull CharSequence thizz, @NotNull CharPredicate s, int fromIndex) {
        return SequenceUtils.indexOfAny(thizz, s.negate(), fromIndex, Integer.MAX_VALUE) != -1;
    }

    public static boolean containsAnyNot(@NotNull CharSequence thizz, @NotNull CharPredicate s, int fromIndex, int endIndex) {
        return SequenceUtils.indexOfAny(thizz, s.negate(), fromIndex, endIndex) != -1;
    }

    public static int indexOf(@NotNull CharSequence thizz, @NotNull CharSequence s) {
        return SequenceUtils.indexOf(thizz, s, 0, Integer.MAX_VALUE);
    }

    public static int indexOf(@NotNull CharSequence thizz, @NotNull CharSequence s, int fromIndex) {
        return SequenceUtils.indexOf(thizz, s, fromIndex, Integer.MAX_VALUE);
    }

    public static int indexOf(@NotNull CharSequence thizz, char c) {
        return SequenceUtils.indexOf(thizz, c, 0, Integer.MAX_VALUE);
    }

    public static int indexOf(@NotNull CharSequence thizz, char c, int fromIndex) {
        return SequenceUtils.indexOf(thizz, c, fromIndex, Integer.MAX_VALUE);
    }

    public static int indexOfAny(@NotNull CharSequence thizz, @NotNull CharPredicate s) {
        return SequenceUtils.indexOfAny(thizz, s, 0, Integer.MAX_VALUE);
    }

    public static int indexOfAny(@NotNull CharSequence thizz, @NotNull CharPredicate s, int index) {
        return SequenceUtils.indexOfAny(thizz, s, index, Integer.MAX_VALUE);
    }

    public static int indexOfAnyNot(@NotNull CharSequence thizz, @NotNull CharPredicate s) {
        return SequenceUtils.indexOfAny(thizz, s.negate(), 0, Integer.MAX_VALUE);
    }

    public static int indexOfAnyNot(@NotNull CharSequence thizz, @NotNull CharPredicate s, int fromIndex) {
        return SequenceUtils.indexOfAny(thizz, s.negate(), fromIndex, Integer.MAX_VALUE);
    }

    public static int indexOfAnyNot(@NotNull CharSequence thizz, @NotNull CharPredicate s, int fromIndex, int endIndex) {
        return SequenceUtils.indexOfAny(thizz, s.negate(), fromIndex, endIndex);
    }

    public static int indexOfNot(@NotNull CharSequence thizz, char c) {
        return SequenceUtils.indexOfNot(thizz, c, 0, Integer.MAX_VALUE);
    }

    public static int indexOfNot(@NotNull CharSequence thizz, char c, int fromIndex) {
        return SequenceUtils.indexOfNot(thizz, c, fromIndex, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(@NotNull CharSequence thizz, @NotNull CharSequence s) {
        return SequenceUtils.lastIndexOf(thizz, s, 0, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(@NotNull CharSequence thizz, @NotNull CharSequence s, int fromIndex) {
        return SequenceUtils.lastIndexOf(thizz, s, 0, fromIndex);
    }

    public static int lastIndexOf(@NotNull CharSequence thizz, char c) {
        return SequenceUtils.lastIndexOf(thizz, c, 0, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(@NotNull CharSequence thizz, char c, int fromIndex) {
        return SequenceUtils.lastIndexOf(thizz, c, 0, fromIndex);
    }

    public static int lastIndexOfAny(@NotNull CharSequence thizz, @NotNull CharPredicate s) {
        return SequenceUtils.lastIndexOfAny(thizz, s, 0, Integer.MAX_VALUE);
    }

    public static int lastIndexOfAny(@NotNull CharSequence thizz, @NotNull CharPredicate s, int fromIndex) {
        return SequenceUtils.lastIndexOfAny(thizz, s, 0, fromIndex);
    }

    public static int lastIndexOfAnyNot(@NotNull CharSequence thizz, @NotNull CharPredicate s) {
        return SequenceUtils.lastIndexOfAny(thizz, s.negate(), 0, Integer.MAX_VALUE);
    }

    public static int lastIndexOfAnyNot(@NotNull CharSequence thizz, @NotNull CharPredicate s, int fromIndex) {
        return SequenceUtils.lastIndexOfAny(thizz, s.negate(), 0, fromIndex);
    }

    public static int lastIndexOfAnyNot(@NotNull CharSequence thizz, @NotNull CharPredicate s, int startIndex, int fromIndex) {
        return SequenceUtils.lastIndexOfAny(thizz, s.negate(), startIndex, fromIndex);
    }

    public static int lastIndexOfNot(@NotNull CharSequence thizz, char c) {
        return SequenceUtils.lastIndexOfNot(thizz, c, 0, Integer.MAX_VALUE);
    }

    public static int lastIndexOfNot(@NotNull CharSequence thizz, char c, int fromIndex) {
        return SequenceUtils.lastIndexOfNot(thizz, c, 0, fromIndex);
    }

    public static int indexOf(@NotNull CharSequence thizz, char c, int fromIndex, int endIndex) {
        fromIndex = Math.max(fromIndex, 0);
        endIndex = Math.min(thizz.length(), endIndex);
        for (int i = fromIndex; i < endIndex; ++i) {
            if (c != thizz.charAt(i)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(@NotNull CharSequence thizz, @NotNull CharSequence s, int fromIndex, int endIndex) {
        fromIndex = Math.max(fromIndex, 0);
        int sMax = s.length();
        if (sMax == 0) {
            return fromIndex;
        }
        endIndex = Math.min(thizz.length(), endIndex);
        if (fromIndex < endIndex) {
            char firstChar = s.charAt(0);
            int pos = fromIndex;
            while ((pos = SequenceUtils.indexOf(thizz, firstChar, pos)) >= 0 && pos + sMax <= endIndex) {
                if (SequenceUtils.matchChars(thizz, s, pos)) {
                    return pos;
                }
                if (++pos + sMax < endIndex) continue;
            }
        }
        return -1;
    }

    public static int lastIndexOf(@NotNull CharSequence thizz, char c, int startIndex, int fromIndex) {
        fromIndex = Math.min(fromIndex, thizz.length() - 1);
        startIndex = Math.max(startIndex, 0);
        int i = ++fromIndex;
        while (i-- > startIndex) {
            if (c != thizz.charAt(i)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfNot(@NotNull CharSequence thizz, char c, int fromIndex, int endIndex) {
        fromIndex = Math.max(fromIndex, 0);
        endIndex = Math.min(endIndex, thizz.length());
        for (int i = fromIndex; i < endIndex; ++i) {
            if (thizz.charAt(i) == c) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfAny(@NotNull CharSequence thizz, @NotNull CharPredicate s, int fromIndex, int endIndex) {
        fromIndex = Math.max(fromIndex, 0);
        endIndex = Math.min(endIndex, thizz.length());
        for (int i = fromIndex; i < endIndex; ++i) {
            char c = thizz.charAt(i);
            if (!s.test(c)) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(@NotNull CharSequence thizz, @NotNull CharSequence s, int startIndex, int fromIndex) {
        startIndex = Math.max(startIndex, 0);
        int sMax = s.length();
        if (sMax == 0) {
            return startIndex;
        }
        if (startIndex < (fromIndex = Math.min(fromIndex, thizz.length()))) {
            int pos = fromIndex;
            char lastChar = s.charAt(sMax - 1);
            while ((pos = SequenceUtils.lastIndexOf(thizz, lastChar, pos)) + 1 >= startIndex + sMax) {
                if (SequenceUtils.matchCharsReversed(thizz, s, pos)) {
                    return pos + 1 - sMax;
                }
                if (--pos + 1 >= startIndex + sMax) continue;
            }
        }
        return -1;
    }

    public static int lastIndexOfNot(@NotNull CharSequence thizz, char c, int startIndex, int fromIndex) {
        fromIndex = Math.min(fromIndex, thizz.length() - 1);
        startIndex = Math.max(startIndex, 0);
        int i = ++fromIndex;
        while (i-- > startIndex) {
            if (thizz.charAt(i) == c) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOfAny(@NotNull CharSequence thizz, @NotNull CharPredicate s, int startIndex, int fromIndex) {
        fromIndex = Math.min(fromIndex, thizz.length() - 1);
        startIndex = Math.max(startIndex, 0);
        int i = ++fromIndex;
        while (i-- > startIndex) {
            char c = thizz.charAt(i);
            if (!s.test(c)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true, value="_, null -> false")
    public static boolean equals(@NotNull CharSequence thizz, Object o) {
        String other;
        if (o == thizz) {
            return true;
        }
        if (!(o instanceof CharSequence)) {
            return false;
        }
        CharSequence chars = (CharSequence)o;
        if (chars.length() != thizz.length()) {
            return false;
        }
        if (o instanceof String ? (other = (String)o).hashCode() != thizz.hashCode() : o instanceof IRichSequence && (other = (IRichSequence)o).hashCode() != thizz.hashCode()) {
            return false;
        }
        return SequenceUtils.matchChars(thizz, chars, 0, false);
    }

    @Contract(pure=true)
    public static int hashCode(@NotNull CharSequence thizz) {
        int h = 0;
        int length = thizz.length();
        if (length > 0) {
            for (int i = 0; i < length; ++i) {
                h = 31 * h + thizz.charAt(i);
            }
        }
        return h;
    }

    public static int compareReversed(@Nullable CharSequence o1, @Nullable CharSequence o2) {
        return SequenceUtils.compare(o2, o1);
    }

    public static int compare(@Nullable CharSequence o1, @Nullable CharSequence o2) {
        return SequenceUtils.compare(o1, o2, false);
    }

    public static int compare(@Nullable CharSequence o1, @Nullable CharSequence o2, boolean ignoreCase) {
        return SequenceUtils.compare(o1, o2, ignoreCase, null);
    }

    public static int compare(@Nullable CharSequence o1, @Nullable CharSequence o2, boolean ignoreCase, @Nullable CharPredicate ignoreChars) {
        if (o1 == null || o2 == null) {
            return o1 == null && o2 == null ? 0 : (o1 == null ? -1 : 1);
        }
        int len1 = o1.length();
        int len2 = o2.length();
        int iMax = Math.min(len1, len2);
        if (ignoreCase) {
            for (int i = 0; i < iMax; ++i) {
                char u2;
                char u1;
                char c2;
                char c1 = o1.charAt(i);
                if (c1 == (c2 = o2.charAt(i)) || (u1 = Character.toUpperCase(c1)) == (u2 = Character.toUpperCase(c2)) || Character.toLowerCase(u1) == Character.toLowerCase(u2) || ignoreChars != null && ignoreChars.test(c1) && ignoreChars.test(c2)) continue;
                return c1 - c2;
            }
        } else {
            for (int i = 0; i < iMax; ++i) {
                char c2;
                char c1 = o1.charAt(i);
                if (c1 == (c2 = o2.charAt(i)) || ignoreChars != null && ignoreChars.test(c1) && ignoreChars.test(c2)) continue;
                return c1 - c2;
            }
        }
        return len1 - len2;
    }

    @NotNull
    public static String[] toStringArray(CharSequence ... sequences) {
        String[] result2 = new String[sequences.length];
        int i = 0;
        for (CharSequence sequence : sequences) {
            result2[i] = sequences[i] == null ? null : sequences[i].toString();
            ++i;
        }
        return result2;
    }

    public static boolean isVisibleWhitespace(char c) {
        return visibleSpacesMap.containsKey(Character.valueOf(c));
    }

    public static int columnsToNextTabStop(int column) {
        return 4 - column % 4;
    }

    @NotNull
    public static int[] expandTo(@NotNull int[] indices, int length, int step) {
        int remainder = length & step;
        int next = length + (remainder != 0 ? step : 0);
        if (indices.length < next) {
            int[] replace = new int[next];
            System.arraycopy(indices, 0, replace, 0, indices.length);
            return replace;
        }
        return indices;
    }

    @NotNull
    public static int[] truncateTo(@NotNull int[] indices, int length) {
        if (indices.length > length) {
            int[] replace = new int[length];
            System.arraycopy(indices, 0, replace, 0, length);
            return replace;
        }
        return indices;
    }

    @NotNull
    public static int[] indexOfAll(@NotNull CharSequence thizz, @NotNull CharSequence s) {
        int length = s.length();
        if (length == 0) {
            return EMPTY_INDICES;
        }
        int pos = SequenceUtils.indexOf(thizz, s);
        if (pos == -1) {
            return EMPTY_INDICES;
        }
        int iMax = 0;
        int[] indices = new int[32];
        indices[iMax++] = pos;
        while ((pos = SequenceUtils.indexOf(thizz, s, pos + length)) != -1) {
            if (indices.length <= iMax) {
                indices = SequenceUtils.expandTo(indices, iMax + 1, 32);
            }
            indices[iMax++] = pos;
        }
        return SequenceUtils.truncateTo(indices, iMax);
    }

    public static boolean matches(@NotNull CharSequence thizz, @NotNull CharSequence chars, boolean ignoreCase) {
        return chars.length() == thizz.length() && SequenceUtils.matchChars(thizz, chars, 0, ignoreCase);
    }

    public static boolean matches(@NotNull CharSequence thizz, @NotNull CharSequence chars) {
        return chars.length() == thizz.length() && SequenceUtils.matchChars(thizz, chars, 0, false);
    }

    public static boolean matchesIgnoreCase(@NotNull CharSequence thizz, @NotNull CharSequence chars) {
        return chars.length() == thizz.length() && SequenceUtils.matchChars(thizz, chars, 0, true);
    }

    public static boolean matchChars(@NotNull CharSequence thizz, @NotNull CharSequence chars, int startIndex, boolean ignoreCase) {
        return SequenceUtils.matchedCharCount(thizz, chars, startIndex, Integer.MAX_VALUE, true, ignoreCase) == chars.length();
    }

    public static boolean matchChars(@NotNull CharSequence thizz, @NotNull CharSequence chars, int startIndex) {
        return SequenceUtils.matchChars(thizz, chars, startIndex, false);
    }

    public static boolean matchCharsIgnoreCase(@NotNull CharSequence thizz, @NotNull CharSequence chars, int startIndex) {
        return SequenceUtils.matchChars(thizz, chars, startIndex, true);
    }

    public static boolean matchChars(@NotNull CharSequence thizz, @NotNull CharSequence chars, boolean ignoreCase) {
        return SequenceUtils.matchChars(thizz, chars, 0, ignoreCase);
    }

    public static boolean matchChars(@NotNull CharSequence thizz, @NotNull CharSequence chars) {
        return SequenceUtils.matchChars(thizz, chars, 0, false);
    }

    public static boolean matchCharsIgnoreCase(@NotNull CharSequence thizz, @NotNull CharSequence chars) {
        return SequenceUtils.matchChars(thizz, chars, 0, true);
    }

    public static boolean matchCharsReversed(@NotNull CharSequence thizz, @NotNull CharSequence chars, int endIndex, boolean ignoreCase) {
        return endIndex + 1 >= chars.length() && SequenceUtils.matchChars(thizz, chars, endIndex + 1 - chars.length(), ignoreCase);
    }

    public static boolean matchCharsReversed(@NotNull CharSequence thizz, @NotNull CharSequence chars, int endIndex) {
        return endIndex + 1 >= chars.length() && SequenceUtils.matchChars(thizz, chars, endIndex + 1 - chars.length(), false);
    }

    public static boolean matchCharsReversedIgnoreCase(@NotNull CharSequence thizz, @NotNull CharSequence chars, int endIndex) {
        return endIndex + 1 >= chars.length() && SequenceUtils.matchChars(thizz, chars, endIndex + 1 - chars.length(), true);
    }

    public static int matchedCharCount(@NotNull CharSequence thizz, @NotNull CharSequence chars, int startIndex, int endIndex, boolean ignoreCase) {
        return SequenceUtils.matchedCharCount(thizz, chars, startIndex, Integer.MAX_VALUE, false, ignoreCase);
    }

    public static int matchedCharCount(@NotNull CharSequence thizz, @NotNull CharSequence chars, int startIndex, boolean ignoreCase) {
        return SequenceUtils.matchedCharCount(thizz, chars, startIndex, Integer.MAX_VALUE, false, ignoreCase);
    }

    public static int matchedCharCount(@NotNull CharSequence thizz, @NotNull CharSequence chars, int startIndex, int endIndex) {
        return SequenceUtils.matchedCharCount(thizz, chars, startIndex, Integer.MAX_VALUE, false, false);
    }

    public static int matchedCharCount(@NotNull CharSequence thizz, @NotNull CharSequence chars, int startIndex) {
        return SequenceUtils.matchedCharCount(thizz, chars, startIndex, Integer.MAX_VALUE, false, false);
    }

    public static int matchedCharCountIgnoreCase(@NotNull CharSequence thizz, @NotNull CharSequence chars, int startIndex, int endIndex) {
        return SequenceUtils.matchedCharCount(thizz, chars, startIndex, Integer.MAX_VALUE, false, true);
    }

    public static int matchedCharCountIgnoreCase(@NotNull CharSequence thizz, @NotNull CharSequence chars, int startIndex) {
        return SequenceUtils.matchedCharCount(thizz, chars, startIndex, Integer.MAX_VALUE, false, true);
    }

    public static int matchedCharCountReversed(@NotNull CharSequence thizz, @NotNull CharSequence chars, int startIndex, int fromIndex) {
        return SequenceUtils.matchedCharCountReversed(thizz, chars, startIndex, fromIndex, false);
    }

    public static int matchedCharCountReversedIgnoreCase(@NotNull CharSequence thizz, @NotNull CharSequence chars, int startIndex, int fromIndex) {
        return SequenceUtils.matchedCharCountReversed(thizz, chars, startIndex, fromIndex, true);
    }

    public static int matchedCharCountReversed(@NotNull CharSequence thizz, @NotNull CharSequence chars, int fromIndex, boolean ignoreCase) {
        return SequenceUtils.matchedCharCountReversed(thizz, chars, 0, fromIndex, ignoreCase);
    }

    public static int matchedCharCountReversed(@NotNull CharSequence thizz, @NotNull CharSequence chars, int fromIndex) {
        return SequenceUtils.matchedCharCountReversed(thizz, chars, 0, fromIndex, false);
    }

    public static int matchedCharCountReversedIgnoreCase(@NotNull CharSequence thizz, @NotNull CharSequence chars, int fromIndex) {
        return SequenceUtils.matchedCharCountReversed(thizz, chars, 0, fromIndex, true);
    }

    public static int matchedCharCount(@NotNull CharSequence thizz, @NotNull CharSequence chars, int startIndex, int endIndex, boolean fullMatchOnly, boolean ignoreCase) {
        int length = chars.length();
        endIndex = Math.min(thizz.length(), endIndex);
        int iMax = Math.min(endIndex - startIndex, length);
        if (fullMatchOnly && iMax < length) {
            return 0;
        }
        if (ignoreCase) {
            for (int i = 0; i < iMax; ++i) {
                char u2;
                char u1;
                char c2;
                char c1 = chars.charAt(i);
                if (c1 == (c2 = thizz.charAt(i + startIndex)) || (u1 = Character.toUpperCase(c1)) == (u2 = Character.toUpperCase(c2)) || Character.toLowerCase(u1) == Character.toLowerCase(u2)) continue;
                return i;
            }
        } else {
            for (int i = 0; i < iMax; ++i) {
                if (chars.charAt(i) == thizz.charAt(i + startIndex)) continue;
                return i;
            }
        }
        return iMax;
    }

    public static int matchedCharCountReversed(@NotNull CharSequence thizz, @NotNull CharSequence chars, int startIndex, int fromIndex, boolean ignoreCase) {
        startIndex = Math.max(0, startIndex);
        fromIndex = Math.max(0, Math.min(thizz.length(), fromIndex));
        int length = chars.length();
        int iMax = Math.min(fromIndex - startIndex, length);
        int offset = fromIndex - iMax;
        if (ignoreCase) {
            int i = iMax;
            while (i-- > 0) {
                char u2;
                char u1;
                char c2;
                char c1 = chars.charAt(i);
                if (c1 == (c2 = thizz.charAt(offset + i)) || (u1 = Character.toUpperCase(c1)) == (u2 = Character.toUpperCase(c2)) || Character.toLowerCase(u1) == Character.toLowerCase(u2)) continue;
                return iMax - i - 1;
            }
        } else {
            int i = iMax;
            while (i-- > 0) {
                if (chars.charAt(i) == thizz.charAt(offset + i)) continue;
                return iMax - i - 1;
            }
        }
        return iMax;
    }

    public static int countOfSpaceTab(@NotNull CharSequence thizz) {
        return SequenceUtils.countOfAny(thizz, CharPredicate.SPACE_TAB, 0, Integer.MAX_VALUE);
    }

    public static int countOfNotSpaceTab(@NotNull CharSequence thizz) {
        return SequenceUtils.countOfAny(thizz, CharPredicate.SPACE_TAB.negate(), 0, Integer.MAX_VALUE);
    }

    public static int countOfWhitespace(@NotNull CharSequence thizz) {
        return SequenceUtils.countOfAny(thizz, CharPredicate.WHITESPACE, Integer.MAX_VALUE);
    }

    public static int countOfNotWhitespace(@NotNull CharSequence thizz) {
        return SequenceUtils.countOfAny(thizz, CharPredicate.WHITESPACE.negate(), 0, Integer.MAX_VALUE);
    }

    public static int countOfAny(@NotNull CharSequence thizz, @NotNull CharPredicate chars, int fromIndex) {
        return SequenceUtils.countOfAny(thizz, chars, fromIndex, Integer.MAX_VALUE);
    }

    public static int countOfAny(@NotNull CharSequence thizz, @NotNull CharPredicate chars) {
        return SequenceUtils.countOfAny(thizz, chars, 0, Integer.MAX_VALUE);
    }

    public static int countOfAnyNot(@NotNull CharSequence thizz, @NotNull CharPredicate chars, int fromIndex, int endIndex) {
        return SequenceUtils.countOfAny(thizz, chars.negate(), fromIndex, endIndex);
    }

    public static int countOfAnyNot(@NotNull CharSequence thizz, @NotNull CharPredicate chars, int fromIndex) {
        return SequenceUtils.countOfAny(thizz, chars.negate(), fromIndex, Integer.MAX_VALUE);
    }

    public static int countOfAnyNot(@NotNull CharSequence thizz, @NotNull CharPredicate chars) {
        return SequenceUtils.countOfAny(thizz, chars.negate(), 0, Integer.MAX_VALUE);
    }

    public static int countOfAny(@NotNull CharSequence thizz, @NotNull CharPredicate s, int fromIndex, int endIndex) {
        fromIndex = Math.max(fromIndex, 0);
        endIndex = Math.min(endIndex, thizz.length());
        int count = 0;
        for (int i = fromIndex; i < endIndex; ++i) {
            char c = thizz.charAt(i);
            if (!s.test(c)) continue;
            ++count;
        }
        return count;
    }

    public static int countLeadingSpace(@NotNull CharSequence thizz) {
        return SequenceUtils.countLeading(thizz, CharPredicate.SPACE, 0, Integer.MAX_VALUE);
    }

    public static int countLeadingSpace(@NotNull CharSequence thizz, int startIndex) {
        return SequenceUtils.countLeading(thizz, CharPredicate.SPACE, startIndex, Integer.MAX_VALUE);
    }

    public static int countLeadingSpace(@NotNull CharSequence thizz, int startIndex, int endIndex) {
        return SequenceUtils.countLeading(thizz, CharPredicate.SPACE, startIndex, endIndex);
    }

    public static int countLeadingNotSpace(@NotNull CharSequence thizz) {
        return SequenceUtils.countLeading(thizz, CharPredicate.SPACE.negate(), 0, Integer.MAX_VALUE);
    }

    public static int countLeadingNotSpace(@NotNull CharSequence thizz, int startIndex) {
        return SequenceUtils.countLeading(thizz, CharPredicate.SPACE.negate(), startIndex, Integer.MAX_VALUE);
    }

    public static int countLeadingNotSpace(@NotNull CharSequence thizz, int startIndex, int endIndex) {
        return SequenceUtils.countLeading(thizz, CharPredicate.SPACE.negate(), startIndex, endIndex);
    }

    public static int countTrailingSpace(@NotNull CharSequence thizz) {
        return SequenceUtils.countTrailing(thizz, CharPredicate.SPACE, 0, Integer.MAX_VALUE);
    }

    public static int countTrailingSpace(@NotNull CharSequence thizz, int fromIndex) {
        return SequenceUtils.countTrailing(thizz, CharPredicate.SPACE, 0, fromIndex);
    }

    public static int countTrailingSpace(@NotNull CharSequence thizz, int startIndex, int fromIndex) {
        return SequenceUtils.countTrailing(thizz, CharPredicate.SPACE, startIndex, fromIndex);
    }

    public static int countTrailingNotSpace(@NotNull CharSequence thizz) {
        return SequenceUtils.countTrailing(thizz, CharPredicate.SPACE.negate(), 0, Integer.MAX_VALUE);
    }

    public static int countTrailingNotSpace(@NotNull CharSequence thizz, int fromIndex) {
        return SequenceUtils.countTrailing(thizz, CharPredicate.SPACE.negate(), 0, fromIndex);
    }

    public static int countTrailingNotSpace(@NotNull CharSequence thizz, int startIndex, int fromIndex) {
        return SequenceUtils.countTrailing(thizz, CharPredicate.SPACE.negate(), startIndex, fromIndex);
    }

    public static int countLeadingSpaceTab(@NotNull CharSequence thizz) {
        return SequenceUtils.countLeading(thizz, CharPredicate.SPACE_TAB, 0, Integer.MAX_VALUE);
    }

    public static int countLeadingSpaceTab(@NotNull CharSequence thizz, int startIndex) {
        return SequenceUtils.countLeading(thizz, CharPredicate.SPACE_TAB, startIndex, Integer.MAX_VALUE);
    }

    public static int countLeadingSpaceTab(@NotNull CharSequence thizz, int startIndex, int endIndex) {
        return SequenceUtils.countLeading(thizz, CharPredicate.SPACE_TAB, startIndex, endIndex);
    }

    public static int countLeadingNotSpaceTab(@NotNull CharSequence thizz) {
        return SequenceUtils.countLeading(thizz, CharPredicate.SPACE_TAB.negate(), 0, Integer.MAX_VALUE);
    }

    public static int countLeadingNotSpaceTab(@NotNull CharSequence thizz, int startIndex) {
        return SequenceUtils.countLeading(thizz, CharPredicate.SPACE_TAB.negate(), startIndex, Integer.MAX_VALUE);
    }

    public static int countLeadingNotSpaceTab(@NotNull CharSequence thizz, int startIndex, int endIndex) {
        return SequenceUtils.countLeading(thizz, CharPredicate.SPACE_TAB.negate(), startIndex, endIndex);
    }

    public static int countTrailingSpaceTab(@NotNull CharSequence thizz) {
        return SequenceUtils.countTrailing(thizz, CharPredicate.SPACE_TAB, 0, Integer.MAX_VALUE);
    }

    public static int countTrailingSpaceTab(@NotNull CharSequence thizz, int fromIndex) {
        return SequenceUtils.countTrailing(thizz, CharPredicate.SPACE_TAB, 0, fromIndex);
    }

    public static int countTrailingSpaceTab(@NotNull CharSequence thizz, int startIndex, int fromIndex) {
        return SequenceUtils.countTrailing(thizz, CharPredicate.SPACE_TAB, startIndex, fromIndex);
    }

    public static int countTrailingNotSpaceTab(@NotNull CharSequence thizz) {
        return SequenceUtils.countTrailing(thizz, CharPredicate.SPACE_TAB.negate(), 0, Integer.MAX_VALUE);
    }

    public static int countTrailingNotSpaceTab(@NotNull CharSequence thizz, int fromIndex) {
        return SequenceUtils.countTrailing(thizz, CharPredicate.SPACE_TAB.negate(), 0, fromIndex);
    }

    public static int countTrailingNotSpaceTab(@NotNull CharSequence thizz, int startIndex, int fromIndex) {
        return SequenceUtils.countTrailing(thizz, CharPredicate.SPACE_TAB.negate(), startIndex, fromIndex);
    }

    public static int countLeadingWhitespace(@NotNull CharSequence thizz) {
        return SequenceUtils.countLeading(thizz, CharPredicate.WHITESPACE, 0, Integer.MAX_VALUE);
    }

    public static int countLeadingWhitespace(@NotNull CharSequence thizz, int startIndex) {
        return SequenceUtils.countLeading(thizz, CharPredicate.WHITESPACE, startIndex, Integer.MAX_VALUE);
    }

    public static int countLeadingWhitespace(@NotNull CharSequence thizz, int startIndex, int endIndex) {
        return SequenceUtils.countLeading(thizz, CharPredicate.WHITESPACE, startIndex, endIndex);
    }

    public static int countLeadingNotWhitespace(@NotNull CharSequence thizz) {
        return SequenceUtils.countLeading(thizz, CharPredicate.WHITESPACE.negate(), 0, Integer.MAX_VALUE);
    }

    public static int countLeadingNotWhitespace(@NotNull CharSequence thizz, int startIndex) {
        return SequenceUtils.countLeading(thizz, CharPredicate.WHITESPACE.negate(), startIndex, Integer.MAX_VALUE);
    }

    public static int countLeadingNotWhitespace(@NotNull CharSequence thizz, int startIndex, int endIndex) {
        return SequenceUtils.countLeading(thizz, CharPredicate.WHITESPACE.negate(), startIndex, endIndex);
    }

    public static int countTrailingWhitespace(@NotNull CharSequence thizz) {
        return SequenceUtils.countTrailing(thizz, CharPredicate.WHITESPACE, 0, Integer.MAX_VALUE);
    }

    public static int countTrailingWhitespace(@NotNull CharSequence thizz, int fromIndex) {
        return SequenceUtils.countTrailing(thizz, CharPredicate.WHITESPACE, 0, fromIndex);
    }

    public static int countTrailingWhitespace(@NotNull CharSequence thizz, int startIndex, int fromIndex) {
        return SequenceUtils.countTrailing(thizz, CharPredicate.WHITESPACE, startIndex, fromIndex);
    }

    public static int countTrailingNotWhitespace(@NotNull CharSequence thizz) {
        return SequenceUtils.countTrailing(thizz, CharPredicate.WHITESPACE.negate(), 0, Integer.MAX_VALUE);
    }

    public static int countTrailingNotWhitespace(@NotNull CharSequence thizz, int fromIndex) {
        return SequenceUtils.countTrailing(thizz, CharPredicate.WHITESPACE.negate(), 0, fromIndex);
    }

    public static int countTrailingNotWhitespace(@NotNull CharSequence thizz, int startIndex, int fromIndex) {
        return SequenceUtils.countTrailing(thizz, CharPredicate.WHITESPACE.negate(), startIndex, fromIndex);
    }

    public static int countLeading(@NotNull CharSequence thizz, @NotNull CharPredicate chars) {
        return SequenceUtils.countLeading(thizz, chars, 0, Integer.MAX_VALUE);
    }

    public static int countLeading(@NotNull CharSequence thizz, @NotNull CharPredicate chars, int fromIndex) {
        return SequenceUtils.countLeading(thizz, chars, fromIndex, Integer.MAX_VALUE);
    }

    public static int countLeadingNot(@NotNull CharSequence thizz, @NotNull CharPredicate chars) {
        return SequenceUtils.countLeading(thizz, chars.negate(), 0, Integer.MAX_VALUE);
    }

    public static int countLeadingNot(@NotNull CharSequence thizz, @NotNull CharPredicate chars, int fromIndex) {
        return SequenceUtils.countLeading(thizz, chars.negate(), fromIndex, Integer.MAX_VALUE);
    }

    public static int countTrailing(@NotNull CharSequence thizz, @NotNull CharPredicate chars) {
        return SequenceUtils.countTrailing(thizz, chars, 0, Integer.MAX_VALUE);
    }

    public static int countTrailing(@NotNull CharSequence thizz, @NotNull CharPredicate chars, int fromIndex) {
        return SequenceUtils.countTrailing(thizz, chars, 0, fromIndex);
    }

    public static int countTrailingNot(@NotNull CharSequence thizz, @NotNull CharPredicate chars) {
        return SequenceUtils.countTrailing(thizz, chars.negate(), 0, Integer.MAX_VALUE);
    }

    public static int countTrailingNot(@NotNull CharSequence thizz, @NotNull CharPredicate chars, int fromIndex) {
        return SequenceUtils.countTrailing(thizz, chars.negate(), 0, fromIndex);
    }

    public static int countLeadingNot(@NotNull CharSequence thizz, @NotNull CharPredicate chars, int startIndex, int endIndex) {
        return SequenceUtils.countLeading(thizz, chars.negate(), startIndex, endIndex);
    }

    public static int countTrailingNot(@NotNull CharSequence thizz, @NotNull CharPredicate chars, int startIndex, int endIndex) {
        return SequenceUtils.countTrailing(thizz, chars.negate(), startIndex, endIndex);
    }

    public static int countLeading(@NotNull CharSequence thizz, @NotNull CharPredicate chars, int fromIndex, int endIndex) {
        int index = SequenceUtils.indexOfAnyNot(thizz, chars, fromIndex = Utils.rangeLimit(fromIndex, 0, endIndex = Math.min(endIndex, thizz.length())), endIndex);
        return index == -1 ? endIndex - fromIndex : index - fromIndex;
    }

    public static int countLeadingColumns(@NotNull CharSequence thizz, int startColumn, @NotNull CharPredicate chars) {
        int fromIndex = 0;
        int endIndex = thizz.length();
        int index = SequenceUtils.indexOfAnyNot(thizz, chars, fromIndex, endIndex);
        int end = index == -1 ? endIndex : index;
        int columns = index == -1 ? endIndex - fromIndex : index - fromIndex;
        int tab = SequenceUtils.indexOf(thizz, '\t', fromIndex, end);
        if (tab != -1) {
            int delta = startColumn;
            do {
                delta += tab + SequenceUtils.columnsToNextTabStop(tab + delta);
            } while ((tab = SequenceUtils.indexOf(thizz, '\t', tab + 1)) >= 0 && tab < endIndex);
            columns += delta;
        }
        return columns;
    }

    public static int countTrailing(@NotNull CharSequence thizz, @NotNull CharPredicate chars, int startIndex, int fromIndex) {
        int index = SequenceUtils.lastIndexOfAnyNot(thizz, chars, startIndex = Utils.rangeLimit(startIndex, 0, fromIndex = Math.min(fromIndex, thizz.length())), fromIndex - 1);
        return index == -1 ? fromIndex - startIndex : (fromIndex <= index ? 0 : fromIndex - index - 1);
    }

    @NotNull
    public static <T extends CharSequence> T trimStart(@NotNull T thizz, @NotNull CharPredicate chars) {
        return SequenceUtils.subSequence(thizz, SequenceUtils.trimStartRange(thizz, 0, chars));
    }

    @Nullable
    public static <T extends CharSequence> T trimmedStart(@NotNull T thizz, @NotNull CharPredicate chars) {
        return SequenceUtils.trimmedStart(thizz, 0, chars);
    }

    @NotNull
    public static <T extends CharSequence> T trimEnd(@NotNull T thizz, @NotNull CharPredicate chars) {
        return SequenceUtils.trimEnd(thizz, 0, chars);
    }

    @Nullable
    public static <T extends CharSequence> T trimmedEnd(@NotNull T thizz, @NotNull CharPredicate chars) {
        return SequenceUtils.trimmedEnd(thizz, 0, chars);
    }

    @NotNull
    public static <T extends CharSequence> T trim(@NotNull T thizz, @NotNull CharPredicate chars) {
        return SequenceUtils.trim(thizz, 0, chars);
    }

    @NotNull
    public static <T extends CharSequence> Pair<T, T> trimmed(@NotNull T thizz, @NotNull CharPredicate chars) {
        return SequenceUtils.trimmed(thizz, 0, chars);
    }

    @NotNull
    public static <T extends CharSequence> T trimStart(@NotNull T thizz, int keep) {
        return SequenceUtils.trimStart(thizz, keep, CharPredicate.WHITESPACE);
    }

    @Nullable
    public static <T extends CharSequence> T trimmedStart(@NotNull T thizz, int keep) {
        return SequenceUtils.trimmedStart(thizz, keep, CharPredicate.WHITESPACE);
    }

    @NotNull
    public static <T extends CharSequence> T trimEnd(@NotNull T thizz, int keep) {
        return SequenceUtils.trimEnd(thizz, keep, CharPredicate.WHITESPACE);
    }

    @Nullable
    public static <T extends CharSequence> T trimmedEnd(@NotNull T thizz, int keep) {
        return SequenceUtils.trimmedEnd(thizz, keep, CharPredicate.WHITESPACE);
    }

    @NotNull
    public static <T extends CharSequence> T trim(@NotNull T thizz, int keep) {
        return SequenceUtils.trim(thizz, keep, CharPredicate.WHITESPACE);
    }

    @NotNull
    public static <T extends CharSequence> Pair<T, T> trimmed(@NotNull T thizz, int keep) {
        return SequenceUtils.trimmed(thizz, keep, CharPredicate.WHITESPACE);
    }

    @NotNull
    public static <T extends CharSequence> T trimStart(@NotNull T thizz) {
        return SequenceUtils.trimStart(thizz, 0, CharPredicate.WHITESPACE);
    }

    @Nullable
    public static <T extends CharSequence> T trimmedStart(@NotNull T thizz) {
        return SequenceUtils.trimmedStart(thizz, 0, CharPredicate.WHITESPACE);
    }

    @NotNull
    public static <T extends CharSequence> T trimEnd(@NotNull T thizz) {
        return SequenceUtils.trimEnd(thizz, 0, CharPredicate.WHITESPACE);
    }

    @Nullable
    public static <T extends CharSequence> T trimmedEnd(@NotNull T thizz) {
        return SequenceUtils.trimmedEnd(thizz, 0, CharPredicate.WHITESPACE);
    }

    @NotNull
    public static <T extends CharSequence> T trim(@NotNull T thizz) {
        return SequenceUtils.trim(thizz, 0, CharPredicate.WHITESPACE);
    }

    @NotNull
    public static <T extends CharSequence> Pair<T, T> trimmed(@NotNull T thizz) {
        return SequenceUtils.trimmed(thizz, 0, CharPredicate.WHITESPACE);
    }

    @NotNull
    public static <T extends CharSequence> T trimStart(@NotNull T thizz, int keep, @NotNull CharPredicate chars) {
        return SequenceUtils.subSequence(thizz, SequenceUtils.trimStartRange(thizz, keep, chars));
    }

    @Nullable
    public static <T extends CharSequence> T trimmedStart(@NotNull T thizz, int keep, @NotNull CharPredicate chars) {
        return SequenceUtils.subSequenceBefore(thizz, SequenceUtils.trimStartRange(thizz, keep, chars));
    }

    @NotNull
    public static <T extends CharSequence> T trimEnd(@NotNull T thizz, int keep, @NotNull CharPredicate chars) {
        return SequenceUtils.subSequence(thizz, SequenceUtils.trimEndRange(thizz, keep, chars));
    }

    @Nullable
    public static <T extends CharSequence> T trimmedEnd(@NotNull T thizz, int keep, @NotNull CharPredicate chars) {
        return SequenceUtils.subSequenceAfter(thizz, SequenceUtils.trimEndRange(thizz, keep, chars));
    }

    @NotNull
    public static <T extends CharSequence> T trim(@NotNull T thizz, int keep, @NotNull CharPredicate chars) {
        return SequenceUtils.subSequence(thizz, SequenceUtils.trimRange(thizz, keep, chars));
    }

    @NotNull
    public static <T extends CharSequence> Pair<T, T> trimmed(@NotNull T thizz, int keep, @NotNull CharPredicate chars) {
        return SequenceUtils.subSequenceBeforeAfter(thizz, SequenceUtils.trimRange(thizz, keep, chars));
    }

    public static Range trimStartRange(@NotNull CharSequence thizz, @NotNull CharPredicate chars) {
        return SequenceUtils.trimStartRange(thizz, 0, chars);
    }

    public static Range trimEndRange(@NotNull CharSequence thizz, @NotNull CharPredicate chars) {
        return SequenceUtils.trimEndRange(thizz, 0, chars);
    }

    public static Range trimRange(@NotNull CharSequence thizz, @NotNull CharPredicate chars) {
        return SequenceUtils.trimRange(thizz, 0, chars);
    }

    public static Range trimStartRange(@NotNull CharSequence thizz, int keep) {
        return SequenceUtils.trimStartRange(thizz, keep, CharPredicate.WHITESPACE);
    }

    public static Range trimEndRange(@NotNull CharSequence thizz, int keep) {
        return SequenceUtils.trimEndRange(thizz, keep, CharPredicate.WHITESPACE);
    }

    public static Range trimRange(@NotNull CharSequence thizz, int keep) {
        return SequenceUtils.trimRange(thizz, keep, CharPredicate.WHITESPACE);
    }

    public static Range trimStartRange(@NotNull CharSequence thizz) {
        return SequenceUtils.trimStartRange(thizz, 0, CharPredicate.WHITESPACE);
    }

    public static Range trimEndRange(@NotNull CharSequence thizz) {
        return SequenceUtils.trimEndRange(thizz, 0, CharPredicate.WHITESPACE);
    }

    public static Range trimRange(@NotNull CharSequence thizz) {
        return SequenceUtils.trimRange(thizz, 0, CharPredicate.WHITESPACE);
    }

    @NotNull
    public static Range trimStartRange(@NotNull CharSequence thizz, int keep, @NotNull CharPredicate chars) {
        int length = thizz.length();
        int trim = SequenceUtils.countLeading(thizz, chars, 0, length);
        return trim > keep ? Range.of(trim - keep, length) : Range.NULL;
    }

    @NotNull
    public static Range trimEndRange(@NotNull CharSequence thizz, int keep, @NotNull CharPredicate chars) {
        int length = thizz.length();
        int trim = SequenceUtils.countTrailing(thizz, chars, 0, length);
        return trim > keep ? Range.of(0, length - trim + keep) : Range.NULL;
    }

    @NotNull
    public static Range trimRange(@NotNull CharSequence thizz, int keep, @NotNull CharPredicate chars) {
        int length = thizz.length();
        if (keep >= length) {
            return Range.NULL;
        }
        int trimStart = SequenceUtils.countLeading(thizz, chars, 0, length);
        if (trimStart > keep) {
            int trimEnd = SequenceUtils.countTrailing(thizz, chars, trimStart - keep, length);
            return trimEnd > keep ? Range.of(trimStart - keep, length - trimEnd + keep) : Range.of(trimStart - keep, length);
        }
        int trimEnd = SequenceUtils.countTrailing(thizz, chars, trimStart, length);
        return trimEnd > keep ? Range.of(0, length - trimEnd + keep) : Range.NULL;
    }

    @NotNull
    public static String padStart(@NotNull CharSequence thizz, int length, char pad) {
        return length <= thizz.length() ? "" : RepeatedSequence.repeatOf(pad, length - thizz.length()).toString();
    }

    @NotNull
    public static String padEnd(@NotNull CharSequence thizz, int length, char pad) {
        return length <= thizz.length() ? "" : RepeatedSequence.repeatOf(pad, length - thizz.length()).toString();
    }

    @NotNull
    public static String padStart(@NotNull CharSequence thizz, int length) {
        return SequenceUtils.padStart(thizz, length, ' ');
    }

    @NotNull
    public static String padEnd(@NotNull CharSequence thizz, int length) {
        return SequenceUtils.padEnd(thizz, length, ' ');
    }

    @NotNull
    public static String toVisibleWhitespaceString(@NotNull CharSequence thizz) {
        StringBuilder sb = new StringBuilder();
        int iMax = thizz.length();
        for (int i = 0; i < iMax; ++i) {
            char c = thizz.charAt(i);
            String s = visibleSpacesMap.get(Character.valueOf(c));
            if (s != null) {
                sb.append(s);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static char lastChar(@NotNull CharSequence thizz) {
        return thizz.length() == 0 ? (char)'\u0000' : thizz.charAt(thizz.length() - 1);
    }

    public static char firstChar(@NotNull CharSequence thizz) {
        return thizz.length() == 0 ? (char)'\u0000' : thizz.charAt(0);
    }

    public static char safeCharAt(@NotNull CharSequence thizz, int index) {
        return index < 0 || index >= thizz.length() ? (char)'\u0000' : thizz.charAt(index);
    }

    public static int eolEndLength(@NotNull CharSequence thizz) {
        return SequenceUtils.eolEndLength(thizz, thizz.length());
    }

    public static int eolEndLength(@NotNull CharSequence thizz, int eolEnd) {
        int pos = Math.min(eolEnd - 1, thizz.length() - 1);
        if (pos < 0) {
            return 0;
        }
        int len = 0;
        char c = thizz.charAt(pos);
        if (c == '\r') {
            if (SequenceUtils.safeCharAt(thizz, pos + 1) != '\n') {
                len = 1;
            }
        } else if (c == '\n') {
            len = SequenceUtils.safeCharAt(thizz, pos - 1) == '\r' ? 2 : 1;
        }
        return len;
    }

    public static int eolStartLength(@NotNull CharSequence thizz, int eolStart) {
        int length = thizz.length();
        int pos = Math.min(eolStart, length);
        int len = 0;
        if (pos >= 0 && pos < length) {
            char c = thizz.charAt(pos);
            if (c == '\r') {
                len = SequenceUtils.safeCharAt(thizz, pos + 1) == '\n' ? 2 : 1;
            } else if (c == '\n' && SequenceUtils.safeCharAt(thizz, pos - 1) != '\r') {
                len = 1;
            }
        }
        return len;
    }

    public static int endOfLine(@NotNull CharSequence thizz, int index) {
        return SequenceUtils.endOfDelimitedBy(thizz, EOL, index);
    }

    public static int endOfLineAnyEOL(@NotNull CharSequence thizz, int index) {
        return SequenceUtils.endOfDelimitedByAny(thizz, CharPredicate.ANY_EOL, index);
    }

    public static int startOfLine(@NotNull CharSequence thizz, int index) {
        return SequenceUtils.startOfDelimitedBy(thizz, EOL, index);
    }

    public static int startOfLineAnyEOL(@NotNull CharSequence thizz, int index) {
        return SequenceUtils.startOfDelimitedByAny(thizz, CharPredicate.ANY_EOL, index);
    }

    public static int startOfDelimitedByAnyNot(@NotNull CharSequence thizz, @NotNull CharPredicate s, int index) {
        return SequenceUtils.startOfDelimitedByAny(thizz, s.negate(), index);
    }

    public static int endOfDelimitedByAnyNot(@NotNull CharSequence thizz, @NotNull CharPredicate s, int index) {
        return SequenceUtils.endOfDelimitedByAny(thizz, s.negate(), index);
    }

    public static int startOfDelimitedBy(@NotNull CharSequence thizz, @NotNull CharSequence s, int index) {
        int offset = SequenceUtils.lastIndexOf(thizz, s, (index = Utils.rangeLimit(index, 0, thizz.length())) - 1);
        return offset == -1 ? 0 : offset + 1;
    }

    public static int startOfDelimitedByAny(@NotNull CharSequence thizz, @NotNull CharPredicate s, int index) {
        int offset = SequenceUtils.lastIndexOfAny(thizz, s, (index = Utils.rangeLimit(index, 0, thizz.length())) - 1);
        return offset == -1 ? 0 : offset + 1;
    }

    public static int endOfDelimitedBy(@NotNull CharSequence thizz, @NotNull CharSequence s, int index) {
        int length = thizz.length();
        int offset = SequenceUtils.indexOf(thizz, s, index = Utils.rangeLimit(index, 0, length));
        return offset == -1 ? length : offset;
    }

    public static int endOfDelimitedByAny(@NotNull CharSequence thizz, @NotNull CharPredicate s, int index) {
        int length = thizz.length();
        int offset = SequenceUtils.indexOfAny(thizz, s, index = Utils.rangeLimit(index, 0, length));
        return offset == -1 ? length : offset;
    }

    @NotNull
    public static Range lineRangeAt(@NotNull CharSequence thizz, int index) {
        return Range.of(SequenceUtils.startOfLine(thizz, index), SequenceUtils.endOfLine(thizz, index));
    }

    @NotNull
    public static Range lineRangeAtAnyEOL(@NotNull CharSequence thizz, int index) {
        return Range.of(SequenceUtils.startOfLineAnyEOL(thizz, index), SequenceUtils.endOfLineAnyEOL(thizz, index));
    }

    @NotNull
    public static Range eolEndRange(@NotNull CharSequence thizz, int eolEnd) {
        int eolLength = SequenceUtils.eolEndLength(thizz, eolEnd);
        return eolLength == 0 ? Range.NULL : Range.of(eolEnd - eolLength, eolEnd);
    }

    @NotNull
    public static Range eolStartRange(@NotNull CharSequence thizz, int eolStart) {
        int eolLength = SequenceUtils.eolStartLength(thizz, eolStart);
        return eolLength == 0 ? Range.NULL : Range.of(eolStart, eolStart + eolLength);
    }

    @NotNull
    public static <T extends CharSequence> T trimEOL(@NotNull T thizz) {
        int eolLength = SequenceUtils.eolEndLength(thizz);
        return (T)(eolLength > 0 ? thizz.subSequence(0, thizz.length() - eolLength) : thizz);
    }

    @Nullable
    public static <T extends CharSequence> T trimmedEOL(@NotNull T thizz) {
        int eolLength = SequenceUtils.eolEndLength(thizz);
        return (T)(eolLength > 0 ? thizz.subSequence(thizz.length() - eolLength, thizz.length()) : null);
    }

    @Nullable
    public static <T extends CharSequence> T trimTailBlankLines(@NotNull T thizz) {
        Range range = SequenceUtils.trailingBlankLinesRange(thizz);
        return range.isNull() ? thizz : SequenceUtils.subSequenceBefore(thizz, range);
    }

    @Nullable
    public static <T extends CharSequence> T trimLeadBlankLines(@NotNull T thizz) {
        Range range = SequenceUtils.leadingBlankLinesRange(thizz);
        return range.isNull() ? thizz : SequenceUtils.subSequenceAfter(thizz, range);
    }

    @NotNull
    public static Range leadingBlankLinesRange(@NotNull CharSequence thizz) {
        return SequenceUtils.leadingBlankLinesRange(thizz, CharPredicate.EOL, 0, Integer.MAX_VALUE);
    }

    @NotNull
    public static Range leadingBlankLinesRange(@NotNull CharSequence thizz, int startIndex) {
        return SequenceUtils.leadingBlankLinesRange(thizz, CharPredicate.EOL, startIndex, Integer.MAX_VALUE);
    }

    @NotNull
    public static Range leadingBlankLinesRange(@NotNull CharSequence thizz, int fromIndex, int endIndex) {
        return SequenceUtils.leadingBlankLinesRange(thizz, CharPredicate.EOL, fromIndex, endIndex);
    }

    @NotNull
    public static Range trailingBlankLinesRange(@NotNull CharSequence thizz) {
        return SequenceUtils.trailingBlankLinesRange(thizz, CharPredicate.EOL, 0, Integer.MAX_VALUE);
    }

    @NotNull
    public static Range trailingBlankLinesRange(@NotNull CharSequence thizz, int fromIndex) {
        return SequenceUtils.trailingBlankLinesRange(thizz, CharPredicate.EOL, fromIndex, Integer.MAX_VALUE);
    }

    @NotNull
    public static Range trailingBlankLinesRange(@NotNull CharSequence thizz, int startIndex, int fromIndex) {
        return SequenceUtils.trailingBlankLinesRange(thizz, CharPredicate.EOL, startIndex, fromIndex);
    }

    @NotNull
    public static Range trailingBlankLinesRange(@NotNull CharSequence thizz, @NotNull CharPredicate eolChars, int startIndex, int fromIndex) {
        int iMax;
        fromIndex = Math.min(fromIndex, thizz.length());
        startIndex = Utils.rangeLimit(startIndex, 0, fromIndex);
        int lastEOL = iMax = fromIndex;
        int i = iMax;
        while (i-- > startIndex) {
            char c = thizz.charAt(i);
            if (eolChars.test(c)) {
                lastEOL = Math.min(i + Math.min(SequenceUtils.eolStartLength(thizz, i), 1), fromIndex);
                continue;
            }
            if (c == ' ' || c == '\t') continue;
            break;
        }
        if (i < startIndex) {
            return Range.of(startIndex, fromIndex);
        }
        if (lastEOL != iMax) {
            return Range.of(lastEOL, fromIndex);
        }
        return Range.NULL;
    }

    @NotNull
    public static Range leadingBlankLinesRange(@NotNull CharSequence thizz, @NotNull CharPredicate eolChars, int fromIndex, int endIndex) {
        int i;
        endIndex = Math.min(endIndex, thizz.length());
        fromIndex = Utils.rangeLimit(fromIndex, 0, endIndex);
        int iMax = endIndex;
        int lastEOL = -1;
        for (i = fromIndex; i < iMax; ++i) {
            char c = thizz.charAt(i);
            if (eolChars.test(c)) {
                lastEOL = i;
                continue;
            }
            if (c != ' ' && c != '\t') break;
        }
        if (i == iMax) {
            return Range.of(fromIndex, endIndex);
        }
        if (lastEOL >= 0) {
            return Range.of(fromIndex, Math.min(lastEOL + Math.min(SequenceUtils.eolStartLength(thizz, lastEOL), 1), endIndex));
        }
        return Range.NULL;
    }

    @NotNull
    public static List<Range> blankLinesRemovedRanges(@NotNull CharSequence thizz) {
        return SequenceUtils.blankLinesRemovedRanges(thizz, CharPredicate.EOL, 0, Integer.MAX_VALUE);
    }

    @NotNull
    public static List<Range> blankLinesRemovedRanges(@NotNull CharSequence thizz, int fromIndex) {
        return SequenceUtils.blankLinesRemovedRanges(thizz, CharPredicate.EOL, fromIndex, Integer.MAX_VALUE);
    }

    @NotNull
    public static List<Range> blankLinesRemovedRanges(@NotNull CharSequence thizz, int fromIndex, int endIndex) {
        return SequenceUtils.blankLinesRemovedRanges(thizz, CharPredicate.EOL, fromIndex, endIndex);
    }

    @NotNull
    public static List<Range> blankLinesRemovedRanges(@NotNull CharSequence thizz, @NotNull CharPredicate eolChars, int fromIndex, int endIndex) {
        endIndex = Math.min(endIndex, thizz.length());
        int lastPos = fromIndex = Utils.rangeLimit(fromIndex, 0, endIndex);
        ArrayList<Range> ranges = new ArrayList<Range>();
        while (lastPos < endIndex) {
            Range blankLines = SequenceUtils.leadingBlankLinesRange(thizz, eolChars, lastPos, endIndex);
            if (blankLines.isNull()) {
                int endOfLine = Math.min(SequenceUtils.endOfLine(thizz, lastPos) + 1, endIndex);
                if (lastPos < endOfLine) {
                    ranges.add(Range.of(lastPos, endOfLine));
                }
                lastPos = endOfLine;
                continue;
            }
            if (lastPos < blankLines.getStart()) {
                ranges.add(Range.of(lastPos, blankLines.getStart()));
            }
            lastPos = blankLines.getEnd();
        }
        return ranges;
    }

    public static boolean isEmpty(@NotNull CharSequence thizz) {
        return thizz.length() == 0;
    }

    public static boolean isBlank(@NotNull CharSequence thizz) {
        return SequenceUtils.isEmpty(thizz) || SequenceUtils.countLeading(thizz, CharPredicate.WHITESPACE, 0, Integer.MAX_VALUE) == thizz.length();
    }

    public static boolean isNotEmpty(@NotNull CharSequence thizz) {
        return thizz.length() != 0;
    }

    public static boolean isNotBlank(@NotNull CharSequence thizz) {
        return !SequenceUtils.isBlank(thizz);
    }

    public static boolean endsWith(@NotNull CharSequence thizz, @NotNull CharSequence suffix) {
        return thizz.length() > 0 && SequenceUtils.matchCharsReversed(thizz, suffix, thizz.length() - 1, false);
    }

    public static boolean endsWith(@NotNull CharSequence thizz, @NotNull CharSequence suffix, boolean ignoreCase) {
        return thizz.length() > 0 && SequenceUtils.matchCharsReversed(thizz, suffix, thizz.length() - 1, ignoreCase);
    }

    public static boolean startsWith(@NotNull CharSequence thizz, @NotNull CharSequence prefix) {
        return thizz.length() > 0 && SequenceUtils.matchChars(thizz, prefix, 0, false);
    }

    public static boolean startsWith(@NotNull CharSequence thizz, @NotNull CharSequence prefix, boolean ignoreCase) {
        return thizz.length() > 0 && SequenceUtils.matchChars(thizz, prefix, 0, ignoreCase);
    }

    public static boolean endsWith(@NotNull CharSequence thizz, @NotNull CharPredicate chars) {
        return SequenceUtils.countTrailing(thizz, chars) > 0;
    }

    public static boolean startsWith(@NotNull CharSequence thizz, @NotNull CharPredicate chars) {
        return SequenceUtils.countLeading(thizz, chars) > 0;
    }

    public static boolean endsWithEOL(@NotNull CharSequence thizz) {
        return SequenceUtils.endsWith(thizz, CharPredicate.EOL);
    }

    public static boolean endsWithAnyEOL(@NotNull CharSequence thizz) {
        return SequenceUtils.endsWith(thizz, CharPredicate.ANY_EOL);
    }

    public static boolean endsWithSpace(@NotNull CharSequence thizz) {
        return SequenceUtils.endsWith(thizz, CharPredicate.SPACE);
    }

    public static boolean endsWithSpaceTab(@NotNull CharSequence thizz) {
        return SequenceUtils.endsWith(thizz, CharPredicate.SPACE_TAB);
    }

    public static boolean endsWithWhitespace(@NotNull CharSequence thizz) {
        return SequenceUtils.endsWith(thizz, CharPredicate.WHITESPACE);
    }

    public static boolean startsWithEOL(@NotNull CharSequence thizz) {
        return SequenceUtils.startsWith(thizz, CharPredicate.EOL);
    }

    public static boolean startsWithAnyEOL(@NotNull CharSequence thizz) {
        return SequenceUtils.startsWith(thizz, CharPredicate.ANY_EOL);
    }

    public static boolean startsWithSpace(@NotNull CharSequence thizz) {
        return SequenceUtils.startsWith(thizz, CharPredicate.SPACE);
    }

    public static boolean startsWithSpaceTab(@NotNull CharSequence thizz) {
        return SequenceUtils.startsWith(thizz, CharPredicate.SPACE_TAB);
    }

    public static boolean startsWithWhitespace(@NotNull CharSequence thizz) {
        return SequenceUtils.startsWith(thizz, CharPredicate.WHITESPACE);
    }

    @NotNull
    public static <T extends CharSequence> List<T> splitList(@NotNull T thizz, @NotNull CharSequence delimiter) {
        return SequenceUtils.splitList(thizz, delimiter, 0, 0, null);
    }

    @NotNull
    public static <T extends CharSequence> List<T> splitList(@NotNull T thizz, @NotNull CharSequence delimiter, int limit, boolean includeDelims, @Nullable CharPredicate trimChars) {
        return SequenceUtils.splitList(thizz, delimiter, limit, includeDelims ? 1 : 0, trimChars);
    }

    @NotNull
    public static <T extends CharSequence> List<T> splitList(@NotNull T thizz, @NotNull CharSequence delimiter, int limit, int flags) {
        return SequenceUtils.splitList(thizz, delimiter, limit, flags, null);
    }

    @NotNull
    public static <T extends CharSequence> List<T> splitList(@NotNull T thizz, @NotNull CharSequence delimiter, boolean includeDelims, @Nullable CharPredicate trimChars) {
        return SequenceUtils.splitList(thizz, delimiter, 0, includeDelims ? 1 : 0, trimChars);
    }

    @NotNull
    public static <T extends CharSequence> List<T> splitListEOL(@NotNull T thizz) {
        return SequenceUtils.splitList(thizz, (CharSequence)EOL, 0, 1, null);
    }

    @NotNull
    public static <T extends CharSequence> List<T> splitListEOL(@NotNull T thizz, boolean includeDelims) {
        return SequenceUtils.splitList(thizz, (CharSequence)EOL, 0, includeDelims ? 1 : 0, null);
    }

    @NotNull
    public static <T extends CharSequence> List<T> splitListEOL(@NotNull T thizz, boolean includeDelims, @Nullable CharPredicate trimChars) {
        return SequenceUtils.splitList(thizz, (CharSequence)EOL, 0, includeDelims ? 1 : 0, trimChars);
    }

    @NotNull
    public static <T extends CharSequence> T[] splitEOL(@NotNull T thizz, T[] emptyArray) {
        return SequenceUtils.split(thizz, emptyArray, (CharSequence)EOL, (int)0, (int)1, null);
    }

    @NotNull
    public static <T extends CharSequence> T[] splitEOL(@NotNull T thizz, T[] emptyArray, boolean includeDelims) {
        return SequenceUtils.split(thizz, emptyArray, (CharSequence)EOL, (int)0, (int)(includeDelims ? 1 : 0), null);
    }

    @NotNull
    public static <T extends CharSequence> T[] split(@NotNull T thizz, T[] emptyArray, @NotNull CharSequence delimiter, boolean includeDelims, @Nullable CharPredicate trimChars) {
        return SequenceUtils.split(thizz, emptyArray, (CharSequence)EOL, (int)0, (int)(includeDelims ? 1 : 0), (CharPredicate)trimChars);
    }

    @NotNull
    public static <T extends CharSequence> T[] split(@NotNull T thizz, T[] emptyArray, @NotNull CharSequence delimiter) {
        return SequenceUtils.split(thizz, emptyArray, (CharSequence)delimiter, (int)0, (int)0, null);
    }

    @NotNull
    public static <T extends CharSequence> T[] split(@NotNull T thizz, T[] emptyArray, @NotNull CharSequence delimiter, int limit, boolean includeDelims, @Nullable CharPredicate trimChars) {
        return SequenceUtils.split(thizz, emptyArray, (CharSequence)delimiter, (int)limit, (int)(includeDelims ? 1 : 0), (CharPredicate)trimChars);
    }

    @NotNull
    public static <T extends CharSequence> T[] split(@NotNull T thizz, T[] emptyArray, @NotNull CharSequence delimiter, int limit, int flags) {
        return SequenceUtils.split(thizz, emptyArray, (CharSequence)delimiter, (int)limit, (int)flags, null);
    }

    @NotNull
    public static <T extends CharSequence> T[] split(@NotNull T thizz, T[] emptyArray, @NotNull CharSequence delimiter, int limit, int flags, @Nullable CharPredicate trimChars) {
        return (CharSequence[])SequenceUtils.splitList(thizz, delimiter, limit, flags, trimChars).toArray(emptyArray);
    }

    @NotNull
    public static <T extends CharSequence> List<T> splitList(@NotNull T thizz, @NotNull CharSequence delimiter, int limit, int flags, @Nullable CharPredicate trimChars) {
        if (trimChars == null) {
            trimChars = CharPredicate.WHITESPACE;
        } else {
            flags |= 2;
        }
        if (limit < 1) {
            limit = Integer.MAX_VALUE;
        }
        boolean includeDelimiterParts = (flags & 8) != 0;
        int includeDelimiter = !includeDelimiterParts && (flags & 1) != 0 ? delimiter.length() : 0;
        boolean trimParts = (flags & 2) != 0;
        boolean skipEmpty = (flags & 4) != 0;
        ArrayList<CharSequence> items = new ArrayList<CharSequence>();
        int lastPos = 0;
        int length = thizz.length();
        if (limit > 1) {
            int pos;
            while (lastPos < length && (pos = SequenceUtils.indexOf(thizz, delimiter, lastPos)) >= 0) {
                if (lastPos < pos || !skipEmpty) {
                    CharSequence item = thizz.subSequence(lastPos, pos + includeDelimiter);
                    if (trimParts) {
                        item = SequenceUtils.trim(item, trimChars);
                    }
                    if (!SequenceUtils.isEmpty(item) || !skipEmpty) {
                        items.add(item);
                        if (includeDelimiterParts) {
                            items.add(thizz.subSequence(pos, pos + delimiter.length()));
                        }
                        if (items.size() >= limit - 1) {
                            lastPos = pos + 1;
                            break;
                        }
                    }
                }
                lastPos = pos + 1;
            }
        }
        if (lastPos < length) {
            CharSequence item = thizz.subSequence(lastPos, length);
            if (trimParts) {
                item = SequenceUtils.trim(item, trimChars);
            }
            if (!SequenceUtils.isEmpty(item) || !skipEmpty) {
                items.add(item);
            }
        }
        return items;
    }

    public static int columnAtIndex(@NotNull CharSequence thizz, int index) {
        int lineStart = SequenceUtils.lastIndexOfAny(thizz, CharPredicate.ANY_EOL, index);
        return index - (lineStart == -1 ? 0 : lineStart + SequenceUtils.eolStartLength(thizz, lineStart));
    }

    @NotNull
    public static Pair<Integer, Integer> lineColumnAtIndex(@NotNull CharSequence thizz, int index) {
        int iMax = thizz.length();
        if (index < 0 || index > iMax) {
            throw new IllegalArgumentException("Index: " + index + " out of range [0, " + iMax + "]");
        }
        boolean hadCr = false;
        int line = 0;
        int col = 0;
        for (int i = 0; i < index; ++i) {
            char c1 = thizz.charAt(i);
            if (c1 == '\r') {
                col = 0;
                ++line;
                hadCr = true;
                continue;
            }
            if (c1 == '\n') {
                if (!hadCr) {
                    ++line;
                }
                col = 0;
                hadCr = false;
                continue;
            }
            ++col;
        }
        return new Pair<Integer, Integer>(line, col);
    }

    public static void validateIndex(int index, int length) {
        if (index < 0 || index >= length) {
            throw new StringIndexOutOfBoundsException("String index: " + index + " out of range: [0, " + length + ")");
        }
    }

    public static void validateIndexInclusiveEnd(int index, int length) {
        if (index < 0 || index > length) {
            throw new StringIndexOutOfBoundsException("index: " + index + " out of range: [0, " + length + "]");
        }
    }

    public static void validateStartEnd(int startIndex, int endIndex, int length) {
        if (startIndex < 0 || startIndex > length) {
            throw new StringIndexOutOfBoundsException("startIndex: " + startIndex + " out of range: [0, " + length + ")");
        }
        if (endIndex < startIndex || endIndex > length) {
            throw new StringIndexOutOfBoundsException("endIndex: " + endIndex + " out of range: [" + startIndex + ", " + length + "]");
        }
    }

    public static Integer parseUnsignedIntOrNull(String text) {
        return SequenceUtils.parseUnsignedIntOrNull(text, 10);
    }

    public static Integer parseUnsignedIntOrNull(String text, int radix) {
        try {
            int value = Integer.parseInt(text, radix);
            return value >= 0 ? Integer.valueOf(value) : null;
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    public static Integer parseIntOrNull(String text) {
        return SequenceUtils.parseIntOrNull(text, 10);
    }

    public static Integer parseIntOrNull(String text, int radix) {
        try {
            return Integer.parseInt(text, radix);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    public static Long parseLongOrNull(String text) {
        return SequenceUtils.parseLongOrNull(text, 10);
    }

    public static Long parseLongOrNull(String text, int radix) {
        try {
            return Long.parseLong(text, radix);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    public static int parseUnsignedIntOrDefault(String text, int defaultValue) {
        return SequenceUtils.parseUnsignedIntOrDefault(text, defaultValue, 10);
    }

    public static int parseUnsignedIntOrDefault(String text, int defaultValue, int radix) {
        try {
            int value = Integer.parseInt(text, radix);
            return value >= 0 ? value : defaultValue;
        }
        catch (NumberFormatException ignored) {
            return defaultValue;
        }
    }

    public static int parseIntOrDefault(String text, int defaultValue) {
        return SequenceUtils.parseIntOrDefault(text, defaultValue, 10);
    }

    public static int parseIntOrDefault(String text, int defaultValue, int radix) {
        try {
            return Integer.parseInt(text, radix);
        }
        catch (NumberFormatException ignored) {
            return defaultValue;
        }
    }

    @Nullable
    public static Number parseNumberOrNull(@Nullable String text) {
        Long octal;
        if (text == null) {
            return null;
        }
        if (text.startsWith("0x")) {
            return SequenceUtils.parseLongOrNull(text.substring(2), 16);
        }
        if (text.startsWith("0b")) {
            return SequenceUtils.parseLongOrNull(text.substring(2), 2);
        }
        if (text.startsWith("0") && (octal = SequenceUtils.parseLongOrNull(text.substring(1), 8)) != null) {
            return octal;
        }
        NumberFormat numberFormat = NumberFormat.getInstance();
        ParsePosition pos = new ParsePosition(0);
        Number number = numberFormat.parse(text, pos);
        return pos.getIndex() == text.length() ? number : null;
    }

    @Nullable
    public static Pair<Number, String> parseNumberPrefixOrNull(@Nullable String text, @Nullable Predicate<String> suffixTester) {
        int decimalDigits;
        int digits;
        if (text == null) {
            return null;
        }
        if (text.startsWith("0x")) {
            digits = SequenceUtils.countLeading(text.substring(2), CharPredicate.HEXADECIMAL_DIGITS);
            String suffix = text.substring(2 + digits);
            if (digits > 0 && (suffix.isEmpty() || suffixTester == null || suffixTester.test(suffix))) {
                return Pair.of(SequenceUtils.parseLongOrNull(text.substring(2, 2 + digits), 16), suffix);
            }
        } else if (text.startsWith("0b")) {
            digits = SequenceUtils.countLeading(text.substring(2), CharPredicate.BINARY_DIGITS);
            String suffix = text.substring(2 + digits);
            if (digits > 0 && (suffix.isEmpty() || suffixTester == null || suffixTester.test(suffix))) {
                return Pair.of(SequenceUtils.parseLongOrNull(text.substring(2, 2 + digits), 2), suffix);
            }
        } else if (text.startsWith("0") && (digits = SequenceUtils.countLeading(text.substring(1), CharPredicate.OCTAL_DIGITS)) == (decimalDigits = SequenceUtils.countLeading(text.substring(1), CharPredicate.DECIMAL_DIGITS))) {
            String suffix = text.substring(1 + digits);
            if (digits > 0 && (suffix.isEmpty() || suffixTester == null || suffixTester.test(suffix))) {
                return Pair.of(SequenceUtils.parseLongOrNull(text.substring(1, 1 + digits), 8), suffix);
            }
        }
        NumberFormat numberFormat = NumberFormat.getInstance();
        ParsePosition pos = new ParsePosition(0);
        Number number = numberFormat.parse(text, pos);
        String suffix = text.substring(pos.getIndex());
        if (pos.getIndex() > 0 && (suffix.isEmpty() || suffixTester == null || suffixTester.test(suffix))) {
            return Pair.of(number, suffix);
        }
        return null;
    }

    public static <T extends CharSequence> boolean containedBy(@NotNull T[] items, @NotNull CharSequence element) {
        for (T item : items) {
            if (!SequenceUtils.equals(element, item)) continue;
            return true;
        }
        return false;
    }

    public static boolean containedBy(@NotNull Collection<? extends CharSequence> items, @NotNull CharSequence element) {
        for (CharSequence charSequence : items) {
            if (!SequenceUtils.equals(element, charSequence)) continue;
            return true;
        }
        return false;
    }
}

