/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.util;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CSVUtil {
    private static final char QUOTE = '\"';
    private static final char COMMA = ',';
    private static final Pattern QUOTE_REPLACE_PATTERN = Pattern.compile("^\"([^\"]+)\"$");
    private static final String ESCAPED_QUOTE = "\"\"";

    private CSVUtil() {
    }

    public static String[] parse(String line) {
        boolean insideQuote = false;
        ArrayList<String> result2 = new ArrayList<String>();
        int quoteCount = 0;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == '\"') {
                insideQuote = !insideQuote;
                ++quoteCount;
            }
            if (c == ',' && !insideQuote) {
                String value = sb.toString();
                value = CSVUtil.unQuoteUnEscape(value);
                result2.add(value);
                sb.setLength(0);
                continue;
            }
            sb.append(c);
        }
        result2.add(sb.toString());
        if (quoteCount % 2 != 0) {
            return new String[0];
        }
        return result2.toArray(new String[0]);
    }

    private static String unQuoteUnEscape(String original) {
        String result2 = original;
        if (result2.indexOf(34) >= 0) {
            Matcher m = QUOTE_REPLACE_PATTERN.matcher(original);
            if (m.matches()) {
                result2 = m.group(1);
            }
            if (result2.contains(ESCAPED_QUOTE)) {
                result2 = result2.replace(ESCAPED_QUOTE, "\"");
            }
        }
        return result2;
    }

    public static String quoteEscape(String original) {
        Object result2 = original;
        if (((String)result2).indexOf(34) >= 0) {
            result2 = ((String)result2).replace("\"", ESCAPED_QUOTE);
        }
        if (((String)result2).indexOf(44) >= 0) {
            result2 = "\"" + (String)result2 + "\"";
        }
        return result2;
    }
}

