/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.PointsReader;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.codecs.TermVectorsReader;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafMetaData;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.MultiBits;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.ReaderSlice;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.Version;

final class SlowCompositeCodecReaderWrapper
extends CodecReader {
    private final LeafMetaData meta;
    private final CodecReader[] codecReaders;
    private final int[] docStarts;
    private final FieldInfos fieldInfos;
    private final Bits liveDocs;
    int numDocs = -1;

    static CodecReader wrap(List<CodecReader> readers) throws IOException {
        switch (readers.size()) {
            case 0: {
                throw new IllegalArgumentException("Must take at least one reader, got 0");
            }
            case 1: {
                return readers.get(0);
            }
        }
        return new SlowCompositeCodecReaderWrapper(readers);
    }

    private SlowCompositeCodecReaderWrapper(List<CodecReader> codecReaders) throws IOException {
        this.codecReaders = (CodecReader[])codecReaders.toArray(CodecReader[]::new);
        this.docStarts = new int[codecReaders.size() + 1];
        int i = 0;
        int docStart = 0;
        for (CodecReader reader : codecReaders) {
            this.docStarts[++i] = docStart += reader.maxDoc();
        }
        int majorVersion = -1;
        Version minVersion = null;
        boolean hasBlocks = false;
        for (CodecReader reader : codecReaders) {
            LeafMetaData readerMeta = reader.getMetaData();
            if (majorVersion == -1) {
                majorVersion = readerMeta.getCreatedVersionMajor();
            } else if (majorVersion != readerMeta.getCreatedVersionMajor()) {
                throw new IllegalArgumentException("Cannot combine leaf readers created with different major versions");
            }
            if (minVersion == null) {
                minVersion = readerMeta.getMinVersion();
            } else if (minVersion.onOrAfter(readerMeta.getMinVersion())) {
                minVersion = readerMeta.getMinVersion();
            }
            hasBlocks |= readerMeta.hasBlocks();
        }
        this.meta = new LeafMetaData(majorVersion, minVersion, null, hasBlocks);
        MultiReader multiReader = new MultiReader((IndexReader[])codecReaders.toArray(CodecReader[]::new));
        this.fieldInfos = FieldInfos.getMergedFieldInfos(multiReader);
        this.liveDocs = MultiBits.getLiveDocs(multiReader);
    }

    private int docIdToReaderId(int doc) {
        Objects.checkIndex(doc, this.docStarts[this.docStarts.length - 1]);
        int readerId = Arrays.binarySearch(this.docStarts, doc);
        if (readerId < 0) {
            readerId = -2 - readerId;
        }
        return readerId;
    }

    @Override
    public StoredFieldsReader getFieldsReader() {
        StoredFieldsReader[] readers = (StoredFieldsReader[])Arrays.stream(this.codecReaders).map(CodecReader::getFieldsReader).toArray(StoredFieldsReader[]::new);
        return new SlowCompositeStoredFieldsReaderWrapper(readers, this.docStarts);
    }

    private FieldInfo remap(FieldInfo info) {
        return this.fieldInfos.fieldInfo(info.name);
    }

    @Override
    public TermVectorsReader getTermVectorsReader() {
        TermVectorsReader[] readers = (TermVectorsReader[])Arrays.stream(this.codecReaders).map(CodecReader::getTermVectorsReader).toArray(TermVectorsReader[]::new);
        return new SlowCompositeTermVectorsReaderWrapper(readers, this.docStarts);
    }

    @Override
    public NormsProducer getNormsReader() {
        return new SlowCompositeNormsProducer(this.codecReaders);
    }

    @Override
    public DocValuesProducer getDocValuesReader() {
        return new SlowCompositeDocValuesProducerWrapper(this.codecReaders, this.docStarts);
    }

    @Override
    public FieldsProducer getPostingsReader() {
        FieldsProducer[] producers = (FieldsProducer[])Arrays.stream(this.codecReaders).map(CodecReader::getPostingsReader).toArray(FieldsProducer[]::new);
        return new SlowCompositeFieldsProducerWrapper(producers, this.docStarts);
    }

    @Override
    public PointsReader getPointsReader() {
        return new SlowCompositePointsReaderWrapper(this.codecReaders, this.docStarts);
    }

    @Override
    public KnnVectorsReader getVectorReader() {
        return new SlowCompositeKnnVectorsReaderWrapper(this.codecReaders, this.docStarts);
    }

    @Override
    public IndexReader.CacheHelper getCoreCacheHelper() {
        return null;
    }

    @Override
    public FieldInfos getFieldInfos() {
        return this.fieldInfos;
    }

    @Override
    public Bits getLiveDocs() {
        return this.liveDocs;
    }

    @Override
    public LeafMetaData getMetaData() {
        return this.meta;
    }

    @Override
    public synchronized int numDocs() {
        if (this.numDocs == -1) {
            this.numDocs = 0;
            for (CodecReader reader : this.codecReaders) {
                this.numDocs += reader.numDocs();
            }
        }
        return this.numDocs;
    }

    @Override
    public int maxDoc() {
        return this.docStarts[this.docStarts.length - 1];
    }

    @Override
    public IndexReader.CacheHelper getReaderCacheHelper() {
        return null;
    }

    private static class SlowCompositeKnnVectorsReaderWrapper
    extends KnnVectorsReader {
        private final CodecReader[] codecReaders;
        private final KnnVectorsReader[] readers;
        private final int[] docStarts;

        SlowCompositeKnnVectorsReaderWrapper(CodecReader[] codecReaders, int[] docStarts) {
            this.codecReaders = codecReaders;
            this.readers = (KnnVectorsReader[])Arrays.stream(codecReaders).map(CodecReader::getVectorReader).toArray(KnnVectorsReader[]::new);
            this.docStarts = docStarts;
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(this.readers);
        }

        @Override
        public long ramBytesUsed() {
            long ramBytesUsed = 0L;
            for (KnnVectorsReader reader : this.readers) {
                ramBytesUsed += reader.ramBytesUsed();
            }
            return ramBytesUsed;
        }

        @Override
        public void checkIntegrity() throws IOException {
            for (KnnVectorsReader reader : this.readers) {
                if (reader == null) continue;
                reader.checkIntegrity();
            }
        }

        @Override
        public FloatVectorValues getFloatVectorValues(String field) throws IOException {
            ArrayList subs = new ArrayList();
            int i = 0;
            int dimension = -1;
            int size = 0;
            for (CodecReader reader : this.codecReaders) {
                FloatVectorValues values = reader.getFloatVectorValues(field);
                if (values != null) {
                    if (dimension == -1) {
                        dimension = values.dimension();
                    }
                    size += values.size();
                }
                subs.add(new DocValuesSub<FloatVectorValues>(values, this.docStarts[i], this.docStarts[i + 1]));
                ++i;
            }
            final int finalDimension = dimension;
            final int finalSize = size;
            final MergedDocIdSetIterator mergedIterator = new MergedDocIdSetIterator(subs);
            return new FloatVectorValues(){

                @Override
                public int dimension() {
                    return finalDimension;
                }

                @Override
                public int size() {
                    return finalSize;
                }

                @Override
                public float[] vectorValue() throws IOException {
                    return ((FloatVectorValues)mergedIterator.current.sub).vectorValue();
                }

                @Override
                public int docID() {
                    return mergedIterator.docID();
                }

                @Override
                public int nextDoc() throws IOException {
                    return mergedIterator.nextDoc();
                }

                @Override
                public int advance(int target) throws IOException {
                    return mergedIterator.advance(target);
                }
            };
        }

        @Override
        public ByteVectorValues getByteVectorValues(String field) throws IOException {
            ArrayList subs = new ArrayList();
            int i = 0;
            int dimension = -1;
            int size = 0;
            for (CodecReader reader : this.codecReaders) {
                ByteVectorValues values = reader.getByteVectorValues(field);
                if (values != null) {
                    if (dimension == -1) {
                        dimension = values.dimension();
                    }
                    size += values.size();
                }
                subs.add(new DocValuesSub<ByteVectorValues>(values, this.docStarts[i], this.docStarts[i + 1]));
                ++i;
            }
            final int finalDimension = dimension;
            final int finalSize = size;
            final MergedDocIdSetIterator mergedIterator = new MergedDocIdSetIterator(subs);
            return new ByteVectorValues(){

                @Override
                public int dimension() {
                    return finalDimension;
                }

                @Override
                public int size() {
                    return finalSize;
                }

                @Override
                public byte[] vectorValue() throws IOException {
                    return ((ByteVectorValues)mergedIterator.current.sub).vectorValue();
                }

                @Override
                public int docID() {
                    return mergedIterator.docID();
                }

                @Override
                public int nextDoc() throws IOException {
                    return mergedIterator.nextDoc();
                }

                @Override
                public int advance(int target) throws IOException {
                    return mergedIterator.advance(target);
                }
            };
        }

        @Override
        public void search(String field, float[] target, KnnCollector knnCollector, Bits acceptDocs) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void search(String field, byte[] target, KnnCollector knnCollector, Bits acceptDocs) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    private static class SlowCompositePointsReaderWrapper
    extends PointsReader {
        private final CodecReader[] codecReaders;
        private final PointsReader[] readers;
        private final int[] docStarts;

        SlowCompositePointsReaderWrapper(CodecReader[] codecReaders, int[] docStarts) {
            this.codecReaders = codecReaders;
            this.readers = (PointsReader[])Arrays.stream(codecReaders).map(CodecReader::getPointsReader).toArray(PointsReader[]::new);
            this.docStarts = docStarts;
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(this.readers);
        }

        @Override
        public void checkIntegrity() throws IOException {
            for (PointsReader reader : this.readers) {
                if (reader == null) continue;
                reader.checkIntegrity();
            }
        }

        @Override
        public PointValues getValues(String field) throws IOException {
            final ArrayList<PointValuesSub> values = new ArrayList<PointValuesSub>();
            for (int i = 0; i < this.readers.length; ++i) {
                PointValues v;
                FieldInfo fi = this.codecReaders[i].getFieldInfos().fieldInfo(field);
                if (fi == null || fi.getPointDimensionCount() <= 0 || (v = this.readers[i].getValues(field)) == null) continue;
                values.add(new PointValuesSub(v, this.docStarts[i]));
            }
            if (values.isEmpty()) {
                return null;
            }
            return new PointValues(){

                @Override
                public PointValues.PointTree getPointTree() throws IOException {
                    return new PointValues.PointTree(){

                        @Override
                        public PointValues.PointTree clone() {
                            return this;
                        }

                        @Override
                        public void visitDocValues(PointValues.IntersectVisitor visitor) throws IOException {
                            for (PointValuesSub sub : values) {
                                sub.sub.getPointTree().visitDocValues(this.wrapIntersectVisitor(visitor, sub.docBase));
                            }
                        }

                        @Override
                        public void visitDocIDs(PointValues.IntersectVisitor visitor) throws IOException {
                            for (PointValuesSub sub : values) {
                                sub.sub.getPointTree().visitDocIDs(this.wrapIntersectVisitor(visitor, sub.docBase));
                            }
                        }

                        private PointValues.IntersectVisitor wrapIntersectVisitor(final PointValues.IntersectVisitor visitor, final int docStart) {
                            return new PointValues.IntersectVisitor(){

                                @Override
                                public void visit(int docID, byte[] packedValue) throws IOException {
                                    visitor.visit(docStart + docID, packedValue);
                                }

                                @Override
                                public void visit(int docID) throws IOException {
                                    visitor.visit(docStart + docID);
                                }

                                @Override
                                public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                                    return visitor.compare(minPackedValue, maxPackedValue);
                                }
                            };
                        }

                        @Override
                        public long size() {
                            long size = 0L;
                            for (PointValuesSub sub : values) {
                                size += sub.sub.size();
                            }
                            return size;
                        }

                        @Override
                        public boolean moveToSibling() throws IOException {
                            return false;
                        }

                        @Override
                        public boolean moveToParent() throws IOException {
                            return false;
                        }

                        @Override
                        public boolean moveToChild() throws IOException {
                            return false;
                        }

                        @Override
                        public byte[] getMinPackedValue() {
                            try {
                                byte[] minPackedValue = null;
                                for (PointValuesSub sub : values) {
                                    if (minPackedValue == null) {
                                        minPackedValue = (byte[])sub.sub.getMinPackedValue().clone();
                                        continue;
                                    }
                                    byte[] leafMinPackedValue = sub.sub.getMinPackedValue();
                                    int numIndexDimensions = sub.sub.getNumIndexDimensions();
                                    int numBytesPerDimension = sub.sub.getBytesPerDimension();
                                    ArrayUtil.ByteArrayComparator comparator = ArrayUtil.getUnsignedComparator(numBytesPerDimension);
                                    for (int i = 0; i < numIndexDimensions; ++i) {
                                        if (comparator.compare(leafMinPackedValue, i * numBytesPerDimension, minPackedValue, i * numBytesPerDimension) >= 0) continue;
                                        System.arraycopy(leafMinPackedValue, i * numBytesPerDimension, minPackedValue, i * numBytesPerDimension, numBytesPerDimension);
                                    }
                                }
                                return minPackedValue;
                            }
                            catch (IOException e) {
                                throw new UncheckedIOException(e);
                            }
                        }

                        @Override
                        public byte[] getMaxPackedValue() {
                            try {
                                byte[] maxPackedValue = null;
                                for (PointValuesSub sub : values) {
                                    if (maxPackedValue == null) {
                                        maxPackedValue = (byte[])sub.sub.getMaxPackedValue().clone();
                                        continue;
                                    }
                                    byte[] leafMinPackedValue = sub.sub.getMaxPackedValue();
                                    int numIndexDimensions = sub.sub.getNumIndexDimensions();
                                    int numBytesPerDimension = sub.sub.getBytesPerDimension();
                                    ArrayUtil.ByteArrayComparator comparator = ArrayUtil.getUnsignedComparator(numBytesPerDimension);
                                    for (int i = 0; i < numIndexDimensions; ++i) {
                                        if (comparator.compare(leafMinPackedValue, i * numBytesPerDimension, maxPackedValue, i * numBytesPerDimension) <= 0) continue;
                                        System.arraycopy(leafMinPackedValue, i * numBytesPerDimension, maxPackedValue, i * numBytesPerDimension, numBytesPerDimension);
                                    }
                                }
                                return maxPackedValue;
                            }
                            catch (IOException e) {
                                throw new UncheckedIOException(e);
                            }
                        }
                    };
                }

                @Override
                public byte[] getMinPackedValue() throws IOException {
                    return this.getPointTree().getMinPackedValue();
                }

                @Override
                public byte[] getMaxPackedValue() throws IOException {
                    return this.getPointTree().getMaxPackedValue();
                }

                @Override
                public int getNumDimensions() throws IOException {
                    return ((PointValuesSub)values.get((int)0)).sub.getNumDimensions();
                }

                @Override
                public int getNumIndexDimensions() throws IOException {
                    return ((PointValuesSub)values.get((int)0)).sub.getNumIndexDimensions();
                }

                @Override
                public int getBytesPerDimension() throws IOException {
                    return ((PointValuesSub)values.get((int)0)).sub.getBytesPerDimension();
                }

                @Override
                public long size() {
                    try {
                        return this.getPointTree().size();
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }

                @Override
                public int getDocCount() {
                    int docCount = 0;
                    for (PointValuesSub sub : values) {
                        docCount += sub.sub.getDocCount();
                    }
                    return docCount;
                }
            };
        }
    }

    private static class PointValuesSub {
        private final PointValues sub;
        private final int docBase;

        PointValuesSub(PointValues sub, int docBase) {
            this.sub = Objects.requireNonNull(sub);
            this.docBase = docBase;
        }
    }

    private static class SlowCompositeFieldsProducerWrapper
    extends FieldsProducer {
        private final FieldsProducer[] producers;
        private final MultiFields fields;

        SlowCompositeFieldsProducerWrapper(FieldsProducer[] producers, int[] docStarts) {
            this.producers = producers;
            ArrayList<FieldsProducer> subs = new ArrayList<FieldsProducer>();
            ArrayList<ReaderSlice> slices = new ArrayList<ReaderSlice>();
            int i = 0;
            for (FieldsProducer producer : producers) {
                if (producer != null) {
                    subs.add(producer);
                    slices.add(new ReaderSlice(docStarts[i], docStarts[i + 1], i));
                }
                ++i;
            }
            this.fields = new MultiFields((Fields[])subs.toArray(Fields[]::new), (ReaderSlice[])slices.toArray(ReaderSlice[]::new));
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(this.producers);
        }

        @Override
        public void checkIntegrity() throws IOException {
            for (FieldsProducer producer : this.producers) {
                if (producer == null) continue;
                producer.checkIntegrity();
            }
        }

        @Override
        public Iterator<String> iterator() {
            return this.fields.iterator();
        }

        @Override
        public Terms terms(String field) throws IOException {
            return this.fields.terms(field);
        }

        @Override
        public int size() {
            return this.fields.size();
        }
    }

    private static class SlowCompositeDocValuesProducerWrapper
    extends DocValuesProducer {
        private final CodecReader[] codecReaders;
        private final DocValuesProducer[] producers;
        private final int[] docStarts;
        private final Map<String, OrdinalMap> cachedOrdMaps = new HashMap<String, OrdinalMap>();

        SlowCompositeDocValuesProducerWrapper(CodecReader[] codecReaders, int[] docStarts) {
            this.codecReaders = codecReaders;
            this.producers = (DocValuesProducer[])Arrays.stream(codecReaders).map(CodecReader::getDocValuesReader).toArray(DocValuesProducer[]::new);
            this.docStarts = docStarts;
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(this.producers);
        }

        @Override
        public void checkIntegrity() throws IOException {
            for (DocValuesProducer producer : this.producers) {
                if (producer == null) continue;
                producer.checkIntegrity();
            }
        }

        @Override
        public NumericDocValues getNumeric(FieldInfo field) throws IOException {
            return MultiDocValues.getNumericValues(new MultiReader((IndexReader[])this.codecReaders), field.name);
        }

        @Override
        public BinaryDocValues getBinary(FieldInfo field) throws IOException {
            return MultiDocValues.getBinaryValues(new MultiReader((IndexReader[])this.codecReaders), field.name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedDocValues getSorted(FieldInfo field) throws IOException {
            OrdinalMap map2 = null;
            Map<String, OrdinalMap> map3 = this.cachedOrdMaps;
            synchronized (map3) {
                map2 = this.cachedOrdMaps.get(field.name);
                if (map2 == null) {
                    SortedDocValues dv = MultiDocValues.getSortedValues(new MultiReader((IndexReader[])this.codecReaders), field.name);
                    if (dv instanceof MultiDocValues.MultiSortedDocValues) {
                        map2 = ((MultiDocValues.MultiSortedDocValues)dv).mapping;
                        this.cachedOrdMaps.put(field.name, map2);
                    }
                    return dv;
                }
            }
            int size = this.codecReaders.length;
            SortedDocValues[] values = new SortedDocValues[size];
            long totalCost = 0L;
            for (int i = 0; i < size; ++i) {
                CodecReader reader = this.codecReaders[i];
                SortedDocValues v = ((LeafReader)reader).getSortedDocValues(field.name);
                if (v == null) {
                    v = DocValues.emptySorted();
                }
                values[i] = v;
                totalCost += v.cost();
            }
            return new MultiDocValues.MultiSortedDocValues(values, this.docStarts, map2, totalCost);
        }

        @Override
        public SortedNumericDocValues getSortedNumeric(FieldInfo field) throws IOException {
            return MultiDocValues.getSortedNumericValues(new MultiReader((IndexReader[])this.codecReaders), field.name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedSetDocValues getSortedSet(FieldInfo field) throws IOException {
            OrdinalMap map2 = null;
            Map<String, OrdinalMap> map3 = this.cachedOrdMaps;
            synchronized (map3) {
                map2 = this.cachedOrdMaps.get(field.name);
                if (map2 == null) {
                    SortedSetDocValues dv = MultiDocValues.getSortedSetValues(new MultiReader((IndexReader[])this.codecReaders), field.name);
                    if (dv instanceof MultiDocValues.MultiSortedSetDocValues) {
                        map2 = ((MultiDocValues.MultiSortedSetDocValues)dv).mapping;
                        this.cachedOrdMaps.put(field.name, map2);
                    }
                    return dv;
                }
            }
            assert (map2 != null);
            int size = this.codecReaders.length;
            SortedSetDocValues[] values = new SortedSetDocValues[size];
            long totalCost = 0L;
            for (int i = 0; i < size; ++i) {
                CodecReader reader = this.codecReaders[i];
                SortedSetDocValues v = ((LeafReader)reader).getSortedSetDocValues(field.name);
                if (v == null) {
                    v = DocValues.emptySortedSet();
                }
                values[i] = v;
                totalCost += v.cost();
            }
            return new MultiDocValues.MultiSortedSetDocValues(values, this.docStarts, map2, totalCost);
        }
    }

    private static class MergedDocIdSetIterator<T extends DocIdSetIterator>
    extends DocIdSetIterator {
        final Iterator<DocValuesSub<T>> it;
        final long cost;
        DocValuesSub<T> current;
        int currentIndex = 0;
        int doc = -1;

        MergedDocIdSetIterator(List<DocValuesSub<T>> subs) {
            long cost = 0L;
            for (DocValuesSub<T> sub : subs) {
                if (sub.sub == null) continue;
                cost += ((DocIdSetIterator)sub.sub).cost();
            }
            this.cost = cost;
            this.it = subs.iterator();
            this.current = this.it.next();
        }

        private boolean advanceSub(int target) {
            while (this.current.sub == null || this.current.docEnd <= target) {
                if (!this.it.hasNext()) {
                    this.doc = Integer.MAX_VALUE;
                    return false;
                }
                this.current = this.it.next();
                ++this.currentIndex;
            }
            return true;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int nextDoc() throws IOException {
            while (true) {
                int next;
                if (this.current.sub != null && (next = ((DocIdSetIterator)this.current.sub).nextDoc()) != Integer.MAX_VALUE) {
                    this.doc = this.current.docStart + next;
                    return this.doc;
                }
                if (!this.it.hasNext()) {
                    this.doc = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                this.current = this.it.next();
                ++this.currentIndex;
            }
        }

        @Override
        public int advance(int target) throws IOException {
            int next;
            while (true) {
                if (!this.advanceSub(target)) {
                    return Integer.MAX_VALUE;
                }
                next = ((DocIdSetIterator)this.current.sub).advance(target - this.current.docStart);
                if (next != Integer.MAX_VALUE) break;
                target = this.current.docEnd;
            }
            this.doc = this.current.docStart + next;
            return this.doc;
        }

        @Override
        public long cost() {
            return this.cost;
        }
    }

    private static class DocValuesSub<T extends DocIdSetIterator> {
        private final T sub;
        private final int docStart;
        private final int docEnd;

        DocValuesSub(T sub, int docStart, int docEnd) {
            this.sub = sub;
            this.docStart = docStart;
            this.docEnd = docEnd;
        }
    }

    private static class SlowCompositeNormsProducer
    extends NormsProducer {
        private final CodecReader[] codecReaders;
        private final NormsProducer[] producers;

        SlowCompositeNormsProducer(CodecReader[] codecReaders) {
            this.codecReaders = codecReaders;
            this.producers = (NormsProducer[])Arrays.stream(codecReaders).map(CodecReader::getNormsReader).toArray(NormsProducer[]::new);
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(this.producers);
        }

        @Override
        public NumericDocValues getNorms(FieldInfo field) throws IOException {
            return MultiDocValues.getNormValues(new MultiReader((IndexReader[])this.codecReaders), field.name);
        }

        @Override
        public void checkIntegrity() throws IOException {
            for (NormsProducer producer : this.producers) {
                if (producer == null) continue;
                producer.checkIntegrity();
            }
        }
    }

    private class SlowCompositeTermVectorsReaderWrapper
    extends TermVectorsReader {
        private final TermVectorsReader[] readers;
        private final int[] docStarts;

        SlowCompositeTermVectorsReaderWrapper(TermVectorsReader[] readers, int[] docStarts) {
            this.readers = readers;
            this.docStarts = docStarts;
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(this.readers);
        }

        @Override
        public TermVectorsReader clone() {
            return new SlowCompositeTermVectorsReaderWrapper((TermVectorsReader[])Arrays.stream(this.readers).map(TermVectorsReader::clone).toArray(TermVectorsReader[]::new), this.docStarts);
        }

        @Override
        public void checkIntegrity() throws IOException {
            for (TermVectorsReader reader : this.readers) {
                if (reader == null) continue;
                reader.checkIntegrity();
            }
        }

        @Override
        public Fields get(int doc) throws IOException {
            int readerId = SlowCompositeCodecReaderWrapper.this.docIdToReaderId(doc);
            TermVectorsReader reader = this.readers[readerId];
            if (reader == null) {
                return null;
            }
            return reader.get(doc - this.docStarts[readerId]);
        }
    }

    private class SlowCompositeStoredFieldsReaderWrapper
    extends StoredFieldsReader {
        private final StoredFieldsReader[] readers;
        private final int[] docStarts;

        SlowCompositeStoredFieldsReaderWrapper(StoredFieldsReader[] readers, int[] docStarts) {
            this.readers = readers;
            this.docStarts = docStarts;
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(this.readers);
        }

        @Override
        public StoredFieldsReader clone() {
            return new SlowCompositeStoredFieldsReaderWrapper((StoredFieldsReader[])Arrays.stream(this.readers).map(StoredFieldsReader::clone).toArray(StoredFieldsReader[]::new), this.docStarts);
        }

        @Override
        public void checkIntegrity() throws IOException {
            for (StoredFieldsReader reader : this.readers) {
                if (reader == null) continue;
                reader.checkIntegrity();
            }
        }

        @Override
        public void document(int docID, final StoredFieldVisitor visitor) throws IOException {
            int readerId = SlowCompositeCodecReaderWrapper.this.docIdToReaderId(docID);
            this.readers[readerId].document(docID - this.docStarts[readerId], new StoredFieldVisitor(){

                @Override
                public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
                    return visitor.needsField(SlowCompositeCodecReaderWrapper.this.remap(fieldInfo));
                }

                @Override
                public void binaryField(FieldInfo fieldInfo, byte[] value) throws IOException {
                    visitor.binaryField(SlowCompositeCodecReaderWrapper.this.remap(fieldInfo), value);
                }

                @Override
                public void stringField(FieldInfo fieldInfo, String value) throws IOException {
                    visitor.stringField(SlowCompositeCodecReaderWrapper.this.remap(fieldInfo), value);
                }

                @Override
                public void intField(FieldInfo fieldInfo, int value) throws IOException {
                    visitor.intField(SlowCompositeCodecReaderWrapper.this.remap(fieldInfo), value);
                }

                @Override
                public void longField(FieldInfo fieldInfo, long value) throws IOException {
                    visitor.longField(SlowCompositeCodecReaderWrapper.this.remap(fieldInfo), value);
                }

                @Override
                public void floatField(FieldInfo fieldInfo, float value) throws IOException {
                    visitor.floatField(SlowCompositeCodecReaderWrapper.this.remap(fieldInfo), value);
                }

                @Override
                public void doubleField(FieldInfo fieldInfo, double value) throws IOException {
                    visitor.doubleField(SlowCompositeCodecReaderWrapper.this.remap(fieldInfo), value);
                }
            });
        }
    }
}

