/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Objects;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldExistsQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Pruning;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ArrayUtil;

public class IndexSortSortedNumericDocValuesRangeQuery
extends Query {
    private final String field;
    private final long lowerValue;
    private final long upperValue;
    private final Query fallbackQuery;

    public IndexSortSortedNumericDocValuesRangeQuery(String field, long lowerValue, long upperValue, Query fallbackQuery) {
        this.field = Objects.requireNonNull(field);
        this.lowerValue = lowerValue;
        this.upperValue = upperValue;
        this.fallbackQuery = fallbackQuery;
    }

    public Query getFallbackQuery() {
        return this.fallbackQuery;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexSortSortedNumericDocValuesRangeQuery that = (IndexSortSortedNumericDocValuesRangeQuery)o;
        return this.lowerValue == that.lowerValue && this.upperValue == that.upperValue && Objects.equals(this.field, that.field) && Objects.equals(this.fallbackQuery, that.fallbackQuery);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.field, this.lowerValue, this.upperValue, this.fallbackQuery);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf(this);
            this.fallbackQuery.visit(visitor);
        }
    }

    @Override
    public String toString(String field) {
        StringBuilder b = new StringBuilder();
        if (!this.field.equals(field)) {
            b.append(this.field).append(":");
        }
        return b.append("[").append(this.lowerValue).append(" TO ").append(this.upperValue).append("]").toString();
    }

    @Override
    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        if (this.lowerValue == Long.MIN_VALUE && this.upperValue == Long.MAX_VALUE) {
            return new FieldExistsQuery(this.field);
        }
        Query rewrittenFallback = this.fallbackQuery.rewrite(indexSearcher);
        if (rewrittenFallback.getClass() == MatchAllDocsQuery.class) {
            return new MatchAllDocsQuery();
        }
        if (rewrittenFallback == this.fallbackQuery) {
            return this;
        }
        return new IndexSortSortedNumericDocValuesRangeQuery(this.field, this.lowerValue, this.upperValue, rewrittenFallback);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        final Weight fallbackWeight = this.fallbackQuery.createWeight(searcher, scoreMode, boost);
        return new ConstantScoreWeight(this, boost){

            @Override
            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                final 1 weight = this;
                IteratorAndCount itAndCount = IndexSortSortedNumericDocValuesRangeQuery.this.getDocIdSetIteratorOrNull(context);
                if (itAndCount != null) {
                    final DocIdSetIterator disi = itAndCount.it;
                    return new ScorerSupplier(){

                        @Override
                        public Scorer get(long leadCost) throws IOException {
                            return new ConstantScoreScorer(weight, this.score(), scoreMode, disi);
                        }

                        @Override
                        public long cost() {
                            return disi.cost();
                        }
                    };
                }
                return fallbackWeight.scorerSupplier(context);
            }

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                ScorerSupplier scorerSupplier = this.scorerSupplier(context);
                if (scorerSupplier == null) {
                    return null;
                }
                return scorerSupplier.get(Long.MAX_VALUE);
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return fallbackWeight.isCacheable(ctx);
            }

            @Override
            public int count(LeafReaderContext context) throws IOException {
                IteratorAndCount itAndCount;
                if (!context.reader().hasDeletions() && (itAndCount = IndexSortSortedNumericDocValuesRangeQuery.this.getDocIdSetIteratorOrNull(context)) != null && itAndCount.count != -1) {
                    return itAndCount.count;
                }
                return fallbackWeight.count(context);
            }
        };
    }

    private static ValueAndDoc findNextValue(PointValues.PointTree pointTree, final byte[] value, final boolean allowEqual, final ArrayUtil.ByteArrayComparator comparator, final boolean lastDoc) throws IOException {
        int cmp = comparator.compare(pointTree.getMaxPackedValue(), 0, value, 0);
        if (cmp < 0 || cmp == 0 && !allowEqual) {
            return null;
        }
        if (!pointTree.moveToChild()) {
            final ValueAndDoc vd = new ValueAndDoc();
            pointTree.visitDocValues(new PointValues.IntersectVisitor(){

                @Override
                public void visit(int docID, byte[] packedValue) throws IOException {
                    if (vd.value == null) {
                        int cmp = comparator.compare(packedValue, 0, value, 0);
                        if (cmp > 0 || cmp == 0 && allowEqual) {
                            vd.value = (byte[])packedValue.clone();
                            vd.docID = docID;
                        }
                    } else if (lastDoc && !vd.done) {
                        int cmp = comparator.compare(packedValue, 0, vd.value, 0);
                        assert (cmp >= 0);
                        if (cmp > 0) {
                            vd.done = true;
                        } else {
                            vd.docID = docID;
                        }
                    }
                }

                @Override
                public void visit(int docID) throws IOException {
                    throw new UnsupportedOperationException();
                }

                @Override
                public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                    return PointValues.Relation.CELL_CROSSES_QUERY;
                }
            });
            if (vd.value != null) {
                return vd;
            }
            return null;
        }
        do {
            ValueAndDoc vd;
            if ((vd = IndexSortSortedNumericDocValuesRangeQuery.findNextValue(pointTree, value, allowEqual, comparator, lastDoc)) == null) continue;
            return vd;
        } while (pointTree.moveToSibling());
        boolean moved = pointTree.moveToParent();
        assert (moved);
        return null;
    }

    private static int nextDoc(PointValues.PointTree pointTree, byte[] value, boolean allowEqual, ArrayUtil.ByteArrayComparator comparator, boolean lastDoc) throws IOException {
        ValueAndDoc vd = IndexSortSortedNumericDocValuesRangeQuery.findNextValue(pointTree, value, allowEqual, comparator, lastDoc);
        if (vd == null) {
            return -1;
        }
        if (!lastDoc || vd.done) {
            return vd.docID;
        }
        int doc = IndexSortSortedNumericDocValuesRangeQuery.lastDoc(pointTree, vd.value, comparator);
        if (doc == -1) {
            return vd.docID;
        }
        return doc;
    }

    private static int lastDoc(PointValues.PointTree pointTree, final byte[] value, final ArrayUtil.ByteArrayComparator comparator) throws IOException {
        ArrayDeque<PointValues.PointTree> stack = new ArrayDeque<PointValues.PointTree>();
        while (true) {
            if (!pointTree.moveToSibling()) {
                if (pointTree.moveToParent()) continue;
                break;
            }
            int cmp = comparator.compare(pointTree.getMinPackedValue(), 0, value, 0);
            if (cmp > 0) break;
            stack.push(pointTree.clone());
        }
        block1: while (!stack.isEmpty()) {
            int cmp;
            PointValues.PointTree next = (PointValues.PointTree)stack.pop();
            if (!next.moveToChild()) {
                final int[] lastDoc = new int[]{-1};
                next.visitDocValues(new PointValues.IntersectVisitor(){

                    @Override
                    public void visit(int docID) throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public void visit(int docID, byte[] packedValue) throws IOException {
                        int cmp = comparator.compare(value, 0, packedValue, 0);
                        if (cmp == 0) {
                            lastDoc[0] = docID;
                        }
                    }

                    @Override
                    public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                        return PointValues.Relation.CELL_CROSSES_QUERY;
                    }
                });
                if (lastDoc[0] == -1) continue;
                return lastDoc[0];
            }
            while ((cmp = comparator.compare(next.getMinPackedValue(), 0, value, 0)) <= 0) {
                stack.push(next.clone());
                if (next.moveToSibling()) continue;
                continue block1;
            }
        }
        return -1;
    }

    private boolean matchNone(PointValues points, byte[] queryLowerPoint, byte[] queryUpperPoint) throws IOException {
        assert (points.getNumDimensions() == 1);
        ArrayUtil.ByteArrayComparator comparator = ArrayUtil.getUnsignedComparator(points.getBytesPerDimension());
        return comparator.compare(points.getMinPackedValue(), 0, queryUpperPoint, 0) > 0 || comparator.compare(points.getMaxPackedValue(), 0, queryLowerPoint, 0) < 0;
    }

    private boolean matchAll(PointValues points, byte[] queryLowerPoint, byte[] queryUpperPoint) throws IOException {
        assert (points.getNumDimensions() == 1);
        ArrayUtil.ByteArrayComparator comparator = ArrayUtil.getUnsignedComparator(points.getBytesPerDimension());
        return comparator.compare(points.getMinPackedValue(), 0, queryLowerPoint, 0) >= 0 && comparator.compare(points.getMaxPackedValue(), 0, queryUpperPoint, 0) <= 0;
    }

    private IteratorAndCount getDocIdSetIteratorOrNullFromBkd(LeafReaderContext context, DocIdSetIterator delegate) throws IOException {
        int maxDocId;
        int minDocId;
        byte[] queryUpperPoint;
        byte[] queryLowerPoint;
        Sort indexSort = context.reader().getMetaData().getSort();
        if (indexSort == null || indexSort.getSort().length == 0 || !indexSort.getSort()[0].getField().equals(this.field)) {
            return null;
        }
        boolean reverse = indexSort.getSort()[0].getReverse();
        PointValues points = context.reader().getPointValues(this.field);
        if (points == null) {
            return null;
        }
        if (points.getNumDimensions() != 1) {
            return null;
        }
        if (points.getBytesPerDimension() != 8 && points.getBytesPerDimension() != 4) {
            return null;
        }
        if (points.size() != (long)points.getDocCount()) {
            return null;
        }
        assert (this.lowerValue <= this.upperValue);
        if (points.getBytesPerDimension() == 4) {
            queryLowerPoint = IntPoint.pack((int[])new int[]{(int)this.lowerValue}).bytes;
            queryUpperPoint = IntPoint.pack((int[])new int[]{(int)this.upperValue}).bytes;
        } else {
            queryLowerPoint = LongPoint.pack((long[])new long[]{this.lowerValue}).bytes;
            queryUpperPoint = LongPoint.pack((long[])new long[]{this.upperValue}).bytes;
        }
        if (this.matchNone(points, queryLowerPoint, queryUpperPoint)) {
            return IteratorAndCount.empty();
        }
        if (this.matchAll(points, queryLowerPoint, queryUpperPoint)) {
            int maxDoc = context.reader().maxDoc();
            if (points.getDocCount() == maxDoc) {
                return IteratorAndCount.all(maxDoc);
            }
            return IteratorAndCount.sparseRange(0, maxDoc, delegate);
        }
        ArrayUtil.ByteArrayComparator comparator = ArrayUtil.getUnsignedComparator(points.getBytesPerDimension());
        if (reverse) {
            minDocId = IndexSortSortedNumericDocValuesRangeQuery.nextDoc(points.getPointTree(), queryUpperPoint, false, comparator, true) + 1;
        } else {
            minDocId = IndexSortSortedNumericDocValuesRangeQuery.nextDoc(points.getPointTree(), queryLowerPoint, true, comparator, false);
            if (minDocId == -1) {
                return IteratorAndCount.empty();
            }
        }
        if (reverse) {
            maxDocId = IndexSortSortedNumericDocValuesRangeQuery.nextDoc(points.getPointTree(), queryLowerPoint, true, comparator, true) + 1;
            if (maxDocId == 0) {
                return IteratorAndCount.empty();
            }
        } else {
            maxDocId = IndexSortSortedNumericDocValuesRangeQuery.nextDoc(points.getPointTree(), queryUpperPoint, false, comparator, false);
            if (maxDocId == -1) {
                maxDocId = context.reader().maxDoc();
            }
        }
        if (minDocId == maxDocId) {
            return IteratorAndCount.empty();
        }
        if (points.getDocCount() == context.reader().maxDoc()) {
            return IteratorAndCount.denseRange(minDocId, maxDocId);
        }
        return IteratorAndCount.sparseRange(minDocId, maxDocId, delegate);
    }

    private IteratorAndCount getDocIdSetIteratorOrNull(LeafReaderContext context) throws IOException {
        if (this.lowerValue > this.upperValue) {
            return IteratorAndCount.empty();
        }
        SortedNumericDocValues sortedNumericValues = DocValues.getSortedNumeric(context.reader(), this.field);
        NumericDocValues numericValues = DocValues.unwrapSingleton(sortedNumericValues);
        if (numericValues != null) {
            SortField sortField;
            SortField.Type sortFieldType;
            IteratorAndCount itAndCount = this.getDocIdSetIteratorOrNullFromBkd(context, numericValues);
            if (itAndCount != null) {
                return itAndCount;
            }
            Sort indexSort = context.reader().getMetaData().getSort();
            if (indexSort != null && indexSort.getSort().length > 0 && indexSort.getSort()[0].getField().equals(this.field) && ((sortFieldType = IndexSortSortedNumericDocValuesRangeQuery.getSortFieldType(sortField = indexSort.getSort()[0])) == SortField.Type.INT || sortFieldType == SortField.Type.LONG)) {
                return this.getDocIdSetIterator(sortField, sortFieldType, context, numericValues);
            }
        }
        return null;
    }

    private IteratorAndCount getDocIdSetIterator(SortField sortField, SortField.Type sortFieldType, LeafReaderContext context, DocIdSetIterator delegate) throws IOException {
        long missingLongValue;
        long lower = sortField.getReverse() ? this.upperValue : this.lowerValue;
        long upper = sortField.getReverse() ? this.lowerValue : this.upperValue;
        int maxDoc = context.reader().maxDoc();
        ValueComparator comparator = IndexSortSortedNumericDocValuesRangeQuery.loadComparator(sortField, sortFieldType, lower, context);
        int low = 0;
        int high = maxDoc - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            if (comparator.compare(mid) <= 0) {
                high = mid - 1;
                comparator = IndexSortSortedNumericDocValuesRangeQuery.loadComparator(sortField, sortFieldType, lower, context);
                continue;
            }
            low = mid + 1;
        }
        int firstDocIdInclusive = high + 1;
        comparator = IndexSortSortedNumericDocValuesRangeQuery.loadComparator(sortField, sortFieldType, upper, context);
        low = firstDocIdInclusive;
        high = maxDoc - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            if (comparator.compare(mid) < 0) {
                high = mid - 1;
                comparator = IndexSortSortedNumericDocValuesRangeQuery.loadComparator(sortField, sortFieldType, upper, context);
                continue;
            }
            low = mid + 1;
        }
        int lastDocIdExclusive = high + 1;
        if (firstDocIdInclusive == lastDocIdExclusive) {
            return IteratorAndCount.empty();
        }
        Object missingValue = sortField.getMissingValue();
        LeafReader reader = context.reader();
        PointValues pointValues = reader.getPointValues(this.field);
        long l = missingLongValue = missingValue == null ? 0L : (Long)missingValue;
        if (pointValues != null && pointValues.getDocCount() == reader.maxDoc() || missingLongValue < this.lowerValue || missingLongValue > this.upperValue) {
            return IteratorAndCount.denseRange(firstDocIdInclusive, lastDocIdExclusive);
        }
        return IteratorAndCount.sparseRange(firstDocIdInclusive, lastDocIdExclusive, delegate);
    }

    private static ValueComparator loadComparator(SortField sortField, SortField.Type type, long topValue, LeafReaderContext context) throws IOException {
        FieldComparator<?> fieldComparator = sortField.getComparator(1, Pruning.NONE);
        if (type == SortField.Type.INT) {
            fieldComparator.setTopValue((int)topValue);
        } else {
            fieldComparator.setTopValue(topValue);
        }
        LeafFieldComparator leafFieldComparator = fieldComparator.getLeafComparator(context);
        int direction = sortField.getReverse() ? -1 : 1;
        return doc -> {
            int value = leafFieldComparator.compareTop(doc);
            return direction * value;
        };
    }

    private static SortField.Type getSortFieldType(SortField sortField) {
        if (sortField instanceof SortedNumericSortField) {
            return ((SortedNumericSortField)sortField).getNumericType();
        }
        return sortField.getType();
    }

    private static class BoundedDocIdSetIterator
    extends DocIdSetIterator {
        private final int firstDoc;
        private final int lastDoc;
        private final DocIdSetIterator delegate;
        private int docID = -1;

        BoundedDocIdSetIterator(int firstDoc, int lastDoc, DocIdSetIterator delegate) {
            assert (delegate != null);
            this.firstDoc = firstDoc;
            this.lastDoc = lastDoc;
            this.delegate = delegate;
        }

        @Override
        public int docID() {
            return this.docID;
        }

        @Override
        public int nextDoc() throws IOException {
            return this.advance(this.docID + 1);
        }

        @Override
        public int advance(int target) throws IOException {
            int result2;
            if (target < this.firstDoc) {
                target = this.firstDoc;
            }
            this.docID = (result2 = this.delegate.advance(target)) < this.lastDoc ? result2 : Integer.MAX_VALUE;
            return this.docID;
        }

        @Override
        public long cost() {
            return Math.min(this.delegate.cost(), (long)(this.lastDoc - this.firstDoc));
        }
    }

    private static class IteratorAndCount {
        private final DocIdSetIterator it;
        private final int count;

        IteratorAndCount(DocIdSetIterator it, int count) {
            this.it = it;
            this.count = count;
        }

        static IteratorAndCount empty() {
            return new IteratorAndCount(DocIdSetIterator.empty(), 0);
        }

        static IteratorAndCount all(int maxDoc) {
            return new IteratorAndCount(DocIdSetIterator.all(maxDoc), maxDoc);
        }

        static IteratorAndCount denseRange(int minDoc, int maxDoc) {
            return new IteratorAndCount(DocIdSetIterator.range(minDoc, maxDoc), maxDoc - minDoc);
        }

        static IteratorAndCount sparseRange(int minDoc, int maxDoc, DocIdSetIterator delegate) {
            return new IteratorAndCount(new BoundedDocIdSetIterator(minDoc, maxDoc, delegate), -1);
        }
    }

    private static interface ValueComparator {
        public int compare(int var1) throws IOException;
    }

    private static class ValueAndDoc {
        byte[] value;
        int docID;
        boolean done;

        private ValueAndDoc() {
        }
    }
}

