/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Comparator;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.SortableBytesRefArray;
import org.apache.lucene.util.StringSorter;

final class FixedLengthBytesRefArray
implements SortableBytesRefArray {
    private final int valueLength;
    private final int valuesPerBlock;
    private int size;
    private int currentBlock = -1;
    private int nextEntry;
    private byte[][] blocks;

    public FixedLengthBytesRefArray(int valueLength) {
        this.valueLength = valueLength;
        this.nextEntry = this.valuesPerBlock = Math.max(1, 32768 / valueLength);
        this.blocks = new byte[0][];
    }

    @Override
    public void clear() {
        this.size = 0;
        this.blocks = new byte[0][];
        this.currentBlock = -1;
        this.nextEntry = this.valuesPerBlock;
    }

    @Override
    public int append(BytesRef bytes) {
        if (bytes.length != this.valueLength) {
            throw new IllegalArgumentException("value length is " + bytes.length + " but is supposed to always be " + this.valueLength);
        }
        if (this.nextEntry == this.valuesPerBlock) {
            ++this.currentBlock;
            if (this.currentBlock == this.blocks.length) {
                int size = ArrayUtil.oversize(this.currentBlock + 1, RamUsageEstimator.NUM_BYTES_OBJECT_REF);
                byte[][] next = new byte[size][];
                System.arraycopy(this.blocks, 0, next, 0, this.blocks.length);
                this.blocks = next;
            }
            this.blocks[this.currentBlock] = new byte[this.valuesPerBlock * this.valueLength];
            this.nextEntry = 0;
        }
        System.arraycopy(bytes.bytes, bytes.offset, this.blocks[this.currentBlock], this.nextEntry * this.valueLength, this.valueLength);
        ++this.nextEntry;
        return this.size++;
    }

    @Override
    public int size() {
        return this.size;
    }

    private int[] sort(Comparator<BytesRef> comp) {
        final int[] orderedEntries = new int[this.size()];
        for (int i = 0; i < orderedEntries.length; ++i) {
            orderedEntries[i] = i;
        }
        new StringSorter(comp){
            {
                super(cmp);
                this.scratchBytes1.length = FixedLengthBytesRefArray.this.valueLength;
                this.scratchBytes2.length = FixedLengthBytesRefArray.this.valueLength;
                this.pivot.length = FixedLengthBytesRefArray.this.valueLength;
            }

            @Override
            protected void get(BytesRefBuilder builder, BytesRef result2, int i) {
                int index = orderedEntries[i];
                result2.bytes = FixedLengthBytesRefArray.this.blocks[index / FixedLengthBytesRefArray.this.valuesPerBlock];
                result2.offset = index % FixedLengthBytesRefArray.this.valuesPerBlock * FixedLengthBytesRefArray.this.valueLength;
            }

            @Override
            protected void swap(int i, int j) {
                int o = orderedEntries[i];
                orderedEntries[i] = orderedEntries[j];
                orderedEntries[j] = o;
            }
        }.sort(0, this.size());
        return orderedEntries;
    }

    @Override
    public BytesRefIterator iterator(Comparator<BytesRef> comp) {
        final BytesRef result2 = new BytesRef();
        result2.length = this.valueLength;
        final int size = this.size();
        final int[] indices = this.sort(comp);
        return new BytesRefIterator(){
            int pos = 0;

            @Override
            public BytesRef next() {
                if (this.pos < size) {
                    int index = indices[this.pos];
                    ++this.pos;
                    result2.bytes = FixedLengthBytesRefArray.this.blocks[index / FixedLengthBytesRefArray.this.valuesPerBlock];
                    result2.offset = index % FixedLengthBytesRefArray.this.valuesPerBlock * FixedLengthBytesRefArray.this.valueLength;
                    return result2;
                }
                return null;
            }
        };
    }
}

