/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.errors.PackProtocolException;
import org.eclipse.jgit.errors.RemoteRepositoryException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectDatabase;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevCommitList;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.CommitTimeRevFilter;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.transport.BasePackConnection;
import org.eclipse.jgit.transport.FetchConnection;
import org.eclipse.jgit.transport.FilterSpec;
import org.eclipse.jgit.transport.GitProtocolConstants;
import org.eclipse.jgit.transport.PackLock;
import org.eclipse.jgit.transport.PackParser;
import org.eclipse.jgit.transport.PackTransport;
import org.eclipse.jgit.transport.PacketLineIn;
import org.eclipse.jgit.transport.PacketLineOut;
import org.eclipse.jgit.transport.SideBandInputStream;
import org.eclipse.jgit.transport.TagOpt;
import org.eclipse.jgit.transport.TransferConfig;
import org.eclipse.jgit.transport.UserAgent;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.TemporaryBuffer;

public abstract class BasePackFetchConnection
extends BasePackConnection
implements FetchConnection {
    private static final int MAX_HAVES = 256;
    protected static final int MIN_CLIENT_BUFFER = 2952;
    public static final String OPTION_INCLUDE_TAG = "include-tag";
    public static final String OPTION_MULTI_ACK = "multi_ack";
    public static final String OPTION_MULTI_ACK_DETAILED = "multi_ack_detailed";
    public static final String OPTION_THIN_PACK = "thin-pack";
    public static final String OPTION_SIDE_BAND = "side-band";
    public static final String OPTION_SIDE_BAND_64K = "side-band-64k";
    public static final String OPTION_OFS_DELTA = "ofs-delta";
    public static final String OPTION_SHALLOW = "shallow";
    public static final String OPTION_NO_PROGRESS = "no-progress";
    public static final String OPTION_NO_DONE = "no-done";
    public static final String OPTION_ALLOW_TIP_SHA1_IN_WANT = "allow-tip-sha1-in-want";
    public static final String OPTION_ALLOW_REACHABLE_SHA1_IN_WANT = "allow-reachable-sha1-in-want";
    public static final String OPTION_FILTER = "filter";
    private final RevWalk walk;
    private RevCommitList<RevCommit> reachableCommits;
    final RevFlag REACHABLE;
    final RevFlag COMMON;
    private final RevFlag STATE;
    final RevFlag ADVERTISED;
    private GitProtocolConstants.MultiAck multiAck = GitProtocolConstants.MultiAck.OFF;
    private boolean thinPack;
    private boolean sideband;
    private boolean includeTags;
    private boolean allowOfsDelta;
    private boolean noDone;
    private boolean noProgress;
    private String lockMessage;
    private PackLock packLock;
    private int maxHaves;
    private Integer depth;
    private Instant deepenSince;
    private List<String> deepenNots;
    private TemporaryBuffer.Heap state;
    private PacketLineOut pckState;
    private final FilterSpec filterSpec;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$jgit$transport$PacketLineIn$AckNackResult;

    public BasePackFetchConnection(PackTransport packTransport) {
        super(packTransport);
        if (this.local != null) {
            FetchConfig cfg = this.getFetchConfig();
            this.allowOfsDelta = cfg.allowOfsDelta;
            this.maxHaves = cfg.maxHaves;
        } else {
            this.allowOfsDelta = true;
            this.maxHaves = Integer.MAX_VALUE;
        }
        this.includeTags = this.transport.getTagOpt() != TagOpt.NO_TAGS;
        this.thinPack = this.transport.isFetchThin();
        this.filterSpec = this.transport.getFilterSpec();
        this.depth = this.transport.getDepth();
        this.deepenSince = this.transport.getDeepenSince();
        this.deepenNots = this.transport.getDeepenNots();
        if (this.local != null) {
            this.walk = new RevWalk(this.local);
            this.walk.setRetainBody(false);
            this.reachableCommits = new RevCommitList();
            this.REACHABLE = this.walk.newFlag("REACHABLE");
            this.COMMON = this.walk.newFlag("COMMON");
            this.STATE = this.walk.newFlag("STATE");
            this.ADVERTISED = this.walk.newFlag("ADVERTISED");
            this.walk.carry(this.COMMON);
            this.walk.carry(this.REACHABLE);
            this.walk.carry(this.ADVERTISED);
        } else {
            this.walk = null;
            this.REACHABLE = null;
            this.COMMON = null;
            this.STATE = null;
            this.ADVERTISED = null;
        }
    }

    @Override
    public final void fetch(ProgressMonitor monitor2, Collection<Ref> want, Set<ObjectId> have) throws TransportException {
        this.fetch(monitor2, want, have, null);
    }

    @Override
    public final void fetch(ProgressMonitor monitor2, Collection<Ref> want, Set<ObjectId> have, OutputStream outputStream) throws TransportException {
        this.markStartedOperation();
        this.doFetch(monitor2, want, have, outputStream);
    }

    @Override
    public boolean didFetchIncludeTags() {
        return false;
    }

    @Override
    public boolean didFetchTestConnectivity() {
        return false;
    }

    @Override
    public void setPackLockMessage(String message) {
        this.lockMessage = message;
    }

    @Override
    public Collection<PackLock> getPackLocks() {
        if (this.packLock != null) {
            return Collections.singleton(this.packLock);
        }
        return Collections.emptyList();
    }

    private void clearState() {
        this.walk.dispose();
        this.reachableCommits = null;
        this.state = null;
        this.pckState = null;
    }

    protected void doFetch(ProgressMonitor monitor2, Collection<Ref> want, Set<ObjectId> have, OutputStream outputStream) throws TransportException {
        try {
            PacketLineOut output;
            this.noProgress = monitor2 == NullProgressMonitor.INSTANCE;
            this.markRefsAdvertised();
            this.markReachable(have, this.maxTimeWanted(want));
            if (TransferConfig.ProtocolVersion.V2.equals((Object)this.getProtocolVersion())) {
                this.state = new TemporaryBuffer.Heap(Integer.MAX_VALUE);
                this.pckState = new PacketLineOut(this.state);
                try {
                    this.doFetchV2(monitor2, want, outputStream);
                }
                finally {
                    this.clearState();
                }
                return;
            }
            if (this.statelessRPC) {
                this.state = new TemporaryBuffer.Heap(Integer.MAX_VALUE);
                this.pckState = new PacketLineOut(this.state);
            }
            PacketLineOut packetLineOut = output = this.statelessRPC ? this.pckState : this.pckOut;
            if (this.sendWants(want, output)) {
                boolean mayHaveShallow = this.depth != null || this.deepenSince != null || !this.deepenNots.isEmpty();
                Set<ObjectId> shallowCommits = this.local.getObjectDatabase().getShallowCommits();
                if (this.isCapableOf(OPTION_SHALLOW)) {
                    this.sendShallow(shallowCommits, output);
                } else if (mayHaveShallow) {
                    throw new PackProtocolException(JGitText.get().shallowNotSupported);
                }
                output.end();
                this.outNeedsEnd = false;
                this.negotiate(monitor2, mayHaveShallow, shallowCommits);
                this.clearState();
                this.receivePack(monitor2, outputStream);
            }
        }
        catch (CancelledException ce) {
            this.close();
            return;
        }
        catch (IOException | RuntimeException err) {
            this.close();
            throw new TransportException(err.getMessage(), err);
        }
    }

    private void doFetchV2(ProgressMonitor monitor2, Collection<Ref> want, OutputStream outputStream) throws IOException, CancelledException {
        this.sideband = true;
        this.negotiateBegin();
        this.pckState.writeString("command=fetch");
        String agent = UserAgent.get();
        if (agent != null && this.isCapableOf("agent")) {
            this.pckState.writeString("agent=" + agent);
        }
        HashSet<String> capabilities = new HashSet<String>();
        String advertised = this.getCapability("fetch");
        if (!StringUtils.isEmptyOrNull(advertised)) {
            capabilities.addAll(Arrays.asList(advertised.split("\\s+")));
        }
        this.pckState.writeDelim();
        for (String capability : this.getCapabilitiesV2(capabilities)) {
            this.pckState.writeString(capability);
        }
        if (!this.sendWants(want, this.pckState)) {
            return;
        }
        Set<ObjectId> shallowCommits = this.local.getObjectDatabase().getShallowCommits();
        if (capabilities.contains(OPTION_SHALLOW)) {
            this.sendShallow(shallowCommits, this.pckState);
        } else if (this.depth != null || this.deepenSince != null || !this.deepenNots.isEmpty()) {
            throw new PackProtocolException(JGitText.get().shallowNotSupported);
        }
        this.outNeedsEnd = false;
        FetchStateV2 fetchState = new FetchStateV2();
        boolean sentDone = false;
        do {
            this.state.writeTo(this.out, monitor2);
        } while (!(sentDone = this.sendNextHaveBatch(fetchState, this.pckOut, monitor2)) && !this.readAcknowledgments(fetchState, this.pckIn, monitor2));
        this.clearState();
        String line = this.pckIn.readString();
        if (sentDone && line.startsWith("ERR ")) {
            throw new RemoteRepositoryException(this.uri, line.substring(4));
        }
        if ("shallow-info".equals(line)) {
            line = this.handleShallowUnshallow(shallowCommits, this.pckIn);
            if (!PacketLineIn.isDelimiter(line)) {
                throw new PackProtocolException(MessageFormat.format(JGitText.get().expectedGot, "0001", line));
            }
            line = this.pckIn.readString();
        }
        if (!"packfile".equals(line)) {
            throw new PackProtocolException(MessageFormat.format(JGitText.get().expectedGot, "packfile", line));
        }
        this.receivePack(monitor2, outputStream);
    }

    private boolean sendNextHaveBatch(FetchStateV2 fetchState, PacketLineOut output, ProgressMonitor monitor2) throws IOException, CancelledException {
        long n = 0L;
        while (n < fetchState.havesToSend) {
            RevCommit c = this.walk.next();
            if (c == null) break;
            output.writeString("have " + c.getId().name() + '\n');
            if (++n % 10L != 0L || !monitor2.isCancelled()) continue;
            throw new CancelledException();
        }
        fetchState.havesTotal += n;
        if (n == 0L || fetchState.hadAcks && fetchState.havesWithoutAck > 256L || fetchState.havesTotal > (long)this.maxHaves) {
            output.writeString("done\n");
            output.end();
            return true;
        }
        fetchState.havesWithoutAck += n;
        output.end();
        fetchState.incHavesToSend(this.statelessRPC);
        return false;
    }

    private boolean readAcknowledgments(FetchStateV2 fetchState, PacketLineIn input, ProgressMonitor monitor2) throws IOException, CancelledException {
        String line = input.readString();
        if (!"acknowledgments".equals(line)) {
            throw new PackProtocolException(MessageFormat.format(JGitText.get().expectedGot, "acknowledgments", line));
        }
        MutableObjectId returnedId = new MutableObjectId();
        line = input.readString();
        boolean gotReady = false;
        long n = 0L;
        while (!PacketLineIn.isEnd(line) && !PacketLineIn.isDelimiter(line)) {
            PacketLineIn.AckNackResult ack = PacketLineIn.parseACKv2(line, returnedId);
            if (!gotReady) {
                if (ack == PacketLineIn.AckNackResult.ACK_COMMON) {
                    this.markCommon(this.walk.parseAny(returnedId), ack, true);
                    fetchState.havesWithoutAck = 0L;
                    fetchState.hadAcks = true;
                } else if (ack == PacketLineIn.AckNackResult.ACK_READY) {
                    gotReady = true;
                }
            }
            if (++n % 10L == 0L && monitor2.isCancelled()) {
                throw new CancelledException();
            }
            line = input.readString();
        }
        if (gotReady) {
            if (!PacketLineIn.isDelimiter(line)) {
                throw new PackProtocolException(MessageFormat.format(JGitText.get().expectedGot, "0001", line));
            }
        } else if (!PacketLineIn.isEnd(line)) {
            throw new PackProtocolException(MessageFormat.format(JGitText.get().expectedGot, "0000", line));
        }
        return gotReady;
    }

    @Override
    public void close() {
        if (this.walk != null) {
            this.walk.close();
        }
        super.close();
    }

    FetchConfig getFetchConfig() {
        return this.local.getConfig().get(FetchConfig::new);
    }

    private int maxTimeWanted(Collection<Ref> wants) {
        int maxTime = 0;
        for (Ref r : wants) {
            try {
                int cTime;
                RevObject obj = this.walk.parseAny(r.getObjectId());
                if (!(obj instanceof RevCommit) || maxTime >= (cTime = ((RevCommit)obj).getCommitTime())) continue;
                maxTime = cTime;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return maxTime;
    }

    private void markReachable(Set<ObjectId> have, int maxTime) throws IOException {
        for (Ref r : this.local.getRefDatabase().getRefs()) {
            ObjectId id = r.getPeeledObjectId();
            if (id == null) {
                id = r.getObjectId();
            }
            if (id == null) continue;
            this.parseReachable(id);
        }
        for (ObjectId id : this.local.getAdditionalHaves()) {
            this.parseReachable(id);
        }
        for (ObjectId id : have) {
            this.parseReachable(id);
        }
        if (maxTime > 0) {
            RevCommit c;
            Date maxWhen = new Date((long)maxTime * 1000L);
            this.walk.sort(RevSort.COMMIT_TIME_DESC);
            this.walk.markStart(this.reachableCommits);
            this.walk.setRevFilter(CommitTimeRevFilter.after(maxWhen));
            while ((c = this.walk.next()) != null) {
                if (!c.has(this.ADVERTISED) || c.has(this.COMMON)) continue;
                c.add(this.COMMON);
                c.carry(this.COMMON);
                this.reachableCommits.add(c);
            }
        }
    }

    private void parseReachable(ObjectId id) {
        try {
            RevCommit o = this.walk.parseCommit(id);
            if (!o.has(this.REACHABLE)) {
                o.add(this.REACHABLE);
                this.reachableCommits.add(o);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean sendWants(Collection<Ref> want, PacketLineOut p) throws IOException {
        boolean first = true;
        for (Ref r : want) {
            ObjectId objectId = r.getObjectId();
            if (objectId == null) continue;
            if (this.transport.getDepth() == null) {
                try {
                    if (this.walk.parseAny(objectId).has(this.REACHABLE)) {
                        continue;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            StringBuilder line = new StringBuilder(46);
            line.append("want ").append(objectId.name());
            if (first && TransferConfig.ProtocolVersion.V0.equals((Object)this.getProtocolVersion())) {
                line.append(this.enableCapabilities());
            }
            first = false;
            line.append('\n');
            p.writeString(line.toString());
        }
        if (first) {
            return false;
        }
        if (!this.filterSpec.isNoOp()) {
            p.writeString(this.filterSpec.filterLine());
        }
        return true;
    }

    private Set<String> getCapabilitiesV2(Set<String> advertisedCapabilities) throws TransportException {
        LinkedHashSet<String> capabilities = new LinkedHashSet<String>();
        if (this.noProgress) {
            capabilities.add(OPTION_NO_PROGRESS);
        }
        if (this.includeTags) {
            capabilities.add(OPTION_INCLUDE_TAG);
        }
        if (this.allowOfsDelta) {
            capabilities.add(OPTION_OFS_DELTA);
        }
        if (this.thinPack) {
            capabilities.add(OPTION_THIN_PACK);
        }
        if (!this.filterSpec.isNoOp() && !advertisedCapabilities.contains(OPTION_FILTER)) {
            throw new PackProtocolException(this.uri, JGitText.get().filterRequiresCapability);
        }
        return capabilities;
    }

    private String enableCapabilities() throws TransportException {
        StringBuilder line = new StringBuilder();
        if (this.noProgress) {
            this.wantCapability(line, OPTION_NO_PROGRESS);
        }
        if (this.includeTags) {
            this.includeTags = this.wantCapability(line, OPTION_INCLUDE_TAG);
        }
        if (this.allowOfsDelta) {
            this.wantCapability(line, OPTION_OFS_DELTA);
        }
        if (this.wantCapability(line, OPTION_MULTI_ACK_DETAILED)) {
            this.multiAck = GitProtocolConstants.MultiAck.DETAILED;
            if (this.statelessRPC) {
                this.noDone = this.wantCapability(line, OPTION_NO_DONE);
            }
        } else {
            this.multiAck = this.wantCapability(line, OPTION_MULTI_ACK) ? GitProtocolConstants.MultiAck.CONTINUE : GitProtocolConstants.MultiAck.OFF;
        }
        if (this.thinPack) {
            this.thinPack = this.wantCapability(line, OPTION_THIN_PACK);
        }
        if (this.wantCapability(line, OPTION_SIDE_BAND_64K)) {
            this.sideband = true;
        } else if (this.wantCapability(line, OPTION_SIDE_BAND)) {
            this.sideband = true;
        }
        if (this.statelessRPC && this.multiAck != GitProtocolConstants.MultiAck.DETAILED) {
            throw new PackProtocolException(this.uri, MessageFormat.format(JGitText.get().statelessRPCRequiresOptionToBeEnabled, OPTION_MULTI_ACK_DETAILED));
        }
        if (!this.filterSpec.isNoOp() && !this.wantCapability(line, OPTION_FILTER)) {
            throw new PackProtocolException(this.uri, JGitText.get().filterRequiresCapability);
        }
        this.addUserAgentCapability(line);
        return line.toString();
    }

    /*
     * Unable to fully structure code
     */
    private void negotiate(ProgressMonitor monitor, boolean mayHaveShallow, Set<ObjectId> shallowCommits) throws IOException, CancelledException {
        ackId = new MutableObjectId();
        resultsPending = 0;
        havesSent = 0;
        havesSinceLastContinue = 0;
        receivedContinue = false;
        receivedAck = false;
        receivedReady = false;
        if (this.statelessRPC) {
            this.state.writeTo(this.out, null);
        }
        this.negotiateBegin();
        block10: while ((c = this.walk.next()) != null) {
            o = c.getId();
            this.pckOut.writeString("have " + o.name() + '\n');
            ++havesSinceLastContinue;
            if ((31 & ++havesSent) != 0) continue;
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            this.pckOut.end();
            ++resultsPending;
            if (havesSent == 32 && !this.statelessRPC) continue;
            block11: while (true) {
                anr = this.pckIn.readACK(ackId);
                switch (BasePackFetchConnection.$SWITCH_TABLE$org$eclipse$jgit$transport$PacketLineIn$AckNackResult()[anr.ordinal()]) {
                    case 1: {
                        --resultsPending;
                        break block11;
                    }
                    case 2: {
                        this.multiAck = GitProtocolConstants.MultiAck.OFF;
                        resultsPending = 0;
                        receivedAck = true;
                        if (!this.statelessRPC) break block10;
                        this.state.writeTo(this.out, null);
                        break block10;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        this.markCommon(this.walk.parseAny(ackId), anr, this.statelessRPC);
                        receivedAck = true;
                        receivedContinue = true;
                        havesSinceLastContinue = 0;
                        if (anr == PacketLineIn.AckNackResult.ACK_READY) {
                            receivedReady = true;
                        }
                    }
                    default: {
                        if (!monitor.isCancelled()) continue block11;
                        throw new CancelledException();
                    }
                }
                break;
            }
            if (this.noDone && receivedReady) break;
            if (this.statelessRPC) {
                this.state.writeTo(this.out, null);
            }
            if ((!receivedContinue || havesSinceLastContinue <= 256) && havesSent < this.maxHaves) continue;
        }
        if (monitor.isCancelled()) {
            throw new CancelledException();
        }
        if (!receivedReady || !this.noDone) {
            this.pckOut.writeString("done\n");
            this.pckOut.flush();
        }
        if (!receivedAck) {
            this.multiAck = GitProtocolConstants.MultiAck.OFF;
            ++resultsPending;
        }
        if (!mayHaveShallow || PacketLineIn.isEnd(line = this.handleShallowUnshallow(shallowCommits, this.pckIn))) ** GOTO lbl70
        throw new PackProtocolException(MessageFormat.format(JGitText.get().expectedGot, new Object[]{"0000", line}));
lbl-1000:
        // 1 sources

        {
            anr = this.pckIn.readACK(ackId);
            --resultsPending;
            switch (BasePackFetchConnection.$SWITCH_TABLE$org$eclipse$jgit$transport$PacketLineIn$AckNackResult()[anr.ordinal()]) {
                case 1: {
                    ** GOTO lbl67
                }
                case 2: {
                    break block12;
                }
                case 3: 
                case 4: 
                case 5: {
                    this.multiAck = GitProtocolConstants.MultiAck.CONTINUE;
                }
lbl67:
                // 3 sources

                default: {
                    if (!monitor.isCancelled()) continue block12;
                    throw new CancelledException();
                }
            }
lbl70:
            // 2 sources

            ** while (resultsPending > 0 || this.multiAck != GitProtocolConstants.MultiAck.OFF)
        }
lbl71:
        // 2 sources

    }

    private void negotiateBegin() throws IOException {
        this.walk.resetRetain(this.REACHABLE, this.ADVERTISED);
        this.walk.markStart(this.reachableCommits);
        this.walk.sort(RevSort.COMMIT_TIME_DESC);
        this.walk.setRevFilter(new RevFilter(){

            @Override
            public RevFilter clone() {
                return this;
            }

            @Override
            public boolean include(RevWalk walker, RevCommit c) {
                boolean remoteKnowsIsCommon = c.has(BasePackFetchConnection.this.COMMON);
                if (c.has(BasePackFetchConnection.this.ADVERTISED)) {
                    c.add(BasePackFetchConnection.this.COMMON);
                }
                return !remoteKnowsIsCommon;
            }

            @Override
            public boolean requiresCommitBody() {
                return false;
            }
        });
    }

    private void markRefsAdvertised() {
        for (Ref r : this.getRefs()) {
            this.markAdvertised(r.getObjectId());
            if (r.getPeeledObjectId() == null) continue;
            this.markAdvertised(r.getPeeledObjectId());
        }
    }

    private void markAdvertised(AnyObjectId id) {
        try {
            this.walk.parseAny(id).add(this.ADVERTISED);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void markCommon(RevObject obj, PacketLineIn.AckNackResult anr, boolean useState) throws IOException {
        if (useState && anr == PacketLineIn.AckNackResult.ACK_COMMON && !obj.has(this.STATE)) {
            this.pckState.writeString("have " + obj.name() + '\n');
            obj.add(this.STATE);
        }
        obj.add(this.COMMON);
        if (obj instanceof RevCommit) {
            ((RevCommit)obj).carry(this.COMMON);
        }
    }

    private void receivePack(ProgressMonitor monitor2, OutputStream outputStream) throws IOException {
        this.onReceivePack();
        InputStream input = this.in;
        SideBandInputStream sidebandIn = null;
        if (this.sideband) {
            sidebandIn = new SideBandInputStream(input, monitor2, this.getMessageWriter(), outputStream);
            input = sidebandIn;
        }
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (ObjectInserter ins = this.local.newObjectInserter();){
                PackParser parser = ins.newPackParser(input);
                parser.setAllowThin(this.thinPack);
                parser.setObjectChecker(this.transport.getObjectChecker());
                parser.setLockMessage(this.lockMessage);
                this.packLock = parser.parse(monitor2);
                ins.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            if (sidebandIn != null) {
                sidebandIn.drainMessages();
            }
        }
    }

    private void sendShallow(Set<ObjectId> shallowCommits, PacketLineOut output) throws IOException {
        for (ObjectId shallowCommit : shallowCommits) {
            output.writeString("shallow " + shallowCommit.name());
        }
        if (this.depth != null) {
            output.writeString("deepen " + this.depth);
        }
        if (this.deepenSince != null) {
            output.writeString("deepen-since " + this.deepenSince.getEpochSecond());
        }
        if (this.deepenNots != null) {
            for (String deepenNotRef : this.deepenNots) {
                output.writeString("deepen-not " + deepenNotRef);
            }
        }
    }

    private String handleShallowUnshallow(Set<ObjectId> advertisedShallowCommits, PacketLineIn input) throws IOException {
        String line = input.readString();
        ObjectDatabase objectDatabase = this.local.getObjectDatabase();
        HashSet<ObjectId> newShallowCommits = new HashSet<ObjectId>(advertisedShallowCommits);
        while (!PacketLineIn.isDelimiter(line) && !PacketLineIn.isEnd(line)) {
            if (line.startsWith("shallow ")) {
                newShallowCommits.add(ObjectId.fromString(line.substring("shallow ".length())));
            } else if (line.startsWith("unshallow ")) {
                ObjectId unshallow = ObjectId.fromString(line.substring("unshallow ".length()));
                if (!advertisedShallowCommits.contains(unshallow)) {
                    throw new PackProtocolException(MessageFormat.format(JGitText.get().notShallowedUnshallow, unshallow.name()));
                }
                newShallowCommits.remove(unshallow);
            }
            line = input.readString();
        }
        objectDatabase.setShallowCommits(newShallowCommits);
        return line;
    }

    protected void onReceivePack() {
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$jgit$transport$PacketLineIn$AckNackResult() {
        if ($SWITCH_TABLE$org$eclipse$jgit$transport$PacketLineIn$AckNackResult != null) {
            return $SWITCH_TABLE$org$eclipse$jgit$transport$PacketLineIn$AckNackResult;
        }
        int[] nArray = new int[PacketLineIn.AckNackResult.values().length];
        try {
            nArray[PacketLineIn.AckNackResult.ACK.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[PacketLineIn.AckNackResult.ACK_COMMON.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[PacketLineIn.AckNackResult.ACK_CONTINUE.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[PacketLineIn.AckNackResult.ACK_READY.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[PacketLineIn.AckNackResult.NAK.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$eclipse$jgit$transport$PacketLineIn$AckNackResult = nArray;
        return nArray;
    }

    private static class CancelledException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private CancelledException() {
        }
    }

    static class FetchConfig {
        final boolean allowOfsDelta;
        final int maxHaves;

        FetchConfig(Config c) {
            this.allowOfsDelta = c.getBoolean("repack", "usedeltabaseoffset", true);
            this.maxHaves = c.getInt("fetch", "maxhaves", Integer.MAX_VALUE);
        }

        FetchConfig(boolean allowOfsDelta, int maxHaves) {
            this.allowOfsDelta = allowOfsDelta;
            this.maxHaves = maxHaves;
        }
    }

    private static class FetchStateV2 {
        long havesToSend = 32L;
        long havesTotal;
        boolean hadAcks;
        long havesWithoutAck;

        private FetchStateV2() {
        }

        void incHavesToSend(boolean statelessRPC) {
            this.havesToSend = statelessRPC ? (this.havesToSend < 16384L ? (this.havesToSend *= 2L) : this.havesToSend * 11L / 10L) : (this.havesToSend += 32L);
        }
    }
}

