/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java;

import com.intellij.openapi.util.Pair;
import com.intellij.util.SmartList;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.jps.builders.java.dependencyView.Callbacks;
import org.jetbrains.jps.dependency.GraphConfiguration;
import org.jetbrains.jps.dependency.Node;
import org.jetbrains.jps.dependency.NodeSource;
import org.jetbrains.jps.dependency.Usage;
import org.jetbrains.jps.dependency.java.ClassUsage;
import org.jetbrains.jps.dependency.java.FieldUsage;
import org.jetbrains.jps.dependency.java.ImportPackageOnDemandUsage;
import org.jetbrains.jps.dependency.java.ImportStaticMemberUsage;
import org.jetbrains.jps.dependency.java.ImportStaticOnDemandUsage;
import org.jetbrains.jps.dependency.java.JvmClassNodeBuilder;
import org.jetbrains.jps.dependency.java.JvmNodeReferenceID;
import org.jetbrains.jps.dependency.java.Proto;
import org.jetbrains.jps.javac.Iterators;
import org.jetbrains.org.objectweb.asm.ClassReader;

final class BackendCallbackToGraphDeltaAdapter
implements Callbacks.Backend {
    private static final String IMPORT_WILDCARD_SUFFIX = ".*";
    private final Map<String, Pair<Collection<String>, Collection<String>>> myImportRefs = Collections.synchronizedMap(new HashMap());
    private final Map<String, Collection<Callbacks.ConstantRef>> myConstantRefs = Collections.synchronizedMap(new HashMap());
    private final Map<String, Set<Usage>> myAdditionalUsages = Collections.synchronizedMap(new HashMap());
    private final Map<Path, Set<Usage>> myPerSourceAdditionalUsages = Collections.synchronizedMap(new HashMap());
    private final List<Pair<Node<?, ?>, Iterable<NodeSource>>> myNodes = new ArrayList();
    private final GraphConfiguration myGraphConfig;

    BackendCallbackToGraphDeltaAdapter(GraphConfiguration graphConfig) {
        this.myGraphConfig = graphConfig;
    }

    @Override
    public void associate(String classFileName, Collection<String> sources, ClassReader cr, boolean isGenerated) {
        Set<Usage> additional;
        JvmClassNodeBuilder builder = JvmClassNodeBuilder.create(classFileName, cr, isGenerated);
        JvmNodeReferenceID nodeID = builder.getReferenceID();
        String nodeName = nodeID.getNodeName();
        BackendCallbackToGraphDeltaAdapter.addConstantUsages(builder, nodeName, this.myConstantRefs.remove(nodeName));
        Pair<Collection<String>, Collection<String>> imports = this.myImportRefs.remove(nodeName);
        if (imports != null) {
            BackendCallbackToGraphDeltaAdapter.addImportUsages(builder, (Collection)imports.getFirst(), (Collection)imports.getSecond());
        }
        if ((additional = this.myAdditionalUsages.remove(nodeName)) != null) {
            for (Usage usage : additional) {
                if (nodeID.equals(usage.getElementOwner())) continue;
                builder.addUsage(usage);
            }
        }
        for (Usage usage : Iterators.flat((Iterable)Iterators.map(sources, src -> this.myPerSourceAdditionalUsages.remove(Path.of(src, new String[0]))))) {
            builder.addUsage(usage);
        }
        Node node = builder.getResult();
        if (!((Proto)((Object)node)).isPrivate()) {
            this.myNodes.add(new Pair((Object)node, (Object)Iterators.collect((Iterable)Iterators.map(sources, this.myGraphConfig.getPathMapper()::toNodeSource), (Collection)new SmartList())));
        }
    }

    public List<Pair<Node<?, ?>, Iterable<NodeSource>>> getNodes() {
        return this.myNodes;
    }

    @Override
    public void registerImports(String className, Collection<String> classImports, Collection<String> staticImports) {
        String key = className.replace('.', '/');
        if (!classImports.isEmpty() || !staticImports.isEmpty()) {
            this.myImportRefs.put(key, (Pair<Collection<String>, Collection<String>>)Pair.create(classImports, staticImports));
        } else {
            this.myImportRefs.remove(key);
        }
    }

    @Override
    public void registerConstantReferences(String className, Collection<Callbacks.ConstantRef> cRefs) {
        String key = className.replace('.', '/');
        if (!cRefs.isEmpty()) {
            this.myConstantRefs.put(key, cRefs);
        } else {
            this.myConstantRefs.remove(key);
        }
    }

    @Override
    public void registerUsage(String className, Usage usage) {
        this.myAdditionalUsages.computeIfAbsent(className.replace('.', '/'), k -> Collections.synchronizedSet(new HashSet())).add(usage);
    }

    @Override
    public void registerUsage(Path source, Usage usage) {
        this.myPerSourceAdditionalUsages.computeIfAbsent(source, k -> Collections.synchronizedSet(new HashSet())).add(usage);
    }

    private static void addImportUsages(JvmClassNodeBuilder builder, Collection<String> classImports, Collection<String> staticImports) {
        for (String anImport : classImports) {
            if (anImport.endsWith(IMPORT_WILDCARD_SUFFIX)) {
                builder.addUsage(new ImportPackageOnDemandUsage(anImport.substring(0, anImport.length() - IMPORT_WILDCARD_SUFFIX.length()).replace('.', '/')));
                continue;
            }
            builder.addUsage(new ClassUsage(anImport.replace('.', '/')));
        }
        for (String anImport : staticImports) {
            if (anImport.endsWith(IMPORT_WILDCARD_SUFFIX)) {
                String iname = anImport.substring(0, anImport.length() - IMPORT_WILDCARD_SUFFIX.length()).replace('.', '/');
                builder.addUsage(new ClassUsage(iname));
                builder.addUsage(new ImportStaticOnDemandUsage(iname));
                continue;
            }
            int i = anImport.lastIndexOf(46);
            if (i <= 0 || i >= anImport.length() - 1) continue;
            String iname = anImport.substring(0, i).replace('.', '/');
            String memberName = anImport.substring(i + 1);
            builder.addUsage(new ClassUsage(iname));
            builder.addUsage(new ImportStaticMemberUsage(iname, memberName));
        }
    }

    private static void addConstantUsages(JvmClassNodeBuilder builder, String nodeName, Collection<? extends Callbacks.ConstantRef> cRefs) {
        if (cRefs != null) {
            for (Callbacks.ConstantRef constantRef : cRefs) {
                String constantOwner = constantRef.getOwner().replace('.', '/');
                if (constantOwner.equals(nodeName)) continue;
                builder.addUsage(new FieldUsage(constantOwner, constantRef.getName(), constantRef.getDescriptor()));
            }
        }
    }
}

