/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.java;

import java.io.IOException;
import org.jetbrains.jps.dependency.GraphDataInput;
import org.jetbrains.jps.dependency.GraphDataOutput;
import org.jetbrains.jps.dependency.impl.RW;
import org.jetbrains.jps.dependency.java.ElemType;
import org.jetbrains.jps.dependency.java.JvmElementUsage;
import org.jetbrains.jps.dependency.java.JvmNodeReferenceID;
import org.jetbrains.jps.dependency.java.TypeRepr;

public final class AnnotationUsage
extends JvmElementUsage {
    private final TypeRepr.ClassType myClassType;
    private final Iterable<String> myUsedArgNames;
    private final Iterable<ElemType> myTargets;

    public AnnotationUsage(TypeRepr.ClassType classType, Iterable<String> usedArgNames, Iterable<ElemType> targets) {
        super(new JvmNodeReferenceID(classType.getJvmName()));
        this.myClassType = classType;
        this.myUsedArgNames = usedArgNames;
        this.myTargets = targets;
    }

    public AnnotationUsage(GraphDataInput in) throws IOException {
        super(in);
        this.myClassType = new TypeRepr.ClassType(in.readUTF());
        this.myUsedArgNames = RW.readCollection(in, () -> in.readUTF());
        this.myTargets = RW.readCollection(in, () -> ElemType.fromOrdinal(in.readInt()));
    }

    @Override
    public void write(GraphDataOutput out) throws IOException {
        super.write(out);
        out.writeUTF(this.myClassType.getJvmName());
        RW.writeCollection(out, this.myUsedArgNames, s -> out.writeUTF((String)s));
        RW.writeCollection(out, this.myTargets, t -> out.writeInt(t.ordinal()));
    }

    public TypeRepr.ClassType getClassType() {
        return this.myClassType;
    }

    public Iterable<String> getUsedArgNames() {
        return this.myUsedArgNames;
    }

    public Iterable<ElemType> getTargets() {
        return this.myTargets;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnotationUsage that = (AnnotationUsage)o;
        if (!this.myClassType.equals(that.myClassType)) {
            return false;
        }
        if (!this.myUsedArgNames.equals(that.myUsedArgNames)) {
            return false;
        }
        return this.myTargets.equals(that.myTargets);
    }

    @Override
    public int hashCode() {
        int result = this.myClassType.hashCode();
        result = 31 * result + this.myUsedArgNames.hashCode();
        result = 31 * result + this.myTargets.hashCode();
        return result;
    }
}

