/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.java;

import java.io.IOException;
import org.jetbrains.jps.dependency.GraphDataInput;
import org.jetbrains.jps.dependency.GraphDataOutput;
import org.jetbrains.jps.dependency.java.JvmNodeReferenceID;
import org.jetbrains.jps.dependency.java.MemberUsage;

public class FieldUsage
extends MemberUsage {
    private final String myDescriptor;

    public FieldUsage(String className, String name, String descriptor) {
        super(className, name);
        this.myDescriptor = descriptor;
    }

    public FieldUsage(JvmNodeReferenceID clsId, String name, String descriptor) {
        super(clsId, name);
        this.myDescriptor = descriptor;
    }

    public FieldUsage(GraphDataInput in) throws IOException {
        super(in);
        this.myDescriptor = in.readUTF();
    }

    @Override
    public void write(GraphDataOutput out) throws IOException {
        super.write(out);
        out.writeUTF(this.myDescriptor);
    }

    public String getDescriptor() {
        return this.myDescriptor;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        FieldUsage that = (FieldUsage)o;
        return this.myDescriptor.equals(that.myDescriptor);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myDescriptor.hashCode();
        return result;
    }
}

