/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.java;

import com.intellij.openapi.util.Pair;
import com.intellij.util.SmartList;
import com.intellij.util.containers.SmartHashSet;
import java.lang.annotation.RetentionPolicy;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.dependency.BackDependencyIndex;
import org.jetbrains.jps.dependency.DifferentiateContext;
import org.jetbrains.jps.dependency.Node;
import org.jetbrains.jps.dependency.NodeSource;
import org.jetbrains.jps.dependency.ReferenceID;
import org.jetbrains.jps.dependency.Usage;
import org.jetbrains.jps.dependency.diff.DiffCapable;
import org.jetbrains.jps.dependency.diff.Difference;
import org.jetbrains.jps.dependency.java.AnnotationChangesTracker;
import org.jetbrains.jps.dependency.java.AnnotationUsage;
import org.jetbrains.jps.dependency.java.ClassAsGenericBoundUsage;
import org.jetbrains.jps.dependency.java.ClassNewUsage;
import org.jetbrains.jps.dependency.java.ClassUsage;
import org.jetbrains.jps.dependency.java.ElemType;
import org.jetbrains.jps.dependency.java.FieldUsage;
import org.jetbrains.jps.dependency.java.InheritanceConstraint;
import org.jetbrains.jps.dependency.java.JVMClassNode;
import org.jetbrains.jps.dependency.java.JVMFlags;
import org.jetbrains.jps.dependency.java.JvmClass;
import org.jetbrains.jps.dependency.java.JvmDifferentiateStrategyImpl;
import org.jetbrains.jps.dependency.java.JvmField;
import org.jetbrains.jps.dependency.java.JvmMethod;
import org.jetbrains.jps.dependency.java.JvmModule;
import org.jetbrains.jps.dependency.java.JvmNodeReferenceID;
import org.jetbrains.jps.dependency.java.ModulePackage;
import org.jetbrains.jps.dependency.java.ModuleRequires;
import org.jetbrains.jps.dependency.java.ModuleUsage;
import org.jetbrains.jps.dependency.java.PackageConstraint;
import org.jetbrains.jps.dependency.java.ParamAnnotation;
import org.jetbrains.jps.dependency.java.Proto;
import org.jetbrains.jps.dependency.java.TypeRepr;
import org.jetbrains.jps.dependency.java.Utils;
import org.jetbrains.jps.javac.Iterators;

public final class JavaDifferentiateStrategy
extends JvmDifferentiateStrategyImpl {
    private static final Iterable<AnnotationChangesTracker> ourAnnotationChangeTrackers = Iterators.collect(ServiceLoader.load(AnnotationChangesTracker.class, JavaDifferentiateStrategy.class.getClassLoader()), (Collection)new SmartList());

    @Override
    public boolean isIncremental(DifferentiateContext context, Node<?, ?> affectedNode) {
        if (affectedNode instanceof JvmClass && ((JvmClass)affectedNode).getFlags().isGenerated()) {
            this.debug("Turning non-incremental for the BuildTarget because dependent class is annotation-processor generated: ", affectedNode.getReferenceID());
            return false;
        }
        return true;
    }

    @Override
    public boolean processRemovedClass(DifferentiateContext context, JvmClass removedClass, Utils future, Utils present) {
        this.debug("Adding usages of removed class ", removedClass.getName());
        context.affectUsage(new ClassUsage(removedClass.getReferenceID()));
        return true;
    }

    @Override
    public boolean processAddedClasses(DifferentiateContext context, Iterable<JvmClass> addedClasses, Utils future, Utils present) {
        if (Iterators.isEmpty(addedClasses)) {
            return true;
        }
        this.debug("Processing added classes:");
        BackDependencyIndex index = context.getGraph().getIndex("class-short-names");
        assert (index != null);
        HashSet<JvmNodeReferenceID> affectedNodes = new HashSet<JvmNodeReferenceID>();
        for (JvmClass addedClass : addedClasses) {
            this.debug("Class name: ", addedClass.getName());
            if (!addedClass.isAnonymous() && !addedClass.isLocal() && addedClass.getOuterFqName().isEmpty()) {
                Set<NodeSource> deletedSources = context.getDelta().getDeletedSources();
                Predicate<? super NodeSource> belongsToChunk = context.getParams().belongsToCurrentCompilationChunk();
                Set candidates = (Set)Iterators.collect((Iterable)Iterators.filter(present.getNodeSources(addedClass.getReferenceID()), s -> !deletedSources.contains(s) && belongsToChunk.test((NodeSource)s)), new HashSet());
                if (!Iterators.isEmpty((Iterable)Iterators.filter((Iterable)candidates, src -> !context.isCompiled((NodeSource)src)))) {
                    Iterators.collect(context.getDelta().getSources(addedClass.getReferenceID()), (Collection)candidates);
                    StringBuilder msg = new StringBuilder();
                    msg.append("Possibly duplicated classes in the same compilation chunk; Scheduling for recompilation sources: ");
                    for (NodeSource candidate : candidates) {
                        context.affectNodeSource(candidate);
                        msg.append(candidate).append("; ");
                    }
                    this.debug(msg.toString());
                    continue;
                }
            }
            if (addedClass.isAnonymous() || addedClass.isLocal()) continue;
            Iterators.collect(index.getDependencies(new JvmNodeReferenceID(addedClass.getShortName())), affectedNodes);
            affectedNodes.add(addedClass.getReferenceID());
        }
        for (ReferenceID id2 : Iterators.unique((Iterable)Iterators.flat((Iterable)Iterators.map(affectedNodes, id -> context.getGraph().getDependingNodes((ReferenceID)id))))) {
            this.affectNodeSources(context, id2, "Affecting dependencies on class with the same short name: " + id2 + " ", true);
        }
        this.debug("End of added classes processing.");
        return true;
    }

    @Override
    public boolean processChangedClass(DifferentiateContext context, Difference.Change<JvmClass, JvmClass.Diff> change, Utils future, Utils present) {
        Difference.Specifier<TypeRepr.ClassType, ?> annotationsDiff;
        JVMFlags addedFlags;
        JvmClass changedClass = change.getPast();
        JvmClass.Diff classDiff = change.getDiff();
        this.debug("Processing changed class ", changedClass.getName());
        if (classDiff.superClassChanged() || classDiff.signatureChanged() || !classDiff.interfaces().unchanged()) {
            boolean extendsChanged = classDiff.superClassChanged() && !classDiff.extendsAdded();
            boolean affectUsages = classDiff.signatureChanged() || extendsChanged || !Iterators.isEmpty(classDiff.interfaces().removed());
            this.affectSubclasses(context, future, change.getNow().getReferenceID(), affectUsages);
            if (extendsChanged) {
                TypeRepr.ClassType exClass = new TypeRepr.ClassType(changedClass.getName());
                for (JvmClass jvmClass : Iterators.flat((Iterable)Iterators.map(context.getGraph().getDependingNodes(changedClass.getReferenceID()), dep -> present.getNodes((ReferenceID)dep, JvmClass.class)))) {
                    for (JvmMethod method : jvmClass.getMethods()) {
                        if (!Iterators.contains(method.getExceptions(), (Object)exClass)) continue;
                        context.affectUsage(method.createUsage(jvmClass.getReferenceID()));
                        this.debug("Affecting usages of methods throwing ", exClass.getJvmName(), " exception; class ", jvmClass.getName());
                    }
                }
            }
            if (!changedClass.isAnonymous()) {
                Set parents = (Set)Iterators.collect(present.allSupertypes(changedClass.getReferenceID()), new HashSet());
                parents.removeAll(Iterators.collect(future.allSupertypes(changedClass.getReferenceID()), new HashSet()));
                for (JvmNodeReferenceID jvmNodeReferenceID : parents) {
                    this.debug("Affecting usages in generic type parameter bounds of class: ", jvmNodeReferenceID);
                    context.affectUsage(new ClassAsGenericBoundUsage(jvmNodeReferenceID));
                }
            }
        }
        if ((addedFlags = classDiff.getAddedFlags()).isInterface() || classDiff.getRemovedFlags().isInterface()) {
            this.debug("Class-to-interface or interface-to-class conversion detected, added class usage to affected usages");
            context.affectUsage(new ClassUsage(changedClass.getReferenceID()));
        }
        if (changedClass.isAnnotation() && changedClass.getRetentionPolicy() == RetentionPolicy.SOURCE) {
            this.debug("Annotation, retention policy = SOURCE => a switch to non-incremental mode requested");
            if (!this.affectOnNonIncrementalChange(context, changedClass.getReferenceID(), changedClass, present)) {
                this.debug("End of Differentiate, returning false");
                return false;
            }
        }
        if (addedFlags.isProtected()) {
            this.debug("Introduction of 'protected' modifier detected, adding class usage + inheritance constraint to affected usages");
            context.affectUsage(new ClassUsage(changedClass.getReferenceID()), new InheritanceConstraint(future, changedClass));
        }
        if (!changedClass.getFlags().isPackageLocal() && change.getNow().getFlags().isPackageLocal()) {
            this.debug("Introduction of 'package-private' access detected, adding class usage + package constraint to affected usages");
            context.affectUsage(new ClassUsage(changedClass.getReferenceID()), new PackageConstraint(changedClass.getPackageName()));
        }
        if (addedFlags.isFinal() || addedFlags.isPrivate()) {
            this.debug("Introduction of 'private' or 'final' modifier(s) detected, adding class usage to affected usages");
            context.affectUsage(new ClassUsage(changedClass.getReferenceID()));
        }
        if (addedFlags.isAbstract() || addedFlags.isStatic()) {
            this.debug("Introduction of 'abstract' or 'static' modifier(s) detected, adding class new usage to affected usages");
            context.affectUsage(new ClassNewUsage(changedClass.getReferenceID()));
        }
        if (!changedClass.isAnonymous() && !changedClass.isPrivate() && classDiff.flagsChanged() && changedClass.isInnerClass()) {
            this.debug("Some modifiers (access flags) were changed for non-private inner class, adding class usage to affected usages");
            context.affectUsage(new ClassUsage(changedClass.getReferenceID()));
        }
        if (changedClass.isAnnotation()) {
            this.debug("Class is annotation, performing annotation-specific analysis");
            if (classDiff.retentionPolicyChanged()) {
                this.debug("Retention policy change detected, adding class usage to affected usages");
                context.affectUsage(new ClassUsage(changedClass.getReferenceID()));
            } else if (classDiff.targetAttributeCategoryMightChange()) {
                this.debug("Annotation's attribute category in bytecode might be affected because of TYPE_USE or RECORD_COMPONENT target, adding class usage to affected usages");
                context.affectUsage(new ClassUsage(changedClass.getReferenceID()));
            } else {
                Difference.Specifier<ElemType, ?> targetsDiff = classDiff.annotationTargets();
                Set removedTargets = (Set)Iterators.collect(targetsDiff.removed(), EnumSet.noneOf(ElemType.class));
                if (removedTargets.contains((Object)ElemType.LOCAL_VARIABLE)) {
                    this.debug("Removed target contains LOCAL_VARIABLE => a switch to non-incremental mode requested");
                    if (!this.affectOnNonIncrementalChange(context, changedClass.getReferenceID(), changedClass, present)) {
                        this.debug("End of Differentiate, returning false");
                        return false;
                    }
                }
                if (!removedTargets.isEmpty()) {
                    this.debug("Removed some annotation targets, adding annotation query");
                    TypeRepr.ClassType classType = new TypeRepr.ClassType(changedClass.getName());
                    context.affectUsage(Iterators.asIterable((Object)changedClass.getReferenceID()), node -> {
                        for (Usage usage : node.getUsages()) {
                            AnnotationUsage annotUsage;
                            if (!(usage instanceof AnnotationUsage) || !classType.equals((annotUsage = (AnnotationUsage)usage).getClassType())) continue;
                            for (ElemType target : annotUsage.getTargets()) {
                                if (!removedTargets.contains((Object)target)) continue;
                                return true;
                            }
                        }
                        return false;
                    });
                }
                for (JvmMethod jvmMethod : classDiff.methods().added()) {
                    if (jvmMethod.getValue() != null) continue;
                    this.debug("Added method with no default value: ", jvmMethod.getName());
                    this.debug("Adding class usage to affected usages");
                    context.affectUsage(new ClassUsage(changedClass.getReferenceID()));
                    break;
                }
            }
            this.debug("End of annotation-specific analysis");
        }
        if (changedClass.getFlags().isEnum() && !Iterators.isEmpty(classDiff.fields().added())) {
            this.debug("Constants added to enum, affecting class usages " + changedClass.getName());
            context.affectUsage(new ClassUsage(changedClass.getReferenceID()), n -> n instanceof JVMClassNode && ((JVMClassNode)n).isSynthetic());
        }
        boolean wasLambdaTarget = present.isLambdaTarget(change.getPast());
        boolean isLambdaTarget = future.isLambdaTarget(change.getNow());
        if (wasLambdaTarget && !isLambdaTarget) {
            for (ReferenceID referenceID : present.withAllSubclasses(changedClass.getReferenceID())) {
                String clsName;
                if (!referenceID.equals(changedClass.getReferenceID()) && !present.isLambdaTarget(referenceID) || (clsName = present.getNodeName(referenceID)) == null) continue;
                this.debug("The interface could be not a SAM interface anymore => affecting lambda instantiations for ", clsName);
                context.affectUsage(new ClassNewUsage(clsName));
            }
        } else if (!wasLambdaTarget && isLambdaTarget) {
            TypeRepr.ClassType samType = new TypeRepr.ClassType(changedClass.getName());
            for (Object depClass : Iterators.flat((Iterable)Iterators.map(context.getGraph().getDependingNodes(changedClass.getReferenceID()), dep -> present.getNodes((ReferenceID)dep, JvmClass.class)))) {
                JvmMethod methodWithSAMType = (JvmMethod)Iterators.find(((JvmClass)depClass).getMethods(), m -> Iterators.contains(m.getArgTypes(), (Object)samType));
                if (methodWithSAMType == null) continue;
                Iterable<Utils.OverloadDescriptor> overloaded = future.findAllOverloads((JvmClass)depClass, m -> {
                    if (!Objects.equals(methodWithSAMType.getName(), m.getName()) || m.isSame(methodWithSAMType)) {
                        return null;
                    }
                    Iterator<TypeRepr> patternSignatureTypes = methodWithSAMType.getArgTypes().iterator();
                    for (TypeRepr arg : m.getArgTypes()) {
                        if (!patternSignatureTypes.hasNext()) {
                            return null;
                        }
                        TypeRepr patternArg = patternSignatureTypes.next();
                        if (!(patternArg.equals(samType) ? arg.equals(samType) || !(arg instanceof TypeRepr.ClassType) : Boolean.FALSE.equals(future.isSubtypeOf(arg, patternArg)) && Boolean.FALSE.equals(future.isSubtypeOf(patternArg, arg)))) continue;
                        return null;
                    }
                    return patternSignatureTypes.hasNext() ? null : m.getFlags();
                });
                for (Utils.OverloadDescriptor descr : overloaded) {
                    this.debug("Found method ", methodWithSAMType, " that uses SAM interface ", samType.getJvmName(), " in its signature --- affect potential lambda-target usages of overloaded method: ", descr.overloadMethod);
                    this.affectMemberUsages(context, descr.owner.getReferenceID(), descr.overloadMethod, future.collectSubclassesWithoutMethod(descr.owner.getReferenceID(), descr.overloadMethod), arg_0 -> JavaDifferentiateStrategy.lambda$processChangedClass$9(future, (JvmClass)depClass, methodWithSAMType, arg_0));
                }
            }
        }
        if (!(annotationsDiff = classDiff.annotations()).unchanged()) {
            boolean affectUsages;
            EnumSet<AnnotationChangesTracker.Recompile> enumSet = EnumSet.noneOf(AnnotationChangesTracker.Recompile.class);
            for (AnnotationChangesTracker tracker : ourAnnotationChangeTrackers) {
                if (enumSet.containsAll(AnnotationChangesTracker.RECOMPILE_ALL)) break;
                Set<AnnotationChangesTracker.Recompile> result = tracker.classAnnotationsChanged(changedClass, annotationsDiff);
                if (result.contains((Object)AnnotationChangesTracker.Recompile.USAGES)) {
                    this.debug("Extension ", tracker.getClass().getName(), " requested class usages recompilation because of changes in annotations list --- adding class usage to affected usages");
                }
                if (result.contains((Object)AnnotationChangesTracker.Recompile.SUBCLASSES)) {
                    this.debug("Extension ", tracker.getClass().getName(), " requested subclasses recompilation because of changes in annotations list --- adding subclasses to affected usages");
                }
                enumSet.addAll(result);
            }
            if (affectUsages = enumSet.contains((Object)AnnotationChangesTracker.Recompile.USAGES)) {
                context.affectUsage(new ClassUsage(changedClass.getReferenceID()));
            }
            if (enumSet.contains((Object)AnnotationChangesTracker.Recompile.SUBCLASSES)) {
                this.affectSubclasses(context, future, changedClass.getReferenceID(), affectUsages);
            }
        }
        return true;
    }

    @Override
    public boolean processChangedMethods(DifferentiateContext context, Difference.Change<JvmClass, JvmClass.Diff> clsChange, Iterable<Difference.Change<JvmMethod, JvmMethod.Diff>> methodChanges, Utils future, Utils present) {
        JvmClass changedClass = clsChange.getPast();
        this.debug("Processing changed methods: ");
        for (Difference.Change<JvmMethod, JvmMethod.Diff> change : methodChanges) {
            JvmMethod changedMethod = change.getPast();
            JvmMethod.Diff diff = change.getDiff();
            this.debug("Method: ", changedMethod.getName());
            if (!this.processChangedMethod(context, clsChange, change, future, present)) {
                return false;
            }
            if (changedClass.isAnnotation()) {
                if (!diff.valueRemoved()) continue;
                this.debug("Class is annotation, default value is removed => adding annotation query");
                String argName = changedMethod.getName();
                TypeRepr.ClassType annotType = new TypeRepr.ClassType(changedClass.getName());
                context.affectUsage(Iterators.asIterable((Object)changedClass.getReferenceID()), node -> {
                    Usage usage;
                    Iterator<Usage> iterator = node.getUsages().iterator();
                    do {
                        if (!iterator.hasNext()) return false;
                    } while (!((usage = iterator.next()) instanceof AnnotationUsage));
                    AnnotationUsage au = (AnnotationUsage)usage;
                    if (!annotType.equals(au.getClassType())) return false;
                    if (!Iterators.isEmpty((Iterable)Iterators.filter(au.getUsedArgNames(), argName::equals))) return false;
                    return true;
                });
                continue;
            }
            Iterable propagated = Iterators.lazy(() -> future.collectSubclassesWithoutMethod(changedClass.getReferenceID(), changedMethod));
            if (diff.becamePackageLocal()) {
                this.debug("Method became package-private, affecting method usages outside the package");
                this.affectMemberUsages(context, changedClass.getReferenceID(), changedMethod, propagated, new PackageConstraint(changedClass.getPackageName()));
            }
            if (diff.typeChanged() || diff.signatureChanged() || !diff.exceptions().unchanged()) {
                this.debug("Return type, throws list or signature changed --- affecting method usages");
                this.affectMemberUsages(context, changedClass.getReferenceID(), changedMethod, propagated);
                for (JvmNodeReferenceID subClass : Iterators.unique((Iterable)Iterators.map(future.getOverridingMethods(changedClass, changedMethod, changedMethod::isSameByJavaRules), p -> ((JvmClass)p.getFirst()).getReferenceID()))) {
                    this.affectNodeSources(context, subClass, "Affect source file of a class which overrides the changed method: ");
                }
            } else if (diff.flagsChanged()) {
                JVMFlags addedFlags = diff.getAddedFlags();
                JVMFlags removedFlags = diff.getRemovedFlags();
                if (addedFlags.isStatic() || addedFlags.isPrivate() || addedFlags.isSynthetic() || addedFlags.isBridge() || removedFlags.isStatic()) {
                    this.debug("Added {static | private | synthetic | bridge} specifier or removed static specifier --- affecting method usages");
                    this.affectMemberUsages(context, changedClass.getReferenceID(), changedMethod, propagated);
                    if (addedFlags.isStatic()) {
                        this.debug("Added static specifier --- affecting subclasses");
                        this.affectSubclasses(context, future, changedClass.getReferenceID(), false);
                        if (!changedMethod.isPrivate()) {
                            this.debug("Added static modifier --- affecting static member on-demand import usages");
                            this.affectStaticMemberOnDemandUsages(context, changedClass.getReferenceID(), propagated);
                        }
                    } else if (removedFlags.isStatic() && !changedMethod.isPrivate()) {
                        this.debug("Removed static modifier --- affecting static method import usages");
                        this.affectStaticMemberImportUsages(context, changedClass.getReferenceID(), changedMethod.getName(), propagated);
                    }
                } else {
                    if (addedFlags.isFinal() || addedFlags.isPublic() || addedFlags.isAbstract()) {
                        this.debug("Added final, public or abstract specifier --- affecting subclasses");
                        this.affectSubclasses(context, future, changedClass.getReferenceID(), false);
                    }
                    if (addedFlags.isProtected() && !removedFlags.isPrivate()) {
                        this.debug("Added public or package-private method became protected --- affect method usages with protected constraint");
                        this.affectMemberUsages(context, changedClass.getReferenceID(), changedMethod, propagated, new InheritanceConstraint(future, changedClass));
                    }
                }
            }
            Difference.Specifier<TypeRepr.ClassType, ?> annotationsDiff = diff.annotations();
            Difference.Specifier<ParamAnnotation, ?> paramAnnotationsDiff = diff.paramAnnotations();
            if (annotationsDiff.unchanged() && paramAnnotationsDiff.unchanged()) continue;
            EnumSet<AnnotationChangesTracker.Recompile> toRecompile = EnumSet.noneOf(AnnotationChangesTracker.Recompile.class);
            for (AnnotationChangesTracker tracker : ourAnnotationChangeTrackers) {
                if (toRecompile.containsAll(AnnotationChangesTracker.RECOMPILE_ALL)) break;
                Set<AnnotationChangesTracker.Recompile> result = tracker.methodAnnotationsChanged(changedMethod, annotationsDiff, paramAnnotationsDiff);
                if (result.contains((Object)AnnotationChangesTracker.Recompile.USAGES)) {
                    this.debug("Extension ", tracker.getClass().getName(), " requested recompilation because of changes in annotations list --- affecting method usages");
                }
                if (result.contains((Object)AnnotationChangesTracker.Recompile.SUBCLASSES)) {
                    this.debug("Extension ", tracker.getClass().getName(), " requested recompilation because of changes in method annotations or method parameter annotations list --- affecting subclasses");
                }
                toRecompile.addAll(result);
            }
            if (toRecompile.contains((Object)AnnotationChangesTracker.Recompile.USAGES)) {
                this.affectMemberUsages(context, changedClass.getReferenceID(), changedMethod, propagated);
                if (changedMethod.isAbstract() || toRecompile.contains((Object)AnnotationChangesTracker.Recompile.SUBCLASSES)) {
                    for (Pair pair : Iterators.recurse((Object)Pair.create((Object)changedClass, (Object)changedMethod), p -> future.getOverridingMethods((JvmClass)p.first, (JvmMethod)p.second, ((JvmMethod)p.second)::isSameByJavaRules), (boolean)false)) {
                        JvmNodeReferenceID clsId = ((JvmClass)pair.first).getReferenceID();
                        JvmMethod meth = (JvmMethod)pair.getSecond();
                        this.affectMemberUsages(context, clsId, meth, future.collectSubclassesWithoutMethod(clsId, meth));
                    }
                }
            }
            if (!toRecompile.contains((Object)AnnotationChangesTracker.Recompile.SUBCLASSES)) continue;
            this.affectSubclasses(context, future, changedClass.getReferenceID(), false);
        }
        Collection moreAccessible = Iterators.collect((Iterable)Iterators.filter(methodChanges, ch -> ((JvmMethod.Diff)ch.getDiff()).accessExpanded()), (Collection)new SmartList());
        if (!Iterators.isEmpty((Iterable)moreAccessible)) {
            Iterable<Utils.OverloadDescriptor> overloaded = future.findAllOverloads(changedClass, method -> {
                JVMFlags mostAccessible = null;
                for (Difference.Change change : moreAccessible) {
                    JvmMethod m = (JvmMethod)change.getNow();
                    if (!Objects.equals(m.getName(), method.getName()) || m.isSame((DiffCapable<?, ?>)method) || mostAccessible != null && !mostAccessible.isWeakerAccess(m.getFlags())) continue;
                    mostAccessible = m.getFlags();
                }
                return mostAccessible;
            });
            for (Utils.OverloadDescriptor descr : overloaded) {
                this.debug("Method became more accessible --- affect usages of overloading methods: ", descr.overloadMethod.getName());
                Predicate<Object> constr = descr.accessScope.isPackageLocal() ? new PackageConstraint(changedClass.getPackageName()).negate() : (descr.accessScope.isProtected() ? new InheritanceConstraint(future, changedClass).negate() : null);
                this.affectMemberUsages(context, descr.owner.getReferenceID(), descr.overloadMethod, future.collectSubclassesWithoutMethod(descr.owner.getReferenceID(), descr.overloadMethod), constr);
            }
        }
        this.debug("End of changed methods processing");
        return true;
    }

    @Override
    public boolean processRemovedMethods(DifferentiateContext context, Difference.Change<JvmClass, JvmClass.Diff> change, Iterable<JvmMethod> removed, Utils future, Utils present) {
        JvmClass changedClass = change.getPast();
        this.debug("Processing removed methods: ");
        Iterators.Provider extendsLibraryClass = Utils.lazyValue(() -> future.inheritsFromLibraryClass(changedClass));
        for (JvmMethod removedMethod : removed) {
            this.debug("Method ", removedMethod.getName());
            if (!this.processRemovedMethod(context, change, removedMethod, future, present)) {
                return false;
            }
            Iterable propagated = Iterators.lazy(() -> future.collectSubclassesWithoutMethod(changedClass.getReferenceID(), removedMethod));
            if (!removedMethod.isPrivate() && removedMethod.isStatic()) {
                this.debug("The method was static --- affecting static method import usages");
                this.affectStaticMemberImportUsages(context, changedClass.getReferenceID(), removedMethod.getName(), propagated);
            }
            if (removedMethod.isPackageLocal()) {
                this.debug("Removed method is package-local, affecting method usages");
                this.affectMemberUsages(context, changedClass.getReferenceID(), removedMethod, propagated);
            } else {
                boolean isClearlyOverridden;
                List overridden = removedMethod.isConstructor() ? Collections.emptyList() : Iterators.lazy(() -> future.getOverriddenMethods(changedClass, removedMethod::isSameByJavaRules));
                boolean bl = isClearlyOverridden = removedMethod.getSignature().isEmpty() && (Boolean)extendsLibraryClass.get() == false && !Iterators.isEmpty(overridden) && Iterators.isEmpty((Iterable)Iterators.filter(overridden, p -> !((JvmMethod)p.getSecond()).getType().equals(removedMethod.getType()) || !((JvmMethod)p.getSecond()).getSignature().isEmpty() || removedMethod.isMoreAccessibleThan((Proto)p.getSecond())));
                if (!isClearlyOverridden) {
                    this.debug("No overridden methods found, affecting method usages");
                    this.affectMemberUsages(context, changedClass.getReferenceID(), removedMethod, propagated);
                }
            }
            for (Pair<JvmClass, JvmMethod> overriding : future.getOverridingMethods(changedClass, removedMethod, removedMethod::isSameByJavaRules)) {
                this.affectNodeSources(context, ((JvmClass)overriding.getFirst()).getReferenceID(), "Affecting file by overriding: ");
            }
            if (removedMethod.isConstructor() || removedMethod.isAbstract() || removedMethod.isStatic()) continue;
            for (JvmNodeReferenceID id : propagated) {
                boolean allOverriddenAbstract;
                Iterator<JvmClass> iterator = future.getNodes(id, JvmClass.class).iterator();
                if (!iterator.hasNext()) continue;
                JvmClass subClass = iterator.next();
                Iterable overriddenForSubclass = Iterators.filter(future.getOverriddenMethods(subClass, removedMethod::isSameByJavaRules), p -> ((JvmMethod)p.getSecond()).isAbstract() || removedMethod.isSame((DiffCapable)p.getSecond()));
                boolean bl = allOverriddenAbstract = !Iterators.isEmpty((Iterable)overriddenForSubclass) && Iterators.isEmpty((Iterable)Iterators.filter((Iterable)overriddenForSubclass, p -> !((JvmMethod)p.getSecond()).isAbstract()));
                if (!allOverriddenAbstract && !future.inheritsFromLibraryClass(subClass)) continue;
                this.debug("Removed method is not abstract & overrides some abstract method which is not then over-overridden in subclass ", subClass.getName());
                this.affectNodeSources(context, subClass.getReferenceID(), "Affecting subclass source file: ");
            }
        }
        this.debug("End of removed methods processing");
        return true;
    }

    @Override
    public boolean processAddedMethods(DifferentiateContext context, Difference.Change<JvmClass, JvmClass.Diff> change, Iterable<JvmMethod> added, Utils future, Utils present) {
        JvmClass changedClass = change.getPast();
        if (changedClass.isAnnotation()) {
            this.debug("Class is annotation, skipping method analysis for added methods");
            return true;
        }
        this.debug("Processing added methods: ");
        for (JvmMethod addedMethod : added) {
            if (addedMethod.isPrivate() || !changedClass.isInterface() && !changedClass.isAbstract() && !addedMethod.isAbstract()) continue;
            this.debug("Method: " + addedMethod.getName());
            this.debug("Class is abstract, or is interface, or added non-private method is abstract => affecting all subclasses");
            this.affectSubclasses(context, future, changedClass.getReferenceID(), false);
            break;
        }
        for (JvmMethod addedMethod : added) {
            JvmClass cls;
            this.debug("Method: ", addedMethod.getName());
            if (!this.processAddedMethod(context, change, addedMethod, future, present)) {
                return false;
            }
            if (addedMethod.isPrivate()) continue;
            Iterable propagated = Iterators.lazy(() -> future.collectSubclassesWithoutMethod(changedClass.getReferenceID(), addedMethod));
            if (!Iterators.isEmpty(addedMethod.getArgTypes()) && !present.hasOverriddenMethods(changedClass, addedMethod)) {
                this.debug("Conservative case on overriding methods, affecting method usages");
                context.affectUsage(Iterators.asIterable((Object)changedClass.getReferenceID()), addedMethod.createUsageQuery(changedClass.getReferenceID()));
                if (!addedMethod.isConstructor()) {
                    for (JvmNodeReferenceID id : propagated) {
                        context.affectUsage(Iterators.asIterable((Object)id), addedMethod.createUsageQuery(id));
                    }
                }
            }
            if (addedMethod.isStatic()) {
                this.affectStaticMemberOnDemandUsages(context, changedClass.getReferenceID(), propagated);
            }
            Predicate<JvmMethod> lessSpecificCond = future.lessSpecific(addedMethod);
            for (JvmMethod jvmMethod : Iterators.filter(changedClass.getMethods(), lessSpecificCond::test)) {
                this.debug("Found less specific method, affecting method usages; ", jvmMethod.getName(), jvmMethod.getDescriptor());
                this.affectMemberUsages(context, changedClass.getReferenceID(), jvmMethod, present.collectSubclassesWithoutMethod(changedClass.getReferenceID(), jvmMethod));
            }
            this.debug("Processing affected by specificity methods");
            for (Pair pair : future.getOverriddenMethods(changedClass, lessSpecificCond)) {
                cls = (JvmClass)pair.getFirst();
                JvmMethod overriddenMethod = (JvmMethod)pair.getSecond();
                this.debug("Method: ", overriddenMethod.getName());
                this.debug("Class : ", cls.getName());
                this.debug("Affecting method usages for that found");
                this.affectMemberUsages(context, changedClass.getReferenceID(), overriddenMethod, present.collectSubclassesWithoutMethod(changedClass.getReferenceID(), overriddenMethod));
            }
            for (Pair pair : future.getOverridingMethods(changedClass, addedMethod, lessSpecificCond)) {
                cls = (JvmClass)pair.getFirst();
                JvmMethod overridingMethod = (JvmMethod)pair.getSecond();
                this.debug("Method: ", overridingMethod.getName());
                this.debug("Class : ", cls.getName());
                if (overridingMethod.isSameByJavaRules(addedMethod)) {
                    this.debug("Current method overrides the added method");
                    this.affectNodeSources(context, cls.getReferenceID(), "Affecting source ");
                    continue;
                }
                this.debug("Current method does not override the added method");
                this.debug("Affecting method usages for the method");
                this.affectMemberUsages(context, cls.getReferenceID(), overridingMethod, present.collectSubclassesWithoutMethod(cls.getReferenceID(), overridingMethod));
            }
            for (ReferenceID referenceID : future.allSubclasses(changedClass.getReferenceID())) {
                Iterable<NodeSource> sources = context.getGraph().getSources(referenceID);
                if (Iterators.isEmpty((Iterable)Iterators.filter(sources, s -> !context.isCompiled((NodeSource)s)))) continue;
                for (JvmClass outerClass : Iterators.flat((Iterable)Iterators.map(future.getNodes(referenceID, JvmClass.class), cl -> future.getNodes(new JvmNodeReferenceID(cl.getOuterFqName()), JvmClass.class)))) {
                    if (!future.isMethodVisible(outerClass, addedMethod)) {
                        if (!future.inheritsFromLibraryClass(outerClass)) continue;
                    }
                    for (NodeSource source : Iterators.filter(sources, context.getParams().affectionFilter()::test)) {
                        this.debug("Affecting file due to local overriding: ", source);
                        context.affectNodeSource(source);
                    }
                }
            }
        }
        this.debug("End of added methods processing");
        return true;
    }

    @Override
    public boolean processAddedFields(DifferentiateContext context, Difference.Change<JvmClass, JvmClass.Diff> change, Iterable<JvmField> added, Utils future, Utils present) {
        if (!Iterators.isEmpty(added)) {
            this.debug("Processing added fields: ");
        }
        return super.processAddedFields(context, change, added, future, present);
    }

    @Override
    public boolean processAddedField(DifferentiateContext context, Difference.Change<JvmClass, JvmClass.Diff> change, JvmField addedField, Utils future, Utils present) {
        JvmClass changedClass = change.getPast();
        this.debug("Field: " + addedField.getName());
        Set<JvmNodeReferenceID> changedClassWithSubclasses = future.collectSubclassesWithoutField(changedClass.getReferenceID(), addedField);
        changedClassWithSubclasses.add(changedClass.getReferenceID());
        for (JvmNodeReferenceID subClass : changedClassWithSubclasses) {
            String affectReason = null;
            if (!addedField.isPrivate()) {
                for (JvmClass cl : future.getNodes(subClass, JvmClass.class)) {
                    Collection outerClasses;
                    if (cl.isLocal()) {
                        affectReason = "Affecting local subclass (introduced field can potentially hide surrounding method parameters/local variables): ";
                        break;
                    }
                    String outerClassName = cl.getOuterFqName();
                    if (outerClassName.isEmpty() || !Iterators.isEmpty((Iterable)(outerClasses = Iterators.collect(future.getClassesByName(outerClassName), (Collection)new SmartList()))) && Iterators.isEmpty((Iterable)Iterators.filter((Iterable)outerClasses, ocl -> future.isFieldVisible((JvmClass)ocl, addedField)))) continue;
                    affectReason = "Affecting inner subclass (introduced field can potentially hide surrounding class fields): ";
                    break;
                }
            }
            if (affectReason != null) {
                this.affectNodeSources(context, subClass, affectReason);
            }
            if (addedField.isPrivate() || !addedField.isStatic()) continue;
            this.affectStaticMemberOnDemandUsages(context, subClass, Collections.emptyList());
        }
        context.affectUsage(changedClassWithSubclasses, node -> {
            if (node instanceof JvmClass) {
                for (Usage usage : node.getUsages()) {
                    if (!(usage instanceof FieldUsage) || !Objects.equals(((FieldUsage)usage).getName(), addedField.getName()) || !changedClassWithSubclasses.contains(usage.getElementOwner())) continue;
                    return true;
                }
            }
            return false;
        });
        return true;
    }

    @Override
    public boolean processRemovedFields(DifferentiateContext context, Difference.Change<JvmClass, JvmClass.Diff> change, Iterable<JvmField> removed, Utils future, Utils present) {
        if (!Iterators.isEmpty(removed)) {
            this.debug("Process removed fields: ");
        }
        return super.processRemovedFields(context, change, removed, future, present);
    }

    @Override
    public boolean processRemovedField(DifferentiateContext context, Difference.Change<JvmClass, JvmClass.Diff> change, JvmField removedField, Utils future, Utils present) {
        JvmClass changedClass = change.getPast();
        this.debug("Field: ", removedField.getName());
        if (!context.getParams().isProcessConstantsIncrementally() && !removedField.isPrivate() && removedField.isInlinable() && removedField.getValue() != null) {
            this.debug("Field had value and was (non-private) final => a switch to non-incremental mode requested");
            if (!this.affectOnNonIncrementalChange(context, changedClass.getReferenceID(), removedField, present)) {
                this.debug("End of Differentiate, returning false");
                return false;
            }
        }
        Set<JvmNodeReferenceID> propagated = present.collectSubclassesWithoutField(changedClass.getReferenceID(), removedField);
        this.affectMemberUsages(context, changedClass.getReferenceID(), removedField, propagated);
        if (!removedField.isPrivate() && removedField.isStatic()) {
            this.debug("The field was static --- affecting static field import usages");
            this.affectStaticMemberImportUsages(context, changedClass.getReferenceID(), removedField.getName(), propagated);
        }
        return true;
    }

    @Override
    public boolean processChangedFields(DifferentiateContext context, Difference.Change<JvmClass, JvmClass.Diff> chng, Iterable<Difference.Change<JvmField, JvmField.Diff>> fieldChanges, Utils future, Utils present) {
        if (!Iterators.isEmpty(fieldChanges)) {
            this.debug("Process changed fields: ");
        }
        return super.processChangedFields(context, chng, fieldChanges, future, present);
    }

    @Override
    public boolean processChangedField(DifferentiateContext context, Difference.Change<JvmClass, JvmClass.Diff> clsChange, Difference.Change<JvmField, JvmField.Diff> fieldChange, Utils future, Utils present) {
        JvmClass changedClass = clsChange.getPast();
        JvmField changedField = fieldChange.getPast();
        JvmField.Diff diff = fieldChange.getDiff();
        this.debug("Field: ", changedField.getName());
        Iterable propagated = Iterators.lazy(() -> future.collectSubclassesWithoutField(changedClass.getReferenceID(), changedField));
        JVMFlags addedFlags = diff.getAddedFlags();
        JVMFlags removedFlags = diff.getRemovedFlags();
        if (!changedField.isPrivate() && changedField.isInlinable() && changedField.getValue() != null) {
            boolean harmful;
            boolean bl = harmful = !Iterators.isEmpty((Iterable)Iterators.filter(List.of(addedFlags, removedFlags), f -> f.isStatic() || f.isFinal()));
            if (harmful || diff.valueChanged() || diff.accessRestricted()) {
                if (context.getParams().isProcessConstantsIncrementally()) {
                    this.debug("Potentially inlined field changed its access or value => affecting field usages and static member import usages");
                    this.affectMemberUsages(context, changedClass.getReferenceID(), changedField, propagated);
                    this.affectStaticMemberImportUsages(context, changedClass.getReferenceID(), changedField.getName(), propagated);
                } else {
                    this.debug("Potentially inlined field changed its access or value => a switch to non-incremental mode requested");
                    if (!this.affectOnNonIncrementalChange(context, changedClass.getReferenceID(), changedField, present)) {
                        this.debug("End of Differentiate, returning false");
                        return false;
                    }
                }
            }
        }
        if (diff.typeChanged() || diff.signatureChanged()) {
            this.debug("Type or signature changed --- affecting field usages");
            this.affectMemberUsages(context, changedClass.getReferenceID(), changedField, propagated);
        } else if (diff.flagsChanged()) {
            if (addedFlags.isStatic() || removedFlags.isStatic() || addedFlags.isPrivate() || addedFlags.isVolatile()) {
                this.debug("Added/removed static modifier or added private/volatile modifier --- affecting field usages");
                this.affectMemberUsages(context, changedClass.getReferenceID(), changedField, propagated);
                if (!changedField.isPrivate()) {
                    if (addedFlags.isStatic()) {
                        this.debug("Added static modifier --- affecting static member on-demand import usages");
                        this.affectStaticMemberOnDemandUsages(context, changedClass.getReferenceID(), propagated);
                    } else if (removedFlags.isStatic()) {
                        this.debug("Removed static modifier --- affecting static field import usages");
                        this.affectStaticMemberImportUsages(context, changedClass.getReferenceID(), changedField.getName(), propagated);
                    }
                }
            } else {
                PackageConstraint constraint = null;
                if (removedFlags.isPublic()) {
                    this.debug("Removed public modifier, affecting field usages with appropriate constraint");
                    constraint = addedFlags.isProtected() ? new InheritanceConstraint(future, changedClass) : new PackageConstraint(changedClass.getPackageName());
                    this.affectMemberUsages(context, changedClass.getReferenceID(), changedField, propagated, constraint);
                } else if (removedFlags.isProtected() && diff.accessRestricted()) {
                    this.debug("Removed protected modifier and the field became less accessible, affecting field usages with package constraint");
                    constraint = new PackageConstraint(changedClass.getPackageName());
                    this.affectMemberUsages(context, changedClass.getReferenceID(), changedField, propagated, constraint);
                }
                if (addedFlags.isFinal()) {
                    this.debug("Added final modifier --- affecting field assign usages");
                    this.affectUsages(context, "field assign", Iterators.flat((Iterable)Iterators.asIterable((Object)changedClass.getReferenceID()), (Iterable)propagated), id -> changedField.createAssignUsage(id.getNodeName()), constraint);
                }
            }
        }
        Difference.Specifier<TypeRepr.ClassType, ?> annotationsDiff = diff.annotations();
        if (!annotationsDiff.unchanged()) {
            EnumSet<AnnotationChangesTracker.Recompile> toRecompile = EnumSet.noneOf(AnnotationChangesTracker.Recompile.class);
            for (AnnotationChangesTracker tracker : ourAnnotationChangeTrackers) {
                if (toRecompile.containsAll(AnnotationChangesTracker.RECOMPILE_ALL)) break;
                Set<AnnotationChangesTracker.Recompile> result = tracker.fieldAnnotationsChanged(changedField, annotationsDiff);
                if (result.contains((Object)AnnotationChangesTracker.Recompile.USAGES)) {
                    this.debug("Extension ", tracker.getClass().getName(), " requested recompilation because of changes in annotations list --- affecting field usages");
                }
                if (result.contains((Object)AnnotationChangesTracker.Recompile.SUBCLASSES)) {
                    this.debug("Extension ", tracker.getClass().getName(), " requested recompilation because of changes in field annotations list --- affecting subclasses");
                }
                toRecompile.addAll(result);
            }
            if (toRecompile.contains((Object)AnnotationChangesTracker.Recompile.USAGES)) {
                this.affectMemberUsages(context, changedClass.getReferenceID(), changedField, propagated);
            }
            if (toRecompile.contains((Object)AnnotationChangesTracker.Recompile.SUBCLASSES)) {
                this.affectSubclasses(context, future, changedClass.getReferenceID(), false);
            }
        }
        return true;
    }

    @Override
    public boolean processAddedModule(DifferentiateContext context, JvmModule addedModule, Utils future, Utils present) {
        this.affectModule(context, future, addedModule);
        return true;
    }

    @Override
    public boolean processRemovedModule(DifferentiateContext context, JvmModule removedModule, Utils future, Utils present) {
        this.affectDependentModules(context, present, removedModule, true, null);
        return true;
    }

    @Override
    public boolean processChangedModule(DifferentiateContext context, Difference.Change<JvmModule, JvmModule.Diff> change, Utils future, Utils present) {
        JvmModule changedModule = change.getPast();
        JvmModule.Diff diff = change.getDiff();
        boolean affectSelf = false;
        boolean affectDeps = false;
        SmartHashSet constraintPackageNames = new SmartHashSet();
        if (diff.versionChanged()) {
            String version = changedModule.getVersion();
            Iterator<Difference.Change<ModuleRequires, ModuleRequires.Diff>> moduleName = changedModule.getName();
            this.affectDependentModules(context, present, changedModule, false, arg_0 -> JavaDifferentiateStrategy.lambda$processChangedModule$31((String)((Object)moduleName), version, arg_0));
        }
        Difference.Specifier<ModuleRequires, ModuleRequires.Diff> requiresDiff = diff.requires();
        for (ModuleRequires removedRequires : requiresDiff.removed()) {
            affectSelf = true;
            if (!removedRequires.isTransitive()) continue;
            affectDeps = true;
            break;
        }
        for (Difference.Change<ModuleRequires, ModuleRequires.Diff> rChange : requiresDiff.changed()) {
            affectSelf |= rChange.getDiff().versionChanged();
            if (!rChange.getDiff().becameNonTransitive()) continue;
            affectDeps = true;
        }
        Difference.Specifier<ModulePackage, ModulePackage.Diff> exportsDiff = diff.exports();
        if (!affectDeps && !Iterators.isEmpty(exportsDiff.removed())) {
            affectDeps = true;
            if (Iterators.isEmpty((Iterable)Iterators.filter(exportsDiff.removed(), modPackage -> !modPackage.isQualified()))) {
                Iterators.collect((Iterable)Iterators.flat((Iterable)Iterators.map(exportsDiff.removed(), modPackage -> modPackage.getModules())), (Collection)constraintPackageNames);
            }
        }
        if (!affectDeps || !constraintPackageNames.isEmpty()) {
            for (Difference.Change<ModulePackage, ModulePackage.Diff> exportChange : exportsDiff.changed()) {
                Iterable<String> removedModuleNames = exportChange.getDiff().targetModules().removed();
                if (!(affectDeps |= !Iterators.isEmpty(removedModuleNames))) continue;
                Iterators.collect(removedModuleNames, (Collection)constraintPackageNames);
            }
        }
        if (affectSelf) {
            this.affectModule(context, present, changedModule);
        }
        if (affectDeps) {
            this.affectDependentModules(context, present, changedModule, true, constraintPackageNames.isEmpty() ? null : arg_0 -> JavaDifferentiateStrategy.lambda$processChangedModule$34((Set)constraintPackageNames, arg_0));
        }
        return true;
    }

    private void affectSubclasses(DifferentiateContext context, Utils utils, ReferenceID fromClass, boolean affectUsages) {
        this.debug("Affecting subclasses of class: ", fromClass, "; with usages affection: ", affectUsages);
        for (ReferenceID cl : utils.withAllSubclasses(fromClass)) {
            String nodeName;
            this.affectNodeSources(context, cl, "Affecting source file: ");
            if (!affectUsages || (nodeName = utils.getNodeName(cl)) == null) continue;
            context.affectUsage(new ClassUsage(nodeName));
            this.debug("Affect usage of class ", nodeName);
        }
    }

    private boolean affectOnNonIncrementalChange(DifferentiateContext context, JvmNodeReferenceID owner, Proto proto, Utils utils) {
        if (proto.isPublic()) {
            this.debug("Public access, switching to a non-incremental mode");
            return false;
        }
        if (proto.isProtected()) {
            this.debug("Protected access, softening non-incremental decision: adding all relevant subclasses for a recompilation");
            this.debug("Root class: ", owner);
            for (ReferenceID id2 : proto instanceof JvmField ? utils.collectSubclassesWithoutField(owner, (JvmField)proto) : utils.allSubclasses(owner)) {
                this.affectNodeSources(context, id2, "Adding ");
            }
        }
        String packageName = JvmClass.getPackageName(owner.getNodeName());
        this.debug("Softening non-incremental decision: adding all package classes for a recompilation");
        this.debug("Package name: ", packageName);
        for (ReferenceID nodeWithinPackage : Iterators.filter(context.getGraph().getRegisteredNodes(), id -> id instanceof JvmNodeReferenceID && packageName.equals(JvmClass.getPackageName(((JvmNodeReferenceID)id).getNodeName())))) {
            this.affectNodeSources(context, nodeWithinPackage, "Adding ");
        }
        return true;
    }

    private void affectModule(DifferentiateContext context, Utils utils, JvmModule mod) {
        this.debug("Affecting module ", mod.getName());
        for (NodeSource source : utils.getNodeSources(mod.getReferenceID())) {
            context.affectNodeSource(source);
            this.debug("Affected source ", source);
        }
    }

    public void affectDependentModules(DifferentiateContext context, Utils utils, JvmModule fromModule, boolean checkTransitive, @Nullable Predicate<Node<?, ?>> constraint) {
        List dependent = !checkTransitive ? Collections.emptyList() : Iterators.recurseDepth((Object)fromModule, mod -> Iterators.filter((Iterable)Iterators.flat((Iterable)Iterators.map(context.getGraph().getDependingNodes(mod.getReferenceID()), id -> utils.getNodes((ReferenceID)id, JvmModule.class))), m -> m.requiresTransitively(mod.getName())), (boolean)false);
        for (JvmModule mod2 : Iterators.flat((Iterable)Iterators.asIterable((Object)fromModule), dependent)) {
            this.debug("Affecting modules depending on module ", mod2.getName());
            ModuleUsage usage = new ModuleUsage(mod2.getReferenceID());
            if (constraint != null) {
                context.affectUsage(usage, constraint);
                continue;
            }
            context.affectUsage(usage);
        }
    }

    private static /* synthetic */ boolean lambda$processChangedModule$34(Set constraintPackageNames, Node node) {
        return node instanceof JvmModule && constraintPackageNames.contains(((JvmModule)node).getName());
    }

    private static /* synthetic */ boolean lambda$processChangedModule$31(String moduleName, String version, Node mod) {
        return mod instanceof JvmModule && !Iterators.isEmpty((Iterable)Iterators.filter(((JvmModule)mod).getRequires(), req -> Objects.equals(moduleName, req.getName()) && Objects.equals(version, req.getVersion())));
    }

    private static /* synthetic */ boolean lambda$processChangedClass$9(Utils future, JvmClass depClass, JvmMethod methodWithSAMType, Node n) {
        return n instanceof JvmClass && future.isVisibleIn(depClass, methodWithSAMType, (JvmClass)n);
    }
}

