/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.java;

import com.intellij.util.SmartList;
import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.dependency.GraphDataInput;
import org.jetbrains.jps.dependency.GraphDataOutput;
import org.jetbrains.jps.dependency.Node;
import org.jetbrains.jps.dependency.diff.DiffCapable;
import org.jetbrains.jps.dependency.diff.Difference;
import org.jetbrains.jps.dependency.impl.RW;
import org.jetbrains.jps.dependency.java.JVMFlags;
import org.jetbrains.jps.dependency.java.JvmNodeReferenceID;
import org.jetbrains.jps.dependency.java.MethodUsage;
import org.jetbrains.jps.dependency.java.ParamAnnotation;
import org.jetbrains.jps.dependency.java.ProtoMember;
import org.jetbrains.jps.dependency.java.TypeRepr;
import org.jetbrains.jps.javac.Iterators;
import org.jetbrains.org.objectweb.asm.Type;

public final class JvmMethod
extends ProtoMember
implements DiffCapable<JvmMethod, Diff> {
    private final Iterable<TypeRepr> myArgTypes;
    private final Iterable<ParamAnnotation> myParamAnnotations;
    private final Iterable<TypeRepr.ClassType> myExceptions;

    public JvmMethod(JVMFlags flags, String signature, String name, String descriptor, @NotNull Iterable<TypeRepr.ClassType> annotations, Iterable<ParamAnnotation> parameterAnnotations, Iterable<String> exceptions, Object defaultValue) {
        if (annotations == null) {
            JvmMethod.$$$reportNull$$$0(0);
        }
        super(flags, signature, name, TypeRepr.getType(Type.getReturnType((String)descriptor)), annotations, defaultValue);
        this.myParamAnnotations = parameterAnnotations;
        this.myExceptions = Iterators.collect((Iterable)Iterators.map(exceptions, s -> new TypeRepr.ClassType((String)s)), (Collection)new SmartList());
        this.myArgTypes = TypeRepr.getTypes(Type.getArgumentTypes((String)descriptor));
    }

    public JvmMethod(GraphDataInput in) throws IOException {
        super(in);
        this.myArgTypes = RW.readCollection(in, () -> TypeRepr.getType(in.readUTF()));
        this.myParamAnnotations = RW.readCollection(in, () -> {
            int index = in.readInt();
            String jvmName = in.readUTF();
            return new ParamAnnotation(index, new TypeRepr.ClassType(jvmName));
        });
        this.myExceptions = RW.readCollection(in, () -> new TypeRepr.ClassType(in.readUTF()));
    }

    @Override
    public void write(GraphDataOutput out) throws IOException {
        super.write(out);
        RW.writeCollection(out, this.myArgTypes, t -> out.writeUTF(t.getDescriptor()));
        RW.writeCollection(out, this.myParamAnnotations, pa -> {
            out.writeInt(pa.paramIndex);
            out.writeUTF(pa.type.getJvmName());
        });
        RW.writeCollection(out, this.myExceptions, t -> out.writeUTF(t.getJvmName()));
    }

    public boolean isConstructor() {
        return "<init>".equals(this.getName());
    }

    @Override
    public MethodUsage createUsage(JvmNodeReferenceID owner) {
        return new MethodUsage(owner, this.getName(), this.getDescriptor());
    }

    public Predicate<Node<?, ?>> createUsageQuery(JvmNodeReferenceID owner) {
        String thisMethodName = this.getName();
        return n -> Iterators.find(n.getUsages(), u -> u instanceof MethodUsage && owner.equals(u.getElementOwner()) && Objects.equals(((MethodUsage)u).getName(), thisMethodName)) != null;
    }

    public Iterable<ParamAnnotation> getParamAnnotations() {
        return this.myParamAnnotations;
    }

    public Iterable<TypeRepr.ClassType> getExceptions() {
        return this.myExceptions;
    }

    public Iterable<TypeRepr> getArgTypes() {
        return this.myArgTypes;
    }

    public boolean isSameByJavaRules(JvmMethod other) {
        return this.getName().equals(other.getName()) && Iterators.equals(this.myArgTypes, other.myArgTypes);
    }

    @Override
    public boolean isSame(DiffCapable<?, ?> other) {
        if (!(other instanceof JvmMethod)) {
            return false;
        }
        JvmMethod that = (JvmMethod)other;
        return Objects.equals(this.getType(), that.getType()) && this.isSameByJavaRules(that);
    }

    @Override
    public int diffHashCode() {
        return 31 * (31 * Iterators.hashCode(this.myArgTypes) + this.getType().hashCode()) + this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof JvmMethod && this.isSame((JvmMethod)obj);
    }

    public int hashCode() {
        return this.diffHashCode();
    }

    @Override
    public Diff difference(JvmMethod past) {
        return new Diff(past);
    }

    public String getDescriptor() {
        return JvmMethod.getDescriptor(this.myArgTypes, this.getType());
    }

    @NotNull
    public static String getDescriptor(Iterable<TypeRepr> argTypes, @NotNull TypeRepr returnType) {
        if (returnType == null) {
            JvmMethod.$$$reportNull$$$0(1);
        }
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        for (TypeRepr t : argTypes) {
            buf.append(t.getDescriptor());
        }
        buf.append(")");
        buf.append(returnType.getDescriptor());
        String string = buf.toString();
        if (string == null) {
            JvmMethod.$$$reportNull$$$0(2);
        }
        return string;
    }

    public String toString() {
        return this.getName() + this.getDescriptor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/dependency/java/JvmMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/dependency/java/JvmMethod";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptor";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public final class Diff
    extends ProtoMember.Diff<JvmMethod> {
        public Diff(JvmMethod past) {
            super((ProtoMember)JvmMethod.this, (ProtoMember)past);
        }

        @Override
        public boolean unchanged() {
            return super.unchanged() && this.paramAnnotations().unchanged() && this.exceptions().unchanged();
        }

        public Difference.Specifier<ParamAnnotation, ?> paramAnnotations() {
            return Difference.diff(((JvmMethod)this.myPast).getParamAnnotations(), JvmMethod.this.getParamAnnotations());
        }

        public Difference.Specifier<TypeRepr.ClassType, ?> exceptions() {
            return Difference.diff(((JvmMethod)this.myPast).getExceptions(), JvmMethod.this.getExceptions());
        }
    }
}

