/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.java;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import kotlin.Metadata;
import kotlinx.metadata.Attributes;
import kotlinx.metadata.KmDeclarationContainer;
import kotlinx.metadata.KmFunction;
import kotlinx.metadata.KmProperty;
import kotlinx.metadata.KmType;
import kotlinx.metadata.KmValueParameter;
import kotlinx.metadata.jvm.JvmExtensionsKt;
import kotlinx.metadata.jvm.KotlinClassHeader;
import kotlinx.metadata.jvm.KotlinClassMetadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.dependency.GraphDataInput;
import org.jetbrains.jps.dependency.GraphDataOutput;
import org.jetbrains.jps.dependency.diff.DiffCapable;
import org.jetbrains.jps.dependency.diff.Difference;
import org.jetbrains.jps.dependency.impl.RW;
import org.jetbrains.jps.dependency.java.JvmMetadata;

public final class KotlinMeta
implements JvmMetadata<KotlinMeta, Diff> {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private final int myKind;
    private final int @NotNull [] myVersion;
    private final String @NotNull [] myData1;
    private final String @NotNull [] myData2;
    @NotNull
    private final String myExtraString;
    @NotNull
    private final String myPackageName;
    private final int myExtraInt;
    private KotlinClassMetadata[] myCachedMeta;

    public KotlinMeta(int kind, int @Nullable [] version, String @Nullable [] data1, String @Nullable [] data2, @Nullable String extraString, @Nullable String packageName, int extraInt) {
        this.myKind = kind;
        this.myVersion = version != null ? version : EMPTY_INT_ARRAY;
        this.myData1 = data1 != null ? data1 : EMPTY_STRING_ARRAY;
        this.myData2 = data2 != null ? data2 : EMPTY_STRING_ARRAY;
        this.myExtraString = extraString != null ? extraString : "";
        this.myPackageName = packageName != null ? packageName : "";
        this.myExtraInt = extraInt;
    }

    public KotlinMeta(GraphDataInput in) throws IOException {
        this.myKind = in.readInt();
        int versionsCount = in.readInt();
        this.myVersion = versionsCount > 0 ? new int[versionsCount] : EMPTY_INT_ARRAY;
        for (int idx = 0; idx < versionsCount; ++idx) {
            this.myVersion[idx] = in.readInt();
        }
        this.myData1 = RW.readCollection(in, in::readUTF).toArray(EMPTY_STRING_ARRAY);
        this.myData2 = RW.readCollection(in, in::readUTF).toArray(EMPTY_STRING_ARRAY);
        this.myExtraString = in.readUTF();
        this.myPackageName = in.readUTF();
        this.myExtraInt = in.readInt();
    }

    @Override
    public void write(GraphDataOutput out) throws IOException {
        out.writeInt(this.myKind);
        out.writeInt(this.myVersion.length);
        for (int elem : this.myVersion) {
            out.writeInt(elem);
        }
        RW.writeCollection(out, Arrays.asList(this.myData1), out::writeUTF);
        RW.writeCollection(out, Arrays.asList(this.myData2), out::writeUTF);
        out.writeUTF(this.myExtraString);
        out.writeUTF(this.myPackageName);
        out.writeInt(this.myExtraInt);
    }

    public int getKind() {
        return this.myKind;
    }

    public int @NotNull [] getVersion() {
        if (this.myVersion == null) {
            KotlinMeta.$$$reportNull$$$0(0);
        }
        return this.myVersion;
    }

    public String @NotNull [] getData1() {
        if (this.myData1 == null) {
            KotlinMeta.$$$reportNull$$$0(1);
        }
        return this.myData1;
    }

    public String @NotNull [] getData2() {
        if (this.myData2 == null) {
            KotlinMeta.$$$reportNull$$$0(2);
        }
        return this.myData2;
    }

    @NotNull
    public String getExtraString() {
        String string = this.myExtraString;
        if (string == null) {
            KotlinMeta.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getPackageName() {
        String string = this.myPackageName;
        if (string == null) {
            KotlinMeta.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public Integer getExtraInt() {
        Integer n = this.myExtraInt;
        if (n == null) {
            KotlinMeta.$$$reportNull$$$0(5);
        }
        return n;
    }

    @Override
    public boolean isSame(DiffCapable<?, ?> other) {
        return other instanceof KotlinMeta;
    }

    @Override
    public int diffHashCode() {
        return KotlinMeta.class.hashCode();
    }

    @Override
    public Diff difference(KotlinMeta past) {
        return new Diff(past);
    }

    public KotlinClassMetadata getClassMetadata() {
        if (this.myCachedMeta == null) {
            try {
                this.myCachedMeta = new KotlinClassMetadata[]{KotlinClassMetadata.readLenient((Metadata)new KotlinClassHeader(Integer.valueOf(this.getKind()), this.getVersion(), this.getData1(), this.getData2(), this.getExtraString(), this.getPackageName(), this.getExtraInt()))};
            }
            catch (Throwable e) {
                this.myCachedMeta = new KotlinClassMetadata[]{null};
            }
        }
        return this.myCachedMeta[0];
    }

    public Iterable<KmProperty> getKmProperties() {
        KmDeclarationContainer container = this.getDeclarationContainer();
        return container != null ? container.getProperties() : Collections.emptyList();
    }

    public Iterable<KmFunction> getKmFunctions() {
        KmDeclarationContainer container = this.getDeclarationContainer();
        return container != null ? container.getFunctions() : Collections.emptyList();
    }

    @Nullable
    public KmDeclarationContainer getDeclarationContainer() {
        KotlinClassMetadata clsMeta = this.getClassMetadata();
        if (clsMeta instanceof KotlinClassMetadata.Class) {
            return ((KotlinClassMetadata.Class)clsMeta).getKmClass();
        }
        if (clsMeta instanceof KotlinClassMetadata.FileFacade) {
            return ((KotlinClassMetadata.FileFacade)clsMeta).getKmPackage();
        }
        if (clsMeta instanceof KotlinClassMetadata.MultiFileClassPart) {
            return ((KotlinClassMetadata.MultiFileClassPart)clsMeta).getKmPackage();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/jps/dependency/java/KotlinMeta";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getData1";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getData2";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraString";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraInt";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public final class Diff
    implements Difference {
        private final KotlinMeta myPast;

        Diff(KotlinMeta past) {
            this.myPast = past;
        }

        @Override
        public boolean unchanged() {
            return !this.kindChanged() && !this.versionChanged() && !this.packageChanged() && !this.extraChanged() && !this.functions().unchanged() && !this.properties().unchanged();
        }

        public boolean kindChanged() {
            return this.myPast.myKind != KotlinMeta.this.myKind;
        }

        public boolean versionChanged() {
            return !Arrays.equals(this.myPast.myVersion, KotlinMeta.this.myVersion);
        }

        public boolean packageChanged() {
            return !Objects.equals(this.myPast.myPackageName, KotlinMeta.this.myPackageName);
        }

        public boolean extraChanged() {
            return this.myPast.myExtraInt != KotlinMeta.this.myExtraInt || !Objects.equals(this.myPast.myExtraString, KotlinMeta.this.myExtraString);
        }

        public Difference.Specifier<KmFunction, KmFunctionsDiff> functions() {
            return Difference.deepDiff(this.myPast.getKmFunctions(), KotlinMeta.this.getKmFunctions(), (f1, f2) -> Objects.equals(JvmExtensionsKt.getSignature((KmFunction)f1), JvmExtensionsKt.getSignature((KmFunction)f2)), f -> Objects.hashCode(JvmExtensionsKt.getSignature((KmFunction)f)), KmFunctionsDiff::new);
        }

        public Difference.Specifier<KmProperty, KmPropertiesDiff> properties() {
            return Difference.deepDiff(this.myPast.getKmProperties(), KotlinMeta.this.getKmProperties(), (p1, p2) -> Objects.equals(p1.getName(), p2.getName()), p -> Objects.hashCode(p.getName()), KmPropertiesDiff::new);
        }
    }

    public static final class KmPropertiesDiff
    implements Difference {
        private final KmProperty past;
        private final KmProperty now;

        public KmPropertiesDiff(KmProperty past, KmProperty now) {
            this.past = past;
            this.now = now;
        }

        @Override
        public boolean unchanged() {
            return !this.nullabilityChanged();
        }

        public boolean nullabilityChanged() {
            return !Objects.equals(this.past.getReturnType(), this.now.getReturnType());
        }

        public boolean becameNullable() {
            return !Attributes.isNullable((KmType)this.past.getReturnType()) && Attributes.isNullable((KmType)this.now.getReturnType());
        }

        public boolean becameNotNull() {
            return Attributes.isNullable((KmType)this.past.getReturnType()) && !Attributes.isNullable((KmType)this.now.getReturnType());
        }
    }

    public static final class KmFunctionsDiff
    implements Difference {
        private final KmFunction past;
        private final KmFunction now;

        public KmFunctionsDiff(KmFunction past, KmFunction now) {
            this.past = past;
            this.now = now;
        }

        @Override
        public boolean unchanged() {
            return !this.becameNullable() && !this.argsBecameNotNull();
        }

        public boolean becameNullable() {
            return !Attributes.isNullable((KmType)this.past.getReturnType()) && Attributes.isNullable((KmType)this.now.getReturnType());
        }

        public boolean argsBecameNotNull() {
            Iterator nowIt = this.now.getValueParameters().iterator();
            for (KmValueParameter pastParam : this.past.getValueParameters()) {
                KmValueParameter nowParam = (KmValueParameter)nowIt.next();
                if (!Attributes.isNullable((KmType)pastParam.getType()) || Attributes.isNullable((KmType)nowParam.getType())) continue;
                return true;
            }
            return false;
        }
    }
}

