/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.java;

import java.io.IOException;
import org.jetbrains.jps.dependency.GraphDataInput;
import org.jetbrains.jps.dependency.GraphDataOutput;
import org.jetbrains.jps.dependency.java.JvmElementUsage;
import org.jetbrains.jps.dependency.java.JvmNodeReferenceID;

public abstract class MemberUsage
extends JvmElementUsage {
    private final String myName;

    protected MemberUsage(String className, String name) {
        this(new JvmNodeReferenceID(className), name);
    }

    protected MemberUsage(JvmNodeReferenceID clsId, String name) {
        super(clsId);
        this.myName = name;
    }

    MemberUsage(GraphDataInput in) throws IOException {
        super(in);
        this.myName = in.readUTF();
    }

    @Override
    public void write(GraphDataOutput out) throws IOException {
        super.write(out);
        out.writeUTF(this.myName);
    }

    public String getName() {
        return this.myName;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        MemberUsage that = (MemberUsage)o;
        return this.myName.equals(that.myName);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.myName.hashCode();
    }
}

