/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.java;

import com.intellij.openapi.util.Pair;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.dependency.BackDependencyIndex;
import org.jetbrains.jps.dependency.DifferentiateContext;
import org.jetbrains.jps.dependency.Graph;
import org.jetbrains.jps.dependency.NodeSource;
import org.jetbrains.jps.dependency.ReferenceID;
import org.jetbrains.jps.dependency.diff.DiffCapable;
import org.jetbrains.jps.dependency.impl.Containers;
import org.jetbrains.jps.dependency.java.JVMClassNode;
import org.jetbrains.jps.dependency.java.JVMFlags;
import org.jetbrains.jps.dependency.java.JvmClass;
import org.jetbrains.jps.dependency.java.JvmField;
import org.jetbrains.jps.dependency.java.JvmMethod;
import org.jetbrains.jps.dependency.java.JvmModule;
import org.jetbrains.jps.dependency.java.JvmNodeReferenceID;
import org.jetbrains.jps.dependency.java.ProtoMember;
import org.jetbrains.jps.dependency.java.TypeRepr;
import org.jetbrains.jps.javac.Iterators;

public final class Utils {
    @NotNull
    private final DifferentiateContext myContext;
    @NotNull
    private final Graph myGraph;
    @Nullable
    private final Graph myDelta;
    @NotNull
    private final BackDependencyIndex myDirectSubclasses;

    public Utils(@NotNull DifferentiateContext context, boolean isDelta) {
        if (context == null) {
            Utils.$$$reportNull$$$0(0);
        }
        this.myContext = context;
        this.myGraph = context.getGraph();
        this.myDelta = isDelta ? context.getDelta() : null;
        this.myDirectSubclasses = Objects.requireNonNull(this.myGraph.getIndex("direct-subclasses"));
    }

    public Iterable<NodeSource> getNodeSources(ReferenceID nodeId) {
        Iterable sources = this.myDelta != null ? this.myDelta.getSources(nodeId) : null;
        return sources != null ? sources : Iterators.filter(this.myGraph.getSources(nodeId), this.myContext.getParams().affectionFilter()::test);
    }

    public Iterable<JvmClass> getClassesByName(@NotNull String name) {
        if (name == null) {
            Utils.$$$reportNull$$$0(1);
        }
        return this.getNodes(new JvmNodeReferenceID(name), JvmClass.class);
    }

    public Iterable<JvmModule> getModulesByName(@NotNull String name) {
        if (name == null) {
            Utils.$$$reportNull$$$0(2);
        }
        return this.getNodes(new JvmNodeReferenceID(name), JvmModule.class);
    }

    @Nullable
    public String getNodeName(ReferenceID id) {
        if (id instanceof JvmNodeReferenceID) {
            return ((JvmNodeReferenceID)id).getNodeName();
        }
        Iterable<JVMClassNode> nodes = this.getNodes(id, JVMClassNode.class);
        Iterator<JVMClassNode> iterator = nodes.iterator();
        if (iterator.hasNext()) {
            JVMClassNode node = iterator.next();
            return node.getName();
        }
        return null;
    }

    public boolean isLambdaTarget(ReferenceID classId) {
        return !Iterators.isEmpty((Iterable)Iterators.filter(this.getNodes(classId, JvmClass.class), this::isLambdaTarget));
    }

    public boolean isLambdaTarget(JvmClass cls) {
        if (cls.isInterface()) {
            int amFound = 0;
            for (JvmMethod method : this.allMethodsRecursively(cls)) {
                if (method.isAbstract() && ++amFound > 1) break;
            }
            if (amFound == 1) {
                return true;
            }
        }
        return false;
    }

    public Iterable<JvmMethod> allMethodsRecursively(JvmClass cls) {
        return Iterators.flat((Iterable)Iterators.map((Iterable)Iterators.recurse((Object)cls, c -> Iterators.flat((Iterable)Iterators.map(c.getSuperTypes(), st -> this.getClassesByName((String)st))), (boolean)true), c -> c.getMethods()));
    }

    public <T extends JVMClassNode<T, ?>> Iterable<T> getNodes(@NotNull ReferenceID id, Class<T> selector) {
        Iterable allNodes;
        if (id == null) {
            Utils.$$$reportNull$$$0(3);
        }
        if (id instanceof JvmNodeReferenceID && "".equals(((JvmNodeReferenceID)id).getNodeName())) {
            return Collections.emptyList();
        }
        Predicate<? super NodeSource> srcFilter = this.myContext.getParams().affectionFilter();
        if (this.myDelta != null) {
            Set deltaSources = (Set)Iterators.collect(this.myDelta.getSources(id), new HashSet());
            allNodes = Iterators.flat((Iterable)Iterators.flat((Iterable)Iterators.map((Iterable)deltaSources, src -> this.myDelta.getNodes((NodeSource)src, selector))), (Iterable)Iterators.flat((Iterable)Iterators.map((Iterable)Iterators.filter(this.myGraph.getSources(id), src -> !deltaSources.contains(src) && srcFilter.test((NodeSource)src)), src -> this.myGraph.getNodes((NodeSource)src, selector))));
        } else {
            allNodes = Iterators.flat((Iterable)Iterators.map((Iterable)Iterators.filter(this.myGraph.getSources(id), srcFilter::test), src -> this.myGraph.getNodes((NodeSource)src, selector)));
        }
        return Iterators.uniqueBy((Iterable)Iterators.filter((Iterable)allNodes, n -> id.equals(n.getReferenceID())), () -> new Iterators.BooleanFunction<T>(){
            Set<T> visited;

            public boolean fun(T t) {
                if (this.visited == null) {
                    this.visited = Containers.createCustomPolicySet(DiffCapable::isSame, DiffCapable::diffHashCode);
                }
                return this.visited.add(t);
            }
        });
    }

    public Iterable<JvmNodeReferenceID> allDirectSupertypes(JvmNodeReferenceID classId) {
        return Iterators.unique((Iterable)Iterators.flat((Iterable)Iterators.map(this.getNodes(classId, JvmClass.class), cl -> Iterators.flat((Iterable)Iterators.map(cl.getSuperTypes(), st -> Iterators.map(this.getNodes(new JvmNodeReferenceID((String)st), JvmClass.class), JVMClassNode::getReferenceID))))));
    }

    public Iterable<JvmClass> allDirectSupertypes(JvmClass cls) {
        return Iterators.flat((Iterable)Iterators.map(cls.getSuperTypes(), st -> this.getNodes(new JvmNodeReferenceID((String)st), JvmClass.class)));
    }

    public Iterable<JvmNodeReferenceID> allSupertypes(JvmNodeReferenceID classId) {
        return Iterators.recurse((Object)classId, this::allDirectSupertypes, (boolean)false);
    }

    @NotNull
    public Iterable<ReferenceID> withAllSubclasses(ReferenceID from) {
        Iterable iterable = Iterators.recurse((Object)from, this.myDirectSubclasses::getDependencies, (boolean)true);
        if (iterable == null) {
            Utils.$$$reportNull$$$0(4);
        }
        return iterable;
    }

    @NotNull
    public Iterable<ReferenceID> allSubclasses(ReferenceID from) {
        Iterable iterable = Iterators.recurse((Object)from, this.myDirectSubclasses::getDependencies, (boolean)false);
        if (iterable == null) {
            Utils.$$$reportNull$$$0(5);
        }
        return iterable;
    }

    public Set<JvmNodeReferenceID> collectSubclassesWithoutField(JvmNodeReferenceID classId, JvmField field) {
        return this.collectSubclassesWithoutMember(classId, f -> Objects.equals(field.getName(), f.getName()), JvmClass::getFields);
    }

    public Set<JvmNodeReferenceID> collectSubclassesWithoutMethod(JvmNodeReferenceID classId, JvmMethod method) {
        return this.collectSubclassesWithoutMember(classId, method::isSame, JvmClass::getMethods);
    }

    private <T extends ProtoMember> Set<JvmNodeReferenceID> collectSubclassesWithoutMember(JvmNodeReferenceID classId, Predicate<? super T> isSame, Function<JvmClass, Iterable<T>> membersGetter) {
        Predicate<ReferenceID> containsMember = id -> Iterators.isEmpty((Iterable)Iterators.filter(this.getNodes((ReferenceID)id, (Class)JvmClass.class), cls -> Iterators.isEmpty((Iterable)Iterators.filter((Iterable)((Iterable)membersGetter.apply((JvmClass)cls)), isSame::test))));
        Iterable<JvmNodeReferenceID> result = Utils.getNodesData(classId, id -> this.myDirectSubclasses.getDependencies((ReferenceID)id), id -> id instanceof JvmNodeReferenceID && !containsMember.test((ReferenceID)id) ? (JvmNodeReferenceID)id : null, Objects::nonNull, false);
        return (Set)Iterators.collect((Iterable)Iterators.filter(result, (Iterators.BooleanFunction)Iterators.notNullFilter()), new HashSet());
    }

    public Iterable<Pair<JvmClass, JvmField>> getOverriddenFields(JvmClass fromCls, JvmField field) {
        Function<JvmClass, Iterable> dataGetter = cl -> Iterators.collect((Iterable)Iterators.map((Iterable)Iterators.filter(cl.getFields(), f -> Objects.equals(f.getName(), field.getName()) && this.isVisibleInHierarchy((JvmClass)cl, (ProtoMember)f, fromCls)), ff -> Pair.create((Object)cl, (Object)ff)), (Collection)new SmartList());
        return Iterators.flat(Utils.getNodesData(fromCls, cl -> Iterators.flat((Iterable)Iterators.map(cl.getSuperTypes(), st -> this.getClassesByName((String)st))), dataGetter, result -> Iterators.isEmpty((Iterable)result), false));
    }

    public Iterable<Pair<JvmClass, JvmMethod>> getOverriddenMethods(JvmClass fromCls, Predicate<JvmMethod> searchCond) {
        Function<JvmClass, Iterable> dataGetter = cl -> Iterators.collect((Iterable)Iterators.map((Iterable)Iterators.filter(cl.getMethods(), m -> searchCond.test((JvmMethod)m) && this.isVisibleInHierarchy((JvmClass)cl, (ProtoMember)m, fromCls)), mm -> Pair.create((Object)cl, (Object)mm)), (Collection)new SmartList());
        return Iterators.flat(Utils.getNodesData(fromCls, cl -> Iterators.flat((Iterable)Iterators.map(cl.getSuperTypes(), st -> this.getClassesByName((String)st))), dataGetter, result -> Iterators.isEmpty((Iterable)result), false));
    }

    public Iterable<Pair<JvmClass, JvmMethod>> getOverridingMethods(JvmClass fromCls, JvmMethod method, Predicate<JvmMethod> searchCond) {
        Function<JvmClass, Iterable> dataGetter = cl -> this.isVisibleInHierarchy(fromCls, method, (JvmClass)cl) ? Iterators.collect((Iterable)Iterators.map((Iterable)Iterators.filter(cl.getMethods(), searchCond::test), mm -> Pair.create((Object)cl, (Object)mm)), (Collection)new SmartList()) : Collections.emptyList();
        return Iterators.flat(Utils.getNodesData(fromCls, cl -> Iterators.flat((Iterable)Iterators.map(this.myDirectSubclasses.getDependencies(cl.getReferenceID()), st -> this.getNodes((ReferenceID)st, (Class)JvmClass.class))), dataGetter, result -> Iterators.isEmpty((Iterable)result), false));
    }

    public Iterable<OverloadDescriptor> findAllOverloads(JvmClass cls, Function<? super JvmMethod, JVMFlags> correspondenceFinder) {
        Function<JvmClass, Iterable> mapper = c -> Iterators.filter((Iterable)Iterators.map(c.getMethods(), m -> {
            JVMFlags accessScope = (JVMFlags)correspondenceFinder.apply((JvmMethod)m);
            return accessScope != null ? new OverloadDescriptor(accessScope, (JvmMethod)m, (JvmClass)c) : null;
        }), (Iterators.BooleanFunction)Iterators.notNullFilter());
        return Iterators.flat((Iterable)Iterators.flat((Iterable)Iterators.map((Iterable)Iterators.recurse((Object)cls, cl -> Iterators.flat((Iterable)Iterators.map(cl.getSuperTypes(), st -> this.getClassesByName((String)st))), (boolean)true), cl -> (Iterable)mapper.apply((JvmClass)cl))), (Iterable)Iterators.flat((Iterable)Iterators.map(this.allSubclasses(cls.getReferenceID()), id -> Iterators.flat((Iterable)Iterators.map(this.getNodes((ReferenceID)id, (Class)JvmClass.class), cl -> (Iterable)mapper.apply((JvmClass)cl))))));
    }

    private static <N, V> Iterable<V> getNodesData(N fromNode, Function<? super N, ? extends Iterable<? extends N>> step, Function<N, V> dataGetter, Predicate<V> continuationCond, boolean includeHead) {
        Function mapper = Utils.cachingFunction(dataGetter);
        return Iterators.map((Iterable)Iterators.recurseDepth(fromNode, node -> fromNode.equals(node) || continuationCond.test(mapper.apply(node)) ? (List)step.apply((Object)node) : Collections.emptyList(), (boolean)includeHead), mapper::apply);
    }

    public boolean hasOverriddenMethods(JvmClass cls, JvmMethod method) {
        return !Iterators.isEmpty(this.getOverriddenMethods(cls, method::isSameByJavaRules)) || this.inheritsFromLibraryClass(cls);
    }

    boolean isFieldVisible(JvmClass cls, JvmField field) {
        return !Iterators.isEmpty((Iterable)Iterators.filter(cls.getFields(), field::isSame)) || !Iterators.isEmpty(this.getOverriddenFields(cls, field));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isMethodVisible(JvmClass cls, JvmMethod method) {
        if (!Iterators.isEmpty((Iterable)Iterators.filter(cls.getMethods(), method::isSameByJavaRules))) return true;
        if (Iterators.isEmpty(this.getOverriddenMethods(cls, method::isSameByJavaRules))) return false;
        return true;
    }

    private boolean isVisibleInHierarchy(JvmClass cls, ProtoMember clsMember, JvmClass subClass) {
        return clsMember.isProtected() || this.isVisibleIn(cls, clsMember, subClass);
    }

    public boolean isVisibleIn(JvmClass cls, ProtoMember clsMember, JvmClass scope) {
        if (clsMember.isPrivate()) {
            return Objects.equals(cls.getReferenceID(), scope.getReferenceID());
        }
        if (clsMember.isPackageLocal()) {
            return Objects.equals(cls.getPackageName(), scope.getPackageName());
        }
        if (clsMember.isProtected()) {
            return Objects.equals(cls.getPackageName(), scope.getPackageName()) || this.isInheritorOf(scope, cls);
        }
        return true;
    }

    public boolean isInheritorOf(JvmClass who, JvmClass whom) {
        return !Iterators.isEmpty((Iterable)Iterators.filter((Iterable)Iterators.recurseDepth((Object)who, cl -> Iterators.flat((Iterable)Iterators.map(who.getSuperTypes(), st -> this.getClassesByName((String)st))), (boolean)true), cl -> cl.getReferenceID().equals(whom.getReferenceID())));
    }

    public boolean inheritsFromLibraryClass(JvmClass cls) {
        for (String st : cls.getSuperTypes()) {
            Iterator<JvmClass> classes = this.getClassesByName(st).iterator();
            if (!classes.hasNext()) {
                return true;
            }
            while (classes.hasNext()) {
                if (!this.inheritsFromLibraryClass(classes.next())) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public Boolean isInheritorOf(JvmNodeReferenceID who, JvmNodeReferenceID whom) {
        if (who.equals(whom) || !Iterators.isEmpty((Iterable)Iterators.filter(this.allSupertypes(who), st -> st.equals(whom)))) {
            return Boolean.TRUE;
        }
        return null;
    }

    public Predicate<JvmMethod> lessSpecific(JvmMethod than) {
        return m -> {
            if (m.isConstructor() || !Objects.equals(m.getName(), than.getName())) {
                return false;
            }
            Iterator<TypeRepr> it = m.getArgTypes().iterator();
            for (TypeRepr thanArgType : than.getArgTypes()) {
                if (!it.hasNext()) {
                    return false;
                }
                TypeRepr mArgType = it.next();
                Boolean subtypeOf = this.isSubtypeOf(thanArgType, mArgType);
                if (subtypeOf == null || subtypeOf.booleanValue()) continue;
                return false;
            }
            return !it.hasNext();
        };
    }

    @Nullable
    public Boolean isSubtypeOf(TypeRepr who, TypeRepr whom) {
        if (who.equals(whom)) {
            return Boolean.TRUE;
        }
        if (who instanceof TypeRepr.PrimitiveType || whom instanceof TypeRepr.PrimitiveType) {
            return Boolean.FALSE;
        }
        if (who instanceof TypeRepr.ArrayType) {
            if (whom instanceof TypeRepr.ArrayType) {
                return this.isSubtypeOf(((TypeRepr.ArrayType)who).getElementType(), ((TypeRepr.ArrayType)whom).getElementType());
            }
            String descr = whom.getDescriptor();
            if ("Ljava/lang/Cloneable;".equals(descr) || "Ljava/lang/Object;".equals(descr) || "Ljava/io/Serializable;".equals(descr)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (whom instanceof TypeRepr.ClassType) {
            return this.isInheritorOf(new JvmNodeReferenceID(((TypeRepr.ClassType)who).getJvmName()), new JvmNodeReferenceID(((TypeRepr.ClassType)whom).getJvmName()));
        }
        return Boolean.FALSE;
    }

    private static <K, V> Function<K, V> cachingFunction(Function<K, V> f) {
        HashMap cache = new HashMap();
        return k -> cache.computeIfAbsent(k, f);
    }

    public static <V> Iterators.Provider<V> lazyValue(final Iterators.Provider<V> provider) {
        return new Iterators.Provider<V>(){
            private Object[] computed;

            public V get() {
                Object object;
                if (this.computed == null) {
                    this.computed = new Object[]{provider.get()};
                    object = this.computed[0];
                } else {
                    object = this.computed[0];
                }
                return object;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/dependency/java/Utils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/dependency/java/Utils";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "withAllSubclasses";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "allSubclasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getClassesByName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getModulesByName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getNodes";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class OverloadDescriptor {
        final JVMFlags accessScope;
        final JvmMethod overloadMethod;
        final JvmClass owner;

        OverloadDescriptor(JVMFlags accessScope, JvmMethod overloadMethod, JvmClass owner) {
            this.accessScope = accessScope;
            this.overloadMethod = overloadMethod;
            this.owner = owner;
        }
    }
}

