/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.kotlin;

import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kotlinx.metadata.Attributes;
import kotlinx.metadata.KmClass;
import kotlinx.metadata.KmDeclarationContainer;
import kotlinx.metadata.KmFunction;
import kotlinx.metadata.KmProperty;
import kotlinx.metadata.KmTypeAlias;
import kotlinx.metadata.Modality;
import kotlinx.metadata.jvm.JvmExtensionsKt;
import kotlinx.metadata.jvm.JvmMethodSignature;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.dependency.DifferentiateContext;
import org.jetbrains.jps.dependency.Node;
import org.jetbrains.jps.dependency.ReferenceID;
import org.jetbrains.jps.dependency.diff.Difference;
import org.jetbrains.jps.dependency.java.ClassNewUsage;
import org.jetbrains.jps.dependency.java.ImportPackageOnDemandUsage;
import org.jetbrains.jps.dependency.java.JVMClassNode;
import org.jetbrains.jps.dependency.java.JvmClass;
import org.jetbrains.jps.dependency.java.JvmDifferentiateStrategyImpl;
import org.jetbrains.jps.dependency.java.JvmField;
import org.jetbrains.jps.dependency.java.JvmMethod;
import org.jetbrains.jps.dependency.java.JvmNodeReferenceID;
import org.jetbrains.jps.dependency.java.KotlinMeta;
import org.jetbrains.jps.dependency.java.MethodUsage;
import org.jetbrains.jps.dependency.java.TypeRepr;
import org.jetbrains.jps.dependency.java.Utils;
import org.jetbrains.jps.javac.Iterators;

public final class KotlinAwareJavaDifferentiateStrategy
extends JvmDifferentiateStrategyImpl {
    @Override
    public boolean processAddedClass(DifferentiateContext context, JvmClass addedClass, Utils future, Utils present) {
        for (JvmClass superClass : Iterators.filter(future.allDirectSupertypes(addedClass), KotlinAwareJavaDifferentiateStrategy::isSealed)) {
            this.affectNodeSources(context, superClass.getReferenceID(), "Subclass of a sealed class was added, affecting ");
        }
        if (!addedClass.isPrivate() && addedClass.getOuterFqName().isEmpty()) {
            String packageName = addedClass.getPackageName();
            String matchName = addedClass.getShortName();
            this.debug("Affecting classes within a package '", packageName, "' (or those on-demand importing the package) that have usages of methods or class constructors named '", matchName, "' or with name starting with '", matchName, "$'");
            context.affectUsage(new ImportPackageOnDemandUsage(packageName), n -> {
                KmDeclarationContainer container = KotlinAwareJavaDifferentiateStrategy.getDeclarationContainer(n);
                if (container == null) {
                    return false;
                }
                for (KmTypeAlias alias : container.getTypeAliases()) {
                    if (!matchName.equals(alias.getName())) continue;
                    return true;
                }
                return Iterators.find((Iterable)Iterators.unique((Iterable)Iterators.map(n.getUsages(), u -> {
                    if (u instanceof MethodUsage) {
                        return ((MethodUsage)u).getName();
                    }
                    if (u instanceof ClassNewUsage) {
                        return JvmClass.getShortName(((ClassNewUsage)u).getClassName());
                    }
                    return "";
                })), name -> name.equals(matchName) || name.length() > matchName.length() + 1 && name.startsWith(matchName) && name.charAt(matchName.length()) == '$') != null;
            });
        }
        return super.processAddedClass(context, addedClass, future, present);
    }

    @Override
    public boolean processRemovedClass(DifferentiateContext context, JvmClass removedClass, Utils future, Utils present) {
        for (JvmClass superClass : Iterators.filter(future.allDirectSupertypes(removedClass), KotlinAwareJavaDifferentiateStrategy::isSealed)) {
            this.affectNodeSources(context, superClass.getReferenceID(), "Subclass of a sealed class was removed, affecting ");
        }
        return super.processRemovedClass(context, removedClass, future, present);
    }

    @Override
    public boolean processChangedClass(DifferentiateContext context, Difference.Change<JvmClass, JvmClass.Diff> change, Utils future, Utils present) {
        JvmClass changedClass = change.getPast();
        JvmClass.Diff diff = change.getDiff();
        Iterable<JvmMethod> removedMethods = diff.methods().removed();
        Iterable addedNonPrivateFields = Iterators.filter(diff.fields().added(), f -> !f.isPrivate());
        Iterable exposedFields = Iterators.filter((Iterable)Iterators.map(diff.fields().changed(), ch -> ((JvmField.Diff)ch.getDiff()).accessExpanded() ? (JvmField)ch.getPast() : null), Objects::nonNull);
        if (diff.superClassChanged() || !diff.interfaces().unchanged()) {
            Difference.Specifier sealedDiff = Difference.diff(Iterators.map((Iterable)Iterators.filter(present.allDirectSupertypes(change.getPast()), KotlinAwareJavaDifferentiateStrategy::isSealed), JVMClassNode::getReferenceID), Iterators.map((Iterable)Iterators.filter(future.allDirectSupertypes(change.getNow()), KotlinAwareJavaDifferentiateStrategy::isSealed), JVMClassNode::getReferenceID));
            for (Object id : sealedDiff.added()) {
                this.affectNodeSources(context, (ReferenceID)id, "Subclass of a sealed class was added, affecting ");
            }
            for (Object id : sealedDiff.removed()) {
                this.affectNodeSources(context, (ReferenceID)id, "Subclass of a sealed class was removed, affecting ");
            }
        }
        if (!(Iterators.isEmpty(removedMethods) && Iterators.isEmpty((Iterable)addedNonPrivateFields) && Iterators.isEmpty((Iterable)exposedFields))) {
            block2: for (PropertyDescriptor propertyDescriptor : KotlinAwareJavaDifferentiateStrategy.findProperties(changedClass)) {
                for (JvmMethod removedMethod : removedMethods) {
                    if (!removedMethod.isSame(propertyDescriptor.getter) || propertyDescriptor.setter == null) continue;
                    this.debug("Kotlin interop: a property getter ", removedMethod.getName(), " was removed => affecting usages of corresponding setter ", propertyDescriptor.setter.getName());
                    this.affectMemberUsages(context, changedClass.getReferenceID(), propertyDescriptor.setter, future.collectSubclassesWithoutMethod(changedClass.getReferenceID(), propertyDescriptor.setter));
                    break;
                }
                for (JvmField field : Iterators.flat((Iterable)addedNonPrivateFields, (Iterable)exposedFields)) {
                    if (!Objects.equals(field.getName(), propertyDescriptor.getter.getName()) && !propertyDescriptor.name.equalsIgnoreCase(field.getName())) continue;
                    this.debug("Kotlin interop: a non-private field with name ", field.getName(), " was added, or the field became more accessible");
                    this.debug(" => affecting usages of corresponding property getter ", propertyDescriptor.getter.getName());
                    this.affectMemberUsages(context, changedClass.getReferenceID(), propertyDescriptor.getter, future.collectSubclassesWithoutMethod(changedClass.getReferenceID(), propertyDescriptor.getter));
                    if (propertyDescriptor.setter == null) continue block2;
                    this.debug(" => affecting usages of corresponding property setter ", propertyDescriptor.setter.getName());
                    this.affectMemberUsages(context, changedClass.getReferenceID(), propertyDescriptor.setter, future.collectSubclassesWithoutMethod(changedClass.getReferenceID(), propertyDescriptor.setter));
                    continue block2;
                }
            }
        }
        if (!present.isLambdaTarget(change.getPast()) && future.isLambdaTarget(change.getNow())) {
            TypeRepr.ClassType samType = new TypeRepr.ClassType(changedClass.getName());
            for (JvmClass depClass : Iterators.flat((Iterable)Iterators.map(context.getGraph().getDependingNodes(changedClass.getReferenceID()), dep -> present.getNodes((ReferenceID)dep, JvmClass.class)))) {
                JvmMethod methodWithSAMType = (JvmMethod)Iterators.find(depClass.getMethods(), m -> Iterators.contains(m.getArgTypes(), (Object)samType));
                if (methodWithSAMType == null) continue;
                KotlinAwareJavaDifferentiateStrategy.affectConflictingExtensionMethods(context, depClass, methodWithSAMType, future);
            }
        }
        for (Difference.Change change2 : diff.metadata(KotlinMeta.class).changed()) {
            KotlinMeta.Diff metaDiff = (KotlinMeta.Diff)change2.getDiff();
            for (Difference.Change<KmFunction, KotlinMeta.KmFunctionsDiff> change3 : metaDiff.functions().changed()) {
                KotlinMeta.KmFunctionsDiff funDiff;
                JvmMethod changedMethod = KotlinAwareJavaDifferentiateStrategy.getJvmMethod(changedClass, JvmExtensionsKt.getSignature((KmFunction)change3.getPast()));
                if (changedMethod == null || changedMethod.getFlags().isPrivate() || !(funDiff = change3.getDiff()).becameNullable() && !funDiff.argsBecameNotNull()) continue;
                this.debug("One of method's parameters or method's return value has become non-nullable; affecting method usages ", changedMethod);
                this.affectMemberUsages(context, changedClass.getReferenceID(), changedMethod, future.collectSubclassesWithoutMethod(changedClass.getReferenceID(), changedMethod));
            }
            for (Difference.Change<Object, Difference> change4 : metaDiff.properties().changed()) {
                JvmMethod setter;
                KmProperty prop = (KmProperty)change4.getPast();
                KotlinMeta.KmPropertiesDiff propDiff = (KotlinMeta.KmPropertiesDiff)change4.getDiff();
                if (propDiff.becameNullable()) {
                    JvmMethod getter = KotlinAwareJavaDifferentiateStrategy.getJvmMethod(changedClass, JvmExtensionsKt.getGetterSignature((KmProperty)prop));
                    if (getter == null || getter.getFlags().isPrivate()) continue;
                    this.debug("A property has become nullable; affecting getter usages ", getter);
                    this.affectMemberUsages(context, changedClass.getReferenceID(), getter, future.collectSubclassesWithoutMethod(changedClass.getReferenceID(), getter));
                    continue;
                }
                if (!propDiff.becameNotNull() || (setter = KotlinAwareJavaDifferentiateStrategy.getJvmMethod(changedClass, JvmExtensionsKt.getSetterSignature((KmProperty)prop))) == null || setter.getFlags().isPrivate()) continue;
                this.debug("A property has become not-null; affecting setter usages ", setter);
                this.affectMemberUsages(context, changedClass.getReferenceID(), setter, future.collectSubclassesWithoutMethod(changedClass.getReferenceID(), setter));
            }
        }
        return true;
    }

    private static boolean isSealed(JvmClass cls) {
        KmDeclarationContainer container = KotlinAwareJavaDifferentiateStrategy.getDeclarationContainer(cls);
        return container instanceof KmClass && Attributes.getModality((KmClass)((KmClass)container)) == Modality.SEALED;
    }

    @Override
    public boolean processAddedMethod(DifferentiateContext context, Difference.Change<JvmClass, JvmClass.Diff> change, JvmMethod addedMethod, Utils future, Utils present) {
        KmFunction kmFunction;
        KotlinAwareJavaDifferentiateStrategy.affectConflictingExtensionMethods(context, change.getPast(), addedMethod, future);
        JvmClass changedClass = change.getNow();
        if (!changedClass.isPrivate() && "invoke".equals(addedMethod.getName()) && (kmFunction = KotlinAwareJavaDifferentiateStrategy.getKmFunction(changedClass, addedMethod)) != null && Attributes.isOperator((KmFunction)kmFunction)) {
            this.debug("Operator method invoke() has been added. Affecting classes instantiations '", changedClass.getName());
            context.affectUsage(new ClassNewUsage(changedClass.getReferenceID()), n -> KotlinAwareJavaDifferentiateStrategy.isKotlinNode(n));
        }
        return true;
    }

    @Override
    public boolean processChangedMethod(DifferentiateContext context, Difference.Change<JvmClass, JvmClass.Diff> clsChange, Difference.Change<JvmMethod, JvmMethod.Diff> methodChange, Utils future, Utils present) {
        JvmClass changedClass = clsChange.getPast();
        JvmMethod changedMethod = methodChange.getPast();
        JvmNodeReferenceID clsId = changedClass.getReferenceID();
        if (KotlinAwareJavaDifferentiateStrategy.isKotlinNode(changedClass) && methodChange.getDiff().valueChanged()) {
            this.debug("Method was inlineable, or has become inlineable or a body of inline method has changed; affecting method usages ", changedMethod);
            this.affectMemberUsages(context, clsId, changedMethod, future.collectSubclassesWithoutMethod(clsId, changedMethod));
        }
        return true;
    }

    private static void affectConflictingExtensionMethods(DifferentiateContext context, JvmClass cls, JvmMethod clsMethod, Utils utils) {
        if (clsMethod.isPrivate() || clsMethod.isConstructor()) {
            return;
        }
        Set targets = (Set)Iterators.collect((Iterable)Iterators.flat(utils.allSupertypes(cls.getReferenceID()), utils.collectSubclassesWithoutMethod(cls.getReferenceID(), clsMethod)), new HashSet());
        targets.add(cls.getReferenceID());
        String matchName = clsMethod.getName();
        context.affectUsage(targets, n -> {
            KmDeclarationContainer container = KotlinAwareJavaDifferentiateStrategy.getDeclarationContainer(n);
            if (container == null) {
                return false;
            }
            if (Iterators.find((Iterable)container.getTypeAliases(), alias -> matchName.equals(alias.getName())) != null) {
                return true;
            }
            return Iterators.find(n.getUsages(), u -> u instanceof MethodUsage && !targets.contains(u.getElementOwner()) && Objects.equals(((MethodUsage)u).getName(), matchName)) != null;
        });
    }

    private static Iterable<PropertyDescriptor> findProperties(JvmClass cls) {
        HashMap<String, JvmMethod> getters = new HashMap<String, JvmMethod>();
        HashMap<String, SmartList> setters = new HashMap<String, SmartList>();
        for (JvmMethod method : cls.getMethods()) {
            String methodName = method.getName();
            if (KotlinAwareJavaDifferentiateStrategy.isGetter(method)) {
                getters.put(methodName.substring(methodName.startsWith("is") ? 2 : 3), method);
                continue;
            }
            if (!KotlinAwareJavaDifferentiateStrategy.isSetter(method)) continue;
            String propName = methodName.substring(3);
            List candidates = (List)setters.get(propName);
            if (candidates == null) {
                candidates = new SmartList();
                setters.put(propName, (SmartList)candidates);
            }
            candidates.add(method);
        }
        return Iterators.map(getters.entrySet(), e -> {
            String propName = (String)e.getKey();
            JvmMethod getter = (JvmMethod)e.getValue();
            Iterator iterator = Iterators.filter((Iterable)((Iterable)setters.get(propName)), s -> Objects.equals(s.getArgTypes().iterator().next(), getter.getType())).iterator();
            if (iterator.hasNext()) {
                JvmMethod setter = (JvmMethod)iterator.next();
                return new PropertyDescriptor(propName, getter, setter);
            }
            return new PropertyDescriptor(propName, getter, null);
        });
    }

    private static boolean isSetter(JvmMethod method) {
        String name = method.getName();
        return name.length() > 3 && name.startsWith("set") && "V".equals(method.getType().getDescriptor()) && KotlinAwareJavaDifferentiateStrategy.sizeEqual(method.getArgTypes(), 1);
    }

    private static boolean isGetter(JvmMethod method) {
        if (!Iterators.isEmpty(method.getArgTypes())) {
            return false;
        }
        String name = method.getName();
        if (name.length() > 3 && name.startsWith("get")) {
            return true;
        }
        if (name.length() > 2 && name.startsWith("is")) {
            TypeRepr returnType = method.getType();
            return TypeRepr.PrimitiveType.BOOLEAN.equals(returnType) || TypeRepr.ClassType.BOOLEAN.equals(returnType);
        }
        return false;
    }

    private static boolean sizeEqual(Iterable<?> it, int expectedSize) {
        if (it instanceof Collection) {
            return expectedSize == ((Collection)it).size();
        }
        Iterator<?> iterator = it.iterator();
        while (expectedSize-- > 0) {
            if (!iterator.hasNext()) {
                return false;
            }
            iterator.next();
        }
        return !iterator.hasNext();
    }

    private static KmFunction getKmFunction(JvmClass cls, JvmMethod method) {
        JvmMethodSignature methodSignature = new JvmMethodSignature(method.getName(), method.getDescriptor());
        return (KmFunction)Iterators.find(KotlinAwareJavaDifferentiateStrategy.allKmFunctions(cls), f -> methodSignature.equals((Object)JvmExtensionsKt.getSignature((KmFunction)f)));
    }

    @Nullable
    private static JvmMethod getJvmMethod(JvmClass cls, JvmMethodSignature sig) {
        return sig != null ? (JvmMethod)Iterators.find(cls.getMethods(), m -> Objects.equals(m.getName(), sig.getName()) && Objects.equals(m.getDescriptor(), sig.getDescriptor())) : null;
    }

    private static Iterable<KmFunction> allKmFunctions(Node<?, ?> node) {
        KotlinMeta meta = KotlinAwareJavaDifferentiateStrategy.getKotlinMeta(node);
        return meta != null ? meta.getKmFunctions() : Collections.emptyList();
    }

    private static KmDeclarationContainer getDeclarationContainer(Node<?, ?> node) {
        KotlinMeta meta = KotlinAwareJavaDifferentiateStrategy.getKotlinMeta(node);
        return meta != null ? meta.getDeclarationContainer() : null;
    }

    private static boolean isKotlinNode(Node<?, ?> node) {
        return KotlinAwareJavaDifferentiateStrategy.getKotlinMeta(node) != null;
    }

    @Nullable
    private static KotlinMeta getKotlinMeta(Node<?, ?> node) {
        return node instanceof JVMClassNode ? (KotlinMeta)Iterators.find(((JVMClassNode)node).getMetadata(), mt -> mt instanceof KotlinMeta) : null;
    }

    private static final class PropertyDescriptor {
        @NotNull
        final String name;
        @NotNull
        final JvmMethod getter;
        @Nullable
        final JvmMethod setter;

        PropertyDescriptor(@NotNull String name, @NotNull JvmMethod getter, @Nullable JvmMethod setter) {
            if (name == null) {
                PropertyDescriptor.$$$reportNull$$$0(0);
            }
            if (getter == null) {
                PropertyDescriptor.$$$reportNull$$$0(1);
            }
            this.name = name;
            this.getter = getter;
            this.setter = setter;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "getter";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/jps/dependency/kotlin/KotlinAwareJavaDifferentiateStrategy$PropertyDescriptor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

