/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.PersistentHashMapValueStorage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.impl.BuildTargetChunk;
import org.jetbrains.jps.builders.impl.storage.BuildTargetStorages;
import org.jetbrains.jps.builders.java.JavaBuilderUtil;
import org.jetbrains.jps.builders.java.dependencyView.Mappings;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.builders.storage.SourceToOutputMapping;
import org.jetbrains.jps.builders.storage.StorageProvider;
import org.jetbrains.jps.cmdline.BuildRunner;
import org.jetbrains.jps.dependency.BackDependencyIndex;
import org.jetbrains.jps.dependency.Delta;
import org.jetbrains.jps.dependency.DependencyGraph;
import org.jetbrains.jps.dependency.DifferentiateParameters;
import org.jetbrains.jps.dependency.DifferentiateResult;
import org.jetbrains.jps.dependency.GraphConfiguration;
import org.jetbrains.jps.dependency.Node;
import org.jetbrains.jps.dependency.NodeSource;
import org.jetbrains.jps.dependency.NodeSourcePathMapper;
import org.jetbrains.jps.dependency.ReferenceID;
import org.jetbrains.jps.dependency.impl.Containers;
import org.jetbrains.jps.dependency.impl.DependencyGraphImpl;
import org.jetbrains.jps.dependency.impl.LoggingDependencyGraph;
import org.jetbrains.jps.dependency.impl.PathSourceMapper;
import org.jetbrains.jps.incremental.IncProjectBuilder;
import org.jetbrains.jps.incremental.relativizer.PathRelativizerService;
import org.jetbrains.jps.incremental.storage.AbstractStateStorage;
import org.jetbrains.jps.incremental.storage.BuildTargetsState;
import org.jetbrains.jps.incremental.storage.CompositeStorageOwner;
import org.jetbrains.jps.incremental.storage.OneToManyPathsMapping;
import org.jetbrains.jps.incremental.storage.OutputToTargetRegistry;
import org.jetbrains.jps.incremental.storage.SourceToOutputMappingImpl;
import org.jetbrains.jps.incremental.storage.StorageOwner;

public final class BuildDataManager {
    private static final Logger LOG = Logger.getInstance(BuildDataManager.class);
    public static final String PROCESS_CONSTANTS_NON_INCREMENTAL_PROPERTY = "compiler.process.constants.non.incremental";
    private static final int VERSION = 39 + (PersistentHashMapValueStorage.COMPRESSION_ENABLED ? 1 : 0);
    private static final String SRC_TO_FORM_STORAGE = "src-form";
    private static final String SRC_TO_OUTPUT_STORAGE = "src-out";
    private static final String OUT_TARGET_STORAGE = "out-target";
    private static final String MAPPINGS_STORAGE = "mappings";
    private static final String SRC_TO_OUTPUT_FILE_NAME = "data";
    private final ConcurrentMap<BuildTarget<?>, BuildTargetStorages> myTargetStorages = new ConcurrentHashMap(16, 0.75f, BuildDataManager.getConcurrencyLevel());
    private final OneToManyPathsMapping mySrcToFormMap;
    private final Mappings myMappings;
    private final Object myGraphManagementLock = new Object();
    private DependencyGraph myDepGraph;
    private final NodeSourcePathMapper myDepGraphPathMapper;
    private final BuildDataPaths myDataPaths;
    private final BuildTargetsState myTargetsState;
    private final OutputToTargetRegistry myOutputToTargetRegistry;
    private final File myVersionFile;
    private final PathRelativizerService myRelativizer;
    private boolean myProcessConstantsIncrementally = !Boolean.parseBoolean(System.getProperty("compiler.process.constants.non.incremental", "false"));
    private final StorageProvider<SourceToOutputMappingImpl> SRC_TO_OUT_MAPPING_PROVIDER = new StorageProvider<SourceToOutputMappingImpl>(){

        @Override
        @NotNull
        public SourceToOutputMappingImpl createStorage(File targetDataDir) throws IOException {
            SourceToOutputMappingImpl sourceToOutputMappingImpl = this.createStorage(targetDataDir, BuildDataManager.this.myRelativizer);
            if (sourceToOutputMappingImpl == null) {
                1.$$$reportNull$$$0(0);
            }
            return sourceToOutputMappingImpl;
        }

        @Override
        @NotNull
        public SourceToOutputMappingImpl createStorage(File targetDataDir, PathRelativizerService relativizer) throws IOException {
            return new SourceToOutputMappingImpl(new File(new File(targetDataDir, BuildDataManager.SRC_TO_OUTPUT_STORAGE), BuildDataManager.SRC_TO_OUTPUT_FILE_NAME), relativizer);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/storage/BuildDataManager$1", "createStorage"));
        }
    };
    private Boolean myVersionDiffers = null;

    public BuildDataManager(BuildDataPaths dataPaths, BuildTargetsState targetsState, PathRelativizerService relativizer) throws IOException {
        this.myDataPaths = dataPaths;
        this.myTargetsState = targetsState;
        try {
            this.mySrcToFormMap = new OneToManyPathsMapping(new File(this.getSourceToFormsRoot(), SRC_TO_OUTPUT_FILE_NAME), relativizer);
            this.myOutputToTargetRegistry = new OutputToTargetRegistry(new File(this.getOutputToSourceRegistryRoot(), SRC_TO_OUTPUT_FILE_NAME), relativizer);
            File mappingsRoot = BuildDataManager.getMappingsRoot(this.myDataPaths.getDataStorageRoot());
            if (JavaBuilderUtil.isDepGraphEnabled()) {
                this.myMappings = null;
                this.createDependencyGraph(mappingsRoot, false);
                LOG.info("Using DependencyGraph-based build incremental analysis");
            } else {
                this.myMappings = new Mappings(mappingsRoot, relativizer);
                this.myMappings.setProcessConstantsIncrementally(this.isProcessConstantsIncrementally());
            }
        }
        catch (IOException e) {
            try {
                this.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw e;
        }
        this.myVersionFile = new File(this.myDataPaths.getDataStorageRoot(), "version.dat");
        this.myDepGraphPathMapper = relativizer != null ? new PathSourceMapper(relativizer::toFull, relativizer::toRelative) : new PathSourceMapper();
        this.myRelativizer = relativizer;
    }

    public void setProcessConstantsIncrementally(boolean processInc) {
        this.myProcessConstantsIncrementally = processInc;
        Mappings mappings = this.myMappings;
        if (mappings != null) {
            mappings.setProcessConstantsIncrementally(processInc);
        }
    }

    public boolean isProcessConstantsIncrementally() {
        return this.myProcessConstantsIncrementally;
    }

    public BuildTargetsState getTargetsState() {
        return this.myTargetsState;
    }

    public OutputToTargetRegistry getOutputToTargetRegistry() {
        return this.myOutputToTargetRegistry;
    }

    public SourceToOutputMapping getSourceToOutputMap(BuildTarget<?> target) throws IOException {
        SourceToOutputMappingImpl map = this.getStorage(target, this.SRC_TO_OUT_MAPPING_PROVIDER);
        return new SourceToOutputMappingWrapper(map, this.myTargetsState.getBuildTargetId(target));
    }

    public SourceToOutputMappingImpl createSourceToOutputMapForStaleTarget(BuildTargetType<?> targetType, String targetId) throws IOException {
        return new SourceToOutputMappingImpl(new File(this.getSourceToOutputMapRoot(targetType, targetId), SRC_TO_OUTPUT_FILE_NAME), this.myRelativizer);
    }

    @NotNull
    public <S extends StorageOwner> S getStorage(@NotNull BuildTarget<?> target, @NotNull StorageProvider<S> provider) throws IOException {
        if (target == null) {
            BuildDataManager.$$$reportNull$$$0(0);
        }
        if (provider == null) {
            BuildDataManager.$$$reportNull$$$0(1);
        }
        BuildTargetStorages targetStorages = this.myTargetStorages.computeIfAbsent(target, t -> new BuildTargetStorages((BuildTarget<?>)t, this.myDataPaths));
        S s = targetStorages.getOrCreateStorage(provider, this.myRelativizer);
        if (s == null) {
            BuildDataManager.$$$reportNull$$$0(2);
        }
        return s;
    }

    public OneToManyPathsMapping getSourceToFormMap() {
        return this.mySrcToFormMap;
    }

    public Mappings getMappings() {
        return this.myMappings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public GraphConfiguration getDependencyGraph() {
        Object object = this.myGraphManagementLock;
        synchronized (object) {
            final DependencyGraph depGraph = this.myDepGraph;
            return depGraph == null ? null : new GraphConfiguration(){

                @Override
                @NotNull
                public NodeSourcePathMapper getPathMapper() {
                    NodeSourcePathMapper nodeSourcePathMapper = BuildDataManager.this.myDepGraphPathMapper;
                    if (nodeSourcePathMapper == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return nodeSourcePathMapper;
                }

                @Override
                @NotNull
                public DependencyGraph getGraph() {
                    DependencyGraph dependencyGraph = depGraph;
                    if (dependencyGraph == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return dependencyGraph;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "org/jetbrains/jps/incremental/storage/BuildDataManager$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getPathMapper";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getGraph";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            };
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanTargetStorages(BuildTarget<?> target) throws IOException {
        try {
            BuildTargetStorages storages = (BuildTargetStorages)this.myTargetStorages.remove(target);
            if (storages != null) {
                storages.close();
            }
        }
        finally {
            File[] targetData = this.myDataPaths.getTargetDataRoot(target).listFiles();
            if (targetData != null) {
                File srcOutputMapRoot = this.getSourceToOutputMapRoot(target);
                for (File dataFile : targetData) {
                    if (FileUtil.filesEqual((File)dataFile, (File)srcOutputMapRoot)) continue;
                    FileUtil.delete((File)dataFile);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clean(Consumer<Future<?>> asyncTaskCollector) throws IOException {
        try {
            this.allTargetStorages(asyncTaskCollector).clean();
            this.myTargetStorages.clear();
        }
        finally {
            try {
                BuildDataManager.wipeStorage(this.getSourceToFormsRoot(), this.mySrcToFormMap);
            }
            finally {
                try {
                    BuildDataManager.wipeStorage(this.getOutputToSourceRegistryRoot(), this.myOutputToTargetRegistry);
                }
                finally {
                    File mappingsRoot = BuildDataManager.getMappingsRoot(this.myDataPaths.getDataStorageRoot());
                    Mappings mappings = this.myMappings;
                    if (mappings != null) {
                        Mappings mappings2 = mappings;
                        synchronized (mappings2) {
                            mappings.clean();
                        }
                    } else {
                        FileUtil.delete((File)mappingsRoot);
                    }
                    if (JavaBuilderUtil.isDepGraphEnabled()) {
                        this.createDependencyGraph(mappingsRoot, true);
                    }
                }
            }
            this.myTargetsState.clean();
        }
        this.saveVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDependencyGraph(File mappingsRoot, boolean deleteExisting) throws IOException {
        try {
            Object object = this.myGraphManagementLock;
            synchronized (object) {
                DependencyGraph depGraph = this.myDepGraph;
                if (depGraph == null) {
                    if (deleteExisting) {
                        FileUtil.delete((File)mappingsRoot);
                    }
                    this.myDepGraph = BuildDataManager.asSynchronizedGraph(new DependencyGraphImpl(Containers.createPersistentContainerFactory(mappingsRoot.getAbsolutePath())));
                } else {
                    try {
                        depGraph.close();
                    }
                    finally {
                        if (deleteExisting) {
                            FileUtil.delete((File)mappingsRoot);
                        }
                        this.myDepGraph = BuildDataManager.asSynchronizedGraph(new DependencyGraphImpl(Containers.createPersistentContainerFactory(mappingsRoot.getAbsolutePath())));
                    }
                }
            }
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(boolean memoryCachesOnly) {
        this.allTargetStorages().flush(memoryCachesOnly);
        this.myOutputToTargetRegistry.flush(memoryCachesOnly);
        this.mySrcToFormMap.flush(memoryCachesOnly);
        Mappings mappings = this.myMappings;
        if (mappings != null) {
            Mappings mappings2 = mappings;
            synchronized (mappings2) {
                mappings.flush(memoryCachesOnly);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.myTargetsState.save();
            try {
                this.allTargetStorages().close();
            }
            finally {
                this.myTargetStorages.clear();
            }
        }
        finally {
            try {
                this.myOutputToTargetRegistry.close();
            }
            finally {
                try {
                    BuildDataManager.closeStorage(this.mySrcToFormMap);
                }
                finally {
                    Mappings mappings = this.myMappings;
                    if (mappings != null) {
                        try {
                            mappings.close();
                        }
                        catch (BuildDataCorruptedException e) {
                            throw e.getCause();
                        }
                    }
                    Object object = this.myGraphManagementLock;
                    synchronized (object) {
                        DependencyGraph depGraph = this.myDepGraph;
                        if (depGraph != null) {
                            this.myDepGraph = null;
                            try {
                                depGraph.close();
                            }
                            catch (BuildDataCorruptedException e) {
                                throw e.getCause();
                            }
                        }
                    }
                }
            }
        }
    }

    public void closeSourceToOutputStorages(Collection<? extends BuildTargetChunk> chunks) throws IOException {
        IOException ex = null;
        for (BuildTargetChunk buildTargetChunk : chunks) {
            for (BuildTarget<?> target : buildTargetChunk.getTargets()) {
                try {
                    BuildTargetStorages targetStorages = (BuildTargetStorages)this.myTargetStorages.get(target);
                    if (targetStorages == null) continue;
                    targetStorages.close(this.SRC_TO_OUT_MAPPING_PROVIDER);
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                    if (ex != null) continue;
                    ex = e;
                }
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    private File getSourceToOutputMapRoot(BuildTarget<?> target) {
        return new File(this.myDataPaths.getTargetDataRoot(target), SRC_TO_OUTPUT_STORAGE);
    }

    private File getSourceToOutputMapRoot(BuildTargetType<?> targetType, String targetId) {
        return new File(this.myDataPaths.getTargetDataRoot(targetType, targetId), SRC_TO_OUTPUT_STORAGE);
    }

    private File getSourceToFormsRoot() {
        return new File(this.myDataPaths.getDataStorageRoot(), SRC_TO_FORM_STORAGE);
    }

    private File getOutputToSourceRegistryRoot() {
        return new File(this.myDataPaths.getDataStorageRoot(), OUT_TARGET_STORAGE);
    }

    public BuildDataPaths getDataPaths() {
        return this.myDataPaths;
    }

    public PathRelativizerService getRelativizer() {
        return this.myRelativizer;
    }

    public static File getMappingsRoot(File dataStorageRoot) {
        return new File(dataStorageRoot, JavaBuilderUtil.isDepGraphEnabled() ? "mappings-graph" : MAPPINGS_STORAGE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void wipeStorage(File root, @Nullable AbstractStateStorage<?, ?> storage) {
        if (storage != null) {
            AbstractStateStorage<?, ?> abstractStateStorage = storage;
            synchronized (abstractStateStorage) {
                storage.wipe();
            }
        } else {
            FileUtil.delete((File)root);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void closeStorage(@Nullable AbstractStateStorage<?, ?> storage) throws IOException {
        if (storage != null) {
            AbstractStateStorage<?, ?> abstractStateStorage = storage;
            synchronized (abstractStateStorage) {
                storage.close();
            }
        }
    }

    public boolean versionDiffers() {
        boolean bl;
        Boolean cached = this.myVersionDiffers;
        if (cached != null) {
            return cached;
        }
        DataInputStream is = new DataInputStream(new FileInputStream(this.myVersionFile));
        try {
            boolean diff = is.readInt() != VERSION;
            this.myVersionDiffers = diff;
            bl = diff;
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException ignored) {
                return false;
            }
            catch (IOException ex) {
                LOG.info((Throwable)ex);
                return true;
            }
        }
        is.close();
        return bl;
    }

    public void saveVersion() {
        Boolean differs = this.myVersionDiffers;
        if (differs == null || differs.booleanValue()) {
            FileUtil.createIfDoesntExist((File)this.myVersionFile);
            try (DataOutputStream os = new DataOutputStream(new FileOutputStream(this.myVersionFile));){
                os.writeInt(VERSION);
                this.myVersionDiffers = Boolean.FALSE;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void reportUnhandledRelativizerPaths() {
        this.myRelativizer.reportUnhandledPaths();
    }

    public static int getConcurrencyLevel() {
        return BuildRunner.isParallelBuildEnabled() ? IncProjectBuilder.MAX_BUILDER_THREADS : 1;
    }

    @NotNull
    private StorageOwner allTargetStorages() {
        StorageOwner storageOwner = this.allTargetStorages(f -> {});
        if (storageOwner == null) {
            BuildDataManager.$$$reportNull$$$0(3);
        }
        return storageOwner;
    }

    private StorageOwner allTargetStorages(final Consumer<Future<?>> asyncTaskCollector) {
        return new CompositeStorageOwner(){

            @Override
            public void clean() throws IOException {
                try {
                    this.close();
                }
                finally {
                    asyncTaskCollector.accept(FileUtil.asyncDelete((File)BuildDataManager.this.myDataPaths.getTargetsDataRoot()));
                }
            }

            protected Iterable<BuildTargetStorages> getChildStorages() {
                return () -> BuildDataManager.this.myTargetStorages.values().iterator();
            }
        };
    }

    private static DependencyGraph asSynchronizedGraph(DependencyGraph graph) {
        final LoggingDependencyGraph delegate = new LoggingDependencyGraph(graph, msg -> LOG.info(msg));
        return new DependencyGraph(){
            private final ReadWriteLock lock = new ReentrantReadWriteLock();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Delta createDelta(Iterable<NodeSource> sourcesToProcess, Iterable<NodeSource> deletedSources) throws IOException {
                this.lock.readLock().lock();
                try {
                    Delta delta = delegate.createDelta(sourcesToProcess, deletedSources);
                    return delta;
                }
                finally {
                    this.lock.readLock().unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public DifferentiateResult differentiate(Delta delta, DifferentiateParameters params) {
                this.lock.readLock().lock();
                try {
                    DifferentiateResult differentiateResult = delegate.differentiate(delta, params);
                    return differentiateResult;
                }
                finally {
                    this.lock.readLock().unlock();
                }
            }

            @Override
            public void integrate(@NotNull DifferentiateResult diffResult) {
                if (diffResult == null) {
                    4.$$$reportNull$$$0(0);
                }
                this.lock.writeLock().lock();
                try {
                    delegate.integrate(diffResult);
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            }

            @Override
            public Iterable<BackDependencyIndex> getIndices() {
                return delegate.getIndices();
            }

            @Override
            @Nullable
            public BackDependencyIndex getIndex(String name) {
                return delegate.getIndex(name);
            }

            @Override
            public Iterable<NodeSource> getSources(@NotNull ReferenceID id) {
                if (id == null) {
                    4.$$$reportNull$$$0(1);
                }
                return delegate.getSources(id);
            }

            @Override
            public Iterable<ReferenceID> getRegisteredNodes() {
                return delegate.getRegisteredNodes();
            }

            @Override
            public Iterable<NodeSource> getSources() {
                return delegate.getSources();
            }

            @Override
            public Iterable<Node<?, ?>> getNodes(@NotNull NodeSource source) {
                if (source == null) {
                    4.$$$reportNull$$$0(2);
                }
                return delegate.getNodes(source);
            }

            @Override
            public <T extends Node<T, ?>> Iterable<T> getNodes(NodeSource src, Class<T> nodeSelector) {
                return delegate.getNodes(src, nodeSelector);
            }

            @Override
            @NotNull
            public Iterable<ReferenceID> getDependingNodes(@NotNull ReferenceID id) {
                if (id == null) {
                    4.$$$reportNull$$$0(3);
                }
                Iterable<ReferenceID> iterable = delegate.getDependingNodes(id);
                if (iterable == null) {
                    4.$$$reportNull$$$0(4);
                }
                return iterable;
            }

            @Override
            public void close() throws IOException {
                this.lock.writeLock().lock();
                try {
                    delegate.close();
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 4: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 4: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "diffResult";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "id";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "source";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/jps/incremental/storage/BuildDataManager$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/jps/incremental/storage/BuildDataManager$4";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDependingNodes";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "integrate";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getSources";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getNodes";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "getDependingNodes";
                        break;
                    }
                    case 4: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 4: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/storage/BuildDataManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/storage/BuildDataManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStorage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "allTargetStorages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getStorage";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class SourceToOutputMappingWrapper
    implements SourceToOutputMapping {
        private final SourceToOutputMapping myDelegate;
        private final int myBuildTargetId;

        SourceToOutputMappingWrapper(SourceToOutputMapping delegate, int buildTargetId) {
            this.myDelegate = delegate;
            this.myBuildTargetId = buildTargetId;
        }

        @Override
        public void setOutputs(@NotNull String srcPath, @NotNull Collection<String> outputs) throws IOException {
            if (srcPath == null) {
                SourceToOutputMappingWrapper.$$$reportNull$$$0(0);
            }
            if (outputs == null) {
                SourceToOutputMappingWrapper.$$$reportNull$$$0(1);
            }
            try {
                this.myDelegate.setOutputs(srcPath, outputs);
            }
            finally {
                BuildDataManager.this.myOutputToTargetRegistry.addMapping(outputs, this.myBuildTargetId);
            }
        }

        @Override
        public void setOutput(@NotNull String srcPath, @NotNull String outputPath) throws IOException {
            if (srcPath == null) {
                SourceToOutputMappingWrapper.$$$reportNull$$$0(2);
            }
            if (outputPath == null) {
                SourceToOutputMappingWrapper.$$$reportNull$$$0(3);
            }
            try {
                this.myDelegate.setOutput(srcPath, outputPath);
            }
            finally {
                BuildDataManager.this.myOutputToTargetRegistry.addMapping(outputPath, this.myBuildTargetId);
            }
        }

        @Override
        public void appendOutput(@NotNull String srcPath, @NotNull String outputPath) throws IOException {
            if (srcPath == null) {
                SourceToOutputMappingWrapper.$$$reportNull$$$0(4);
            }
            if (outputPath == null) {
                SourceToOutputMappingWrapper.$$$reportNull$$$0(5);
            }
            try {
                this.myDelegate.appendOutput(srcPath, outputPath);
            }
            finally {
                BuildDataManager.this.myOutputToTargetRegistry.addMapping(outputPath, this.myBuildTargetId);
            }
        }

        @Override
        public void remove(@NotNull String srcPath) throws IOException {
            if (srcPath == null) {
                SourceToOutputMappingWrapper.$$$reportNull$$$0(6);
            }
            this.myDelegate.remove(srcPath);
        }

        @Override
        public void removeOutput(@NotNull String sourcePath, @NotNull String outputPath) throws IOException {
            if (sourcePath == null) {
                SourceToOutputMappingWrapper.$$$reportNull$$$0(7);
            }
            if (outputPath == null) {
                SourceToOutputMappingWrapper.$$$reportNull$$$0(8);
            }
            this.myDelegate.removeOutput(sourcePath, outputPath);
        }

        @Override
        @NotNull
        public Collection<String> getSources() throws IOException {
            Collection<String> collection = this.myDelegate.getSources();
            if (collection == null) {
                SourceToOutputMappingWrapper.$$$reportNull$$$0(9);
            }
            return collection;
        }

        @Override
        @Nullable
        public Collection<String> getOutputs(@NotNull String srcPath) throws IOException {
            if (srcPath == null) {
                SourceToOutputMappingWrapper.$$$reportNull$$$0(10);
            }
            return this.myDelegate.getOutputs(srcPath);
        }

        @Override
        @NotNull
        public Iterator<String> getOutputsIterator(@NotNull String srcPath) throws IOException {
            if (srcPath == null) {
                SourceToOutputMappingWrapper.$$$reportNull$$$0(11);
            }
            Iterator<String> iterator = this.myDelegate.getOutputsIterator(srcPath);
            if (iterator == null) {
                SourceToOutputMappingWrapper.$$$reportNull$$$0(12);
            }
            return iterator;
        }

        @Override
        @NotNull
        public Iterator<String> getSourcesIterator() throws IOException {
            Iterator<String> iterator = this.myDelegate.getSourcesIterator();
            if (iterator == null) {
                SourceToOutputMappingWrapper.$$$reportNull$$$0(13);
            }
            return iterator;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 9: 
                case 12: 
                case 13: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 9: 
                case 12: 
                case 13: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "srcPath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputs";
                    break;
                }
                case 3: 
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputPath";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourcePath";
                    break;
                }
                case 9: 
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/jps/incremental/storage/BuildDataManager$SourceToOutputMappingWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/jps/incremental/storage/BuildDataManager$SourceToOutputMappingWrapper";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSources";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOutputsIterator";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSourcesIterator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setOutputs";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setOutput";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "appendOutput";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "remove";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "removeOutput";
                    break;
                }
                case 9: 
                case 12: 
                case 13: {
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getOutputs";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "getOutputsIterator";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 9: 
                case 12: 
                case 13: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

