/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.action;

import com.intellij.debugger.streams.lib.LibrarySupportProvider;
import com.intellij.debugger.streams.wrapper.StreamChain;
import com.intellij.debugger.streams.wrapper.StreamChainBuilder;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ChainResolver {
    private static final Logger LOG = Logger.getInstance(ChainResolver.class);
    private final AtomicReference<ChainsSearchResult> mySearchResult = new AtomicReference<ChainsSearchResult>(new ChainsSearchResult(0L, -1L, null));
    private final ExecutorService myExecutor = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"Stream debugger chains detector");

    ChainResolver() {
    }

    @NotNull
    ChainStatus tryFindChain(@NotNull PsiElement elementAtDebugger) {
        ChainsSearchResult result;
        if (elementAtDebugger == null) {
            ChainResolver.$$$reportNull$$$0(0);
        }
        if ((result = this.mySearchResult.get()).isSuitableFor(elementAtDebugger)) {
            ChainStatus chainStatus = result.chainsStatus;
            if (chainStatus == null) {
                ChainResolver.$$$reportNull$$$0(1);
            }
            return chainStatus;
        }
        result = ChainsSearchResult.of(elementAtDebugger);
        ChainResolver.checkChainsExistenceInBackground(elementAtDebugger, result, this.myExecutor);
        this.mySearchResult.set(result);
        ChainStatus chainStatus = result.chainsStatus;
        if (chainStatus == null) {
            ChainResolver.$$$reportNull$$$0(2);
        }
        return chainStatus;
    }

    @NotNull
    List<StreamChainWithLibrary> getChains(@NotNull PsiElement elementAtDebugger) {
        ChainsSearchResult result;
        if (elementAtDebugger == null) {
            ChainResolver.$$$reportNull$$$0(3);
        }
        if (!(result = this.mySearchResult.get()).isSuitableFor(elementAtDebugger) || !result.chainsStatus.equals((Object)ChainStatus.FOUND)) {
            LOG.error("Cannot build chains: " + result.chainsStatus);
            List<StreamChainWithLibrary> list2 = Collections.emptyList();
            if (list2 == null) {
                ChainResolver.$$$reportNull$$$0(4);
            }
            return list2;
        }
        ArrayList<StreamChainWithLibrary> chains = new ArrayList<StreamChainWithLibrary>();
        String elementLanguageId = elementAtDebugger.getLanguage().getID();
        LibrarySupportProvider.EP_NAME.forEachExtensionSafe(provider -> {
            StreamChainBuilder chainBuilder;
            if (provider.getLanguageId().equals(elementLanguageId) && (chainBuilder = provider.getChainBuilder()).isChainExists(elementAtDebugger)) {
                for (StreamChain x : chainBuilder.build(elementAtDebugger)) {
                    chains.add(new StreamChainWithLibrary(x, (LibrarySupportProvider)provider));
                }
            }
        });
        ArrayList<StreamChainWithLibrary> arrayList = chains;
        if (arrayList == null) {
            ChainResolver.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static void checkChainsExistenceInBackground(@NotNull PsiElement elementAtDebugger, @NotNull ChainsSearchResult searchResult, @NotNull ExecutorService executor) {
        List<LibrarySupportProvider> extensions;
        if (elementAtDebugger == null) {
            ChainResolver.$$$reportNull$$$0(6);
        }
        if (searchResult == null) {
            ChainResolver.$$$reportNull$$$0(7);
        }
        if (executor == null) {
            ChainResolver.$$$reportNull$$$0(8);
        }
        if ((extensions = ChainResolver.forLanguage(elementAtDebugger.getLanguage())).isEmpty()) {
            searchResult.markUnsupportedLanguage();
        } else {
            ReadAction.nonBlocking(() -> {
                boolean found = false;
                for (LibrarySupportProvider provider : extensions) {
                    try {
                        if (!provider.getChainBuilder().isChainExists(elementAtDebugger)) continue;
                        found = true;
                        break;
                    }
                    catch (ProcessCanceledException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        LOG.error(e);
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Chains found:" + found);
                }
                searchResult.updateStatus(found);
            }).inSmartMode(elementAtDebugger.getProject()).submit((Executor)executor);
        }
    }

    @NotNull
    private static List<LibrarySupportProvider> forLanguage(@NotNull Language language) {
        if (language == null) {
            ChainResolver.$$$reportNull$$$0(9);
        }
        List list2 = LibrarySupportProvider.EP_NAME.getByGroupingKey((Object)language.getID(), ChainResolver.class, LibrarySupportProvider::getLanguageId);
        if (list2 == null) {
            ChainResolver.$$$reportNull$$$0(10);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 5, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementAtDebugger";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/streams/action/ChainResolver";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchResult";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/streams/action/ChainResolver";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "tryFindChain";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChains";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "forLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "tryFindChain";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getChains";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkChainsExistenceInBackground";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "forLanguage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 5, 10 -> new IllegalStateException(string);
        };
    }

    private static final class ChainsSearchResult {
        final long elementHash;
        final long offset;
        final long fileModificationStamp;
        @NotNull
        volatile ChainStatus chainsStatus = ChainStatus.COMPUTING;

        ChainsSearchResult(long elementHash, long offsetInFile, @Nullable PsiFile containingFile) {
            this.elementHash = elementHash;
            this.fileModificationStamp = ChainsSearchResult.getModificationStamp(containingFile);
            this.offset = offsetInFile;
        }

        void updateStatus(boolean found) {
            LOG.assertTrue(ChainStatus.COMPUTING.equals((Object)this.chainsStatus));
            this.chainsStatus = found ? ChainStatus.FOUND : ChainStatus.NOT_FOUND;
        }

        void markUnsupportedLanguage() {
            LOG.assertTrue(ChainStatus.COMPUTING.equals((Object)this.chainsStatus));
            this.chainsStatus = ChainStatus.LANGUAGE_NOT_SUPPORTED;
        }

        boolean isSuitableFor(@NotNull PsiElement element) {
            if (element == null) {
                ChainsSearchResult.$$$reportNull$$$0(0);
            }
            return this.elementHash == (long)element.hashCode() && this.offset == (long)element.getTextOffset() && this.fileModificationStamp == ChainsSearchResult.getModificationStamp(element.getContainingFile());
        }

        private static long getModificationStamp(@Nullable PsiFile file) {
            return file == null ? -1L : file.getModificationStamp();
        }

        @NotNull
        static ChainsSearchResult of(@NotNull PsiElement element) {
            if (element == null) {
                ChainsSearchResult.$$$reportNull$$$0(1);
            }
            return new ChainsSearchResult(element.hashCode(), element.getTextOffset(), element.getContainingFile());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "element";
            objectArray2[1] = "com/intellij/debugger/streams/action/ChainResolver$ChainsSearchResult";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSuitableFor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "of";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static enum ChainStatus {
        LANGUAGE_NOT_SUPPORTED,
        COMPUTING,
        FOUND,
        NOT_FOUND;

    }

    static final class StreamChainWithLibrary {
        final StreamChain chain;
        final LibrarySupportProvider provider;

        StreamChainWithLibrary(@NotNull StreamChain chain, @NotNull LibrarySupportProvider provider) {
            if (chain == null) {
                StreamChainWithLibrary.$$$reportNull$$$0(0);
            }
            if (provider == null) {
                StreamChainWithLibrary.$$$reportNull$$$0(1);
            }
            this.chain = chain;
            this.provider = provider;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "chain";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "provider";
                    break;
                }
            }
            objectArray[1] = "com/intellij/debugger/streams/action/ChainResolver$StreamChainWithLibrary";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

