/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.swagger;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.FUSEventSource;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginAdvertiserService;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginAdvertiserServiceKt;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiser;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.SuggestedIde;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.swagger.OpenApiSuggestionProviderKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0002\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0002H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/yaml/swagger/OpenApiPluginSuggestion;", "Ljava/util/function/Function;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Lcom/intellij/ui/EditorNotificationPanel;", "project", "Lcom/intellij/openapi/project/Project;", "thisProductCode", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getThisProductCode", "()Ljava/lang/String;", "apply", "fileEditor", "intellij.yaml"})
@SourceDebugExtension(value={"SMAP\nOpenApiSuggestionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenApiSuggestionProvider.kt\norg/jetbrains/yaml/swagger/OpenApiPluginSuggestion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,123:1\n1549#2:124\n1620#2,3:125\n*S KotlinDebug\n*F\n+ 1 OpenApiSuggestionProvider.kt\norg/jetbrains/yaml/swagger/OpenApiPluginSuggestion\n*L\n62#1:124\n62#1:125,3\n*E\n"})
final class OpenApiPluginSuggestion
implements Function<FileEditor, EditorNotificationPanel> {
    @NotNull
    private final Project project;
    @NotNull
    private final String thisProductCode;

    public OpenApiPluginSuggestion(@NotNull Project project, @NotNull String thisProductCode) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)thisProductCode, (String)"thisProductCode");
        this.project = project;
        this.thisProductCode = thisProductCode;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final String getThisProductCode() {
        return this.thisProductCode;
    }

    @Override
    @NotNull
    public EditorNotificationPanel apply(@NotNull FileEditor fileEditor) {
        Intrinsics.checkNotNullParameter((Object)fileEditor, (String)"fileEditor");
        EditorNotificationPanel.Status status = PluginAdvertiserService.Companion.isCommunityIde() ? EditorNotificationPanel.Status.Promo : EditorNotificationPanel.Status.Info;
        EditorNotificationPanel panel = new EditorNotificationPanel(fileEditor, status);
        String suggestedIdeCode = PluginAdvertiserService.Companion.getSuggestedCommercialIdeCode(this.thisProductCode);
        SuggestedIde suggestedCommercialIde = PluginAdvertiserService.Companion.getIde(suggestedIdeCode);
        if (suggestedCommercialIde == null) {
            Object[] objectArray = new Object[]{"OpenAPI"};
            panel.setText(IdeBundle.message((String)"plugins.advertiser.plugins.found", (Object[])objectArray));
            objectArray = new Object[]{"OpenAPI Specifications"};
            panel.createActionLabel(IdeBundle.message((String)"plugins.advertiser.action.install.plugin.name", (Object[])objectArray), () -> OpenApiPluginSuggestion.apply$lambda$1(this));
        } else {
            Object[] objectArray = new Object[]{"OpenAPI", suggestedCommercialIde.getName()};
            panel.setText(IdeBundle.message((String)"plugins.advertiser.extensions.supported.in.ultimate", (Object[])objectArray));
            PluginAdvertiserServiceKt.createTryUltimateActionLabel$default((EditorNotificationPanel)panel, (SuggestedIde)suggestedCommercialIde, (Project)this.project, (PluginId)PluginId.getId((String)"com.intellij.swagger"), null, (int)8, null);
        }
        panel.createActionLabel(IdeBundle.message((String)"plugins.advertiser.action.ignore.ultimate", (Object[])new Object[0]), () -> OpenApiPluginSuggestion.apply$lambda$2(this));
        return panel;
    }

    private static final void apply$lambda$1$lambda$0(OpenApiPluginSuggestion this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        EditorNotifications.getInstance((Project)this$0.project).updateAllNotifications();
    }

    /*
     * WARNING - void declaration
     */
    private static final void apply$lambda$1(OpenApiPluginSuggestion this$0) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        List pluginIds = CollectionsKt.listOf((Object)"com.intellij.swagger");
        FUSEventSource.EDITOR.logInstallPlugins(pluginIds, this$0.project);
        Iterable iterable = pluginIds;
        Project project = this$0.project;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string = (String)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(PluginId.getId((String)p0));
        }
        PluginsAdvertiser.installAndEnable$default((Project)project, (Set)CollectionsKt.toSet((Iterable)((List)destination$iv$iv)), (boolean)true, (boolean)false, null, () -> OpenApiPluginSuggestion.apply$lambda$1$lambda$0(this$0), (int)24, null);
    }

    private static final void apply$lambda$2(OpenApiPluginSuggestion this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        FUSEventSource.EDITOR.logIgnoreExtension(this$0.project);
        OpenApiSuggestionProviderKt.access$dismissPluginSuggestion();
        EditorNotifications.getInstance((Project)this$0.project).updateAllNotifications();
    }
}

