/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.editor;

import com.intellij.application.options.CodeStyle;
import com.intellij.formatting.IndentInfo;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.lineIndent.LineIndentProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.TextMateLanguage;
import org.jetbrains.plugins.textmate.TextMateService;
import org.jetbrains.plugins.textmate.editor.TextMateEditorUtils;
import org.jetbrains.plugins.textmate.editor.Utils;
import org.jetbrains.plugins.textmate.language.preferences.IndentAction;
import org.jetbrains.plugins.textmate.language.preferences.IndentationRules;
import org.jetbrains.plugins.textmate.language.preferences.OnEnterRule;
import org.jetbrains.plugins.textmate.language.preferences.Preferences;
import org.jetbrains.plugins.textmate.language.preferences.PreferencesRegistry;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateScope;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u00a2\u0006\u0002\u0010\fJ,\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0004H\u0016J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/textmate/editor/TextMateLineIndentProvider;", "Lcom/intellij/psi/codeStyle/lineIndent/LineIndentProvider;", "()V", "getIndentChange", "", "prevLineText", "", "indentationRules", "Lorg/jetbrains/plugins/textmate/language/preferences/IndentationRules;", "onEnterRules", "", "Lorg/jetbrains/plugins/textmate/language/preferences/OnEnterRule;", "(Ljava/lang/String;Lorg/jetbrains/plugins/textmate/language/preferences/IndentationRules;Ljava/util/List;)Ljava/lang/Integer;", "getLineIndent", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "language", "Lcom/intellij/lang/Language;", "offset", "isSuitableFor", "", "intellij.textmate"})
@SourceDebugExtension(value={"SMAP\nTextMateLineIndentProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextMateLineIndentProvider.kt\norg/jetbrains/plugins/textmate/editor/TextMateLineIndentProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,89:1\n1789#2,3:90\n1603#2,9:93\n1855#2:102\n1856#2:104\n1612#2:105\n1#3:103\n*S KotlinDebug\n*F\n+ 1 TextMateLineIndentProvider.kt\norg/jetbrains/plugins/textmate/editor/TextMateLineIndentProvider\n*L\n29#1:90,3\n30#1:93,9\n30#1:102\n30#1:104\n30#1:105\n30#1:103\n*E\n"})
public final class TextMateLineIndentProvider
implements LineIndentProvider {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public String getLineIndent(@NotNull Project project, @NotNull Editor editor, @Nullable Language language, int offset) {
        void $this$mapNotNullTo$iv$iv;
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (!(language instanceof TextMateLanguage)) {
            return null;
        }
        TextMateScope textMateScope = TextMateEditorUtils.getCurrentScopeSelector((EditorEx)editor);
        if (textMateScope == null) {
            return null;
        }
        TextMateScope actualScope = textMateScope;
        PreferencesRegistry preferencesRegistry = TextMateService.getInstance().getPreferenceRegistry();
        Intrinsics.checkNotNullExpressionValue((Object)preferencesRegistry, (String)"getPreferenceRegistry(...)");
        PreferencesRegistry registry = preferencesRegistry;
        List<Preferences> list = registry.getPreferences(actualScope);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getPreferences(...)");
        List<Preferences> preferencesList = list;
        Iterable iterable = preferencesList;
        IndentationRules initial$iv = IndentationRules.empty();
        boolean $i$f$fold22 = false;
        IndentationRules accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void r;
            Preferences preferences = (Preferences)element$iv;
            IndentationRules x = accumulator$iv;
            boolean bl = false;
            accumulator$iv = x.updateWith(r.getIndentationRules());
        }
        IndentationRules indentationRules = accumulator$iv;
        Intrinsics.checkNotNullExpressionValue((Object)indentationRules, (String)"fold(...)");
        IndentationRules indentationRules2 = indentationRules;
        Iterable $this$mapNotNull$iv = preferencesList;
        boolean $i$f$mapNotNull = false;
        Iterable $i$f$fold22 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Set<OnEnterRule> it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Preferences it = (Preferences)element$iv$iv;
            boolean bl2 = false;
            if (it.getOnEnterRules() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List onEnterRules = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
        DocumentEx documentEx = ((EditorEx)editor).getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        DocumentEx document = documentEx;
        int lineNumber = document.getLineNumber(offset);
        if ((long)lineNumber <= 0L) {
            return null;
        }
        int lineOffset = document.getLineStartOffset(lineNumber);
        if ((long)lineOffset <= 0L) {
            return null;
        }
        String string = document.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String prevLineText = (String)StringsKt.lines((CharSequence)string).get(lineNumber - 1);
        CommonCodeStyleSettings.IndentOptions indentOptions = CodeStyle.getSettings((Project)project, (VirtualFile)((EditorEx)editor).getVirtualFile()).getIndentOptionsByFile(project, ((EditorEx)editor).getVirtualFile(), null);
        Intrinsics.checkNotNullExpressionValue((Object)indentOptions, (String)"getIndentOptionsByFile(...)");
        CommonCodeStyleSettings.IndentOptions options = indentOptions;
        Integer indentChange = this.getIndentChange(prevLineText, indentationRules2, onEnterRules);
        if (indentChange != null) {
            int baseLineIndent = Utils.Companion.indentOfLine(prevLineText, options);
            return new IndentInfo(0, baseLineIndent + indentChange * options.TAB_SIZE, 0).generateNewWhiteSpace(options);
        }
        return null;
    }

    public boolean isSuitableFor(@Nullable Language language) {
        return language != null && language instanceof TextMateLanguage;
    }

    private final Integer getIndentChange(String prevLineText, IndentationRules indentationRules, List<OnEnterRule> onEnterRules) {
        CharSequence charSequence;
        CharSequence charSequence2;
        for (OnEnterRule onEnterRule : onEnterRules) {
            CharSequence charSequence3;
            String beforeTextPatter = onEnterRule.getBeforeText().getText();
            if (!new Regex(beforeTextPatter).containsMatchIn(charSequence3 = (CharSequence)prevLineText)) continue;
            switch (WhenMappings.$EnumSwitchMapping$0[onEnterRule.getAction().getIndent().ordinal()]) {
                case 1: {
                    return 1;
                }
                case 2: {
                    return null;
                }
            }
        }
        String increasePattern = indentationRules.getIncreaseIndentPattern();
        if (increasePattern != null && new Regex(increasePattern).matches(charSequence2 = (CharSequence)prevLineText)) {
            return 1;
        }
        String string = indentationRules.getDecreaseIndentPattern();
        if (string != null && new Regex(string).matches(charSequence = (CharSequence)prevLineText)) {
            return -1;
        }
        return null;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IndentAction.values().length];
            try {
                nArray[IndentAction.INDENT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IndentAction.NONE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

