/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.highlight;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiFile;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.highlight.QodanaHighlightedReportService;
import org.jetbrains.qodana.highlight.QodanaHighlightingPassState;
import org.jetbrains.qodana.highlight.QodanaReportHighlightingPass;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R9\u0010\u0005\u001a-\u0012$\u0012\"\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b \n*\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b\u0018\u00010\u00070\u00070\u0006\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/qodana/highlight/QodanaHighlightingPassRegistrar;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactory;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactoryRegistrar;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "QODANA_MARKUP_HIGHLIGHTED_INFOS", "Lcom/intellij/openapi/util/Key;", "Ljava/util/concurrent/atomic/AtomicReference;", "", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "createHighlightingPass", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "registerHighlightingPassFactory", "", "registrar", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassRegistrar;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.qodana"})
public final class QodanaHighlightingPassRegistrar
implements TextEditorHighlightingPassFactory,
TextEditorHighlightingPassFactoryRegistrar,
DumbAware {
    @NotNull
    private final Key<AtomicReference<List<HighlightInfo>>> QODANA_MARKUP_HIGHLIGHTED_INFOS;

    public QodanaHighlightingPassRegistrar() {
        Key key = Key.create((String)"Qodana.Markup.Highlighted.Infos");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        this.QODANA_MARKUP_HIGHLIGHTED_INFOS = key;
    }

    public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, null, false, -1);
    }

    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        QodanaHighlightedReportService qodanaHighlightedReportService = QodanaHighlightedReportService.Companion.getInstanceIfCreated(project);
        if (qodanaHighlightedReportService == null) {
            return null;
        }
        QodanaHighlightedReportService highlightedReportService = qodanaHighlightedReportService;
        Project project2 = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        QodanaHighlightingPassState qodanaHighlightingPassState = QodanaHighlightingPassState.Companion.getOrCreateForEditor(project2, editor);
        if (qodanaHighlightingPassState == null) {
            return null;
        }
        QodanaHighlightingPassState passState = qodanaHighlightingPassState;
        return new QodanaReportHighlightingPass(file, editor, highlightedReportService, passState);
    }
}

