/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.inspections.coverage;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.DefaultCoverageFileProvider;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.report.XMLProjectData;
import com.intellij.util.containers.ComparatorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.staticAnalysis.inspections.coverage.CoverageInspectionBaseKt;
import org.jetbrains.qodana.staticAnalysis.inspections.coverage.CoverageStatistics;
import org.jetbrains.qodana.staticAnalysis.inspections.coverage.UtilsKt;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaGlobalInspectionContext;
import org.jetbrains.qodana.staticAnalysis.script.ComparingScriptKt;
import org.jetbrains.qodana.staticAnalysis.script.ComparingScriptState;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u00a4\u0001\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a*\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0000\u001a\u001a\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u0019\u001a\u00020\u0002H\u0002\u001a*\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u001b2\u0006\u0010!\u001a\u00020\"\u001a.\u0010#\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00142\u0006\u0010'\u001a\u00020(\u001a\u001e\u0010)\u001a\u0004\u0018\u00010\u00022\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010+\u001a\u00020,\u001a\u0012\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u00020 H\u0002\u001a\u000e\u00100\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"\u001a\u0010\u00101\u001a\u00020\u00142\u0006\u00102\u001a\u00020\u0002H\u0002\u001a\u0010\u00103\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"H\u0000\u001aB\u00104\u001a\u00020\u00142\b\u0010\n\u001a\u0004\u0018\u00010\u000e2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\"2\u0006\u00105\u001a\u00020\r2\u0006\u0010&\u001a\u00020\u00142\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u001a@\u00106\u001a\u00020\u00142\b\u0010\n\u001a\u0004\u0018\u00010\u000e2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\"2\u0006\u00105\u001a\u00020\r2\u0006\u0010&\u001a\u00020\u00142\u0006\u0010'\u001a\u00020(\u001a \u00107\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000e2\u0006\u00108\u001a\u00020,2\u0006\u0010'\u001a\u00020(\u001a(\u00109\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u00108\u001a\u00020,2\u0006\u0010'\u001a\u00020(H\u0002\u001a\u001e\u0010:\u001a\u00020\u00072\u0006\u0010;\u001a\u00020<2\u0006\u00108\u001a\u00020,2\u0006\u0010'\u001a\u00020(\u001a\u000e\u0010=\u001a\u00020\u00022\u0006\u0010>\u001a\u00020\u0002\u001a\u0018\u0010?\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\"2\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0010\u0010@\u001a\u0004\u0018\u00010\t2\u0006\u0010\b\u001a\u00020\t\u001a \u0010A\u001a\u00020\u000b2\u0006\u0010B\u001a\u00020\u000b2\u0006\u0010C\u001a\u00020\u00022\u0006\u0010D\u001a\u00020\u0002H\u0002\u001a\u0018\u0010E\u001a\u00020\u000b2\u0006\u0010B\u001a\u00020\u000b2\u0006\u0010F\u001a\u00020,H\u0002\u001a\u0016\u0010G\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010H\u001a\u00020I\u001a \u0010J\u001a\u00020\u00072\u0006\u0010K\u001a\u00020L2\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010M\u001a\u00020\u0002\u001a\n\u0010N\u001a\u0004\u0018\u00010IH\u0000\u001a\u0012\u0010O\u001a\u0004\u0018\u00010I2\u0006\u0010!\u001a\u00020\"H\u0000\u001a(\u0010P\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u001b2\u0006\u0010'\u001a\u00020(H\u0000\u001a\u0012\u0010Q\u001a\u00020\u0007*\u00020%2\u0006\u0010R\u001a\u00020S\"\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u000e\u0010\u0005\u001a\u00020\u0002X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006T"}, d2={"CLASS_ENGINES", "", "", "getCLASS_ENGINES", "()Ljava/util/Set;", "COVERAGE_DATA", "applyNewDataToBundle", "", "bundle", "Lcom/intellij/coverage/CoverageSuitesBundle;", "data", "Lcom/intellij/rt/coverage/data/ProjectData;", "computeCoverage", "", "Lcom/intellij/rt/coverage/data/ClassData;", "document", "Lcom/intellij/openapi/editor/Document;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "fullScanNeeded", "", "computeProblemDescriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "element", "Lcom/intellij/psi/PsiElement;", "descriptionTemplate", "computeSuites", "", "Lcom/intellij/coverage/CoverageSuite;", "engine", "Lcom/intellij/coverage/CoverageEngine;", "coverageFiles", "Ljava/io/File;", "project", "Lcom/intellij/openapi/project/Project;", "failAndLoadMissingCoverageIfNeeded", "psiFile", "Lcom/intellij/psi/PsiFile;", "warnMissingCoverage", "globalContext", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaGlobalInspectionContext;", "findPathToRemap", "files", "contentRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "getCoverageRunner", "Lcom/intellij/coverage/CoverageRunner;", "file", "isLocalChanges", "isRelativePath", "pathString", "isUnderLocalChangesOnOldCode", "issueWithClassCoverage", "threshold", "issueWithMethodCoverage", "loadClassData", "virtualFile", "loadMissingData", "loadXmlLineData", "fileInfo", "Lcom/intellij/rt/coverage/report/XMLProjectData$FileInfo;", "normalizeFilePath", "path", "remapCoverage", "remapCoverageFromCloud", "remapData", "oldData", "oldPath", "newPath", "remapDataToProjectDir", "projectPath", "removePrefixFromCoverage", "prefix", "Ljava/nio/file/Path;", "reportElement", "problemsHolder", "Lcom/intellij/codeInspection/ProblemsHolder;", "problem", "reportsInExternalPath", "reportsInProjectPath", "retrieveCoverageData", "iterateContents", "visitor", "Lcom/intellij/psi/PsiElementVisitor;", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nutils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 utils.kt\norg/jetbrains/qodana/staticAnalysis/inspections/coverage/UtilsKt\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,308:1\n37#2,2:309\n37#2,2:325\n215#3,2:311\n215#3,2:313\n215#3,2:327\n215#3,2:329\n1#4:315\n731#5,9:316\n*S KotlinDebug\n*F\n+ 1 utils.kt\norg/jetbrains/qodana/staticAnalysis/inspections/coverage/UtilsKt\n*L\n117#1:309,2\n262#1:325,2\n131#1:311,2\n159#1:313,2\n283#1:327,2\n300#1:329,2\n262#1:316,9\n*E\n"})
public final class UtilsKt {
    @NotNull
    public static final String COVERAGE_DATA = "qodana.coverage.input";
    @NotNull
    private static final Set<String> CLASS_ENGINES;

    @NotNull
    public static final Set<String> getCLASS_ENGINES() {
        return CLASS_ENGINES;
    }

    @NotNull
    public static final String normalizeFilePath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String filePath = path;
        if (SystemInfo.isWindows) {
            String string = StringUtil.toLowerCase((String)filePath);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            filePath = string;
        }
        String string = FileUtil.toSystemIndependentName((String)filePath);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
        return string;
    }

    public static final void iterateContents(@NotNull PsiFile $this$iterateContents, @NotNull PsiElementVisitor visitor) {
        Intrinsics.checkNotNullParameter((Object)$this$iterateContents, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        $this$iterateContents.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(visitor){
            final /* synthetic */ PsiElementVisitor $visitor;
            {
                this.$visitor = $visitor;
            }

            public void visitElement(@NotNull PsiElement element2) {
                Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
                ProgressManager.checkCanceled();
                for (PsiElement child = element2.getFirstChild(); child != null; child = child.getNextSibling()) {
                    child.accept(this.$visitor);
                    child.accept((PsiElementVisitor)this);
                }
            }
        });
    }

    public static final void reportElement(@NotNull ProblemsHolder problemsHolder, @NotNull PsiElement element2, @InspectionMessage @NotNull String problem) {
        Intrinsics.checkNotNullParameter((Object)problemsHolder, (String)"problemsHolder");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        Project project = problemsHolder.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (UtilsKt.isLocalChanges(project)) {
            return;
        }
        problemsHolder.registerProblem(UtilsKt.computeProblemDescriptor(element2, problem));
    }

    public static final boolean issueWithClassCoverage(@Nullable ClassData data, @NotNull PsiFile psiFile2, @NotNull TextRange textRange, @NotNull Project project, int threshold, boolean warnMissingCoverage, boolean fullScanNeeded) {
        Intrinsics.checkNotNullParameter((Object)psiFile2, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (data == null) {
            return warnMissingCoverage;
        }
        Document document2 = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile2);
        if (document2 == null) {
            return false;
        }
        Document doc = document2;
        return UtilsKt.computeCoverage(data, doc, textRange, fullScanNeeded) < threshold;
    }

    public static /* synthetic */ boolean issueWithClassCoverage$default(ClassData classData, PsiFile psiFile2, TextRange textRange, Project project, int n, boolean bl, boolean bl2, int n2, Object object) {
        if ((n2 & 0x40) != 0) {
            bl2 = false;
        }
        return UtilsKt.issueWithClassCoverage(classData, psiFile2, textRange, project, n, bl, bl2);
    }

    public static final boolean issueWithMethodCoverage(@Nullable ClassData data, @NotNull PsiFile psiFile2, @NotNull TextRange textRange, @NotNull Project project, int threshold, boolean warnMissingCoverage, @NotNull QodanaGlobalInspectionContext globalContext) {
        Intrinsics.checkNotNullParameter((Object)psiFile2, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)globalContext), (String)"globalContext");
        if (data == null) {
            return UtilsKt.failAndLoadMissingCoverageIfNeeded(project, textRange, psiFile2, warnMissingCoverage, globalContext);
        }
        Document document2 = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile2);
        if (document2 == null) {
            return false;
        }
        Document doc = document2;
        return UtilsKt.computeCoverage$default(data, doc, textRange, false, 8, null) < threshold;
    }

    public static final void loadClassData(@Nullable ClassData data, @NotNull VirtualFile virtualFile2, @NotNull QodanaGlobalInspectionContext globalContext) {
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)((Object)globalContext), (String)"globalContext");
        if (data == null) {
            return;
        }
        CoverageStatistics coverageStatistics = (CoverageStatistics)globalContext.getUserData(CoverageStatistics.Companion.getStats());
        if (coverageStatistics == null) {
            return;
        }
        CoverageStatistics stat = coverageStatistics;
        stat.loadClassData(data, virtualFile2);
    }

    public static final int computeCoverage(@NotNull ClassData data, @NotNull Document document2, @NotNull TextRange textRange, boolean fullScanNeeded) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        int startOffset = textRange.getStartOffset();
        int endOffset = textRange.getEndOffset();
        int startLineNumber = document2.getLineNumber(startOffset) + 1;
        int endLineNumber = document2.getLineNumber(endOffset) + 1;
        int maxStoredLine = data.getLines().length - 1;
        int totalLines = 0;
        int coveredLines = 0;
        boolean firstLine = true;
        int i = startLineNumber;
        Comparable comparable = ComparatorUtil.min((Comparable)Integer.valueOf(maxStoredLine), (Comparable)Integer.valueOf(endLineNumber));
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"min(...)");
        int n = ((Number)((Object)comparable)).intValue();
        if (i <= n) {
            while (true) {
                LineData lineData = data.getLineData(i);
                if (!data.isIgnoredLine(i) && lineData != null) {
                    ++totalLines;
                    if ((byte)lineData.getStatus() != 0) {
                        ++coveredLines;
                    } else if (firstLine && !fullScanNeeded) {
                        return 0;
                    }
                    firstLine = false;
                }
                if (i == n) break;
                ++i;
            }
        }
        if (totalLines == 0) {
            return 100;
        }
        return coveredLines * 100 / totalLines;
    }

    public static /* synthetic */ int computeCoverage$default(ClassData classData, Document document2, TextRange textRange, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return UtilsKt.computeCoverage(classData, document2, textRange, bl);
    }

    @Nullable
    public static final ProjectData retrieveCoverageData(@NotNull CoverageEngine engine, @NotNull List<? extends File> coverageFiles2, @NotNull QodanaGlobalInspectionContext globalContext) {
        ProjectData data;
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Intrinsics.checkNotNullParameter(coverageFiles2, (String)"coverageFiles");
        Intrinsics.checkNotNullParameter((Object)((Object)globalContext), (String)"globalContext");
        Project project = globalContext.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        List<CoverageSuite> suites = UtilsKt.computeSuites(engine, coverageFiles2, project);
        if (!CollectionsKt.any((Iterable)suites)) {
            return null;
        }
        Collection $this$toTypedArray$iv = suites;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        CoverageSuitesBundle bundle = new CoverageSuitesBundle(thisCollection$iv.toArray(new CoverageSuite[0]));
        if (bundle.getCoverageData() == null) {
            return null;
        }
        if (!CLASS_ENGINES.contains(engine.getClass().getSimpleName())) {
            ProjectData projectData = bundle.getCoverageData();
            Intrinsics.checkNotNull((Object)projectData);
            if (projectData.getClasses().isEmpty()) {
                CoverageInspectionBaseKt.getLogger().error("Coverage reports were empty or not loaded correctly");
                return null;
            }
            Project project2 = globalContext.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            UtilsKt.remapCoverage(project2, bundle);
        }
        if ((data = bundle.getCoverageData()) != null) {
            CoverageStatistics stat;
            Project project3 = globalContext.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
            if (UtilsKt.isLocalChanges(project3) && (stat = (CoverageStatistics)globalContext.getUserData(CoverageStatistics.Companion.getStats())) != null) {
                Map map2 = data.getClasses();
                Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getClasses(...)");
                Map $this$forEach$iv = map2;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry x = element$iv = iterator2.next();
                    boolean bl = false;
                    Object v = x.getValue();
                    Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
                    stat.processReportClassData((ClassData)v);
                }
            }
        }
        return data;
    }

    @NotNull
    public static final List<CoverageSuite> computeSuites(@NotNull CoverageEngine engine, @NotNull List<? extends File> coverageFiles2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Intrinsics.checkNotNullParameter(coverageFiles2, (String)"coverageFiles");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        List runnersAndCovers = new ArrayList();
        for (File file : coverageFiles2) {
            CoverageRunner runner;
            if (UtilsKt.getCoverageRunner(file) == null || !runner.acceptsCoverageEngine(engine)) continue;
            runnersAndCovers.add(new Pair((Object)runner, (Object)file));
        }
        CoverageInspectionBaseKt.getLogger().info("Engine " + engine.getPresentableText() + " - accepted " + runnersAndCovers.size() + " files");
        if (CollectionsKt.any((Iterable)runnersAndCovers) && Boolean.parseBoolean(System.getProperty("qodana.coverage.debug.info", "false"))) {
            CoverageInspectionBaseKt.getLogger().info("Engine " + engine.getPresentableText() + " - accepted : " + CollectionsKt.joinToString$default((Iterable)runnersAndCovers, (CharSequence)", ", null, null, (int)0, null, (Function1)computeSuites.1.INSTANCE, (int)30, null));
        }
        List suites = new ArrayList();
        for (Pair pair : runnersAndCovers) {
            CoverageSuite suite2;
            CoverageRunner runner = (CoverageRunner)pair.component1();
            File cover = (File)pair.component2();
            CoverageFileProvider fileProvider = (CoverageFileProvider)new DefaultCoverageFileProvider(cover.getPath());
            if (engine.createCoverageSuite(cover.getName(), project, runner, fileProvider, -1L) == null) continue;
            suites.add(suite2);
        }
        CoverageInspectionBaseKt.getLogger().info("Engine " + engine.getPresentableText() + " - loaded " + suites.size() + " coverage suites");
        return suites;
    }

    @NotNull
    public static final ProjectData removePrefixFromCoverage(@NotNull ProjectData data, @NotNull Path prefix) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        ProjectData newData = new ProjectData();
        Map map2 = data.getClasses();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getClasses(...)");
        Map $this$forEach$iv = map2;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl = false;
            String name = (String)entry.getKey();
            ClassData oldClass = (ClassData)entry.getValue();
            ClassData newClass = newData.getOrCreateClassData(((Object)prefix.relativize(Path.of(name, new String[0]))).toString());
            Object[] objectArray = oldClass.getLines();
            Intrinsics.checkNotNull((Object)objectArray, (String)"null cannot be cast to non-null type kotlin.Array<com.intellij.rt.coverage.data.LineData?>");
            newClass.setLines((LineData[])objectArray);
        }
        return newData;
    }

    @Nullable
    public static final CoverageSuitesBundle remapCoverageFromCloud(@NotNull CoverageSuitesBundle bundle) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        Project project = bundle.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        VirtualFile virtualFile2 = ProjectUtil.guessProjectDir((Project)project);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile projectDir = virtualFile2;
        ProjectData projectData = bundle.getCoverageData();
        Intrinsics.checkNotNull((Object)projectData);
        UtilsKt.applyNewDataToBundle(bundle, UtilsKt.remapDataToProjectDir(projectData, projectDir));
        return bundle;
    }

    public static final boolean isUnderLocalChangesOnOldCode(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return project.getUserData(ComparingScriptKt.getCOMPARING_SCRIPT_STATE()) == ComparingScriptState.RUN_BEFORE;
    }

    public static final boolean isLocalChanges(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return project.getUserData(ComparingScriptKt.getCOMPARING_SCRIPT_STATE()) != null;
    }

    public static final boolean failAndLoadMissingCoverageIfNeeded(@NotNull Project project, @NotNull TextRange textRange, @NotNull PsiFile psiFile2, boolean warnMissingCoverage, @NotNull QodanaGlobalInspectionContext globalContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        Intrinsics.checkNotNullParameter((Object)psiFile2, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)((Object)globalContext), (String)"globalContext");
        if (warnMissingCoverage) {
            Document document2 = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile2);
            if (document2 == null) {
                return false;
            }
            Document doc = document2;
            VirtualFile virtualFile2 = psiFile2.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getVirtualFile(...)");
            UtilsKt.loadMissingData(doc, textRange, virtualFile2, globalContext);
        }
        return warnMissingCoverage;
    }

    public static final void loadXmlLineData(@NotNull XMLProjectData.FileInfo fileInfo, @NotNull VirtualFile virtualFile2, @NotNull QodanaGlobalInspectionContext globalContext) {
        Intrinsics.checkNotNullParameter((Object)fileInfo, (String)"fileInfo");
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)((Object)globalContext), (String)"globalContext");
        CoverageStatistics coverageStatistics = (CoverageStatistics)globalContext.getUserData(CoverageStatistics.Companion.getStats());
        if (coverageStatistics == null) {
            return;
        }
        CoverageStatistics stat = coverageStatistics;
        stat.loadXmlLineData(fileInfo, virtualFile2);
    }

    @Nullable
    public static final Path reportsInProjectPath(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object object = ProjectUtil.guessProjectDir((Project)project);
        if (object == null || (object = object.toNioPath()) == null) {
            return null;
        }
        Object projectPath = object;
        Path reportsPath = projectPath.resolve(".qodana").resolve("code-coverage");
        Intrinsics.checkNotNull((Object)reportsPath);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(reportsPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return reportsPath.toAbsolutePath();
        }
        return null;
    }

    @Nullable
    public static final Path reportsInExternalPath() {
        String string = System.getProperty(COVERAGE_DATA);
        if (string == null) {
            return null;
        }
        String externalPath = string;
        return Path.of(externalPath, new String[0]);
    }

    private static final void loadMissingData(Document document2, TextRange textRange, VirtualFile virtualFile2, QodanaGlobalInspectionContext globalContext) {
        CoverageStatistics coverageStatistics = (CoverageStatistics)globalContext.getUserData(CoverageStatistics.Companion.getStats());
        if (coverageStatistics == null) {
            return;
        }
        CoverageStatistics stat = coverageStatistics;
        stat.loadMissingData(document2, textRange, virtualFile2);
    }

    private static final ProblemDescriptor computeProblemDescriptor(PsiElement element2, @InspectionMessage String descriptionTemplate) {
        String textContent = element2.getText();
        Intrinsics.checkNotNull((Object)textContent);
        int it = StringsKt.indexOf$default((CharSequence)textContent, (char)'\n', (int)0, (boolean)false, (int)6, null);
        boolean bl = false;
        int endOffsetFirstLine = it == -1 ? textContent.length() : it;
        ProblemDescriptor problemDescriptor = InspectionManager.getInstance((Project)element2.getProject()).createProblemDescriptor(element2, new TextRange(0, endOffsetFirstLine), descriptionTemplate, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, true, new LocalQuickFix[0]);
        Intrinsics.checkNotNullExpressionValue((Object)problemDescriptor, (String)"createProblemDescriptor(...)");
        return problemDescriptor;
    }

    private static final CoverageRunner getCoverageRunner(File file) {
        for (CoverageRunner runner : CoverageRunner.EP_NAME.getExtensionList()) {
            String[] stringArray;
            Intrinsics.checkNotNullExpressionValue((Object)runner.getDataFileExtensions(), (String)"getDataFileExtensions(...)");
            for (String extension : stringArray) {
                if (!Comparing.strEqual((String)FilesKt.getExtension((File)file), (String)extension) || !runner.canBeLoaded(file)) continue;
                return runner;
            }
        }
        return null;
    }

    private static final void remapCoverage(Project project, CoverageSuitesBundle bundle) {
        ProjectData projectData = bundle.getCoverageData();
        Intrinsics.checkNotNull((Object)projectData);
        ProjectData data = projectData;
        VirtualFile[] virtualFileArray = ((Iterable)data.getClasses().keySet()).iterator();
        if (!virtualFileArray.hasNext()) {
            throw new NoSuchElementException();
        }
        String it = (String)virtualFileArray.next();
        boolean bl = false;
        Comparable comparable = (Comparable)((Object)it);
        while (virtualFileArray.hasNext()) {
            String it2 = (String)virtualFileArray.next();
            $i$a$-minOf-UtilsKt$remapCoverage$1 = false;
            Comparable comparable2 = (Comparable)((Object)it2);
            if (comparable.compareTo(comparable2) <= 0) continue;
            comparable = comparable2;
        }
        Comparable comparable3 = comparable;
        Intrinsics.checkNotNullExpressionValue((Object)comparable3, (String)"minOf(...)");
        if (UtilsKt.isRelativePath((String)((Object)comparable3))) {
            Project project2 = bundle.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            VirtualFile virtualFile2 = ProjectUtil.guessProjectDir((Project)project2);
            if (virtualFile2 == null) {
                return;
            }
            VirtualFile projectDir = virtualFile2;
            data = UtilsKt.remapDataToProjectDir(data, projectDir);
            UtilsKt.applyNewDataToBundle(bundle, data);
        } else {
            ProjectRootManager rootManager = ProjectRootManager.getInstance((Project)project);
            VirtualFile[] roots2 = (VirtualFile[])ReadAction.compute((ThrowableComputable)new ThrowableComputable(rootManager){
                final /* synthetic */ ProjectRootManager $rootManager;
                {
                    this.$rootManager = $rootManager;
                }

                public final VirtualFile[] compute() {
                    return this.$rootManager.getContentRoots();
                }
            });
            Intrinsics.checkNotNull((Object)roots2);
            for (VirtualFile contentRoot : roots2) {
                Set<String> files2 = data.getClasses().keySet();
                String pathToRemap = UtilsKt.findPathToRemap(files2, contentRoot);
                if (pathToRemap == null) continue;
                String string = contentRoot.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                data = UtilsKt.remapData(data, pathToRemap, string);
                UtilsKt.applyNewDataToBundle(bundle, data);
            }
        }
    }

    private static final void applyNewDataToBundle(CoverageSuitesBundle bundle, ProjectData data) {
        bundle.setCoverageData(data);
        CoverageSuite[] coverageSuiteArray = bundle.getSuites();
        Intrinsics.checkNotNullExpressionValue((Object)coverageSuiteArray, (String)"getSuites(...)");
        for (CoverageSuite suiteSuite : coverageSuiteArray) {
            suiteSuite.setCoverageData(data);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final String findPathToRemap(@NotNull Set<String> files2, @NotNull VirtualFile contentRoot) {
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        Intrinsics.checkNotNullParameter((Object)contentRoot, (String)"contentRoot");
        Comparator comparator2 = Comparator.comparingInt(findPathToRemap.comparator.1.INSTANCE);
        List list2 = ContainerUtil.reverse((List)ContainerUtil.sorted((Collection)files2, comparator2));
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"reverse(...)");
        List sortedFiles = list2;
        List suspects = sortedFiles.subList(0, Math.min(3, sortedFiles.size()));
        String pathToRemap = null;
        for (String suspect : suspects) {
            void $this$toTypedArray$iv;
            List list3;
            Collection $this$dropLastWhile$iv;
            Object object = suspect;
            Regex regex = new Regex("/");
            int n = 0;
            object = regex.split((CharSequence)object, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list3 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list3 = CollectionsKt.emptyList();
            }
            $this$dropLastWhile$iv = list3;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            String[] pathParts = thisCollection$iv.toArray(new String[0]);
            Object path = "";
            String oldValue = pathToRemap;
            for (String part : pathParts) {
                String relPath = StringUtil.substringAfter((String)suspect, (String)(path = (String)path + part + "/"));
                if (relPath == null || contentRoot.findFileByRelativePath(relPath) == null) continue;
                pathToRemap = StringUtil.substringBeforeLast((String)path, (String)"/");
                break;
            }
            if (oldValue == null || Intrinsics.areEqual(oldValue, pathToRemap)) continue;
            pathToRemap = null;
            break;
        }
        return pathToRemap;
    }

    private static final ProjectData remapData(ProjectData oldData, String oldPath, String newPath) {
        ProjectData newData = new ProjectData();
        Map map2 = oldData.getClasses();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getClasses(...)");
        Map $this$forEach$iv = map2;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl = false;
            String name = (String)entry.getKey();
            ClassData oldClass = (ClassData)entry.getValue();
            Intrinsics.checkNotNull((Object)name);
            ClassData newClass = newData.getOrCreateClassData(StringsKt.replace$default((String)name, (String)oldPath, (String)newPath, (boolean)false, (int)4, null));
            Object[] objectArray = oldClass.getLines();
            Intrinsics.checkNotNull((Object)objectArray, (String)"null cannot be cast to non-null type kotlin.Array<com.intellij.rt.coverage.data.LineData?>");
            newClass.setLines((LineData[])objectArray);
        }
        return newData;
    }

    private static final boolean isRelativePath(String pathString) {
        boolean unixAbsolute = StringsKt.startsWith$default((String)pathString, (String)"/", (boolean)false, (int)2, null);
        boolean windowsAbsolute = new Regex("^[A-Za-z]:[\\\\/].*").matches((CharSequence)pathString);
        return !unixAbsolute && !windowsAbsolute;
    }

    private static final ProjectData remapDataToProjectDir(ProjectData oldData, VirtualFile projectPath) {
        ProjectData newData = new ProjectData();
        Map map2 = oldData.getClasses();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getClasses(...)");
        Map $this$forEach$iv = map2;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl = false;
            String name = (String)entry.getKey();
            ClassData oldClass = (ClassData)entry.getValue();
            VirtualFile fixedPathFile = projectPath.findFileByRelativePath(FileUtil.toSystemIndependentName((String)name));
            if (fixedPathFile == null) continue;
            ClassData newClass = newData.getOrCreateClassData(fixedPathFile.getPath());
            Object[] objectArray = oldClass.getLines();
            Intrinsics.checkNotNull((Object)objectArray, (String)"null cannot be cast to non-null type kotlin.Array<com.intellij.rt.coverage.data.LineData?>");
            newClass.setLines((LineData[])objectArray);
        }
        return newData;
    }

    static {
        Object[] objectArray = new String[]{"JavaCoverageEngine", "XMLReportEngine"};
        CLASS_ENGINES = SetsKt.setOf((Object[])objectArray);
    }
}

