/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.inspections.runner;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ex.InspectionProblemConsumer;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.jetbrains.qodana.sarif.model.Fix;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.AsyncInspectionToolResultWriter;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.Problem;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaToolResultDatabase;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.XmlProblem;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.globalOutput.GlobalOutputConsumer;
import org.jetbrains.qodana.staticAnalysis.profile.NamedInspectionGroup;
import org.jetbrains.qodana.staticAnalysis.profile.QodanaProfile;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0017\u001a\u00020\u0018H\u0086@\u00a2\u0006\u0002\u0010\u0019J\u001c\u0010\u001a\u001a\u00020\u00182\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u0014J#\u0010\u001a\u001a\u00020\u00182\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u001c2\u0006\u0010\u001e\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b!J(\u0010\u001a\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u00162\u000e\u0010#\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030$H\u0016J\u001c\u0010%\u001a\u00020\u00182\f\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u001cH\u0086@\u00a2\u0006\u0002\u0010(R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaProblemConsumer;", "Lcom/intellij/codeInspection/ex/InspectionProblemConsumer;", "project", "Lcom/intellij/openapi/project/Project;", "database", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaToolResultDatabase;", "profileState", "Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaProfile$QodanaProfileState;", "qodanaRunScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaToolResultDatabase;Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaProfile$QodanaProfileState;Lkotlinx/coroutines/CoroutineScope;)V", "macroManager", "Lcom/intellij/openapi/components/PathMacroManager;", "Lorg/jetbrains/annotations/NotNull;", "writer", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/AsyncInspectionToolResultWriter;", "buildFixes", "", "Lcom/jetbrains/qodana/sarif/model/Fix;", "fileUri", "", "descriptor", "Lcom/intellij/codeInspection/CommonProblemDescriptor;", "close", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "consume", "elements", "", "Lorg/jdom/Element;", "inspectionId", "problems", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/Problem;", "consume$intellij_qodana", "element", "toolWrapper", "Lcom/intellij/codeInspection/ex/InspectionToolWrapper;", "consumeGlobalOutput", "paths", "Ljava/nio/file/Path;", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nQodanaProblemConsumer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QodanaProblemConsumer.kt\norg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaProblemConsumer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n1549#2:70\n1620#2,3:71\n*S KotlinDebug\n*F\n+ 1 QodanaProblemConsumer.kt\norg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaProblemConsumer\n*L\n54#1:70\n54#1:71,3\n*E\n"})
public final class QodanaProblemConsumer
implements InspectionProblemConsumer {
    @NotNull
    private final Project project;
    @NotNull
    private final QodanaToolResultDatabase database;
    @NotNull
    private final QodanaProfile.QodanaProfileState profileState;
    @NotNull
    private final PathMacroManager macroManager;
    @NotNull
    private final AsyncInspectionToolResultWriter writer;

    public QodanaProblemConsumer(@NotNull Project project, @NotNull QodanaToolResultDatabase database, @NotNull QodanaProfile.QodanaProfileState profileState, @NotNull CoroutineScope qodanaRunScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter((Object)profileState, (String)"profileState");
        Intrinsics.checkNotNullParameter((Object)qodanaRunScope, (String)"qodanaRunScope");
        this.project = project;
        this.database = database;
        this.profileState = profileState;
        PathMacroManager pathMacroManager = PathMacroManager.getInstance((ComponentManager)((ComponentManager)this.project));
        Intrinsics.checkNotNullExpressionValue((Object)pathMacroManager, (String)"getInstance(...)");
        this.macroManager = pathMacroManager;
        this.writer = new AsyncInspectionToolResultWriter(CoroutineScopeKt.childScope$default((CoroutineScope)qodanaRunScope, null, (boolean)false, (int)3, null), this.project, this.database, this.profileState, this.macroManager);
    }

    public void consume(@NotNull Element element2, @NotNull CommonProblemDescriptor descriptor2, @NotNull InspectionToolWrapper<?, ?> toolWrapper) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter(toolWrapper, (String)"toolWrapper");
        String fileUri = element2.getChildText("file");
        String string = this.macroManager.collapsePath(fileUri);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"collapsePath(...)");
        XmlProblem problem = new XmlProblem(element2, this.buildFixes(string, descriptor2), descriptor2 instanceof UserDataHolderEx ? (UserDataHolderEx)descriptor2 : null);
        List list2 = CollectionsKt.listOf((Object)problem);
        String string2 = toolWrapper.getShortName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getShortName(...)");
        this.consume$intellij_qodana(list2, string2);
    }

    private final Set<Fix> buildFixes(String fileUri, CommonProblemDescriptor descriptor2) {
        return SetsKt.emptySet();
    }

    @Nullable
    public final Object consumeGlobalOutput(@NotNull List<? extends Path> paths, @NotNull Continuation<? super Unit> $completion) {
        Object object = GlobalOutputConsumer.Companion.runConsumers$intellij_qodana(this.profileState, paths, this.database, this.project, (Function2<? super List<? extends Problem>, ? super String, Unit>)((Function2)new Function2<List<? extends Problem>, String, Unit>((Object)this){

            public final void invoke(@NotNull List<? extends Problem> p0, @NotNull String p1) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                ((QodanaProblemConsumer)this.receiver).consume$intellij_qodana(p0, p1);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    public final void consume(@NotNull List<? extends Element> elements, @NotNull String inspectionId) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter((Object)inspectionId, (String)"inspectionId");
        Iterable iterable = elements;
        QodanaProblemConsumer qodanaProblemConsumer = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Element element2 = (Element)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new XmlProblem((Element)it, null, null, 6, null));
        }
        qodanaProblemConsumer.consume$intellij_qodana((List)destination$iv$iv, inspectionId);
    }

    public final void consume$intellij_qodana(@NotNull List<? extends Problem> problems2, @NotNull String inspectionId) {
        Intrinsics.checkNotNullParameter(problems2, (String)"problems");
        Intrinsics.checkNotNullParameter((Object)inspectionId, (String)"inspectionId");
        this.profileState.onReceive(inspectionId, problems2.size());
        NamedInspectionGroup.State state = this.profileState.getStateByInspectionId().get(inspectionId);
        if (state == null) {
            return;
        }
        NamedInspectionGroup.State profileGroupState = state;
        this.writer.batchConsume((Iterable<? extends Problem>)problems2, (Function1<? super Problem, Boolean>)((Function1)new Function1<Problem, Boolean>(profileGroupState, inspectionId){
            final /* synthetic */ NamedInspectionGroup.State $profileGroupState;
            final /* synthetic */ String $inspectionId;
            {
                this.$profileGroupState = $profileGroupState;
                this.$inspectionId = $inspectionId;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Problem problem) {
                Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
                String relativePath = problem.getFile();
                String module2 = problem.getModule();
                return this.$profileGroupState.onConsumeProblem(this.$inspectionId, relativePath, module2);
            }
        }));
    }

    @Nullable
    public final Object close(@NotNull Continuation<? super Unit> $completion) {
        Object object = this.writer.close($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }
}

