/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.coverage.CoverageLogger;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.DefaultCoverageFileProvider;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.rt.coverage.data.ProjectData;
import java.io.File;
import java.lang.ref.SoftReference;
import java.util.concurrent.TimeUnit;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseCoverageSuite
implements CoverageSuite,
JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance((String)BaseCoverageSuite.class.getName());
    @NonNls
    private static final String FILE_PATH = "FILE_PATH";
    @NonNls
    private static final String SOURCE_PROVIDER = "SOURCE_PROVIDER";
    @NonNls
    private static final String MODIFIED_STAMP = "MODIFIED";
    @NonNls
    private static final String NAME_ATTRIBUTE = "NAME";
    @NonNls
    private static final String COVERAGE_RUNNER = "RUNNER";
    @NonNls
    private static final String COVERAGE_BY_TEST_ENABLED_ATTRIBUTE_NAME = "COVERAGE_BY_TEST_ENABLED";
    @NonNls
    private static final String BRANCH_COVERAGE_ATTRIBUTE_NAME = "COVERAGE_TRACING_ENABLED";
    private SoftReference<ProjectData> myCoverageData;
    private String myName;
    private Project myProject;
    protected CoverageRunner myRunner;
    private CoverageFileProvider myCoverageDataFileProvider;
    private long myTimestamp;
    private RunConfigurationBase<?> myConfiguration;
    protected boolean myTrackTestFolders;
    protected boolean myBranchCoverage;
    protected boolean myCoverageByTestEnabled;

    protected BaseCoverageSuite() {
        this.myCoverageData = new SoftReference<Object>(null);
        this.myTrackTestFolders = false;
        this.myBranchCoverage = false;
        this.myCoverageByTestEnabled = false;
    }

    public BaseCoverageSuite(@NotNull String name, @Nullable Project project2, @Nullable CoverageRunner runner, @Nullable CoverageFileProvider fileProvider, long timestamp) {
        if (name == null) {
            BaseCoverageSuite.$$$reportNull$$$0(0);
        }
        this.myCoverageData = new SoftReference<Object>(null);
        this.myTrackTestFolders = false;
        this.myBranchCoverage = false;
        this.myCoverageByTestEnabled = false;
        this.myName = name;
        this.myProject = project2;
        this.myRunner = runner;
        this.myCoverageDataFileProvider = fileProvider;
        this.myTimestamp = timestamp;
    }

    @Deprecated
    public BaseCoverageSuite(String name, @Nullable CoverageFileProvider fileProvider, long timestamp, boolean coverageByTestEnabled, boolean branchCoverage, boolean trackTestFolders, CoverageRunner coverageRunner, @Nullable Project project2) {
        this(name, project2, coverageRunner, fileProvider, timestamp);
        this.myTrackTestFolders = trackTestFolders;
        this.myBranchCoverage = branchCoverage;
        this.myCoverageByTestEnabled = coverageByTestEnabled;
    }

    @Deprecated
    public BaseCoverageSuite(String name, @Nullable CoverageFileProvider fileProvider, long timestamp, boolean coverageByTestEnabled, boolean branchCoverage, boolean trackTestFolders, CoverageRunner coverageRunner) {
        this(name, fileProvider, timestamp, coverageByTestEnabled, branchCoverage, trackTestFolders, coverageRunner, null);
    }

    @Override
    public boolean isValid() {
        return this.myCoverageDataFileProvider.isValid();
    }

    @Override
    public String getPresentableName() {
        return this.myName;
    }

    @Override
    public Project getProject() {
        return this.myProject;
    }

    public void setProject(Project project2) {
        this.myProject = project2;
    }

    @Override
    public CoverageRunner getRunner() {
        return this.myRunner;
    }

    @Override
    @NotNull
    public CoverageFileProvider getCoverageDataFileProvider() {
        CoverageFileProvider coverageFileProvider = this.myCoverageDataFileProvider;
        if (coverageFileProvider == null) {
            BaseCoverageSuite.$$$reportNull$$$0(1);
        }
        return coverageFileProvider;
    }

    @Override
    public long getLastCoverageTimeStamp() {
        return this.myTimestamp;
    }

    @Override
    public boolean isTrackTestFolders() {
        return this.myTrackTestFolders;
    }

    @Override
    public boolean isBranchCoverage() {
        return this.myBranchCoverage;
    }

    @Override
    public boolean isCoverageByTestEnabled() {
        return this.myCoverageByTestEnabled;
    }

    @Nullable
    public RunConfigurationBase<?> getConfiguration() {
        return this.myConfiguration;
    }

    public void setConfiguration(RunConfigurationBase<?> configuration) {
        this.myConfiguration = configuration;
    }

    @Override
    @Nullable
    public ProjectData getCoverageData(CoverageDataManager coverageDataManager) {
        ProjectData data2 = this.getCoverageData();
        if (data2 == null) {
            data2 = this.loadProjectInfo();
            this.setCoverageData(data2);
        }
        return data2;
    }

    public ProjectData getCoverageData() {
        return this.myCoverageData.get();
    }

    @Override
    public void setCoverageData(ProjectData projectData) {
        this.myCoverageData = new SoftReference<ProjectData>(projectData);
    }

    @Override
    public void restoreCoverageData() {
        this.setCoverageData(this.loadProjectInfo());
    }

    @Nullable
    protected ProjectData loadProjectInfo() {
        String sessionDataFileName = this.getCoverageDataFileName();
        File sessionDataFile = new File(sessionDataFileName);
        if (!sessionDataFile.exists()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Nonexistent file given +" + sessionDataFileName);
            }
            return null;
        }
        long startNs = System.nanoTime();
        ProjectData projectData = this.myRunner.loadCoverageData(sessionDataFile, this);
        long timeMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
        if (projectData != null) {
            CoverageLogger.logReportLoading(this.myProject, this.myRunner, timeMs, projectData.getClassesNumber());
        }
        return projectData;
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.myCoverageDataFileProvider = BaseCoverageSuite.readDataFileProviderAttribute(element);
        this.myName = element.getAttributeValue(NAME_ATTRIBUTE);
        if (this.myName == null) {
            this.myName = BaseCoverageSuite.generateName(this.myCoverageDataFileProvider.getCoverageDataFilePath());
        }
        this.myTimestamp = Long.parseLong(element.getAttributeValue(MODIFIED_STAMP));
        this.myRunner = BaseCoverageSuite.readRunnerAttribute(element);
        String collectedLineInfo = element.getAttributeValue(COVERAGE_BY_TEST_ENABLED_ATTRIBUTE_NAME);
        this.myCoverageByTestEnabled = collectedLineInfo != null && Boolean.valueOf(collectedLineInfo) != false;
        String branchCoverage = element.getAttributeValue(BRANCH_COVERAGE_ATTRIBUTE_NAME);
        this.myBranchCoverage = branchCoverage != null && Boolean.valueOf(branchCoverage) != false;
    }

    public void writeExternal(Element element) throws WriteExternalException {
        String string2;
        String absolutePath = this.myCoverageDataFileProvider.getCoverageDataFilePath();
        String pathInSystemDir = FileUtil.getRelativePath((File)new File(PathManager.getSystemPath()), (File)new File(absolutePath));
        element.setAttribute(FILE_PATH, pathInSystemDir != null ? FileUtil.toSystemIndependentName((String)pathInSystemDir) : absolutePath);
        element.setAttribute(NAME_ATTRIBUTE, this.myName);
        element.setAttribute(MODIFIED_STAMP, String.valueOf(this.myTimestamp));
        CoverageFileProvider coverageFileProvider = this.myCoverageDataFileProvider;
        if (coverageFileProvider instanceof DefaultCoverageFileProvider) {
            DefaultCoverageFileProvider defaultProvider = (DefaultCoverageFileProvider)coverageFileProvider;
            string2 = defaultProvider.getSourceProvider();
        } else {
            string2 = this.myCoverageDataFileProvider.getClass().getName();
        }
        element.setAttribute(SOURCE_PROVIDER, string2);
        if (this.myRunner != null) {
            element.setAttribute(COVERAGE_RUNNER, this.myRunner.getId());
        }
        element.setAttribute(COVERAGE_BY_TEST_ENABLED_ATTRIBUTE_NAME, String.valueOf(this.myCoverageByTestEnabled));
        element.setAttribute(BRANCH_COVERAGE_ATTRIBUTE_NAME, String.valueOf(this.myBranchCoverage));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        String thisName = this.myCoverageDataFileProvider.getCoverageDataFilePath();
        String thatName = ((BaseCoverageSuite)o).myCoverageDataFileProvider.getCoverageDataFilePath();
        return thisName.equals(thatName);
    }

    public int hashCode() {
        return this.myCoverageDataFileProvider.getCoverageDataFilePath().hashCode();
    }

    public GlobalSearchScope getSearchScope(Project project2) {
        ModuleBasedConfiguration moduleConfig;
        Module module;
        GlobalSearchScope scope2;
        RunConfigurationBase<?> configuration = this.getConfiguration();
        GlobalSearchScope globalSearchScope = scope2 = this.isTrackTestFolders() ? GlobalSearchScope.projectScope((Project)project2) : GlobalSearchScopesCore.projectProductionScope((Project)project2);
        if (configuration instanceof ModuleBasedConfiguration && (module = (moduleConfig = (ModuleBasedConfiguration)configuration).getConfigurationModule().getModule()) != null) {
            return GlobalSearchScope.moduleWithDependenciesScope((Module)module).intersectWith(scope2);
        }
        return scope2;
    }

    private static String generateName(String path2) {
        String text2 = path2;
        int i = text2.lastIndexOf(File.separatorChar);
        if (i >= 0) {
            text2 = text2.substring(i + 1);
        }
        if ((i = text2.lastIndexOf(46)) >= 0) {
            text2 = text2.substring(0, i);
        }
        return text2;
    }

    @Nullable
    public static CoverageRunner readRunnerAttribute(Element element) {
        String runner = element.getAttributeValue(COVERAGE_RUNNER);
        return runner == null ? null : CoverageRunner.getInstanceById(runner);
    }

    @NotNull
    public static CoverageFileProvider readDataFileProviderAttribute(Element element) {
        String relativeOrAbsolutePath;
        File file;
        String sourceProvider = element.getAttributeValue(SOURCE_PROVIDER);
        if (sourceProvider == null) {
            sourceProvider = DefaultCoverageFileProvider.DEFAULT_LOCAL_PROVIDER_KEY;
        }
        if (!(file = new File(relativeOrAbsolutePath = FileUtil.toSystemDependentName((String)element.getAttributeValue(FILE_PATH)))).exists()) {
            file = new File(PathManager.getSystemPath(), relativeOrAbsolutePath);
        }
        return new DefaultCoverageFileProvider(file, sourceProvider);
    }

    @Deprecated
    protected void setRunner(CoverageRunner runner) {
        this.myRunner = runner;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/BaseCoverageSuite";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/BaseCoverageSuite";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoverageDataFileProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }
}

