/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.CoverageBundle;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.DefaultCoverageFileProvider;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.rt.coverage.data.ProjectData;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CoverageSuite
extends JDOMExternalizable {
    public boolean isValid();

    @NlsSafe
    public String getPresentableName();

    public Project getProject();

    @NotNull
    public CoverageEngine getCoverageEngine();

    public CoverageRunner getRunner();

    @NotNull
    public CoverageFileProvider getCoverageDataFileProvider();

    public long getLastCoverageTimeStamp();

    public boolean isTrackTestFolders();

    public boolean isBranchCoverage();

    public boolean isCoverageByTestEnabled();

    @Nullable
    public ProjectData getCoverageData(CoverageDataManager var1);

    public void setCoverageData(ProjectData var1);

    public void restoreCoverageData();

    @NotNull
    default public String getCoverageDataFileName() {
        String string2 = this.getCoverageDataFileProvider().getCoverageDataFilePath();
        if (string2 == null) {
            CoverageSuite.$$$reportNull$$$0(0);
        }
        return string2;
    }

    default public boolean canRemove() {
        DefaultCoverageFileProvider defaultProvider;
        CoverageFileProvider provider2 = this.getCoverageDataFileProvider();
        return provider2 instanceof DefaultCoverageFileProvider && Comparing.strEqual((String)(defaultProvider = (DefaultCoverageFileProvider)provider2).getSourceProvider(), (String)DefaultCoverageFileProvider.DEFAULT_LOCAL_PROVIDER_KEY);
    }

    default public void deleteCachedCoverageData() {
        File file;
        String fileName = this.getCoverageDataFileName();
        if (!FileUtil.isAncestor((String)PathManager.getSystemPath(), (String)fileName, (boolean)false)) {
            String message2 = CoverageBundle.message("dialog.message.would.you.like.to.delete.file.on.disk", fileName);
            if (Messages.showYesNoDialog((Project)this.getProject(), (String)message2, (String)CoverageBundle.message("delete.file", new Object[0]), (Icon)Messages.getWarningIcon()) != 0) {
                return;
            }
        }
        if ((file = new File(fileName)).exists()) {
            FileUtil.delete((File)file);
        }
        this.getCoverageEngine().deleteAssociatedTraces(this);
    }

    default public boolean isCoverageByTestApplicable() {
        CoverageRunner runner = this.getRunner();
        if (runner == null) {
            return false;
        }
        return runner.isCoverageByTestApplicable();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coverage/CoverageSuite", "getCoverageDataFileName"));
    }
}

