/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageDataManagerImpl;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileContentsChangedAdapter;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
public final class ExternalCoverageWatchManager {
    private final Project myProject;
    private Set<LocalFileSystem.WatchRequest> myWatchRequests;
    private List<String> myCurrentSuiteRoots;
    private final VirtualFileContentsChangedAdapter myContentListener = new VirtualFileContentsChangedAdapter(){

        protected void onFileChange(@NotNull VirtualFile fileOrDirectory) {
            if (fileOrDirectory == null) {
                1.$$$reportNull$$$0(0);
            }
            if (ExternalCoverageWatchManager.this.myCurrentSuiteRoots != null && VfsUtilCore.isUnder((String)fileOrDirectory.getPath(), ExternalCoverageWatchManager.this.myCurrentSuiteRoots)) {
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    CoverageDataManagerImpl manager = (CoverageDataManagerImpl)CoverageDataManager.getInstance(ExternalCoverageWatchManager.this.myProject);
                    for (CoverageSuitesBundle bundle : manager.activeSuites()) {
                        bundle.restoreCoverageData();
                        manager.updateCoverageData(bundle);
                    }
                });
            }
        }

        protected void onBeforeFileChange(@NotNull VirtualFile fileOrDirectory) {
            if (fileOrDirectory == null) {
                1.$$$reportNull$$$0(1);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "fileOrDirectory";
            objectArray2[1] = "com/intellij/coverage/ExternalCoverageWatchManager$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onFileChange";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onBeforeFileChange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    public static ExternalCoverageWatchManager getInstance(@NotNull Project project2) {
        if (project2 == null) {
            ExternalCoverageWatchManager.$$$reportNull$$$0(0);
        }
        return (ExternalCoverageWatchManager)project2.getService(ExternalCoverageWatchManager.class);
    }

    public ExternalCoverageWatchManager(Project project2) {
        this.myProject = project2;
    }

    public void addRootsToWatch(List<? extends CoverageSuite> suites) {
        this.myCurrentSuiteRoots = ContainerUtil.map(suites, suite2 -> suite2.getCoverageDataFileName());
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        this.myCurrentSuiteRoots.forEach(path2 -> fileSystem.refreshAndFindFileByPath(path2));
        this.myWatchRequests = fileSystem.addRootsToWatch(this.myCurrentSuiteRoots, true);
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)this.myContentListener);
    }

    public void clearWatches() {
        if (this.myWatchRequests == null) {
            return;
        }
        LocalFileSystem.getInstance().removeWatchedRoots(this.myWatchRequests);
        VirtualFileManager.getInstance().removeVirtualFileListener((VirtualFileListener)this.myContentListener);
        this.myWatchRequests = null;
        this.myCurrentSuiteRoots = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/coverage/ExternalCoverageWatchManager", "getInstance"));
    }
}

