/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.openapi.ui.ValidationInfo;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JTextField;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CloneDvcsValidationUtils {
    private static final Pattern SSH_URL_PATTERN;

    @Nullable
    public static ValidationInfo createDestination(@NotNull String path2) {
        if (path2 == null) {
            CloneDvcsValidationUtils.$$$reportNull$$$0(0);
        }
        try {
            Path directoryPath = Paths.get(path2, new String[0]);
            if (!directoryPath.toFile().exists()) {
                Files.createDirectories(directoryPath, new FileAttribute[0]);
            } else if (!directoryPath.toFile().isDirectory()) {
                return new ValidationInfo(DvcsBundle.message("clone.destination.directory.error.access", new Object[0])).withOKEnabled();
            }
            return null;
        }
        catch (InvalidPathException e) {
            return new ValidationInfo(DvcsBundle.message("clone.destination.directory.error.invalid", new Object[0]));
        }
        catch (Exception e) {
            return new ValidationInfo(DvcsBundle.message("clone.destination.directory.error.access", new Object[0])).withOKEnabled();
        }
    }

    @Nullable
    public static ValidationInfo checkDirectory(@NotNull String directoryPath, @NotNull JComponent component2) {
        if (directoryPath == null) {
            CloneDvcsValidationUtils.$$$reportNull$$$0(1);
        }
        if (component2 == null) {
            CloneDvcsValidationUtils.$$$reportNull$$$0(2);
        }
        if (directoryPath.length() == 0) {
            return new ValidationInfo("");
        }
        try {
            Path path2 = Paths.get(directoryPath, new String[0]);
            if (!path2.toFile().exists()) {
                return null;
            }
            if (!path2.toFile().isDirectory()) {
                return new ValidationInfo(DvcsBundle.message("clone.destination.directory.error.not.directory", new Object[0]), component2);
            }
            if (!CloneDvcsValidationUtils.isDirectoryEmpty(path2)) {
                return new ValidationInfo(DvcsBundle.message("clone.destination.directory.error.exists", new Object[0]), component2);
            }
        }
        catch (IOException | InvalidPathException e) {
            return new ValidationInfo(DvcsBundle.message("clone.destination.directory.error.invalid", new Object[0]), component2);
        }
        return null;
    }

    @Deprecated
    @Nullable
    public static ValidationInfo checkDirectory(@NotNull String directoryPath, @NotNull JTextField component2) {
        if (directoryPath == null) {
            CloneDvcsValidationUtils.$$$reportNull$$$0(3);
        }
        if (component2 == null) {
            CloneDvcsValidationUtils.$$$reportNull$$$0(4);
        }
        return CloneDvcsValidationUtils.checkDirectory(directoryPath, (JComponent)component2);
    }

    private static boolean isDirectoryEmpty(@NotNull Path directory) throws IOException {
        DirectoryStream<Path> directoryStream;
        if (directory == null) {
            CloneDvcsValidationUtils.$$$reportNull$$$0(5);
        }
        return !(directoryStream = Files.newDirectoryStream(directory)).iterator().hasNext();
    }

    @Nullable
    public static ValidationInfo checkRepositoryURL(JComponent component2, String repository) {
        if (repository.length() == 0) {
            return new ValidationInfo(DvcsBundle.message("clone.repository.url.error.empty", new Object[0]), component2);
        }
        if (CloneDvcsValidationUtils.isRepositoryUrlValid(repository = CloneDvcsValidationUtils.sanitizeCloneUrl(repository))) {
            return null;
        }
        try {
            Path path2 = Paths.get(repository, new String[0]);
            if (path2.toFile().exists()) {
                if (!path2.toFile().isDirectory()) {
                    return new ValidationInfo(DvcsBundle.message("clone.repository.url.error.not.directory", new Object[0]), component2);
                }
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ValidationInfo(DvcsBundle.message("clone.repository.url.error.invalid", new Object[0]), component2);
    }

    public static boolean isRepositoryUrlValid(@NotNull String repository) {
        if (repository == null) {
            CloneDvcsValidationUtils.$$$reportNull$$$0(6);
        }
        if (repository.isEmpty()) {
            return false;
        }
        try {
            if (new URI(repository).isAbsolute()) {
                return true;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return SSH_URL_PATTERN.matcher(repository).matches();
    }

    @NotNull
    static String sanitizeCloneUrl(@NotNull String urlText) {
        if (urlText == null) {
            CloneDvcsValidationUtils.$$$reportNull$$$0(7);
        }
        String string2 = StringsKt.removePrefix((String)StringsKt.removePrefix((String)urlText.trim(), (CharSequence)"git clone"), (CharSequence)"hg clone").trim();
        if (string2 == null) {
            CloneDvcsValidationUtils.$$$reportNull$$$0(8);
        }
        return string2;
    }

    static {
        @NonNls String ch = "[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]";
        @NonNls String ch2 = "[\\p{ASCII}&&[\\p{Graph}]&&[^/]]";
        @NonNls String host = "[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+(?:\\.[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+)*";
        @NonNls String path2 = "/?[\\p{ASCII}&&[\\p{Graph}]&&[^/]]+(?:/[\\p{ASCII}&&[\\p{Graph}]&&[^/]]+)*/?";
        @NonNls String all2 = "(?:[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+@)?[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+(?:\\.[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+)*:/?[\\p{ASCII}&&[\\p{Graph}]&&[^/]]+(?:/[\\p{ASCII}&&[\\p{Graph}]&&[^/]]+)*/?";
        SSH_URL_PATTERN = Pattern.compile("(?:[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+@)?[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+(?:\\.[\\p{ASCII}&&[\\p{Graph}]&&[^@:/]]+)*:/?[\\p{ASCII}&&[\\p{Graph}]&&[^/]]+(?:/[\\p{ASCII}&&[\\p{Graph}]&&[^/]]+)*/?");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryPath";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlText";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/ui/CloneDvcsValidationUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/ui/CloneDvcsValidationUtils";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "sanitizeCloneUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDestination";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkDirectory";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isDirectoryEmpty";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isRepositoryUrlValid";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "sanitizeCloneUrl";
                break;
            }
            case 8: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 8 -> new IllegalStateException(string2);
        };
    }
}

