/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core;

import com.intellij.history.core.Content;
import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.changes.Change;
import com.intellij.history.core.changes.ChangeSet;
import com.intellij.history.core.changes.CreateEntryChange;
import com.intellij.history.core.changes.DeleteChange;
import com.intellij.history.core.changes.StructuralChange;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.core.tree.RootEntry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.codeStyle.NameUtil;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a<\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00042\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\bH\u0007\u001a&\u0010\n\u001a\u00020\u000b*\u00020\f2\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u001aV\u0010\u0010\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u000b2\u001a\u0010\u0019\u001a\u0016\u0012\u0004\u0012\u00020\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u000b0\u001aH\u0007\u00a8\u0006\u001b"}, d2={"collectChanges", "", "Lcom/intellij/history/core/LocalHistoryFacade;", "projectId", "", "startPath", "patternString", "consumer", "Lkotlin/Function1;", "Lcom/intellij/history/core/changes/ChangeSet;", "matches", "", "Lcom/intellij/history/core/changes/Change;", "path", "pattern", "Ljava/util/regex/Pattern;", "processContents", "gateway", "Lcom/intellij/history/integration/IdeaGateway;", "root", "Lcom/intellij/history/core/tree/RootEntry;", "changeSets", "", "", "before", "processor", "Lkotlin/Function2;", "intellij.platform.lvcs.impl"})
@SourceDebugExtension(value={"SMAP\nLocalHistoryFacade.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalHistoryFacade.kt\ncom/intellij/history/core/LocalHistoryFacadeKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,277:1\n1#2:278\n*E\n"})
public final class LocalHistoryFacadeKt {
    @ApiStatus.Experimental
    public static final void collectChanges(@NotNull LocalHistoryFacade $this$collectChanges, @Nullable String projectId, @NotNull String startPath, @Nullable String patternString, @NotNull Function1<? super ChangeSet, Unit> consumer) {
        Pattern pattern2;
        Intrinsics.checkNotNullParameter((Object)$this$collectChanges, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)startPath, (String)"startPath");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        String string2 = patternString;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            pattern2 = Pattern.compile(NameUtil.buildRegexp((String)it, (int)0, (boolean)true, (boolean)true), 2);
        } else {
            pattern2 = null;
        }
        Pattern pattern3 = pattern2;
        Set processedChangesSets = new LinkedHashSet();
        Function3 processChangeSet2 = (Function3)new Function3<ChangeSet, Change, String, Unit>((Set<Long>)processedChangesSets, projectId, pattern3, consumer){
            final /* synthetic */ Set<Long> $processedChangesSets;
            final /* synthetic */ String $projectId;
            final /* synthetic */ Pattern $pattern;
            final /* synthetic */ Function1<ChangeSet, Unit> $consumer;
            {
                this.$processedChangesSets = $processedChangesSets;
                this.$projectId = $projectId;
                this.$pattern = $pattern;
                this.$consumer = $consumer;
                super(3);
            }

            public final void invoke(@NotNull ChangeSet changeSet, @NotNull Change change, @NotNull String changePath) {
                Intrinsics.checkNotNullParameter((Object)changeSet, (String)"changeSet");
                Intrinsics.checkNotNullParameter((Object)change, (String)"change");
                Intrinsics.checkNotNullParameter((Object)changePath, (String)"changePath");
                if (!this.$processedChangesSets.contains(changeSet.getId()) && LocalHistoryFacadeKt.matches(change, this.$projectId, changePath, this.$pattern)) {
                    this.$processedChangesSets.add(changeSet.getId());
                    this.$consumer.invoke((Object)changeSet);
                }
            }
        };
        String path2 = startPath;
        boolean pathExists = true;
        for (ChangeSet changeSet : $this$collectChanges.getChanges$intellij_platform_lvcs_impl()) {
            List<Change> list2 = changeSet.getChanges();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getChanges(...)");
            for (Change change : CollectionsKt.reversed((Iterable)list2)) {
                if (!pathExists) {
                    if (change instanceof StructuralChange) {
                        Intrinsics.checkNotNullExpressionValue((Object)((StructuralChange)change).revertPath(path2), (String)"revertPath(...)");
                    }
                    if (!(change instanceof DeleteChange) || !((DeleteChange)change).isDeletionOf(path2)) continue;
                    processChangeSet2.invoke((Object)changeSet, (Object)change, (Object)path2);
                    pathExists = true;
                    continue;
                }
                Intrinsics.checkNotNull((Object)change);
                processChangeSet2.invoke((Object)changeSet, (Object)change, (Object)path2);
                if (change instanceof StructuralChange) {
                    Intrinsics.checkNotNullExpressionValue((Object)((StructuralChange)change).revertPath(path2), (String)"revertPath(...)");
                }
                if (!(change instanceof CreateEntryChange) || !change.isCreationalFor(path2)) continue;
                pathExists = false;
            }
        }
    }

    public static final boolean matches(@NotNull Change $this$matches, @Nullable String projectId, @NotNull String path2, @Nullable Pattern pattern2) {
        Intrinsics.checkNotNullParameter((Object)$this$matches, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        if (!$this$matches.affectsPath(path2) && !$this$matches.affectsProject(projectId)) {
            return false;
        }
        return pattern2 == null || $this$matches.affectsMatching(pattern2);
    }

    @ApiStatus.Internal
    public static final void processContents(@NotNull LocalHistoryFacade $this$processContents, @NotNull IdeaGateway gateway, @NotNull RootEntry root, @NotNull String startPath, @NotNull Set<Long> changeSets, boolean before2, @NotNull Function2<? super Long, ? super String, Boolean> processor2) {
        Intrinsics.checkNotNullParameter((Object)$this$processContents, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)gateway, (String)"gateway");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)startPath, (String)"startPath");
        Intrinsics.checkNotNullParameter(changeSets, (String)"changeSets");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        Function2 processContents2 = (Function2)new Function2<Long, String, Boolean>(changeSets, root, processor2, gateway){
            final /* synthetic */ Set<Long> $changeSets;
            final /* synthetic */ RootEntry $root;
            final /* synthetic */ Function2<Long, String, Boolean> $processor;
            final /* synthetic */ IdeaGateway $gateway;
            {
                this.$changeSets = $changeSets;
                this.$root = $root;
                this.$processor = $processor;
                this.$gateway = $gateway;
                super(2);
            }

            @NotNull
            public final Boolean invoke(long changeSetId, @NotNull String path2) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
                if (!this.$changeSets.contains(changeSetId)) {
                    return true;
                }
                Entry entry2 = this.$root.findEntry(path2);
                return (Boolean)this.$processor.invoke((Object)changeSetId, (object = entry2) != null && (object = ((Entry)object).getContent()) != null ? ((Content)object).getString(entry2, this.$gateway) : null);
            }
        };
        String path2 = startPath;
        for (ChangeSet changeSet : $this$processContents.getChanges$intellij_platform_lvcs_impl()) {
            ProgressManager.checkCanceled();
            if (Thread.currentThread().isInterrupted()) {
                throw new ProcessCanceledException();
            }
            if (!before2 && !((Boolean)processContents2.invoke((Object)changeSet.getId(), (Object)path2)).booleanValue()) break;
            List<Change> list2 = changeSet.getChanges();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getChanges(...)");
            for (Change change : CollectionsKt.reversed((Iterable)list2)) {
                if (!(change instanceof StructuralChange) || !change.affectsPath(path2)) continue;
                ((StructuralChange)change).revertOn(root, false);
                Intrinsics.checkNotNullExpressionValue((Object)((StructuralChange)change).revertPath(path2), (String)"revertPath(...)");
            }
            if (!before2 || ((Boolean)processContents2.invoke((Object)changeSet.getId(), (Object)path2)).booleanValue()) continue;
            break;
        }
    }
}

